/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.txw2.output;

import com.sun.xml.internal.txw2.TxwException;
import com.sun.xml.internal.txw2.output.IndentingXMLFilter;
import com.sun.xml.internal.txw2.output.XmlSerializer;
import java.util.Stack;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SaxSerializer
implements XmlSerializer {
    private final ContentHandler writer;
    private final LexicalHandler lexical;
    private final Stack<String> prefixBindings = new Stack();
    private final Stack<String> elementBindings = new Stack();
    private final AttributesImpl attrs = new AttributesImpl();

    public SaxSerializer(ContentHandler contentHandler) {
        this(contentHandler, null, true);
    }

    public SaxSerializer(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this(contentHandler, lexicalHandler, true);
    }

    public SaxSerializer(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean bl) {
        if (!bl) {
            this.writer = contentHandler;
            this.lexical = lexicalHandler;
        } else {
            IndentingXMLFilter indentingXMLFilter = new IndentingXMLFilter(contentHandler, lexicalHandler);
            this.writer = indentingXMLFilter;
            this.lexical = indentingXMLFilter;
        }
    }

    public SaxSerializer(SAXResult sAXResult) {
        this(sAXResult.getHandler(), sAXResult.getLexicalHandler());
    }

    @Override
    public void startDocument() {
        try {
            this.writer.startDocument();
        }
        catch (SAXException sAXException) {
            throw new TxwException(sAXException);
        }
    }

    @Override
    public void writeXmlns(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string.equals("xml")) {
            return;
        }
        this.prefixBindings.add(string2);
        this.prefixBindings.add(string);
    }

    @Override
    public void beginStartTag(String string, String string2, String string3) {
        this.elementBindings.add(SaxSerializer.getQName(string3, string2));
        this.elementBindings.add(string2);
        this.elementBindings.add(string);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, StringBuilder stringBuilder) {
        this.attrs.addAttribute(string, string2, SaxSerializer.getQName(string3, string2), "CDATA", stringBuilder.toString());
    }

    @Override
    public void endStartTag(String string, String string2, String string3) {
        try {
            while (this.prefixBindings.size() != 0) {
                this.writer.startPrefixMapping(this.prefixBindings.pop(), this.prefixBindings.pop());
            }
            this.writer.startElement(string, string2, SaxSerializer.getQName(string3, string2), this.attrs);
            this.attrs.clear();
        }
        catch (SAXException sAXException) {
            throw new TxwException(sAXException);
        }
    }

    @Override
    public void endTag() {
        try {
            this.writer.endElement(this.elementBindings.pop(), this.elementBindings.pop(), this.elementBindings.pop());
        }
        catch (SAXException sAXException) {
            throw new TxwException(sAXException);
        }
    }

    @Override
    public void text(StringBuilder stringBuilder) {
        try {
            this.writer.characters(stringBuilder.toString().toCharArray(), 0, stringBuilder.length());
        }
        catch (SAXException sAXException) {
            throw new TxwException(sAXException);
        }
    }

    @Override
    public void cdata(StringBuilder stringBuilder) {
        if (this.lexical == null) {
            throw new UnsupportedOperationException("LexicalHandler is needed to write PCDATA");
        }
        try {
            this.lexical.startCDATA();
            this.text(stringBuilder);
            this.lexical.endCDATA();
        }
        catch (SAXException sAXException) {
            throw new TxwException(sAXException);
        }
    }

    @Override
    public void comment(StringBuilder stringBuilder) {
        try {
            if (this.lexical == null) {
                throw new UnsupportedOperationException("LexicalHandler is needed to write comments");
            }
            this.lexical.comment(stringBuilder.toString().toCharArray(), 0, stringBuilder.length());
        }
        catch (SAXException sAXException) {
            throw new TxwException(sAXException);
        }
    }

    @Override
    public void endDocument() {
        try {
            this.writer.endDocument();
        }
        catch (SAXException sAXException) {
            throw new TxwException(sAXException);
        }
    }

    @Override
    public void flush() {
    }

    private static String getQName(String string, String string2) {
        String string3 = string == null || string.length() == 0 ? string2 : string + ':' + string2;
        return string3;
    }
}

