/*
 * Decompiled with CFR 0.152.
 */
package system;

import components.OutputListener;
import components.cartridge.Cartridge;
import components.cartridge.SMSCartridge;
import components.cpu.MemoryMap;
import components.cpu.PortMap;
import components.cpu.Z80;
import components.input.AbstractSMSInputDevice;
import components.input.InputDevice;
import components.input.SMSButtons;
import components.input.SMSInputDevice;
import components.sound.SMSAudioMixer;
import components.sound.SMSJapaneseAudioMixer;
import components.sound.SN76489;
import components.sound.YM2413;
import components.video.SMS2VDP;
import components.video.TMS9918A;
import events.AbstractArrayListEventModel;
import events.Event;
import events.EventModel;
import events.EventType;
import events.systems.MasterSystemEventTypes;
import java.io.File;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import messages.Z80MessageParser;
import output.SMSDisplayWindow;
import output.SMSSoundOutput;
import system.DebuggableSystem;
import system.EmulatableSystem;
import system.IntBiMapBasedRamRomMap;
import system.RamRomMap;
import system.SystemEventListener;
import util.list.AbstractIntList;
import util.list.IntList;
import util.map.HashIntBiMap;
import util.map.IntBiMap;

public class MasterSystem
implements DebuggableSystem,
PortMap {
    public static final int CYCLES_PER_SECOND_NTSC = 3579545;
    public static final int CYCLES_PER_SECOND_PAL = 3546895;
    public static final int ERROR_INVALID_VDP_ACCESS = 0;
    public static final int ERROR_ACCESS_MIRROR = 1;
    public static final int ERROR_ILLEGAL_MEMORY_SETUP = 2;
    public static final int ERROR_BREAKPOINT = 3;
    private static final int[] ERROR_CODES;
    private static final String[] ADDITIONAL_MEMORY_LOCATION_NAMES;
    private static final int[] ADDITIONAL_MEMORY_LOCATION_LENGTHS;
    private static final String[] ADDITIONAL_REGISTER_NAMES;
    private static final SMSCartridge NULL_CARTRIDGE;
    private static SMSCartridge emuliciousBIOSsms;
    private final int FRAMES_PER_SECOND;
    private final int CYCLES_PER_SECOND;
    private final int CYCLES_PER_FRAME;
    private int CYCLES_PER_SOUND_FRAME;
    private final SMSDisplayWindow window;
    private final SMSSoundOutput soundOutput;
    private final int[] ram = new int[8192];
    protected final Z80 cpu = new Z80(this, this);
    protected SMSCartridge cartridge = NULL_CARTRIDGE;
    protected SMSCartridge bios;
    private SMSCartridge card;
    protected SMS2VDP vdp;
    protected SN76489 psg;
    protected YM2413 fm;
    protected SMSAudioMixer audioMixer;
    protected SMSButtons buttons;
    protected final SMSInputDevice[] inputDevices = new SMSInputDevice[]{SMSInputDevice.NULL_DEVICE, SMSInputDevice.NULL_DEVICE};
    private int prevInputState;
    protected int timerSound;
    protected boolean cartridgeEnabled;
    protected boolean cardEnabled;
    protected boolean biosEnabled;
    private boolean biosDone;
    private int valueMemoryBus;
    protected int reg3Dglasses;
    private int notTRio0 = 255;
    private int notTRio1 = 255;
    private int trOut0;
    private int trOut1;
    private int notTHio0 = 255;
    private int notTHio1 = 255;
    private int thOut0;
    private int thOut1;
    protected boolean ramEnabled;
    protected boolean ioEnabled;
    private final IntBiMap ramSources = new HashIntBiMap();
    private final RamRomMap ramRomMap = new IntBiMapBasedRamRomMap(this.ramSources);
    private final boolean[] ramInitialized = new boolean[this.ram.length];
    private AbstractArrayListEventModel eventModel;
    private IntList allRAMaddresses;
    private final LinkedList<SystemEventListener> systemEventListenerList = new LinkedList();
    private SystemEventListener[] systemEventListeners = new SystemEventListener[0];
    private final LinkedList<OutputListener> portListenerList = new LinkedList();
    private OutputListener[] portListeners = new OutputListener[0];
    private final AbstractSMSInputDevice VDP_INPUT_DEVICE = new AbstractSMSInputDevice(){

        @Override
        public int readData(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void handleRisingEdgeTH(int n) {
            MasterSystem.this.vdp.updateHcounter(n);
        }
    };

    static {
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[2] = 1;
        nArray[3] = 2;
        ERROR_CODES = nArray;
        ADDITIONAL_MEMORY_LOCATION_NAMES = new String[]{"VDP", "PSG", "FM"};
        ADDITIONAL_MEMORY_LOCATION_LENGTHS = new int[]{11, 11, 64};
        ADDITIONAL_REGISTER_NAMES = new String[]{"R", "I", "VA", "Line", "ROMB0", "ROMB1", "ROMB2", "SRAMB"};
        NULL_CARTRIDGE = new SMSCartridge(new int[0]);
    }

    protected MasterSystem(SMSDisplayWindow sMSDisplayWindow, SMSSoundOutput sMSSoundOutput) {
        this(false, sMSDisplayWindow, sMSSoundOutput, 0, false);
    }

    public MasterSystem(boolean bl, SMSDisplayWindow sMSDisplayWindow, SMSSoundOutput sMSSoundOutput, int n, boolean bl2) {
        this.window = sMSDisplayWindow;
        this.soundOutput = sMSSoundOutput;
        if (bl) {
            this.FRAMES_PER_SECOND = 50;
            this.CYCLES_PER_SECOND = 3546895;
        } else {
            this.FRAMES_PER_SECOND = 60;
            this.CYCLES_PER_SECOND = 3579545;
        }
        this.init(sMSDisplayWindow, sMSSoundOutput, n, bl2);
        this.CYCLES_PER_FRAME = this.vdp.getCyclesPerFrame();
    }

    protected SMS2VDP createVDP() {
        return this.FRAMES_PER_SECOND == 50 ? new SMS2VDP(313) : new SMS2VDP(262);
    }

    protected void init(final SMSDisplayWindow sMSDisplayWindow, final SMSSoundOutput sMSSoundOutput, int n, boolean bl) {
        this.vdp = this.createVDP();
        this.psg = new SN76489(this.CYCLES_PER_SECOND, this.FRAMES_PER_SECOND, n);
        if (bl) {
            this.fm = new YM2413(this.CYCLES_PER_SECOND);
        }
        this.CYCLES_PER_SOUND_FRAME = this.psg.getCyclesPerSecond() / this.psg.getFramesPerSecond();
        this.audioMixer = new SMSJapaneseAudioMixer(this.psg, this.fm);
        sMSDisplayWindow.setVDP(this.vdp);
        sMSSoundOutput.setAudioMixer(this.audioMixer);
        final Z80 z80 = this.cpu;
        this.vdp.addOutputListener(new OutputListener(){
            private final TMS9918A.State state;
            {
                this.state = MasterSystem.this.vdp.getState();
            }

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                switch (n) {
                    case 0x110000: {
                        if (n2 == MasterSystem.this.vdp.getScanlines() - 2) {
                            MasterSystem.this.handleInputChanges();
                            z80.setInterruptLine(2, MasterSystem.this.isPauseButtonPressed());
                            if (MasterSystem.this.isPauseButtonPressed()) {
                                MasterSystem.this.addEvent(MasterSystemEventTypes.NMI, 0);
                            }
                        } else if (n2 == MasterSystem.this.vdp.getScanlines() - 1) {
                            MasterSystem.this.frameFinished();
                        }
                        sMSDisplayWindow.renderLine();
                        break;
                    }
                    case 0x110007: {
                        sMSDisplayWindow.prepareSprites();
                        break;
                    }
                    case 0x110001: {
                        sMSDisplayWindow.setMode(n2);
                        break;
                    }
                    case 0x110003: {
                        sMSDisplayWindow.updateColor(n2 & 0x1F, n3, (n2 & 0x20) != 0);
                        break;
                    }
                    case 0x110002: {
                        MasterSystem.this.fireCRAMwrite(n2 & 0x3F, MasterSystem.this.vdp.getCRAM()[n2 & 0x1F], n2 >> 8);
                        if (MasterSystem.this.eventModel == null) break;
                        MasterSystem.this.addEvent(MasterSystemEventTypes.CRAM, MasterSystem.this.vdp.getCRAM()[n2 & 0x1F], n2 >> 8, n3, n2);
                        break;
                    }
                    case 0x110004: {
                        if ((n2 & 0x20000) != 0) {
                            sMSDisplayWindow.makePatternDirty((n2 & 0x1FFFF) >> 2);
                        }
                        MasterSystem.this.fireVRAMwrite(n2 & 0x1FFFF, MasterSystem.this.vdp.getVRAM()[n2 & 0x1FFFF], (n2 & 0xFF00000) >> 20);
                        if (MasterSystem.this.eventModel == null) break;
                        MasterSystem.this.addEvent(MasterSystemEventTypes.VRAM, MasterSystem.this.vdp.getVRAM()[n2 & 0x1FFFF], (n2 & 0xFF00000) >> 20, n3, n2);
                        break;
                    }
                    case 0x110005: {
                        MasterSystem.this.fireVRAMread(n2 & 0x1FFFF, MasterSystem.this.vdp.getVRAM()[n2 & 0x1FFFF]);
                        if (MasterSystem.this.eventModel == null) break;
                        MasterSystem.this.addEvent(MasterSystemEventTypes.VRAM, MasterSystem.this.vdp.getVRAM()[n2 & 0x1FFFF], -1, n3, n2);
                        break;
                    }
                    case 0x110006: {
                        if (MasterSystem.this.eventModel == null) break;
                        MasterSystem.this.addEvent(MasterSystemEventTypes.VDP_STATUS, MasterSystem.this.vdp.getRegStatus(0), -1, n3);
                        break;
                    }
                    case 0x110010: {
                        MasterSystem.this.fireVRAMaddressWritten();
                        break;
                    }
                    case 0x110013: {
                        MasterSystem.this.fireVRAMaddressWriteCancelled();
                        break;
                    }
                    case 1114303: {
                        z80.setInterruptLine(1, n2 > 0);
                        if (n2 <= 0) break;
                        if (MasterSystem.this.vdp.getTimer() < 0) {
                            n3 = 0;
                        }
                        if (n2 == 2) {
                            ++n3;
                        }
                        MasterSystem.this.addEvent(MasterSystemEventTypes.IRQ, n3);
                        break;
                    }
                    case 0x1100FF: {
                        MasterSystem.this.fireErrorOccurred(0, n2);
                        break;
                    }
                    case 0x110011: {
                        MasterSystem.this.fireVdpRegisterWrite(n2 & 0xF, this.state.getReg(n2 & 0xF), n2 >> 8);
                        break;
                    }
                    case 0x110012: {
                        MasterSystem.this.handleVdpRegisterEvent(n2 & 0xF, n2 >> 8 & 0xFF, n2 >> 16, n3);
                    }
                }
            }
        });
        this.psg.addOutputListener(new OutputListener(){
            private final SN76489.State state;
            {
                this.state = MasterSystem.this.psg.getState();
            }

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                switch (n) {
                    case 2228351: {
                        sMSSoundOutput.updateBuffer(MasterSystem.this.CYCLES_PER_SOUND_FRAME - (MasterSystem.this.timerSound - n2));
                        break;
                    }
                    case 0x220000: {
                        int n4 = (n2 & 0x7F) >> 1;
                        int n5 = (n2 & 1) != 0 ? 2 : (n2 & 0x80) >> 7 ^ 1;
                        int n6 = n4 == 3 && (n2 & 1) != 0 ? n4 * 3 + 1 : n4 * 3 + n5;
                        MasterSystem.this.firePsgRegisterWrite(n6, this.getOldValue(n6), n2 >> 8);
                    }
                }
            }

            private int getOldValue(int n) {
                int n2 = n / 3;
                if (n2 == 3) {
                    if (n % 3 == 0) {
                        return this.state.getRegNoise();
                    }
                    return this.state.getRegVolume(n2);
                }
                if (n % 3 == 2) {
                    return this.state.getRegVolume(n2);
                }
                return this.state.getRegTone(n2) >> 8 * (n % 3);
            }
        });
        if (this.fm != null) {
            this.fm.addOutputListener(new OutputListener(){
                private final YM2413.State state;
                {
                    this.state = MasterSystem.this.fm.getState();
                }

                @Override
                public void outputAvailable(int n, int n2, int n3) {
                    switch (n) {
                        case 3342463: {
                            if (n2 < 0) break;
                            sMSSoundOutput.updateBuffer(MasterSystem.this.CYCLES_PER_SOUND_FRAME - (MasterSystem.this.timerSound - n2));
                            break;
                        }
                        case 0x330000: {
                            MasterSystem.this.fireFmRegisterWrite(n2 & 0x3F, this.state.getReg(n2 & 0x3F), n2 >> 6);
                        }
                    }
                }
            });
        }
    }

    protected int getReg3Dglasses() {
        return this.reg3Dglasses;
    }

    protected boolean isPauseButtonPressed() {
        return this.buttons.isPauseButtonPressed();
    }

    @Override
    public int readPort(int n, int n2) {
        int n3 = this.doReadPort(n, n2);
        this.firePortRead(n, n3, n2);
        return n3;
    }

    private int doReadPort(int n, int n2) {
        switch (n >> 6) {
            case 0: {
                return this.valueMemoryBus;
            }
            case 1: {
                return this.vdp.readCounter(n & 1, n2);
            }
            case 2: {
                return this.vdp.readByte(n & 1, n2);
            }
            case 3: {
                int n3 = 255;
                if (n == 242 && this.fm != null) {
                    n3 &= this.audioMixer.readPort(n);
                }
                if (this.ioEnabled) {
                    this.handleInputChanges();
                    switch (n & 1) {
                        case 0: {
                            return n3 & (((this.inputDevices[1].readData(n2) & 3) << 6 | this.inputDevices[0].readData(n2) & 0x3F) & this.notTRio0 | this.trOut0);
                        }
                        case 1: {
                            int n4 = this.inputDevices[0].readData(n2);
                            int n5 = this.inputDevices[1].readData(n2);
                            int n6 = n5 << 1 & 0x80 & this.notTHio1 | n4 & 0x40 & this.notTHio0;
                            return n6 | this.thOut0 | this.thOut1 | 0x20 | this.buttons.getResetButtonState() | n5 >> 2 & 0xF & this.notTRio1 | this.trOut1;
                        }
                    }
                } else if (n != 242 || this.fm == null) {
                    return this.valueMemoryBus;
                }
                return n3;
            }
        }
        return this.valueMemoryBus;
    }

    @Override
    public void writePort(int n, int n2, int n3) {
        if (n >= 256) {
            if (n == 256) {
                this.fireErrorOccurred(3, n2);
            } else if (n == 338) {
                this.handleMessage();
            } else if (n == 374) {
                this.addEvent(MasterSystemEventTypes.HALT, n2 ^ 1, n2, (228 - (this.vdp.getTimer() - n3)) * 3 / 2);
            }
            return;
        }
        this.firePortWritten(n, n2, n3);
        switch (n >> 6) {
            case 0: {
                if ((n & 1) == 0) {
                    this.cartridgeEnabled = this.cartridge != NULL_CARTRIDGE && (n2 & 0x40) == 0;
                    this.cardEnabled = this.card != null && (n2 & 0x20) == 0;
                    this.biosEnabled = this.bios != null && (n2 & 8) == 0;
                    this.ramEnabled = (n2 & 0x10) == 0;
                    this.ioEnabled = (n2 & 4) == 0;
                    int n4 = 0;
                    if (this.cardEnabled) {
                        ++n4;
                    }
                    if (this.cartridgeEnabled) {
                        ++n4;
                    }
                    if (this.biosEnabled) {
                        ++n4;
                    }
                    if (n4 != 1) {
                        this.fireErrorOccurred(2, n2);
                        break;
                    }
                    if (this.biosEnabled) break;
                    this.biosDone = true;
                    break;
                }
                if (!this.ioEnabled) break;
                this.notTRio0 = ~((n2 & 1 ^ 1) << 5);
                this.notTRio1 = ~((n2 & 4 ^ 4) << 1);
                this.trOut0 = n2 << 1 & ~this.notTRio0;
                this.trOut1 = n2 >> 3 & ~this.notTRio1;
                this.notTHio0 = ~((n2 & 2 ^ 2) << 5);
                this.notTHio1 = ~((n2 & 8 ^ 8) << 4);
                this.thOut0 = n2 << 1 & ~this.notTHio0;
                this.thOut1 = n2 & ~this.notTHio1;
                this.VDP_INPUT_DEVICE.setPins(true, (this.thOut0 | ~this.notTHio0 ^ 0x40 | (this.thOut1 | ~this.notTHio1 ^ 0x80)) != 0, n3);
                this.inputDevices[0].setPins((this.trOut0 | ~this.notTRio0 ^ 0x20) != 0, (this.thOut0 | ~this.notTHio0 ^ 0x40) != 0, n3);
                this.inputDevices[1].setPins((this.trOut1 | ~this.notTRio1 ^ 8) != 0, (this.thOut1 | ~this.notTHio1 ^ 0x80) != 0, n3);
                break;
            }
            case 1: {
                this.psg.processInput(n, n2, n3);
                break;
            }
            case 2: {
                this.vdp.processInput(n & 1, n2, n3);
                break;
            }
            case 3: {
                if (this.fm == null) break;
                if (n == 242) {
                    this.audioMixer.writePort(n, n2);
                    break;
                }
                if ((n & 0xFE) != 240) break;
                this.fm.processInput(n & 1, n2, n3);
            }
        }
    }

    public static SMSCartridge createEmuliciousBIOS() {
        if (emuliciousBIOSsms != null) {
            return emuliciousBIOSsms;
        }
        int[] nArray = new int[1176];
        nArray[0] = 243;
        nArray[1] = 237;
        nArray[2] = 86;
        nArray[3] = 49;
        nArray[4] = 240;
        nArray[5] = 223;
        nArray[6] = 33;
        nArray[7] = 128;
        nArray[8] = 4;
        nArray[9] = 1;
        nArray[10] = 191;
        nArray[11] = 24;
        nArray[12] = 237;
        nArray[13] = 179;
        nArray[14] = 175;
        nArray[15] = 211;
        nArray[16] = 190;
        nArray[17] = 33;
        nArray[18] = 137;
        nArray[19] = 2;
        nArray[20] = 17;
        nArray[21] = 10;
        nArray[22] = 199;
        nArray[23] = 1;
        nArray[24] = 10;
        nArray[25] = 0;
        nArray[26] = 237;
        nArray[27] = 176;
        nArray[28] = 6;
        nArray[29] = 10;
        nArray[30] = 197;
        nArray[31] = 1;
        nArray[32] = 51;
        nArray[33] = 51;
        nArray[34] = 11;
        nArray[35] = 120;
        nArray[36] = 177;
        nArray[37] = 32;
        nArray[38] = 251;
        nArray[39] = 193;
        nArray[40] = 16;
        nArray[41] = 244;
        nArray[42] = 195;
        nArray[43] = 10;
        nArray[44] = 199;
        nArray[1152] = 54;
        nArray[1153] = 128;
        nArray[1154] = 160;
        nArray[1155] = 129;
        nArray[1156] = 255;
        nArray[1157] = 130;
        nArray[1158] = 255;
        nArray[1159] = 131;
        nArray[1160] = 255;
        nArray[1161] = 132;
        nArray[1162] = 255;
        nArray[1163] = 133;
        nArray[1164] = 251;
        nArray[1165] = 134;
        nArray[1166] = 0;
        nArray[1167] = 136;
        nArray[1168] = 0;
        nArray[1169] = 137;
        nArray[1170] = 255;
        nArray[1171] = 138;
        nArray[1172] = 0;
        nArray[1173] = 135;
        nArray[1174] = 16;
        nArray[1175] = 192;
        nArray[649] = 62;
        nArray[650] = 171;
        nArray[651] = 50;
        nArray[652] = 0;
        nArray[653] = 192;
        nArray[654] = 211;
        nArray[655] = 62;
        nArray[656] = 195;
        nArray[657] = 0;
        nArray[658] = 0;
        emuliciousBIOSsms = new SMSCartridge(nArray){

            @Override
            public int readByte(int n, int n2) {
                if (n < this.getRom().length) {
                    return super.readByte(n, n2);
                }
                return 255;
            }

            @Override
            public void processWrite(int n, int n2, int n3) {
            }
        };
        return emuliciousBIOSsms;
    }

    public void setBIOS(SMSCartridge sMSCartridge) {
        this.bios = sMSCartridge;
    }

    private void setPort3F(int n) {
        this.notTRio0 = ~((n & 1 ^ 1) << 5);
        this.notTRio1 = ~((n & 4 ^ 4) << 1);
        this.trOut0 = n << 1 & ~this.notTRio0;
        this.trOut1 = n >> 3 & ~this.notTRio1;
        this.notTHio0 = ~((n & 2 ^ 2) << 5);
        this.notTHio1 = ~((n & 8 ^ 8) << 4);
        this.thOut0 = n << 1 & ~this.notTHio0;
        this.thOut1 = n & ~this.notTHio1;
    }

    protected int makePort3FforState() {
        int n = ~this.notTRio0 >> 5 ^ 1;
        n |= ~this.notTRio1 >> 1 ^ 4;
        n |= (this.trOut0 | this.notTRio0 & 0x20) >> 1;
        n |= (this.trOut1 | this.notTRio1 & 8) << 3;
        n |= ~this.notTHio0 >> 5 ^ 2;
        n |= ~this.notTHio1 >> 4 ^ 8;
        n |= (this.thOut0 | this.notTHio0 & 0x40) >> 1;
        return n |= this.thOut1 | this.notTHio1 & 0x80;
    }

    @Override
    public int getMemoryLength() {
        return 65536;
    }

    @Override
    public int readByte(int n, int n2) {
        int n3 = -1;
        if (n < 49152) {
            if (this.cartridgeEnabled) {
                n3 &= this.cartridge.readByte(n, n2);
                if (this.isSRAMaddress(n)) {
                    this.addEvent(MasterSystemEventTypes.SRAM, n3, -1, (228 - this.vdp.getTimer() + n2) * 3 / 2, n & 0x3FFF);
                }
            }
            if (this.biosEnabled) {
                n3 &= this.bios.readByte(n, n2);
            }
            if (this.cardEnabled) {
                n3 &= this.card.readByte(n, n2);
            }
        } else if (this.ramEnabled) {
            int n4;
            int n5;
            if (!(this.ramInitialized[n & 0x1FFF] || (n5 = this.peekByte(n4 = this.getPrevPC())) == 237 && this.peekByte(n4 + 1) == 103 && (this.peekByte(n4 + 2) & 0xF8) == 120 || n5 == 42 && (n - 1 & 0x1FFF) == ((this.peekByte(n4 + 2) << 8 | this.peekByte(n4 + 1)) & 0x1FFF) && this.peekByte(n4 + 3) == 38)) {
                this.fireErrorOccurred(-1, n);
            }
            if (n >= 57344 && n < 65528) {
                this.fireErrorOccurred(1, n);
            }
            n3 = this.ram[n & 0x1FFF];
            this.addEvent(MasterSystemEventTypes.RAM, n3, -1, (228 - this.vdp.getTimer() + n2) * 3 / 2, n & 0x1FFF);
        }
        return n3 < 0 ? this.valueMemoryBus : (this.valueMemoryBus = n3);
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        if ((n & 0x7FFC) == 32760) {
            this.reg3Dglasses = n2;
        }
        if (n >= 49152) {
            if (n >= 65520) {
                if (this.biosEnabled) {
                    this.bios.processWrite(n, n2, n3);
                }
                if (this.cartridgeEnabled) {
                    if (this.eventModel != null && this.isSRAMaddress(n)) {
                        this.addEvent(MasterSystemEventTypes.SRAM, this.cartridge.readByte(n, n3), n2, (228 - this.vdp.getTimer() + n3) * 3 / 2, n & 0x3FFF);
                    }
                    this.cartridge.processWrite(n, n2, n3);
                }
                if (this.cardEnabled) {
                    this.card.processWrite(n, n2, n3);
                }
            }
            if (this.ramEnabled) {
                if (n >= 57344 && n < 65520) {
                    this.fireErrorOccurred(1, n);
                }
                n &= 0x1FFF;
                if (this.biosDone) {
                    this.ramInitialized[n] = true;
                    int n4 = -1;
                    if (this.peekByte(this.cpu.getPrevPC()) == 237 && this.peekByte(this.cpu.getPrevPC() + 1) == 176) {
                        n4 = this.isRAMaddress(this.cpu.getRegisterValue(2)) ? this.ramSources.get(this.mapAddress(this.cpu.getRegisterValue(2))) : this.mapAddress(this.cpu.getRegisterValue(2));
                    }
                    if (n4 >= 0) {
                        this.ramSources.put(n, n4);
                    } else {
                        this.ramSources.remove(n);
                    }
                }
                this.addEvent(MasterSystemEventTypes.RAM, this.ram[n], n2, (228 - this.vdp.getTimer() + n3) * 3 / 2, n & 0x1FFF);
                this.ram[n] = n2;
            }
        } else {
            if (this.cartridgeEnabled) {
                this.cartridge.processWrite(n, n2, n3);
            }
            if (this.cardEnabled) {
                this.card.processWrite(n, n2, n3);
            }
        }
    }

    @Override
    public void plugInInputDevice(int n, InputDevice inputDevice) {
        if (!(inputDevice instanceof SMSInputDevice)) {
            throw new IllegalArgumentException(inputDevice + " is not compatible with " + this.getClass().getSimpleName());
        }
        this.inputDevices[n & 1] = (SMSInputDevice)inputDevice;
        if ((n & 1) == 0) {
            this.inputDevices[0].setPins((this.trOut0 | ~this.notTRio0 ^ 0x20) != 0, (this.thOut0 | ~this.notTHio0 ^ 0x40) != 0, 0);
        } else {
            this.inputDevices[1].setPins((this.trOut1 | ~this.notTRio1 ^ 8) != 0, (this.thOut1 | ~this.notTHio1 ^ 0x80) != 0, 0);
        }
        this.window.setInputDevice(n, inputDevice);
    }

    public void setButtons(SMSButtons sMSButtons) {
        this.buttons = sMSButtons;
    }

    public String getMapperName() {
        return this.cartridge != NULL_CARTRIDGE ? this.cartridge.getMapperName() : "None";
    }

    @Override
    public void insertCartridge(Cartridge cartridge) {
        this.cartridge = (SMSCartridge)cartridge;
        if (this.bios != null && !this.isEmuliciousBIOS()) {
            this.predetectMapper();
        }
        this.reset();
    }

    @Override
    public void ejectCartridge() {
        this.cartridge.eject();
        this.cartridgeEnabled = false;
        this.cartridge = NULL_CARTRIDGE;
    }

    @Override
    public void shutdown() {
        this.ejectCartridge();
        this.ejectCard();
        this.bios = null;
    }

    public void insertCard(SMSCartridge sMSCartridge) {
        this.card = sMSCartridge;
    }

    public void ejectCard() {
        if (this.card != null) {
            this.card.eject();
        }
        this.card = null;
    }

    protected boolean isEmuliciousBIOS() {
        return this.bios == emuliciousBIOSsms;
    }

    private void predetectMapper() {
        final SMSCartridge sMSCartridge = this.cartridge;
        if (sMSCartridge.getMapper() != 0) {
            return;
        }
        final int[] nArray = new int[8192];
        Z80 z80 = new Z80(new MemoryMap(){

            @Override
            public void writeByte(int n, int n2, int n3) {
                if (n >= 49152) {
                    if (n >= 65520) {
                        sMSCartridge.processWrite(n, n2, n3);
                    }
                    nArray[n & 0x1FFF] = n2;
                } else {
                    sMSCartridge.processWrite(n, n2, n3);
                }
            }

            @Override
            public int readByte(int n, int n2) {
                if (n < 49152) {
                    return sMSCartridge.readByte(n, n2);
                }
                return nArray[n & 0x1FFF];
            }

            @Override
            public int getMemoryLength() {
                return 65536;
            }
        }, new PortMap(){

            @Override
            public void writePort(int n, int n2, int n3) {
            }

            @Override
            public int readPort(int n, int n2) {
                return 0;
            }
        });
        try {
            int n = this.CYCLES_PER_SECOND / 10;
            z80.setInterruptLine(1, true);
            int n2 = 0;
            while (n2 < 10 && sMSCartridge.getMapper() == 0) {
                z80.execute(n);
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        sMSCartridge.reset();
    }

    @Override
    public boolean isCartridgeEnabled() {
        return this.cartridgeEnabled;
    }

    @Override
    public boolean isBiosEnabled() {
        return this.biosEnabled;
    }

    public boolean isDBmapper() {
        return this.cartridge.isDBMapper();
    }

    public int getDBshift() {
        return this.cartridge.getDBbankShift();
    }

    public String getInputDeviceName(int n) {
        return SMSButtons.getInputDeviceName(this.inputDevices[n]);
    }

    public String[] getButtonNames(int n) {
        return SMSButtons.getButtonNames(this.inputDevices[n]);
    }

    public boolean isButtonDown(int n, int n2) {
        if (n == 2) {
            return this.buttons.isButtonDown(n2);
        }
        return this.inputDevices[n].isButtonDown(n2);
    }

    public void setButtonDownOverride(int n, int n2, boolean bl) {
        if (n == 2) {
            this.buttons.setButtonDownOverride(n2, bl);
        } else {
            this.inputDevices[n].setButtonDownOverride(n2, bl);
        }
    }

    @Override
    public void reset() {
        this.ramEnabled = true;
        this.ioEnabled = true;
        this.biosEnabled = this.bios != null;
        this.cartridgeEnabled = !this.biosEnabled;
        this.biosDone = !this.biosEnabled;
        this.cardEnabled = false;
        this.prevInputState = 0;
        this.setPort3F(255);
        this.cpu.reset();
        this.vdp.reset();
        this.psg.reset();
        if (this.fm != null) {
            this.fm.reset();
        }
        this.audioMixer.reset();
        this.cartridge.reset();
        if (this.card != null) {
            this.card.reset();
        }
        this.ramSources.clear();
        Arrays.fill(this.ramInitialized, false);
        this.ramInitialized[0] = true;
    }

    @Override
    public int execute(int n) {
        while ((n = this.executeOnce(n)) > 0) {
        }
        return n;
    }

    @Override
    public int executeOnce(int n) {
        int n2 = this.cpu.execute(Math.min(n, this.vdp.getTimer()));
        n -= n2;
        this.vdp.update(n2);
        this.timerSound -= n2;
        while (this.timerSound <= 0) {
            this.timerSound += this.CYCLES_PER_SOUND_FRAME;
            this.soundOutput.updateBuffer(this.CYCLES_PER_SOUND_FRAME);
            this.soundOutput.finishFrame();
        }
        this.inputDevices[0].update(n2);
        this.inputDevices[1].update(n2);
        return n;
    }

    @Override
    public int getCyclesPerSecond() {
        return this.CYCLES_PER_SECOND;
    }

    @Override
    public int getCyclesPerFrame() {
        return this.CYCLES_PER_FRAME;
    }

    @Override
    public void uninitializeMemory(int n) {
        int[] nArray = this.vdp.getVRAM();
        int[] nArray2 = this.vdp.getCRAM();
        if (n < 0 || n >= 256) {
            Random random = new Random();
            int n2 = 0;
            while (n2 < this.ram.length) {
                this.ram[n2] = random.nextInt(256);
                ++n2;
            }
            n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = random.nextInt(256);
                ++n2;
            }
            n2 = 0;
            while (n2 < nArray2.length) {
                nArray2[n2] = random.nextInt(256);
                ++n2;
            }
        } else {
            Arrays.fill(this.ram, n);
            Arrays.fill(nArray, n);
            Arrays.fill(nArray2, n);
        }
        int n3 = 0;
        while (n3 < nArray2.length) {
            this.window.updateColor(n3, 0, true);
            ++n3;
        }
        n3 = 0;
        while (n3 < nArray.length) {
            this.window.makePatternDirty(n3 >> 2);
            n3 += 4;
        }
    }

    @Override
    public int[] getRAM() {
        return this.ram;
    }

    @Override
    public int[] getSRAM() {
        return this.cartridge.getSRAM();
    }

    @Override
    public int[] getVRAM() {
        return this.vdp.getVRAM();
    }

    private int calcNumberOfBytesPerPaletteEntry() {
        int n = this.vdp.getColorMaxIntensity() + 1;
        return n * n * n >= 256 ? 2 : 1;
    }

    @Override
    public int getNumberOfPaletteBytes() {
        return this.getNumberOfPaletteEntries() * this.calcNumberOfBytesPerPaletteEntry();
    }

    @Override
    public int getNumberOfPaletteEntries() {
        return this.vdp.getCRAM().length;
    }

    @Override
    public int getPaletteByte(int n) {
        int n2 = this.calcNumberOfBytesPerPaletteEntry();
        return this.vdp.getCRAM()[n / n2] >> n % n2 * 8 & 0xFF;
    }

    @Override
    public void setPaletteByte(int n, int n2) {
        int n3 = this.calcNumberOfBytesPerPaletteEntry();
        int n4 = 255 << n % n3 * 8;
        this.vdp.getCRAM()[n / n3] = this.vdp.getCRAM()[n / n3] & ~n4 | n2 << n % n3 * 8;
    }

    @Override
    public String getPaletteName(int n) {
        return null;
    }

    @Override
    public void setAddress(int n, int n2) {
        if (n2 == 3) {
            this.setRegValue(7, n);
        } else if (n2 == 2) {
            this.cartridge.setBank2(n / 16384);
            this.setRegValue(7, 0x8000 | n & 0x3FFF);
        } else if (n2 == 1) {
            this.cartridge.setBank1(n / 16384);
            this.setRegValue(7, 0x4000 | n & 0x3FFF);
        } else if (n2 == 0) {
            if (!this.cartridge.isSEGAmapper() || n >= 1024) {
                this.cartridge.setBank0(n / 16384);
            }
            this.setRegValue(7, n & 0x3FFF);
        }
    }

    @Override
    public int getPrevPC() {
        return this.cpu.getPrevPC();
    }

    @Override
    public int getPC() {
        return this.cpu.getPC();
    }

    @Override
    public int getSP() {
        return this.cpu.getSP();
    }

    @Override
    public int getStackPointer() {
        int n = this.getSP();
        if (!this.isROMaddress(n - 1) || this.isROMaddress(this.cpu.getPrevSP() - 1)) {
            return n;
        }
        return this.cpu.getPrevSP();
    }

    @Override
    public int getVirtualAddress() {
        return this.toVirtualAddress(this.getPC());
    }

    @Override
    public int toVirtualAddress(int n) {
        switch (n >> 14) {
            case 0: {
                return this.getBank0() << 16 | n;
            }
            case 1: {
                return this.getBank1() << 16 | n;
            }
            case 2: {
                if (this.cartridge.isSRAMaddress(n)) {
                    return 0x1000000 | this.cartridge.getSRAMbank() << 16 | n;
                }
                return this.getBank2() << 16 | n;
            }
            case 3: {
                return n;
            }
        }
        return 0;
    }

    @Override
    public int getROMsize() {
        return this.cartridge.getRom().length;
    }

    @Override
    public int getByte(int n) {
        if ((n & 0x1000000) != 0) {
            return this.getSRAM()[this.mapAddress(n & 0xFFFF, n >> 16 & 0xFF)];
        }
        return this.getByte(n & 0xFFFF, n >> 16);
    }

    @Override
    public int getByte(int n, int n2) {
        if (n2 < 0) {
            n2 = this.getBank(n);
        }
        if (this.isROMaddress(n)) {
            return this.cartridge.getRom()[this.mapAddress(n, n2)];
        }
        if (this.isRAMaddress(n)) {
            return this.ram[this.mapAddress(n, n2)];
        }
        if (this.isSRAMaddress(n)) {
            return this.cartridge.getSRAM()[this.mapAddress(n, n2)];
        }
        return 255;
    }

    @Override
    public int peekByte(int n) {
        int n2 = 255;
        if (n < 49152) {
            if (this.cartridgeEnabled) {
                n2 &= this.cartridge.readByte(n, 0);
            }
            if (this.biosEnabled) {
                n2 &= this.bios.readByte(n, 0);
            }
            if (this.cardEnabled) {
                n2 &= this.card.readByte(n, 0);
            }
        } else if (this.ramEnabled) {
            n2 = this.ram[n & 0x1FFF];
        }
        return n2;
    }

    @Override
    public void pokeByte(int n, int n2) {
        if ((n & 0x7FFC) == 32760) {
            this.reg3Dglasses = n2;
        }
        if (n >= 49152) {
            if (n >= 65520) {
                if (this.biosEnabled) {
                    this.bios.processWrite(n, n2, 0);
                }
                if (this.cartridgeEnabled) {
                    this.cartridge.processWrite(n, n2, 0);
                }
                if (this.cardEnabled) {
                    this.card.processWrite(n, n2, 0);
                }
            }
            if (this.ramEnabled) {
                n &= 0x1FFF;
                if (this.biosDone) {
                    this.ramInitialized[n] = true;
                    this.ramSources.remove(n);
                }
                this.ram[n] = n2;
            }
        } else {
            if (this.cartridgeEnabled) {
                this.cartridge.processWrite(n, n2, 0);
            }
            if (this.cardEnabled) {
                this.card.processWrite(n, n2, 0);
            }
        }
    }

    @Override
    public void setByte(int n, int n2, int n3) {
        if (this.isROMaddress(n)) {
            this.cartridge.getRom()[this.mapAddress((int)n, (int)n2)] = n3;
        }
        if (this.isSRAMaddress(n)) {
            this.cartridge.getSRAM()[this.mapAddress((int)n, (int)n2)] = n3;
        }
        if (this.isRAMaddress(n)) {
            int n4 = this.mapAddress(n, n2);
            this.ram[n4] = n3;
            this.ramInitialized[n4] = true;
        }
    }

    @Override
    public String getMemoryName(int n) {
        if ((n & 0xF) == 0) {
            switch (n >> 14) {
                case 0: {
                    return "ROM Slot 0";
                }
                case 1: {
                    return "ROM Slot 1";
                }
                case 2: {
                    return "ROM Slot 2";
                }
                case 3: {
                    return "RAM";
                }
            }
        }
        return null;
    }

    @Override
    public void setMemoryAt(int n, int[] nArray) {
        System.arraycopy(nArray, 0, this.ram, n & this.ram.length - 1, Math.min(this.ram.length - (n & this.ram.length - 1), nArray.length));
    }

    @Override
    public String[] getRegisterNames() {
        return this.cpu.getRegisterNames();
    }

    @Override
    public int indexOfPC() {
        return this.cpu.indexOfPC();
    }

    @Override
    public int getRegisterValue(int n) {
        return this.cpu.getRegisterValue(n);
    }

    @Override
    public int getVRAMaddress() {
        return this.vdp.getAddress();
    }

    @Override
    public boolean isAdditionalRegister(int n) {
        return this.cpu.isAdditionalRegister(n);
    }

    @Override
    public String getAdditionalRegisterName(int n) {
        if (n < 4) {
            return this.cpu.getRegisterNames()[8 + n];
        }
        return (n -= 4) < ADDITIONAL_REGISTER_NAMES.length ? ADDITIONAL_REGISTER_NAMES[n] : null;
    }

    @Override
    public int getAdditionalRegisterValue(int n) {
        if (n < 4) {
            return this.cpu.getRegisterValue(8 + n);
        }
        switch (n -= 4) {
            case 0: {
                return this.cpu.getRegisterValue(12);
            }
            case 1: {
                return this.cpu.getRegisterValue(13);
            }
            case 2: {
                return this.getVRAMaddress();
            }
            case 3: {
                return this.vdp.getLine();
            }
            case 4: {
                return this.cartridge.getBank0();
            }
            case 5: {
                return this.cartridge.getBank1();
            }
            case 6: {
                return this.cartridge.getBank2();
            }
            case 7: {
                return this.cartridge.getSRAMbank();
            }
        }
        return 0;
    }

    @Override
    public int getAdditionalRegisterSize(int n) {
        if (n < 4) {
            return 2;
        }
        switch (n -= 4) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public boolean hasSRAM() {
        return this.cartridge.hasSRAM();
    }

    @Override
    public boolean isROMaddress(int n) {
        return this.isROMaddress(n, false);
    }

    @Override
    public boolean isROMaddress(int n, boolean bl) {
        return this.cartridgeEnabled ^ this.cardEnabled && !this.biosEnabled && this.cartridge.isROMaddress(n) || bl && n < 49152;
    }

    @Override
    public boolean isRAMaddress(int n) {
        return n >= 49152 && n < 65536;
    }

    @Override
    public boolean isRAMaddress(int n, boolean bl) {
        return this.isRAMaddress(n);
    }

    @Override
    public boolean isSRAMaddress(int n) {
        return this.cartridgeEnabled && this.cartridge.isSRAMaddress(n);
    }

    @Override
    public boolean isVRAMaddress(int n) {
        return false;
    }

    @Override
    public int mapAddress(int n) {
        if (this.isRAMaddress(n)) {
            return n & this.ram.length - 1;
        }
        return this.cartridge.mapAddress(n);
    }

    @Override
    public int mapAddress(int n, int n2) {
        if (this.isRAMaddress(n)) {
            return n & this.ram.length - 1;
        }
        return this.cartridge.mapAddress(n, n2);
    }

    @Override
    public int mapAddress(int n, int n2, boolean bl) {
        return this.mapAddress(n, n2);
    }

    @Override
    public int mapVirtualAddress(int n) {
        return this.mapAddress(n & 0xFFFF, n >> 16);
    }

    @Override
    public void setRegValue(int n, int n2) {
        this.cpu.setRegValue(n, n2);
    }

    @Override
    public void setAdditionalRegValue(int n, int n2) {
        if (n < 4) {
            this.cpu.setRegValue(8 + n, n2);
        } else {
            switch (n -= 4) {
                case 0: {
                    this.cpu.setRegValue(12, n2);
                    break;
                }
                case 1: {
                    this.cpu.setRegValue(13, n2);
                    break;
                }
                case 4: {
                    this.cartridge.setBank0(n2);
                    break;
                }
                case 5: {
                    this.cartridge.setBank1(n2);
                    break;
                }
                case 6: {
                    this.cartridge.setBank2(n2);
                    break;
                }
                case 7: {
                    this.cartridge.setSRAMbank(n2);
                }
            }
        }
    }

    @Override
    public String getAdditionalRegisterDescription(int n) {
        return null;
    }

    @Override
    public String[] getFlagNames() {
        return this.cpu.getFlagNames();
    }

    @Override
    public boolean isFlagSet(int n) {
        return this.cpu.isFlagSet(n);
    }

    @Override
    public void setFlagSet(int n, boolean bl) {
        int n2 = this.cpu.getRegisterValue(3);
        n2 = !bl ? (n2 &= ~(1 << n)) : (n2 |= 1 << n);
        this.cpu.setRegValue(3, n2);
    }

    @Override
    public int getNumberOfPorts() {
        return 256;
    }

    @Override
    public int getPortExtension() {
        return 0;
    }

    @Override
    public int getRAMlength() {
        return this.ram.length;
    }

    @Override
    public IntList getAllRAMaddresses() {
        int n;
        int n2 = n = this.hasSRAM() ? this.getRAMlength() + this.getSRAM().length : this.getRAMlength();
        if (this.allRAMaddresses == null || this.allRAMaddresses.size() != n) {
            this.allRAMaddresses = new AbstractIntList(){

                @Override
                public int get(int n2) {
                    if (n2 < MasterSystem.this.getRAMlength()) {
                        return 49152 + n2;
                    }
                    return 0x1000000 | (n2 -= MasterSystem.this.getRAMlength()) / 16384 << 16 | 0x8000 | n2 & 0x1FFF;
                }

                @Override
                public int size() {
                    return n;
                }
            };
        }
        return this.allRAMaddresses;
    }

    @Override
    public int getStackStart() {
        return 49152;
    }

    @Override
    public int getStackLength() {
        return this.getRAMlength();
    }

    @Override
    public int getRAMvalue(int n) {
        return this.ram[n & this.ram.length - 1];
    }

    @Override
    public int getBank0() {
        return this.cartridge.getBank0();
    }

    @Override
    public int getBank1() {
        return this.cartridge.getBank1();
    }

    @Override
    public int getBank2() {
        return this.cartridge.getBank2();
    }

    @Override
    public int getBank3() {
        return this.cartridge.getBank3();
    }

    @Override
    public int getBank(int n) {
        if ((n &= 0xFFFF) < 49152) {
            return this.cartridge.getBank(n);
        }
        return 0;
    }

    @Override
    public void setBank(int n, int n2) {
        if ((n &= 0xFFFF) < 49152) {
            this.cartridge.setBank(n, n2);
        }
    }

    @Override
    public int getRomBankSize() {
        return this.cartridge.getBankSize();
    }

    @Override
    public boolean isSRAMenabled() {
        return this.cartridge.isSRAMenabled();
    }

    @Override
    public void setSRAMenabled(boolean bl) {
        this.cartridge.setSRAMenabled(bl);
    }

    @Override
    public int getSRAMbank() {
        return this.cartridge.getSRAMbank();
    }

    @Override
    public int getScanline() {
        return this.vdp.getLine();
    }

    @Override
    public boolean isHalted() {
        return this.cpu.isHalted();
    }

    @Override
    public boolean isVBlank() {
        return this.vdp.getLine() >= this.vdp.getScreenHeight();
    }

    @Override
    public boolean isInterruptsEnabled() {
        return this.cpu.isInterruptsEnabled();
    }

    @Override
    public void setInterruptsEnabled(boolean bl) {
        this.cpu.setInterruptsEnabled(bl);
    }

    @Override
    public void syncLazyState() {
    }

    @Override
    public boolean isInterruptAddress(int n) {
        return n == 56 || n == 102;
    }

    @Override
    public boolean isConditionMet(int n) {
        int n2 = this.cpu.getRegisterValue(3);
        switch (n) {
            case 0: {
                return (n2 & 0x40) == 0;
            }
            case 1: {
                return (n2 & 0x40) != 0;
            }
            case 2: {
                return (n2 & 1) == 0;
            }
            case 3: {
                return (n2 & 1) != 0;
            }
            case 4: {
                return (n2 & 4) == 0;
            }
            case 5: {
                return (n2 & 4) != 0;
            }
            case 6: {
                return (n2 & 0x80) == 0;
            }
            case 7: {
                return (n2 & 0x80) != 0;
            }
            case 8: {
                return this.cpu.getRegisterValue(0) >> 8 > 1;
            }
        }
        return false;
    }

    @Override
    public boolean canStepOver() {
        int n = this.peekByte(this.getPC());
        return n != 24 && n != 195 && n != 201 && n != 233 && (n != 237 || (this.peekByte(this.getPC() + 1) & 0xC7) != 69);
    }

    @Override
    public RamRomMap getRamRomMap() {
        return this.ramRomMap;
    }

    @Override
    public int[] getErrorCodes() {
        return ERROR_CODES;
    }

    @Override
    public int getNumberOfAdditionalMemoryLocations() {
        return ADDITIONAL_MEMORY_LOCATION_NAMES.length;
    }

    @Override
    public String getAdditionalMemoryLocationName(int n) {
        return ADDITIONAL_MEMORY_LOCATION_NAMES[n];
    }

    @Override
    public int getAdditionalMemoryLocationLength(int n) {
        return ADDITIONAL_MEMORY_LOCATION_LENGTHS[n];
    }

    @Override
    public String getAdditionalMemoryLocationAt(int n) {
        return null;
    }

    @Override
    public boolean isAdditionalMemoryLocationMemoryMapped(String string) {
        return false;
    }

    @Override
    public String cpuAddressToString(int n) {
        switch (n >> 14) {
            case 0: {
                return String.format("ROM%02X:%04X", this.getBank0(), n);
            }
            case 1: {
                return String.format("ROM%02X:%04X", this.getBank1(), n);
            }
            case 2: {
                if (this.cartridge.isSRAMaddress(n)) {
                    return String.format("SRAM%X:%04X", this.cartridge.getSRAMbank(), n);
                }
                return String.format("ROM%02X:%04X", this.getBank2(), n);
            }
            case 3: {
                return String.format(n < 57344 ? "  RAM:%04X" : " ECHO:%04X", n);
            }
        }
        return null;
    }

    @Override
    public String virtualAddressToString(int n) {
        boolean bl = n >> 24 != 0;
        int n2 = n >> 16 & 0xFF;
        int n3 = n & 0xFFFF;
        switch (n3 >> 14) {
            case 0: 
            case 1: {
                return String.format("ROM%02X:%04X", n2, n3);
            }
            case 2: {
                if (bl) {
                    return String.format("SRAM%X:%04X", n2, n3);
                }
                return String.format("ROM%02X:%04X", n2, n3);
            }
            case 3: {
                return String.format(n3 < 57344 ? "  RAM:%04X" : " ECHO:%04X", n3);
            }
        }
        return null;
    }

    @Override
    public String romAddressToString(int n) {
        if (n < 49152) {
            return String.format("%02X:%04X", n / 16384, n);
        }
        return String.format("%02X:%04X", n / 16384, 0x8000 | n & 0x3FFF);
    }

    @Override
    public String ramAddressToString(int n) {
        return String.format("%04X", 0xC000 | n);
    }

    @Override
    public String vramAddressToString(int n) {
        return String.format("%04X", n);
    }

    @Override
    public String sramAddressToString(int n) {
        if (this.getSRAM().length <= 16384) {
            return String.format("%04X", n);
        }
        return String.format("%X:%04X", n / 16384, n & 0x3FFF);
    }

    @Override
    public String palAddressToString(int n) {
        return String.format("PAL%X:%X", n / 16, n & 0xF);
    }

    @Override
    public boolean isRamInitialized(int n) {
        return this.ramInitialized[n];
    }

    @Override
    public boolean isVramInitialized(int n) {
        return true;
    }

    @Override
    public boolean isSramInitialized(int n) {
        return true;
    }

    @Override
    public boolean isCpuMemoryInitialized(int n) {
        if (this.isRAMaddress(n)) {
            return this.isRamInitialized(this.mapAddress(n));
        }
        if (this.isVRAMaddress(n)) {
            return this.isVramInitialized(this.mapAddress(n));
        }
        if (this.isSRAMaddress(n)) {
            return this.isSramInitialized(this.mapAddress(n));
        }
        return true;
    }

    @Override
    public boolean isPaletteInitialized(int n) {
        return true;
    }

    @Override
    public EventModel createEventModel() {
        if (this.eventModel == null) {
            EventType[] eventTypeArray = MasterSystemEventTypes.values();
            String[][] stringArray = new String[][]{{"Sync enable", "Extra height enable/TMS9918 mode select", "Mode 4 enable", "Shift sprites left 8 pixels", "Enable line interrupts", "Hide leftmost 8 pixels", "Horizontal scroll lock", "Vertical scroll lock"}, {"Doubled (stretched) sprites", "Large (tiled) sprites", "Unused", "240-line mode/TMS9918 mode select", "224-line mode/TMS9918 mode select", "Enable frame interrupts", "Enable display"}};
            this.eventModel = new AbstractArrayListEventModel(eventTypeArray, (MasterSystemEventTypes[])eventTypeArray, stringArray){
                private final /* synthetic */ MasterSystemEventTypes[] val$eventTypes;
                private final /* synthetic */ String[][] val$bitLabels;
                {
                    this.val$eventTypes = masterSystemEventTypesArray;
                    this.val$bitLabels = stringArray;
                    super(eventTypeArray);
                }

                @Override
                protected String pcToString(int n) {
                    return MasterSystem.this.virtualAddressToString(n).trim();
                }

                @Override
                protected String getDetails(Event event) {
                    if (event.getType() >= this.val$eventTypes.length) {
                        return null;
                    }
                    switch (this.val$eventTypes[event.getType()]) {
                        case VDP0: {
                            int n = event.getNewValue() ^ event.getOldValue();
                            boolean bl = (n & 6) != 0;
                            n &= 0xFFFFFFF9;
                            StringBuilder stringBuilder = new StringBuilder();
                            if (bl) {
                                stringBuilder.append("Mode: " + MasterSystem.this.vdp.getModeName(event.getDetailsData()));
                            }
                            int n2 = 1;
                            int n3 = 0;
                            while (n3 < this.val$bitLabels[0].length) {
                                if ((n & n2) != 0) {
                                    if (stringBuilder.length() > 0) {
                                        stringBuilder.append(", ");
                                    }
                                    stringBuilder.append(this.val$bitLabels[0][n3]).append(' ').append((event.getNewValue() & n2) != 0 ? "Enabled" : "Disabled");
                                }
                                n2 <<= 1;
                                ++n3;
                            }
                            return stringBuilder.toString();
                        }
                        case VDP1: {
                            int n = event.getNewValue() ^ event.getOldValue();
                            boolean bl = (n & 0x18) != 0;
                            n &= 0xFFFFFFE7;
                            StringBuilder stringBuilder = new StringBuilder();
                            if (bl) {
                                stringBuilder.append("Mode: " + MasterSystem.this.vdp.getModeName(event.getDetailsData()));
                            }
                            int n4 = 1;
                            int n5 = 0;
                            while (n5 < this.val$bitLabels[1].length) {
                                if ((n & n4) != 0) {
                                    if (stringBuilder.length() > 0) {
                                        stringBuilder.append(", ");
                                    }
                                    stringBuilder.append(this.val$bitLabels[1][n5]).append(' ').append((event.getNewValue() & n4) != 0 ? "Enabled" : "Disabled");
                                }
                                n4 <<= 1;
                                ++n5;
                            }
                            return stringBuilder.toString();
                        }
                        case VDP2: {
                            return "Name Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP3: {
                            return "Color Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP4: {
                            return "Pattern Generator Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP5: {
                            return "Sprite Attribute Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP6: {
                            return "Sprite Pattern Generator Table Base Address: " + String.format("%04X", event.getDetailsData());
                        }
                        case VDP7: {
                            return "Foreground Color: " + (event.getNewValue() >> 4) + ", Backdrop Color: " + (event.getNewValue() & 0xF);
                        }
                        case VDP8: {
                            return "Background X Scroll: " + event.getNewValue();
                        }
                        case VDP9: {
                            return "Background Y Scroll: " + event.getNewValue();
                        }
                        case VDP10: {
                            return "Line Counter: " + event.getNewValue();
                        }
                        case RAM: {
                            if (event.getNewValue() >= 0) {
                                return "RAM write to " + MasterSystem.this.ramAddressToString(event.getDetailsData());
                            }
                            return "RAM read from " + MasterSystem.this.ramAddressToString(event.getDetailsData());
                        }
                        case SRAM: {
                            if (event.getNewValue() >= 0) {
                                return "SRAM write to " + MasterSystem.this.sramAddressToString(event.getDetailsData());
                            }
                            return "SRAM read from " + MasterSystem.this.sramAddressToString(event.getDetailsData());
                        }
                        case CRAM: {
                            return "CRAM write to " + String.format("%02X", event.getDetailsData() & 0x1F);
                        }
                        case VRAM: {
                            if (event.getNewValue() >= 0) {
                                return "VRAM write to " + String.format("%04X", event.getDetailsData() & 0x1FFFF);
                            }
                            return "VRAM read from " + String.format("%04X", event.getDetailsData() & 0x1FFFF);
                        }
                        case HALT: {
                            return event.getNewValue() != 0 ? "Halted" : "Unhalted";
                        }
                    }
                    return null;
                }

                @Override
                protected int getCurrentScanline() {
                    return MasterSystem.this.getScanline();
                }

                @Override
                protected int getCurrentDot() {
                    return (228 - MasterSystem.this.vdp.getTimer()) * 3 / 2;
                }

                @Override
                protected int getCurrentPC() {
                    return MasterSystem.this.getVirtualAddress();
                }

                @Override
                public int getBreakpointEventId() {
                    return MasterSystemEventTypes.BREAKPOINT.ordinal();
                }

                @Override
                public int getExceptionEventId() {
                    return MasterSystemEventTypes.EXCEPTION.ordinal();
                }

                @Override
                protected boolean isRead(Event event) {
                    return event.getOldValue() >= 0 && event.getNewValue() < 0;
                }
            };
        }
        return this.eventModel;
    }

    protected void handleVdpRegisterEvent(int n, int n2, int n3, int n4) {
        MasterSystemEventTypes masterSystemEventTypes;
        if (this.eventModel != null && (masterSystemEventTypes = MasterSystemEventTypes.get(n)) != null) {
            switch (masterSystemEventTypes) {
                case VDP0: 
                case VDP1: {
                    this.addEvent(masterSystemEventTypes, n2, n3, n4, this.vdp.getModeBits());
                    break;
                }
                case VDP2: {
                    this.addEvent(masterSystemEventTypes, n2, n3, n4, this.getScreenMapBaseAddress());
                    break;
                }
                case VDP3: {
                    this.addEvent(masterSystemEventTypes, n2, n3, n4, this.getColorTableAddress());
                    break;
                }
                case VDP4: {
                    this.addEvent(masterSystemEventTypes, n2, n3, n4, this.getPatternGeneratorTableAddress());
                    break;
                }
                case VDP5: {
                    this.addEvent(masterSystemEventTypes, n2, n3, n4, this.getSpriteAttributeTableAddress());
                    break;
                }
                case VDP6: {
                    this.addEvent(masterSystemEventTypes, n2, n3, n4, this.getSpritePatternAddress());
                    break;
                }
                default: {
                    this.addEvent(masterSystemEventTypes, n2, n3, n4);
                }
            }
        }
    }

    protected void addEvent(MasterSystemEventTypes masterSystemEventTypes, int n) {
        this.addEvent(masterSystemEventTypes, -1, -1, n);
    }

    protected void addEvent(MasterSystemEventTypes masterSystemEventTypes, int n, int n2, int n3) {
        this.addEvent(masterSystemEventTypes, n, n2, n3, -1);
    }

    protected void addEvent(MasterSystemEventTypes masterSystemEventTypes, int n, int n2, int n3, int n4) {
        this.addEvent(masterSystemEventTypes, n, n2, n3, n4, null);
    }

    protected void addEvent(MasterSystemEventTypes masterSystemEventTypes, int n, int n2, int n3, int n4, String string) {
        if (this.eventModel != null) {
            this.eventModel.addEvent(masterSystemEventTypes, this.getScanline(), n3, n, n2, this.getVirtualAddress(), n4, string);
        }
    }

    @Override
    public void addDebugEvent(DebuggableSystem.DebugEvent debugEvent, String string) {
        switch (debugEvent) {
            case BREAKPOINT: {
                this.addEvent(MasterSystemEventTypes.BREAKPOINT, -1, -1, (228 - this.vdp.getTimer()) * 3 / 2, -1, string);
                break;
            }
            case EXCEPTION: {
                this.addEvent(MasterSystemEventTypes.EXCEPTION, -1, -1, (228 - this.vdp.getTimer()) * 3 / 2, -1, string);
            }
        }
    }

    protected void frameFinished() {
        this.inputDevices[0].frameFinished();
        this.inputDevices[1].frameFinished();
        if (this.eventModel != null) {
            this.eventModel.finishFrame();
        }
    }

    protected void handleInputChanges() {
        int n = this.getInputState();
        if (n != this.prevInputState) {
            this.fireInputStateChanged(n);
            this.prevInputState = n;
        }
    }

    public int getInputState() {
        return this.inputDevices[0].getState() | this.inputDevices[1].getState() | this.buttons.getState();
    }

    @Override
    public void setInputState(long l) {
        this.inputDevices[0].setState(l);
        this.inputDevices[1].setState(l);
        this.buttons.setState(l);
    }

    @Override
    public void setDebugger(DebuggableSystem debuggableSystem) {
        if (debuggableSystem == null) {
            debuggableSystem = this;
        }
        this.cpu.setMemoryMap(debuggableSystem);
    }

    public void setVdpReg(int n, int n2) {
        this.vdp.setReg(n, n2);
    }

    public void setPsgReg(int n, int n2) {
        this.psg.setReg(n, n2);
    }

    public void setFmReg(int n, int n2) {
        this.fm.writeReg(n, n2);
    }

    public boolean hasFM() {
        return this.fm != null;
    }

    public int getScreenMapBaseAddress() {
        return this.vdp.getScreenMapBaseAddress();
    }

    public int getColorTableAddress() {
        return this.vdp.getColorTableAddress();
    }

    public int getPatternGeneratorTableAddress() {
        return this.vdp.getPatternGeneratorTableAddress();
    }

    public int getSpriteAttributeTableAddress() {
        return this.vdp.getSpriteAttributeTableAddress();
    }

    public int getSpritePatternAddress() {
        return this.vdp.getSpritePatternAddress();
    }

    private void handleMessage() {
        this.fireMessageSent(Z80MessageParser.parseMessage(this));
    }

    protected void fireMessageSent(String string) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n = this.systemEventListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemEventListener systemEventListener = systemEventListenerArray[n2];
            systemEventListener.messageSent(string);
            ++n2;
        }
    }

    protected void fireInputStateChanged(int n) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n2 = this.systemEventListeners.length;
        int n3 = 0;
        while (n3 < n2) {
            SystemEventListener systemEventListener = systemEventListenerArray[n3];
            systemEventListener.inputStateChanged(n);
            ++n3;
        }
    }

    protected void fireErrorOccurred(int n, int n2) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n3 = this.systemEventListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemEventListener systemEventListener = systemEventListenerArray[n4];
            systemEventListener.errorOccurred(n, n2);
            ++n4;
        }
    }

    protected void fireVRAMread(int n, int n2) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n3 = this.systemEventListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemEventListener systemEventListener = systemEventListenerArray[n4];
            systemEventListener.vramRead(n, n2);
            ++n4;
        }
    }

    protected void fireVRAMwrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.vramWrite(n, n2, n3);
            ++n5;
        }
    }

    protected void fireCRAMwrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("palettes", n, n2, n3);
            ++n5;
        }
    }

    protected void fireVRAMaddressWritten() {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n = this.systemEventListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemEventListener systemEventListener = systemEventListenerArray[n2];
            systemEventListener.vramAddressWritten();
            ++n2;
        }
    }

    protected void fireVRAMaddressWriteCancelled() {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n = this.systemEventListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemEventListener systemEventListener = systemEventListenerArray[n2];
            systemEventListener.vramAddressWriteCancelled();
            ++n2;
        }
    }

    protected void fireVdpRegisterWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("vdp", n, n2, n3);
            ++n5;
        }
    }

    protected void firePsgRegisterWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("psg", n, n2, n3);
            ++n5;
        }
    }

    protected void fireFmRegisterWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("fm", n, n2, n3);
            ++n5;
        }
    }

    @Override
    public void addSystemEventListener(SystemEventListener systemEventListener) {
        if (!this.systemEventListenerList.contains(systemEventListener)) {
            this.systemEventListenerList.addFirst(systemEventListener);
            this.systemEventListeners = this.systemEventListenerList.toArray(new SystemEventListener[this.systemEventListenerList.size()]);
        }
    }

    @Override
    public void removeSystemEventListener(SystemEventListener systemEventListener) {
        if (this.systemEventListenerList.remove(systemEventListener)) {
            this.systemEventListeners = this.systemEventListenerList.toArray(new SystemEventListener[this.systemEventListenerList.size()]);
        }
    }

    protected void firePortWritten(int n, int n2, int n3) {
        OutputListener[] outputListenerArray = this.portListeners;
        int n4 = this.portListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            OutputListener outputListener = outputListenerArray[n5];
            outputListener.outputAvailable(n, n2, n3);
            ++n5;
        }
    }

    protected void firePortRead(int n, int n2, int n3) {
        OutputListener[] outputListenerArray = this.portListeners;
        int n4 = this.portListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            OutputListener outputListener = outputListenerArray[n5];
            outputListener.outputAvailable(n, Integer.MIN_VALUE | n2, n3);
            ++n5;
        }
    }

    @Override
    public void addPortListener(OutputListener outputListener) {
        if (!this.portListenerList.contains(outputListener)) {
            this.portListenerList.addFirst(outputListener);
            this.portListeners = this.portListenerList.toArray(new OutputListener[this.portListenerList.size()]);
        }
    }

    @Override
    public void removePortListener(OutputListener outputListener) {
        if (this.portListenerList.remove(outputListener)) {
            this.portListeners = this.portListenerList.toArray(new OutputListener[this.portListenerList.size()]);
        }
    }

    public void addOutputListener(OutputListener outputListener) {
        this.vdp.addOutputListener(outputListener);
        this.psg.addOutputListener(outputListener);
        if (this.fm != null) {
            this.fm.addOutputListener(outputListener);
        }
    }

    public void removeOutputListener(OutputListener outputListener) {
        this.vdp.removeOutputListener(outputListener);
        this.psg.removeOutputListener(outputListener);
        if (this.fm != null) {
            this.fm.removeOutputListener(outputListener);
        }
    }

    @Override
    public EmulatableSystem.State createMutableState() {
        return this.getState().clone();
    }

    @Override
    public State getState() {
        final Z80.State state = this.cpu.getState();
        final TMS9918A.State state2 = this.vdp.getState();
        final SMSCartridge.State state3 = this.cartridge.getState();
        final SN76489.State state4 = this.psg.getState();
        final YM2413.State state5 = this.fm != null ? this.fm.getState() : new YM2413(this.CYCLES_PER_SECOND).getState();
        final int[] nArray = this.ram;
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public boolean isCartridgeEnabled() {
                return MasterSystem.this.cartridgeEnabled;
            }

            @Override
            public boolean isCardEnabled() {
                return MasterSystem.this.cardEnabled;
            }

            @Override
            public boolean isBiosEnabled() {
                return MasterSystem.this.biosEnabled;
            }

            @Override
            public boolean isRamEnabled() {
                return MasterSystem.this.ramEnabled;
            }

            @Override
            public boolean isIoEnabled() {
                return MasterSystem.this.ioEnabled;
            }

            @Override
            public boolean isPsgEnabled() {
                return MasterSystem.this.audioMixer.isPsgEnabled();
            }

            @Override
            public boolean isFmEnabled() {
                return MasterSystem.this.audioMixer.isFmEnabled();
            }

            @Override
            public int[] getRam() {
                return nArray;
            }

            @Override
            public int getReg3Dglasses() {
                return MasterSystem.this.reg3Dglasses;
            }

            @Override
            public int getPort3F() {
                return MasterSystem.this.makePort3FforState();
            }

            @Override
            public SMSCartridge.State getCartridgeState() {
                return state3;
            }

            @Override
            public Z80.State getCPUstate() {
                return state;
            }

            @Override
            public TMS9918A.State getVDPstate() {
                return state2;
            }

            @Override
            public SN76489.State getPSGstate() {
                return state4;
            }

            @Override
            public YM2413.State getFMstate() {
                return state5;
            }

            @Override
            public boolean[] getRamInitialized() {
                return MasterSystem.this.ramInitialized;
            }
        };
    }

    @Override
    public void setState(EmulatableSystem.State state, boolean bl, boolean bl2) {
        if (state instanceof State) {
            this.predetectMapper();
            State state2 = (State)state;
            this.cartridgeEnabled = state2.isCartridgeEnabled();
            this.cardEnabled = state2.isCardEnabled();
            this.biosEnabled = state2.isBiosEnabled();
            this.ramEnabled = state2.isRamEnabled();
            this.ioEnabled = state2.isIoEnabled();
            this.audioMixer.setState(state2.isPsgEnabled(), state2.isFmEnabled());
            System.arraycopy(state2.getRam(), 0, this.ram, 0, Math.min(this.ram.length, state2.getRam().length));
            System.arraycopy(state2.getRamInitialized(), 0, this.ramInitialized, 0, this.ramInitialized.length);
            this.setPort3F(state2.getPort3F());
            this.reg3Dglasses = state2.getReg3Dglasses();
            this.cartridge.setState(state2.getCartridgeState(), bl);
            this.cpu.setState(state2.getCPUstate());
            this.vdp.setState(state2.getVDPstate(), bl2);
            this.psg.setState(state2.getPSGstate());
            if (this.fm != null) {
                this.fm.setState(state2.getFMstate());
            }
        }
    }

    @Override
    public void loadSAV(File file) {
        this.cartridge.readRAMfromFile(file);
    }

    public static interface State
    extends EmulatableSystem.State {
        public boolean isCartridgeEnabled();

        public boolean isCardEnabled();

        public boolean isBiosEnabled();

        public boolean isRamEnabled();

        public boolean isIoEnabled();

        public boolean isPsgEnabled();

        public boolean isFmEnabled();

        public int[] getRam();

        public int getReg3Dglasses();

        public int getPort3F();

        public SMSCartridge.State getCartridgeState();

        public Z80.State getCPUstate();

        public TMS9918A.State getVDPstate();

        public SN76489.State getPSGstate();

        public YM2413.State getFMstate();

        public boolean[] getRamInitialized();
    }

    private static class StateClone
    implements State {
        private boolean cartridgeEnabled;
        private boolean cardEnabled;
        private boolean biosEnabled;
        private boolean ramEnabled;
        private boolean ioEnabled;
        private boolean psgEnabled;
        private boolean fmEnabled;
        private final int[] ram;
        private int port3F;
        private int reg3Dglasses;
        private final SMSCartridge.State cartridge;
        private final Z80.State cpu;
        private final TMS9918A.State vdp;
        private final SN76489.State psg;
        private final YM2413.State fm;
        private final boolean[] ramInitialized;

        public StateClone(State state) {
            this.cartridgeEnabled = state.isCartridgeEnabled();
            this.cardEnabled = state.isCardEnabled();
            this.biosEnabled = state.isBiosEnabled();
            this.ramEnabled = state.isRamEnabled();
            this.ioEnabled = state.isIoEnabled();
            this.psgEnabled = state.isPsgEnabled();
            this.fmEnabled = state.isFmEnabled();
            this.ram = new int[state.getRam().length];
            System.arraycopy(state.getRam(), 0, this.ram, 0, Math.min(this.ram.length, state.getRam().length));
            this.port3F = state.getPort3F();
            this.reg3Dglasses = state.getReg3Dglasses();
            this.cartridge = state.getCartridgeState().clone();
            this.cpu = state.getCPUstate().clone();
            this.vdp = state.getVDPstate().clone();
            this.psg = state.getPSGstate().clone();
            this.fm = state.getFMstate().clone();
            boolean[] blArray = state.getRamInitialized();
            this.ramInitialized = new boolean[this.ram.length];
            System.arraycopy(blArray, 0, this.ramInitialized, 0, blArray.length);
        }

        @Override
        public void setState(EmulatableSystem.State state) throws UnmodifiableClassException {
            State state2 = (State)state;
            this.cartridgeEnabled = state2.isCartridgeEnabled();
            this.cardEnabled = state2.isCardEnabled();
            this.biosEnabled = state2.isBiosEnabled();
            this.ramEnabled = state2.isRamEnabled();
            this.ioEnabled = state2.isIoEnabled();
            this.psgEnabled = state2.isPsgEnabled();
            this.fmEnabled = state2.isFmEnabled();
            System.arraycopy(state2.getRam(), 0, this.ram, 0, Math.min(this.ram.length, state2.getRam().length));
            this.port3F = state2.getPort3F();
            this.reg3Dglasses = state2.getReg3Dglasses();
            this.cartridge.setState(state2.getCartridgeState());
            this.cpu.setState(state2.getCPUstate());
            this.vdp.setState(state2.getVDPstate());
            this.psg.setState(state2.getPSGstate());
            this.fm.setState(state2.getFMstate());
            boolean[] blArray = state2.getRamInitialized();
            System.arraycopy(blArray, 0, this.ramInitialized, 0, blArray.length);
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public boolean isCartridgeEnabled() {
            return this.cartridgeEnabled;
        }

        @Override
        public boolean isCardEnabled() {
            return this.cardEnabled;
        }

        @Override
        public boolean isBiosEnabled() {
            return this.biosEnabled;
        }

        @Override
        public boolean isRamEnabled() {
            return this.ramEnabled;
        }

        @Override
        public boolean isIoEnabled() {
            return this.ioEnabled;
        }

        @Override
        public boolean isPsgEnabled() {
            return this.psgEnabled;
        }

        @Override
        public boolean isFmEnabled() {
            return this.fmEnabled;
        }

        @Override
        public int[] getRam() {
            return this.ram;
        }

        @Override
        public int getReg3Dglasses() {
            return this.reg3Dglasses;
        }

        @Override
        public int getPort3F() {
            return this.port3F;
        }

        @Override
        public SMSCartridge.State getCartridgeState() {
            return this.cartridge;
        }

        @Override
        public Z80.State getCPUstate() {
            return this.cpu;
        }

        @Override
        public TMS9918A.State getVDPstate() {
            return this.vdp;
        }

        @Override
        public SN76489.State getPSGstate() {
            return this.psg;
        }

        @Override
        public YM2413.State getFMstate() {
            return this.fm;
        }

        @Override
        public boolean[] getRamInitialized() {
            return this.ramInitialized;
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(EmulatableSystem.State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

