/*
 * Decompiled with CFR 0.152.
 */
package replay;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import replay.Bk2GBInputLog;
import replay.Bk2MSXInputLog;
import replay.GBInputLog;
import replay.MSXInputLog;

public class Bk2ReplayData {
    private final ZipFile zipFile;
    private boolean closed;

    public Bk2ReplayData(File file) throws IOException {
        this.zipFile = new ZipFile(file);
    }

    public InputStream getFile(String string) throws IOException {
        ZipEntry zipEntry = this.zipFile.getEntry(string);
        if (zipEntry == null) {
            throw new FileNotFoundException("Could not find '" + string + "' in " + this.zipFile.getName());
        }
        return this.zipFile.getInputStream(zipEntry);
    }

    public MSXInputLog getMSXInputLog() throws IOException {
        return new Bk2MSXInputLog(this);
    }

    public GBInputLog getGBInputLog() throws IOException {
        return new Bk2GBInputLog(this);
    }

    public void close() throws IOException {
        this.zipFile.close();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    InputStream getInputLog() throws IOException {
        return this.getFile("Input Log.txt");
    }
}

