/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import common.MenuItem;
import common.ScreenUtilities;
import expressions.ParseException;
import expressions.UnknownVariableException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import platform.Emulicious;
import platform.debugger.Debugger;
import treetable.AbstractTreeTableModel;
import treetable.TreeTable;

class ProfilerWindow {
    private static ProfilerWindow profilerWindow;
    private static boolean wasEnabled;
    final Window window;
    Debugger debugger;
    JTable table;
    DefaultTableModel tableModel;
    boolean mayUpdateGUI;
    int firstRowToUpdate = Integer.MAX_VALUE;
    int lastRowToUpdate = Integer.MIN_VALUE;
    TreeTable treeTable;
    ProcedureProfilerModel procedureProfilerModel;
    JTable hotSpotsTable;
    HotSpotTableModel hotSpotsTableModel;
    final JCheckBox enableProcedureProfiler = new JCheckBox("Enable Procedure Profiler");
    final JCheckBox profileInterruptsInSeparateRoots = new JCheckBox("Profile interrupts in separate roots", Boolean.parseBoolean(Emulicious.getProperties().getProperty("ProfileInterruptsInSeparateRoots")));
    final JTabbedPane tabbedPane = new JTabbedPane();
    final ArrayList<ProfilingData> profilingData = new ArrayList();
    ProcedureProfilingData currentProcedure;
    ProcedureProfilingData currentProcedureEx;
    LinkedHashMap<String, SummedProcedureProfilingData> hotSpots = new LinkedHashMap();
    boolean profiling;
    boolean enableAfterInterrupt;
    private boolean wasExecutingInterrupt;
    private boolean shouldMergeNext;
    volatile boolean sortingHotspotsTable;
    private long prevCycles;
    long totalCycles;

    private ProfilerWindow(Window window, Debugger debugger, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Profiler");
        this.window.setIconImages(window.getIconImages());
        this.debugger = debugger;
        this.tabbedPane.add("General", this.createProfilerTable());
        this.tabbedPane.add("Procedures", this.createProcedureProfilerPanel());
        this.window.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.setSelectedIndex(1);
        if (!Boolean.parseBoolean(Emulicious.getProperties().getProperty("Window" + this.getClass().getSimpleName() + "ProcedureProfiler"))) {
            this.tabbedPane.setSelectedIndex(0);
        }
        debugger.installRunActions(this.getRootPane());
        if (profilerWindow == null || !profilerWindow.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private JRootPane getRootPane() {
        if (this.window instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)this.window)).getRootPane();
        }
        return null;
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private boolean isProcedureProfilerSelected() {
        return this.tabbedPane.getSelectedIndex() == 1;
    }

    private JScrollPane createProfilerTable() {
        this.tableModel = new DefaultTableModel(new Object[]{"", "Start Address", "End Address", "Measurements", "Cycles (Min/Max/Avg)", "Instructions (Min/Max/Avg)", "Scanlines (Min/Max/Avg)"}, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n < this.getRowCount() - 1) {
                    return n2 <= 2;
                }
                return n2 == 1;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n < this.getRowCount() - 1) {
                    if (n2 == 0) {
                        ProfilingData profilingData = ProfilerWindow.this.profilingData.get(n);
                        profilingData.active = Boolean.parseBoolean(object.toString());
                    } else if (n2 == 1) {
                        ProfilingData profilingData = ProfilerWindow.this.profilingData.get(n);
                        try {
                            ProfilingData profilingData2 = new ProfilingData(object.toString(), profilingData.endText);
                            if (!profilingData2.equals(profilingData)) {
                                ProfilerWindow.this.profilingData.set(n, profilingData2);
                                this.fireTableRowsUpdated(n, n);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            illegalArgumentException.printStackTrace();
                        }
                    } else if (n2 == 2) {
                        ProfilingData profilingData = ProfilerWindow.this.profilingData.get(n);
                        try {
                            ProfilingData profilingData3 = new ProfilingData(profilingData.startText, object.toString());
                            if (!profilingData3.equals(profilingData)) {
                                ProfilerWindow.this.profilingData.set(n, profilingData3);
                                this.fireTableRowsUpdated(n, n);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            illegalArgumentException.printStackTrace();
                        }
                    }
                } else if (n2 == 1) {
                    try {
                        ProfilerWindow.this.profilingData.add(new ProfilingData(object.toString(), null));
                        ProfilerWindow.this.table.clearSelection();
                        this.fireTableRowsInserted(n, n);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                }
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n < this.getRowCount() - 1) {
                    ProfilingData profilingData = ProfilerWindow.this.profilingData.get(n);
                    switch (n2) {
                        case 0: {
                            return profilingData.active;
                        }
                        case 1: {
                            return profilingData.startText;
                        }
                        case 2: {
                            return profilingData.endText;
                        }
                        case 3: {
                            return profilingData.getMeasurements();
                        }
                        case 4: {
                            return String.format("%d/%d/%.1f", profilingData.getMinCycles(), profilingData.getMaxCycles(), profilingData.getAvgCycles());
                        }
                        case 5: {
                            return String.format("%d/%d/%.1f", profilingData.getMinInstructions(), profilingData.getMaxInstructions(), profilingData.getAvgInstructions());
                        }
                        case 6: {
                            return String.format("%d/%d/%.1f", profilingData.getMinScanlines(), profilingData.getMaxScanlines(), profilingData.getAvgScanlines());
                        }
                    }
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return ProfilerWindow.this.profilingData.size() + 1;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n <= 0) {
                    return Boolean.class;
                }
                return super.getColumnClass(n);
            }
        };
        this.table = new JTable(this.tableModel){

            @Override
            public void updateUI() {
                super.updateUI();
                Dimension dimension = this.getCellRenderer(0, 1).getTableCellRendererComponent(this, "_LABEL_0_", false, false, 0, 1).getPreferredSize();
                this.setRowHeight(Math.max(dimension.height, this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, null, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height));
            }

            @Override
            public Color getForeground() {
                return ProfilerWindow.this.debugger.getTableForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return ProfilerWindow.this.debugger.getTableSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return ProfilerWindow.this.debugger.getTableBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return ProfilerWindow.this.debugger.getTableSelectionBackground();
            }

            @Override
            public Color getGridColor() {
                Color color = super.getGridColor();
                if (color != null && color.equals(Color.WHITE)) {
                    return Color.GRAY;
                }
                return color;
            }

            @Override
            public Font getFont() {
                return ProfilerWindow.this.debugger.getFont();
            }

            @Override
            public void setFont(Font font) {
                Component component = this.getEditorComponent();
                if (component == null) {
                    component = this.getDefaultEditor(Object.class).getTableCellEditorComponent(this, null, false, 0, 0);
                }
                component.setFont(this.getFont());
            }
        };
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JComponent) {
                    ((JComponent)component).setToolTipText(null);
                }
                if (n < jTable.getRowCount() - 1) {
                    if (n2 == 4 && component instanceof JComponent) {
                        ((JComponent)component).setToolTipText(ProfilerWindow.this.profilingData.get(n).cyclesAsMillis());
                    }
                } else if (n2 == 1 && component instanceof JLabel) {
                    ((JLabel)component).setText("Add Profiler");
                }
                return component;
            }
        });
        ((DefaultCellEditor)this.table.getDefaultEditor(Object.class)).setClickCountToStart(1);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.isPopupTrigger() && (n = ProfilerWindow.this.table.rowAtPoint(mouseEvent.getPoint())) < ProfilerWindow.this.profilingData.size()) {
                    if (!ProfilerWindow.this.table.getSelectionModel().isSelectedIndex(n)) {
                        ProfilerWindow.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                    ProfilerWindow.this.showPopupMenu(mouseEvent.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.isPopupTrigger() && (n = ProfilerWindow.this.table.rowAtPoint(mouseEvent.getPoint())) < ProfilerWindow.this.profilingData.size()) {
                    if (!ProfilerWindow.this.table.getSelectionModel().isSelectedIndex(n)) {
                        ProfilerWindow.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                    ProfilerWindow.this.showPopupMenu(mouseEvent.getPoint());
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0 && ProfilerWindow.this.table.getSelectedRow() >= 0 && ProfilerWindow.this.table.getSelectedRow() < ProfilerWindow.this.table.getRowCount() - 1) {
                    ProfilerWindow.this.debugger.setSelectedAddress(ProfilerWindow.this.profilingData.get((int)ProfilerWindow.this.table.getSelectedRow()).start);
                }
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.table.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "delete");
        this.table.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (ProfilerWindow.this.table.getSelectedRow() >= 0 && ProfilerWindow.this.table.getSelectedRow() < ProfilerWindow.this.table.getRowCount() - 1) {
                    ProfilerWindow.this.profilingData.remove(ProfilerWindow.this.table.getSelectedRow());
                    ProfilerWindow.this.tableModel.fireTableRowsDeleted(ProfilerWindow.this.table.getSelectedRow(), ProfilerWindow.this.table.getSelectedRow());
                }
            }
        });
        this.table.setFillsViewportHeight(true);
        int n = this.table.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this.table, (Object)this.table.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(n);
        tableColumn.setMaxWidth(n);
        Dimension dimension = this.table.getCellRenderer(0, 1).getTableCellRendererComponent(this.table, "Add Profiler", false, false, 0, 1).getPreferredSize();
        n = dimension.width;
        int n2 = 0;
        while (n2 < this.table.getRowCount()) {
            int n3 = this.table.getCellRenderer((int)n2, (int)1).getTableCellRendererComponent((JTable)this.table, (Object)this.table.getValueAt((int)n2, (int)1), (boolean)false, (boolean)false, (int)n2, (int)1).getPreferredSize().width;
            n = Math.max(n, n3);
            ++n2;
        }
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n + this.table.getIntercellSpacing().width);
        n2 = n;
        tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(n + this.table.getIntercellSpacing().width);
        n2 += n;
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.table.getTableHeader().getDefaultRenderer();
        }
        tableColumn = this.table.getColumnModel().getColumn(3);
        int n4 = n = tableCellRenderer.getTableCellRendererComponent((JTable)this.table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)3).getPreferredSize().width;
        tableColumn = this.table.getColumnModel().getColumn(4);
        n = tableCellRenderer.getTableCellRendererComponent((JTable)this.table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)4).getPreferredSize().width;
        if (n > n4) {
            n4 = n;
        }
        tableColumn = this.table.getColumnModel().getColumn(5);
        n = tableCellRenderer.getTableCellRendererComponent((JTable)this.table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)5).getPreferredSize().width;
        if (n > n4) {
            n4 = n;
        }
        tableColumn = this.table.getColumnModel().getColumn(6);
        n = tableCellRenderer.getTableCellRendererComponent((JTable)this.table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)6).getPreferredSize().width;
        if (n > n4) {
            n4 = n;
        }
        int n5 = tableCellRenderer.getTableCellRendererComponent((JTable)this.table, (Object)"214748364721474836472147483647", (boolean)false, (boolean)false, (int)-1, (int)2).getPreferredSize().width;
        tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setMinWidth(n4 += this.table.getIntercellSpacing().width);
        tableColumn.setPreferredWidth(n5);
        n2 += n5;
        tableColumn = this.table.getColumnModel().getColumn(4);
        tableColumn.setMinWidth(n4);
        tableColumn.setPreferredWidth(n5);
        n2 += n5;
        tableColumn = this.table.getColumnModel().getColumn(5);
        tableColumn.setMinWidth(n4);
        tableColumn.setPreferredWidth(n5);
        n2 += n5;
        tableColumn = this.table.getColumnModel().getColumn(6);
        tableColumn.setMinWidth(n4);
        tableColumn.setPreferredWidth(n5);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(n2 += n5, jScrollPane.getPreferredSize().height));
        return jScrollPane;
    }

    private JPanel createProcedureProfilerPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.enableProcedureProfiler);
        JButton jButton = new JButton("Reset");
        this.enableProcedureProfiler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ProfilerWindow.this.enableAfterInterrupt = ProfilerWindow.this.enableProcedureProfiler.isSelected() && ProfilerWindow.this.profileInterruptsInSeparateRoots.isSelected() && ProfilerWindow.this.debugger.isExecutingInterrupt();
                if (!ProfilerWindow.this.enableAfterInterrupt) {
                    if (ProfilerWindow.this.enableProcedureProfiler.isSelected()) {
                        ProfilerWindow.reset();
                    }
                    ProfilerWindow.this.profiling = ProfilerWindow.this.enableProcedureProfiler.isSelected();
                }
            }
        });
        if (wasEnabled) {
            this.enableProcedureProfiler.doClick(0);
        }
        jPanel2.add(this.profileInterruptsInSeparateRoots);
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ProfilerWindow.this.profiling;
                ProfilerWindow.this.profiling = false;
                ProfilerWindow.reset();
                if (bl) {
                    ProfilerWindow.this.enableProcedureProfiler.setSelected(false);
                    ProfilerWindow.this.enableProcedureProfiler.doClick(0);
                }
            }
        });
        jPanel.add((Component)jPanel2, "North");
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        jTabbedPane.addTab("Call Tree", this.createTreeTable());
        jTabbedPane.addTab("Hot Spots", this.createHotSpotsTable());
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    private JScrollPane createTreeTable() {
        this.procedureProfilerModel = new ProcedureProfilerModel();
        this.treeTable = new TreeTable(this.procedureProfilerModel){

            @Override
            public Color getForeground() {
                return ProfilerWindow.this.debugger.getTableForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return ProfilerWindow.this.debugger.getTableSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return ProfilerWindow.this.debugger.getTableBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return ProfilerWindow.this.debugger.getTableSelectionBackground();
            }

            @Override
            public Color getGridColor() {
                Color color = super.getGridColor();
                if (color != null && color.equals(Color.WHITE)) {
                    return Color.GRAY;
                }
                return color;
            }

            @Override
            public Font getFont() {
                return ProfilerWindow.this.debugger.getFont();
            }
        };
        this.treeTable.setDefaultRenderer(Long.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ProcedureProfilingData procedureProfilingData;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 2 && component instanceof JComponent && (procedureProfilingData = (ProcedureProfilingData)jTable.getValueAt(n, 0)) != null) {
                    ((JComponent)component).setToolTipText(procedureProfilingData.totalCyclesAsMillis());
                }
                return component;
            }
        });
        this.treeTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ProcedureProfilingData procedureProfilingData;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 4 && component instanceof JComponent && (procedureProfilingData = (ProcedureProfilingData)jTable.getValueAt(n, 0)) != null) {
                    ((JComponent)component).setToolTipText(procedureProfilingData.cyclesAsMillis());
                }
                return component;
            }
        });
        this.treeTable.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(final JTable jTable, Object object, final boolean bl, boolean bl2, final int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 1) {
                    return new JLabel("", 0, component){
                        {
                            super(string, n3);
                            this.setFont(component.getFont());
                        }

                        @Override
                        protected void paintComponent(Graphics graphics) {
                            ProcedureProfilingData procedureProfilingData = (ProcedureProfilingData)jTable.getValueAt(n, 0);
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            Rectangle rectangle = graphics2D.getClipBounds();
                            if (bl) {
                                graphics2D.setColor(jTable.getSelectionBackground());
                                graphics2D.fill(rectangle);
                            }
                            if (procedureProfilingData != null) {
                                double d = procedureProfilingData.cyclesAsPercent();
                                rectangle.x = Math.max(rectangle.x, 1);
                                rectangle.width = Math.min(rectangle.width, this.getWidth() - rectangle.x - 1);
                                rectangle.y = Math.max(rectangle.y, 1);
                                rectangle.height = Math.min(rectangle.height, this.getHeight() - rectangle.y - 1);
                                rectangle.width = (int)Math.round((double)rectangle.width * d);
                                graphics2D.setColor(Color.RED);
                                graphics2D.fill(rectangle);
                                String string = String.format("%.1f%%", Float.valueOf((float)Math.round(d * 1000.0) / 10.0f));
                                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                                int n2 = (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0);
                                if ((double)(rectangle.x + rectangle.width) >= (double)n2 + rectangle2D.getWidth()) {
                                    this.setForeground(Color.WHITE);
                                } else {
                                    this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
                                }
                                this.setText(string);
                                super.paintComponent(graphics);
                            }
                        }
                    };
                }
                return component;
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0 && ProfilerWindow.this.treeTable.getSelectedRow() >= 0 && ProfilerWindow.this.treeTable.getSelectedRow() < ProfilerWindow.this.treeTable.getRowCount() - 1) {
                    ProcedureProfilingData procedureProfilingData = (ProcedureProfilingData)ProfilerWindow.this.treeTable.getValueAt(ProfilerWindow.this.treeTable.getSelectedRow(), 0);
                    ProfilerWindow.this.debugger.setSelectedAddress(procedureProfilingData.name);
                }
            }
        });
        this.treeTable.setFillsViewportHeight(true);
        return new JScrollPane(this.treeTable);
    }

    private JScrollPane createHotSpotsTable() {
        this.hotSpotsTableModel = new HotSpotTableModel();
        final JTable jTable = new JTable(this.hotSpotsTableModel){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setRowHeight(this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)"_LABEL_0_", (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height);
            }

            @Override
            public Color getForeground() {
                return ProfilerWindow.this.debugger.getTableForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return ProfilerWindow.this.debugger.getTableSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return ProfilerWindow.this.debugger.getTableBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return ProfilerWindow.this.debugger.getTableSelectionBackground();
            }

            @Override
            public Color getGridColor() {
                Color color = super.getGridColor();
                if (color != null && color.equals(Color.WHITE)) {
                    return Color.GRAY;
                }
                return color;
            }

            @Override
            public Font getFont() {
                return ProfilerWindow.this.debugger.getFont();
            }
        };
        jTable.setAutoCreateRowSorter(true);
        jTable.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(2, SortOrder.DESCENDING)));
        jTable.setDefaultRenderer(Long.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    if (n2 == 2) {
                        ProcedureProfilingData procedureProfilingData = (ProcedureProfilingData)jTable.getValueAt(n, -1);
                        if (procedureProfilingData != null) {
                            jComponent.setToolTipText(procedureProfilingData.totalCyclesAsMillis());
                        } else {
                            jComponent.setToolTipText(null);
                        }
                    } else if (n2 == 4) {
                        ProcedureProfilingData procedureProfilingData = (ProcedureProfilingData)jTable.getValueAt(n, -1);
                        if (procedureProfilingData != null) {
                            jComponent.setToolTipText(procedureProfilingData.cyclesAsMillis());
                        } else {
                            jComponent.setToolTipText(null);
                        }
                    } else {
                        jComponent.setToolTipText(null);
                    }
                }
                return component;
            }
        });
        jTable.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(final JTable jTable, Object object, final boolean bl, boolean bl2, final int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 1) {
                    return new JLabel("", 0, component){
                        {
                            super(string, n3);
                            this.setFont(component.getFont());
                        }

                        @Override
                        protected void paintComponent(Graphics graphics) {
                            ProcedureProfilingData procedureProfilingData = (ProcedureProfilingData)jTable.getValueAt(n, -1);
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            Rectangle rectangle = graphics2D.getClipBounds();
                            if (bl) {
                                graphics2D.setColor(jTable.getSelectionBackground());
                                graphics2D.fill(rectangle);
                            }
                            if (procedureProfilingData != null) {
                                double d = procedureProfilingData.cyclesAsPercent();
                                rectangle.x = Math.max(rectangle.x, 1);
                                rectangle.width = Math.min(rectangle.width, this.getWidth() - rectangle.x - 1);
                                rectangle.y = Math.max(rectangle.y, 1);
                                rectangle.height = Math.min(rectangle.height, this.getHeight() - rectangle.y - 1);
                                rectangle.width = (int)Math.round((double)rectangle.width * d);
                                graphics2D.setColor(Color.RED);
                                graphics2D.fill(rectangle);
                                String string = String.format("%.1f%%", Float.valueOf((float)Math.round(d * 1000.0) / 10.0f));
                                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                                int n2 = (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0);
                                if ((double)(rectangle.x + rectangle.width) >= (double)n2 + rectangle2D.getWidth()) {
                                    this.setForeground(Color.WHITE);
                                } else {
                                    this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
                                }
                                this.setText(string);
                                super.paintComponent(graphics);
                            }
                        }
                    };
                }
                return component;
            }
        });
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0 && jTable.getSelectedRow() >= 0 && jTable.getSelectedRow() < jTable.getRowCount() - 1) {
                    ProcedureProfilingData procedureProfilingData = (ProcedureProfilingData)jTable.getValueAt(jTable.getSelectedRow(), -1);
                    ProfilerWindow.this.debugger.setSelectedAddress(procedureProfilingData.name);
                }
            }
        });
        jTable.setFillsViewportHeight(true);
        this.hotSpotsTable = jTable;
        return new JScrollPane(jTable);
    }

    private void startProfilingProcedure(String string) {
        this.handleInterrupts();
        if (this.currentProcedure == null) {
            this.currentProcedure = (ProcedureProfilingData)this.procedureProfilerModel.getRoot();
        }
        this.currentProcedure = this.currentProcedure.putChild(string);
        if (this.shouldMergeNext) {
            this.currentProcedure.setMerge(true);
            this.shouldMergeNext = false;
        }
    }

    private void stopProfilingProcedure(String string) {
        if (this.currentProcedure != null) {
            boolean bl = this.currentProcedure.isMerge();
            this.currentProcedure.stopProfiling();
            this.currentProcedure = this.currentProcedure.getParent();
            if (this.currentProcedure != null && bl) {
                this.stopProfilingProcedure(this.currentProcedure.name);
            }
        }
    }

    private void handleTailCall() {
        this.shouldMergeNext = true;
    }

    private void handleInterrupts() {
        boolean bl = this.debugger.isExecutingInterrupt();
        if (this.profileInterruptsInSeparateRoots.isSelected()) {
            if (bl && !this.wasExecutingInterrupt) {
                this.currentProcedureEx = this.currentProcedure;
                this.currentProcedure = (ProcedureProfilingData)this.procedureProfilerModel.getRoot();
            } else if (!bl && this.wasExecutingInterrupt) {
                this.currentProcedure = this.currentProcedureEx;
                ProcedureProfilingData procedureProfilingData = ProfilerWindow.profilerWindow.currentProcedure;
                while (procedureProfilingData.parent != null) {
                    long l = this.debugger.getExecutedCycles() - procedureProfilingData.prevCycles;
                    procedureProfilingData.profilingData.startCycles += l;
                    procedureProfilingData.prevCycles = this.debugger.getExecutedCycles();
                    procedureProfilingData = procedureProfilingData.parent;
                }
            }
        }
        this.wasExecutingInterrupt = bl;
    }

    public static void reset() {
        if (profilerWindow != null) {
            ProfilerWindow.profilerWindow.procedureProfilerModel.clear();
            ProfilerWindow.profilerWindow.currentProcedure = null;
            ProfilerWindow.profilerWindow.prevCycles = ProfilerWindow.profilerWindow.debugger.getExecutedCycles();
            ProfilerWindow.profilerWindow.totalCycles = 0L;
            ProfilerWindow.profilerWindow.wasExecutingInterrupt = false;
            ProfilerWindow.profilerWindow.currentProcedureEx = null;
            ProfilerWindow.profilerWindow.hotSpots.clear();
            ProfilerWindow.profilerWindow.enableAfterInterrupt = false;
            for (String string : ProfilerWindow.profilerWindow.debugger.getCurrentStackLabels()) {
                profilerWindow.startProfilingProcedure(string);
            }
        }
    }

    public static void procedureEntered(String string) {
        if (profilerWindow != null && profilerWindow.isVisible() && ProfilerWindow.profilerWindow.profiling) {
            profilerWindow.startProfilingProcedure(string);
        }
    }

    public static void procedureExited(String string) {
        if (profilerWindow != null && profilerWindow.isVisible() && ProfilerWindow.profilerWindow.profiling) {
            profilerWindow.stopProfilingProcedure(string);
        }
    }

    public static void tailCall() {
        if (profilerWindow != null && profilerWindow.isVisible() && ProfilerWindow.profilerWindow.profiling) {
            profilerWindow.handleTailCall();
        }
    }

    public static void resync() {
        if (profilerWindow != null && profilerWindow.isVisible() && ProfilerWindow.profilerWindow.profiling) {
            ProfilerWindow.profilerWindow.currentProcedure = null;
            for (String string : ProfilerWindow.profilerWindow.debugger.getCurrentStackLabels()) {
                profilerWindow.startProfilingProcedure(string);
            }
        }
    }

    public static void update(int n, boolean bl) {
        if (profilerWindow != null && profilerWindow.isVisible()) {
            int n2 = 0;
            while (n2 < ProfilerWindow.profilerWindow.profilingData.size()) {
                ProfilingData profilingData = ProfilerWindow.profilerWindow.profilingData.get(n2);
                if (profilingData.update(n)) {
                    if (n2 < ProfilerWindow.profilerWindow.firstRowToUpdate) {
                        ProfilerWindow.profilerWindow.firstRowToUpdate = n2;
                    }
                    if (n2 > ProfilerWindow.profilerWindow.lastRowToUpdate) {
                        ProfilerWindow.profilerWindow.lastRowToUpdate = n2;
                    }
                }
                ++n2;
            }
            if (bl) {
                ProfilerWindow.profilerWindow.mayUpdateGUI = true;
            }
            if (ProfilerWindow.profilerWindow.mayUpdateGUI && ProfilerWindow.profilerWindow.firstRowToUpdate <= ProfilerWindow.profilerWindow.lastRowToUpdate) {
                ProfilerWindow.profilerWindow.tableModel.fireTableRowsUpdated(ProfilerWindow.profilerWindow.firstRowToUpdate, ProfilerWindow.profilerWindow.lastRowToUpdate);
                ProfilerWindow.profilerWindow.firstRowToUpdate = Integer.MAX_VALUE;
                ProfilerWindow.profilerWindow.lastRowToUpdate = Integer.MIN_VALUE;
                ProfilerWindow.profilerWindow.mayUpdateGUI = false;
            }
            if (ProfilerWindow.profilerWindow.enableAfterInterrupt && !ProfilerWindow.profilerWindow.debugger.isExecutingInterrupt()) {
                ProfilerWindow.reset();
                ProfilerWindow.profilerWindow.profiling = true;
            }
            if (ProfilerWindow.profilerWindow.profiling) {
                long l = ProfilerWindow.profilerWindow.debugger.getExecutedCycles();
                if (l != ProfilerWindow.profilerWindow.prevCycles) {
                    ProfilerWindow.profilerWindow.totalCycles += l - ProfilerWindow.profilerWindow.prevCycles;
                    ProfilerWindow.profilerWindow.prevCycles = l;
                    if (ProfilerWindow.profilerWindow.currentProcedure != null) {
                        ProcedureProfilingData procedureProfilingData = ProfilerWindow.profilerWindow.currentProcedure;
                        while (procedureProfilingData.parent != null) {
                            procedureProfilingData.update(l);
                            procedureProfilingData = procedureProfilingData.parent;
                        }
                    }
                }
                profilerWindow.handleInterrupts();
                if (bl) {
                    ProfilerWindow.profilerWindow.treeTable.repaint();
                    if (ProfilerWindow.profilerWindow.hotSpotsTable.isShowing()) {
                        ProfilerWindow.profilerWindow.hotSpotsTable.repaint();
                        profilerWindow.sortHotSpotsTable();
                    }
                }
            }
        }
    }

    void sortHotSpotsTable() {
        if (!this.sortingHotspotsTable) {
            this.sortingHotspotsTable = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilerWindow.this.hotSpotsTable.getRowSorter().allRowsChanged();
                    ProfilerWindow.this.sortingHotspotsTable = false;
                }
            });
        }
    }

    void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        MenuItem menuItem = new MenuItem("Reset profiler");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ProfilerWindow.this.table.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    ProfilingData profilingData = ProfilerWindow.this.profilingData.get(n3);
                    ProfilingData profilingData2 = new ProfilingData(profilingData.startText, profilingData.endText);
                    ProfilerWindow.this.profilingData.set(n3, profilingData2);
                    ProfilerWindow.this.tableModel.fireTableRowsUpdated(n3, n3);
                    ++n2;
                }
            }
        });
        jPopupMenu.add(menuItem);
        menuItem = new MenuItem("Remove profiler");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (ProfilerWindow.this.table.getSelectedRow() >= 0 && ProfilerWindow.this.table.getSelectedRow() < ProfilerWindow.this.table.getRowCount() - 1) {
                    ProfilerWindow.this.profilingData.remove(ProfilerWindow.this.table.getSelectedRow());
                    ProfilerWindow.this.tableModel.fireTableRowsDeleted(ProfilerWindow.this.table.getSelectedRow(), ProfilerWindow.this.table.getSelectedRow());
                }
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        jPopupMenu.add(menuItem);
        jPopupMenu.show(this.table, point.x, point.y);
    }

    public void addProfiler(String string) {
        this.profilingData.add(new ProfilingData(string, null));
        this.tableModel.fireTableRowsInserted(this.tableModel.getRowCount() - 2, this.tableModel.getRowCount() - 2);
    }

    public void addProfiler(String string, String string2) {
        this.profilingData.add(new ProfilingData(string, string2));
        this.tableModel.fireTableRowsInserted(this.tableModel.getRowCount() - 2, this.tableModel.getRowCount() - 2);
    }

    public static void saveProfilers(File file) {
        if (profilerWindow == null) {
            return;
        }
        if (!ProfilerWindow.profilerWindow.profilingData.isEmpty()) {
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                for (ProfilingData profilingData : ProfilerWindow.profilerWindow.profilingData) {
                    profilingData.write(printWriter);
                }
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            file.delete();
        }
    }

    public static void loadProfilers(File file) {
        if (profilerWindow == null) {
            return;
        }
        ProfilerWindow.profilerWindow.profilingData.clear();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string = bufferedReader.readLine();
            while (string != null) {
                try {
                    String[] stringArray = string.split(" ");
                    if (stringArray.length >= 12) {
                        ArrayList<ProfilingData> arrayList = ProfilerWindow.profilerWindow.profilingData;
                        ProfilerWindow profilerWindow = ProfilerWindow.profilerWindow;
                        profilerWindow.getClass();
                        arrayList.add(profilerWindow.new ProfilingData(stringArray[0], stringArray[1], Long.parseLong(stringArray[2]), Long.parseLong(stringArray[3]), Double.parseDouble(stringArray[4]), Integer.parseInt(stringArray[5]), Integer.parseInt(stringArray[6]), Double.parseDouble(stringArray[7]), Integer.parseInt(stringArray[8]), Integer.parseInt(stringArray[9]), Double.parseDouble(stringArray[10]), Integer.parseInt(stringArray[11])));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ProfilerWindow.profilerWindow.tableModel.fireTableDataChanged();
    }

    public static void addProfiler(Window window, Debugger debugger, File file, String string) {
        ProfilerWindow.open(window, debugger, file, false);
        ProfilerWindow.profilerWindow.tabbedPane.setSelectedIndex(0);
        profilerWindow.addProfiler(string);
    }

    public static void addProfiler(Window window, Debugger debugger, File file, String string, String string2) {
        ProfilerWindow.open(window, debugger, file, false);
        ProfilerWindow.profilerWindow.tabbedPane.setSelectedIndex(0);
        profilerWindow.addProfiler(string, string2);
    }

    public static void open(Window window, Debugger debugger, File file, boolean bl) {
        if (profilerWindow == null) {
            profilerWindow = new ProfilerWindow(window, debugger, Emulicious.isUseFrames());
            ProfilerWindow.loadProfilers(file);
            profilerWindow.setVisible(true);
        } else if (!bl) {
            profilerWindow.setVisible(true);
        }
    }

    public static void close() {
        if (profilerWindow != null) {
            Emulicious.getProperties().setProperty("Window" + profilerWindow.getClass().getSimpleName() + "Open", "" + profilerWindow.isVisible());
            Emulicious.getProperties().setProperty("Window" + profilerWindow.getClass().getSimpleName() + "X", "" + profilerWindow.getX());
            Emulicious.getProperties().setProperty("Window" + profilerWindow.getClass().getSimpleName() + "Y", "" + profilerWindow.getY());
            Emulicious.getProperties().setProperty("Window" + profilerWindow.getClass().getSimpleName() + "Width", "" + profilerWindow.getWidth());
            Emulicious.getProperties().setProperty("Window" + profilerWindow.getClass().getSimpleName() + "Height", "" + profilerWindow.getHeight());
            Emulicious.getProperties().setProperty("Window" + profilerWindow.getClass().getSimpleName() + "ProcedureProfiler", "" + profilerWindow.isProcedureProfilerSelected());
            Emulicious.getProperties().setProperty("ProfileInterruptsInSeparateRoots", "" + ProfilerWindow.profilerWindow.profileInterruptsInSeparateRoots.isSelected());
            wasEnabled = ProfilerWindow.profilerWindow.enableProcedureProfiler.isSelected();
            profilerWindow.dispose();
            profilerWindow = null;
        }
    }

    final class HotSpotTableModel
    extends AbstractTableModel {
        private final String[] COLUMN_NAMES = new String[]{"Procedure", "% Self Cycles", "Self Cycles", "Invocations", "Procedure Cycles"};
        private List<SummedProcedureProfilingData> cache = new ArrayList<SummedProcedureProfilingData>();

        HotSpotTableModel() {
        }

        @Override
        public int getRowCount() {
            return ProfilerWindow.this.hotSpots.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return Double.class;
            }
            if (n == 2) {
                return Long.class;
            }
            if (n == 4) {
                return String.class;
            }
            return Long.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException();
            }
            Collection<SummedProcedureProfilingData> collection = ProfilerWindow.this.hotSpots.values();
            if (collection.size() < this.cache.size()) {
                this.cache.clear();
            } else if (collection.size() > this.cache.size()) {
                this.cache.clear();
                this.cache.addAll(collection);
            }
            if (n >= this.cache.size()) {
                return null;
            }
            SummedProcedureProfilingData summedProcedureProfilingData = this.cache.get(n);
            if (summedProcedureProfilingData == null) {
                return null;
            }
            switch (n2) {
                case -1: {
                    return summedProcedureProfilingData;
                }
                case 0: {
                    return summedProcedureProfilingData.getName();
                }
                case 1: {
                    return summedProcedureProfilingData.getTotalCycles();
                }
                case 2: {
                    return summedProcedureProfilingData.getTotalCycles();
                }
                case 3: {
                    return summedProcedureProfilingData.getInvocations();
                }
                case 4: {
                    return summedProcedureProfilingData.getCycles();
                }
            }
            return null;
        }
    }

    private final class ProcedureProfilerModel
    extends AbstractTreeTableModel {
        private final String[] COLUMN_NAMES;

        public ProcedureProfilerModel() {
            super(new ProcedureProfilingData(ProfilerWindow.this, "root", null){

                @Override
                public void startProfiling() {
                    throw new UnsupportedOperationException("Cannot start profiling root.");
                }

                @Override
                public void update(long l) {
                    throw new UnsupportedOperationException("Cannot update root.");
                }
            });
            this.COLUMN_NAMES = new String[]{"Procedure", "% Total Cycles", "Total Cycles", "Invocations", "Procedure Cycles (Min/Max/Avg)"};
        }

        @Override
        public int getChildCount(Object object) {
            ArrayList<ProcedureProfilingData> arrayList = ((ProcedureProfilingData)object).sortedChildren;
            if (arrayList.size() == 1 && arrayList.get(0) instanceof SelfTimeProcedureProfilingData) {
                return 0;
            }
            return arrayList.size();
        }

        @Override
        public Object getChild(Object object, int n) {
            ProcedureProfilingData procedureProfilingData = (ProcedureProfilingData)object;
            return procedureProfilingData.sortedChildren.get(n);
        }

        @Override
        public void setValueAt(Object object, Object object2, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return false;
        }

        @Override
        public Object getValueAt(Object object, int n) {
            if (!(object instanceof ProcedureProfilingData)) {
                return null;
            }
            ProcedureProfilingData procedureProfilingData = (ProcedureProfilingData)object;
            switch (n) {
                case 0: {
                    return procedureProfilingData.getName();
                }
                case 2: {
                    return procedureProfilingData.getTotalCycles();
                }
                case 3: {
                    return procedureProfilingData.getInvocations();
                }
                case 4: {
                    return procedureProfilingData.getCycles();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        protected Object[] getPathToRoot(ProcedureProfilingData procedureProfilingData) {
            return this.getPathToRoot(procedureProfilingData, 0);
        }

        private Object[] getPathToRoot(ProcedureProfilingData procedureProfilingData, int n) {
            if (procedureProfilingData == null) {
                return new Object[n];
            }
            Object[] objectArray = this.getPathToRoot(procedureProfilingData.getParent(), ++n);
            objectArray[objectArray.length - n] = procedureProfilingData;
            return objectArray;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return Double.class;
            }
            if (n == 2) {
                return Long.class;
            }
            if (n == 4) {
                return String.class;
            }
            return Long.class;
        }

        public void childAdded(ProcedureProfilingData procedureProfilingData, ProcedureProfilingData procedureProfilingData2) {
            if (procedureProfilingData == this.root) {
                final List<TreePath> list = ProfilerWindow.this.treeTable.getExpandedPaths();
                this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((ProcedureProfilerModel)ProcedureProfilerModel.this).ProfilerWindow.this.treeTable.expandPaths(list);
                    }
                });
            } else {
                this.childrenAdded(procedureProfilingData, new ProcedureProfilingData[]{procedureProfilingData2}, new int[]{procedureProfilingData.children.size() - 1});
            }
        }

        public void childrenAdded(ProcedureProfilingData procedureProfilingData, ProcedureProfilingData[] procedureProfilingDataArray, int[] nArray) {
            this.fireTreeNodesInserted(this, this.getPathToRoot(procedureProfilingData), nArray, procedureProfilingDataArray);
        }

        public void childrenRemoved(ProcedureProfilingData procedureProfilingData, ProcedureProfilingData[] procedureProfilingDataArray, int[] nArray) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(procedureProfilingData), nArray, procedureProfilingDataArray);
        }

        public void childrenSwapped(ProcedureProfilingData procedureProfilingData, ProcedureProfilingData procedureProfilingData2, ProcedureProfilingData procedureProfilingData3, int n, int n2) {
            ProcedureProfilingData[] procedureProfilingDataArray = new ProcedureProfilingData[]{procedureProfilingData2, procedureProfilingData3};
            int[] nArray = new int[]{n, n2};
            final List<TreePath> list = ProfilerWindow.this.treeTable.getExpandedPaths();
            this.childrenRemoved(procedureProfilingData, procedureProfilingDataArray, nArray);
            procedureProfilingDataArray[0] = procedureProfilingData3;
            procedureProfilingDataArray[1] = procedureProfilingData2;
            this.childrenAdded(procedureProfilingData, procedureProfilingDataArray, nArray);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((ProcedureProfilerModel)ProcedureProfilerModel.this).ProfilerWindow.this.treeTable.expandPaths(list);
                }
            });
        }

        public void clear() {
            ((ProcedureProfilingData)this.root).children.clear();
            ((ProcedureProfilingData)this.root).sortedChildren.clear();
            this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
        }
    }

    private class ProcedureProfilingData {
        final ProfilingData profilingData;
        final String name;
        final HashMap<String, ProcedureProfilingData> children;
        final ArrayList<ProcedureProfilingData> sortedChildren;
        final ProcedureProfilingData parent;
        final ProcedureProfilingData self;
        boolean merge;
        long invocations;
        long prevCycles;
        long cycles;

        protected ProcedureProfilingData(String string, ProcedureProfilingData procedureProfilingData) {
            this.profilingData = new ProfilingData("0", "1");
            this.children = new HashMap();
            this.sortedChildren = new ArrayList();
            this.name = string;
            this.parent = procedureProfilingData;
            if (!(this instanceof SelfTimeProcedureProfilingData) && procedureProfilingData != null) {
                this.self = new SelfTimeProcedureProfilingData(this);
                this.children.put("%Self Time%", this.self);
                this.sortedChildren.add(this.self);
                SummedProcedureProfilingData summedProcedureProfilingData = ProfilerWindow.this.hotSpots.get(string);
                if (summedProcedureProfilingData == null) {
                    summedProcedureProfilingData = new SummedProcedureProfilingData(string);
                    ProfilerWindow.this.hotSpots.put(string, summedProcedureProfilingData);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((ProcedureProfilingData)ProcedureProfilingData.this).ProfilerWindow.this.hotSpotsTableModel.fireTableDataChanged();
                        }
                    });
                }
                summedProcedureProfilingData.add(this.self);
            } else {
                this.self = null;
            }
        }

        public String getName() {
            return this.name;
        }

        public void setMerge(boolean bl) {
            this.merge = bl;
        }

        public boolean isMerge() {
            return this.merge;
        }

        public ProcedureProfilingData getChild(String string) {
            return this.children.get(string);
        }

        public ProcedureProfilingData putChild(final String string) {
            ProcedureProfilingData procedureProfilingData = this.getChild(string);
            if (procedureProfilingData == null) {
                procedureProfilingData = new ProcedureProfilingData(string, this);
                try {
                    final ProcedureProfilingData procedureProfilingData2 = procedureProfilingData;
                    if (!SwingUtilities.isEventDispatchThread() && Emulicious.isRunning()) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ProcedureProfilingData.this.children.put(string, procedureProfilingData2);
                                ProcedureProfilingData.this.sortedChildren.add(procedureProfilingData2);
                                ((ProcedureProfilingData)ProcedureProfilingData.this).ProfilerWindow.this.procedureProfilerModel.childAdded(ProcedureProfilingData.this, procedureProfilingData2);
                            }
                        });
                    } else {
                        this.children.put(string, procedureProfilingData2);
                        this.sortedChildren.add(procedureProfilingData2);
                        ProfilerWindow.this.procedureProfilerModel.childAdded(this, procedureProfilingData2);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            procedureProfilingData.startProfiling();
            return procedureProfilingData;
        }

        public void startProfiling() {
            this.prevCycles = ProfilerWindow.this.debugger.getExecutedCycles();
            this.profilingData.update(0);
            ++this.invocations;
        }

        public void stopProfiling() {
            this.profilingData.update(1);
        }

        public ProcedureProfilingData getParent() {
            return this.parent;
        }

        public void update(long l) {
            this.cycles += l - this.prevCycles;
            this.prevCycles = l;
            if (this == ProfilerWindow.this.currentProcedure) {
                this.childUpdated(this.self);
            }
            this.parent.childUpdated(this);
        }

        public void childUpdated(ProcedureProfilingData procedureProfilingData) {
            ProcedureProfilingData procedureProfilingData2;
            int n = this.sortedChildren.indexOf(procedureProfilingData);
            if (n > 0 && procedureProfilingData.isTotalCyclesGreaterThan((procedureProfilingData2 = this.sortedChildren.get(n - 1)).getTotalCycles())) {
                this.sortedChildren.set(n, procedureProfilingData2);
                this.sortedChildren.set(n - 1, procedureProfilingData);
                ProfilerWindow.this.procedureProfilerModel.childrenSwapped(this, procedureProfilingData2, procedureProfilingData, n - 1, n);
            }
        }

        public boolean isTotalCyclesGreaterThan(long l) {
            return this.cycles > l;
        }

        public long getTotalCycles() {
            return this.cycles;
        }

        public String getCycles() {
            if (this.profilingData.isAvailable()) {
                return String.format("%d/%d/%.1f", this.profilingData.getMinCycles(), this.profilingData.getMaxCycles(), this.profilingData.getAvgCycles());
            }
            return null;
        }

        public String cyclesAsMillis() {
            if (this.profilingData.isAvailable()) {
                return this.profilingData.cyclesAsMillis();
            }
            return null;
        }

        public String totalCyclesAsMillis() {
            double d = (double)ProfilerWindow.this.debugger.getCyclesPerSecond() / 1000.0;
            return String.format("%.1fms", (double)this.getTotalCycles() / d);
        }

        public double cyclesAsPercent() {
            return (double)this.getTotalCycles() / (double)ProfilerWindow.this.totalCycles;
        }

        public long getInvocations() {
            return this.invocations;
        }

        public ProfilingData getProfilingData() {
            return this.profilingData;
        }

        public String toString() {
            return this.getName();
        }
    }

    private final class ProfilingData {
        final String startText;
        final String endText;
        int start = -1;
        int end = -1;
        boolean active;
        long minCycles = Long.MAX_VALUE;
        long maxCycles;
        double avgCycles;
        int minInstructions = Integer.MAX_VALUE;
        int maxInstructions;
        double avgInstructions;
        int minScanlines = Integer.MAX_VALUE;
        int maxScanlines;
        double avgScanlines;
        long startCycles;
        int startInstructions;
        int startScanlines;
        int measurements;

        public ProfilingData(String string, String string2) {
            int n;
            this.startText = string;
            this.endText = string2;
            try {
                this.start = Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    n = ProfilerWindow.this.debugger.parseExpression(string).getValue();
                    this.start = n >> 16 | n & 0xFFFF;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                catch (UnknownVariableException unknownVariableException) {
                    unknownVariableException.printStackTrace();
                }
            }
            if (this.start < 0) {
                throw new IllegalArgumentException("Couldn't resolve start address!");
            }
            if (string2 != null && !string2.isEmpty()) {
                try {
                    this.end = Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        n = ProfilerWindow.this.debugger.parseExpression(string2).getValue();
                        this.end = n >> 16 | n & 0xFFFF;
                    }
                    catch (UnknownVariableException unknownVariableException) {
                        unknownVariableException.printStackTrace();
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }
                if (this.end < 0) {
                    throw new IllegalArgumentException("Couldn't resolve end address!");
                }
            }
            this.active = true;
        }

        public ProfilingData(String string, String string2, long l, long l2, double d, int n, int n2, double d2, int n3, int n4, double d3, int n5) {
            this(string, string2);
            this.minCycles = l;
            this.maxCycles = l2;
            this.avgCycles = d;
            this.minInstructions = n;
            this.maxInstructions = n2;
            this.avgInstructions = d2;
            this.minScanlines = n3;
            this.maxScanlines = n4;
            this.avgScanlines = d3;
            this.measurements = n5;
            this.active = false;
        }

        public boolean update(int n) {
            if (!this.active) {
                return false;
            }
            if (this.startCycles == 0L && n == this.start) {
                this.startCycles = ProfilerWindow.this.debugger.getExecutedCycles();
                this.startInstructions = ProfilerWindow.this.debugger.getExecutedInstructions();
                this.startScanlines = ProfilerWindow.this.debugger.getExecutedScanlines();
            } else if (this.startCycles != 0L && (this.end < 0 || n == this.end)) {
                long l = ProfilerWindow.this.debugger.getExecutedCycles() - this.startCycles;
                int n2 = ProfilerWindow.this.debugger.getExecutedInstructions() - this.startInstructions;
                int n3 = ProfilerWindow.this.debugger.getExecutedScanlines() - this.startScanlines;
                if (l < 0L) {
                    this.startCycles = 0L;
                    return true;
                }
                if (l == 0L) {
                    return false;
                }
                if (l < this.minCycles) {
                    this.minCycles = l;
                }
                if (l > this.maxCycles) {
                    this.maxCycles = l;
                }
                if (n2 < this.minInstructions) {
                    this.minInstructions = n2;
                }
                if (n2 > this.maxInstructions) {
                    this.maxInstructions = n2;
                }
                if (n3 < this.minScanlines) {
                    this.minScanlines = n3;
                }
                if (n3 > this.maxScanlines) {
                    this.maxScanlines = n3;
                }
                if (this.end >= 0) {
                    if (n == this.start) {
                        this.startCycles = ProfilerWindow.this.debugger.getExecutedCycles();
                        this.startInstructions = ProfilerWindow.this.debugger.getExecutedInstructions();
                        this.startScanlines = ProfilerWindow.this.debugger.getExecutedScanlines();
                    } else {
                        this.startCycles = 0L;
                    }
                    ++this.measurements;
                } else {
                    this.measurements = 0;
                    this.avgCycles = (double)this.maxCycles / (double)this.maxInstructions;
                    this.avgInstructions = 1.0;
                    this.avgScanlines = (double)this.maxScanlines / (double)this.maxInstructions;
                }
                if (this.measurements > 0) {
                    this.avgCycles = (this.avgCycles * (double)(this.measurements - 1) + (double)l) / (double)this.measurements;
                    this.avgInstructions = (this.avgInstructions * (double)(this.measurements - 1) + (double)n2) / (double)this.measurements;
                    this.avgScanlines = (this.avgScanlines * (double)(this.measurements - 1) + (double)n3) / (double)this.measurements;
                }
                return true;
            }
            return false;
        }

        public boolean isAvailable() {
            return this.minCycles < Long.MAX_VALUE && this.minInstructions < Integer.MAX_VALUE && this.minScanlines < Integer.MAX_VALUE;
        }

        public long getMinCycles() {
            if (this.minCycles < Long.MAX_VALUE) {
                return this.minCycles;
            }
            return 0L;
        }

        public long getMaxCycles() {
            return this.maxCycles;
        }

        public double getAvgCycles() {
            return this.avgCycles;
        }

        public int getMinInstructions() {
            if (this.minInstructions < Integer.MAX_VALUE) {
                return this.minInstructions;
            }
            return 0;
        }

        public int getMaxInstructions() {
            return this.maxInstructions;
        }

        public double getAvgInstructions() {
            return this.avgInstructions;
        }

        public int getMinScanlines() {
            if (this.minScanlines < Integer.MAX_VALUE) {
                return this.minScanlines;
            }
            return 0;
        }

        public int getMaxScanlines() {
            return this.maxScanlines;
        }

        public double getAvgScanlines() {
            return this.avgScanlines;
        }

        public int getMeasurements() {
            return this.measurements;
        }

        public void write(PrintWriter printWriter) {
            printWriter.print(this.startText.replace(" ", "%20"));
            printWriter.print(" ");
            if (this.endText != null) {
                printWriter.print(this.endText.replace(" ", "%20"));
            }
            printWriter.print(" ");
            printWriter.print(this.minCycles);
            printWriter.print(" ");
            printWriter.print(this.maxCycles);
            printWriter.print(" ");
            printWriter.print(this.avgCycles);
            printWriter.print(" ");
            printWriter.print(this.minInstructions);
            printWriter.print(" ");
            printWriter.print(this.maxInstructions);
            printWriter.print(" ");
            printWriter.print(this.avgInstructions);
            printWriter.print(" ");
            printWriter.print(this.minScanlines);
            printWriter.print(" ");
            printWriter.print(this.maxScanlines);
            printWriter.print(" ");
            printWriter.print(this.avgScanlines);
            printWriter.print(" ");
            printWriter.print(this.measurements);
            printWriter.println();
        }

        public String cyclesAsMillis() {
            double d = (double)ProfilerWindow.this.debugger.getCyclesPerSecond() / 1000.0;
            return String.format("%.1fms/%.1fms/%.1fms", (double)this.getMinCycles() / d, (double)this.getMaxCycles() / d, this.getAvgCycles() / d);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.end;
            n = 31 * n + this.start;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ProfilingData profilingData = (ProfilingData)object;
            if (this.end != profilingData.end) {
                return false;
            }
            return this.start == profilingData.start;
        }
    }

    private class SelfTimeProcedureProfilingData
    extends ProcedureProfilingData {
        public SelfTimeProcedureProfilingData(ProcedureProfilingData procedureProfilingData) {
            super(procedureProfilingData.getName(), procedureProfilingData);
        }

        @Override
        public ProcedureProfilingData getChild(String string) {
            return null;
        }

        @Override
        public ProcedureProfilingData putChild(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void startProfiling() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void stopProfiling() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void update(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void childUpdated(ProcedureProfilingData procedureProfilingData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTotalCycles() {
            long l = this.getParent().getTotalCycles();
            for (ProcedureProfilingData procedureProfilingData : this.getParent().sortedChildren) {
                if (procedureProfilingData == this) continue;
                l -= procedureProfilingData.getTotalCycles();
            }
            return l;
        }

        @Override
        public boolean isTotalCyclesGreaterThan(long l) {
            long l2 = this.getParent().getTotalCycles() - l;
            for (ProcedureProfilingData procedureProfilingData : this.getParent().sortedChildren) {
                if (procedureProfilingData == this || (l2 -= procedureProfilingData.getTotalCycles()) > 0L) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getCycles() {
            return null;
        }

        @Override
        public String cyclesAsMillis() {
            return null;
        }

        @Override
        public ProfilingData getProfilingData() {
            return this.getParent().getProfilingData();
        }

        @Override
        public long getInvocations() {
            return this.getParent().getInvocations();
        }

        @Override
        public String getName() {
            return "Self Time";
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    private class SummedProcedureProfilingData
    extends ProcedureProfilingData {
        private final List<ProcedureProfilingData> procedures;

        public SummedProcedureProfilingData(String string) {
            super(string, null);
            this.procedures = new ArrayList<ProcedureProfilingData>();
        }

        public synchronized void add(ProcedureProfilingData procedureProfilingData) {
            this.procedures.add(procedureProfilingData);
        }

        @Override
        public ProcedureProfilingData getChild(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcedureProfilingData putChild(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void startProfiling() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void stopProfiling() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcedureProfilingData getParent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void update(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void childUpdated(ProcedureProfilingData procedureProfilingData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized long getTotalCycles() {
            long l = 0L;
            for (ProcedureProfilingData procedureProfilingData : this.procedures) {
                l += procedureProfilingData.getTotalCycles();
            }
            return l;
        }

        @Override
        public synchronized String getCycles() {
            long l = Long.MAX_VALUE;
            long l2 = 0L;
            double d = 0.0;
            int n = 0;
            for (ProcedureProfilingData procedureProfilingData : this.procedures) {
                ProfilingData profilingData = procedureProfilingData.getProfilingData();
                if (!profilingData.isAvailable()) continue;
                l = Math.min(l, profilingData.getMinCycles());
                l2 = Math.max(l2, profilingData.getMaxCycles());
                d += profilingData.getAvgCycles() * (double)profilingData.getMeasurements();
                n += profilingData.getMeasurements();
            }
            if (n <= 0) {
                return null;
            }
            return String.format("%d/%d/%.1f", l, l2, d /= (double)n);
        }

        @Override
        public synchronized String cyclesAsMillis() {
            long l = Long.MAX_VALUE;
            long l2 = 0L;
            double d = 0.0;
            int n = 0;
            for (ProcedureProfilingData procedureProfilingData : this.procedures) {
                ProfilingData profilingData = procedureProfilingData.getProfilingData();
                if (!profilingData.isAvailable()) continue;
                l = Math.min(l, profilingData.getMinCycles());
                l2 = Math.max(l2, profilingData.getMaxCycles());
                d += profilingData.getAvgCycles() * (double)profilingData.getMeasurements();
                n += profilingData.getMeasurements();
            }
            if (n <= 0) {
                return null;
            }
            double d2 = (double)ProfilerWindow.this.debugger.getCyclesPerSecond() / 1000.0;
            return String.format("%.1fms/%.1fms/%.1fms", (double)l / d2, (double)l2 / d2, (d /= (double)n) / d2);
        }

        @Override
        public synchronized long getInvocations() {
            long l = 0L;
            for (ProcedureProfilingData procedureProfilingData : this.procedures) {
                l += procedureProfilingData.getInvocations();
            }
            return l;
        }
    }
}

