/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.Event;
import net.java.games.input.WinTabButtonComponent;
import net.java.games.input.WinTabContext;
import net.java.games.input.WinTabCursorComponent;
import net.java.games.input.WinTabPacket;

public class WinTabComponent
extends AbstractComponent {
    private int min;
    private int max;
    protected float lastKnownValue;
    private boolean analog;

    protected WinTabComponent(WinTabContext winTabContext, int n, String string, Component.Identifier identifier, int n2, int n3) {
        super(string, identifier);
        this.min = n2;
        this.max = n3;
        this.analog = true;
    }

    protected WinTabComponent(WinTabContext winTabContext, int n, String string, Component.Identifier identifier) {
        super(string, identifier);
        this.min = 0;
        this.max = 1;
        this.analog = false;
    }

    @Override
    protected float poll() throws IOException {
        return this.lastKnownValue;
    }

    @Override
    public boolean isAnalog() {
        return this.analog;
    }

    @Override
    public boolean isRelative() {
        return false;
    }

    public static List<WinTabComponent> createComponents(WinTabContext winTabContext, int n, int n2, int[] nArray) {
        ArrayList<WinTabComponent> arrayList = new ArrayList<WinTabComponent>();
        switch (n2) {
            case 1: {
                Component.Identifier.Axis axis = Component.Identifier.Axis.X;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[0], nArray[1]));
                break;
            }
            case 2: {
                Component.Identifier.Axis axis = Component.Identifier.Axis.Y;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[0], nArray[1]));
                break;
            }
            case 3: {
                Component.Identifier.Axis axis = Component.Identifier.Axis.Z;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[0], nArray[1]));
                break;
            }
            case 4: {
                Component.Identifier.Axis axis = Component.Identifier.Axis.X_FORCE;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[0], nArray[1]));
                break;
            }
            case 5: {
                Component.Identifier.Axis axis = Component.Identifier.Axis.Y_FORCE;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[0], nArray[1]));
                break;
            }
            case 6: {
                Component.Identifier.Axis axis = Component.Identifier.Axis.RX;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[0], nArray[1]));
                axis = Component.Identifier.Axis.RY;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[2], nArray[3]));
                axis = Component.Identifier.Axis.RZ;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[4], nArray[5]));
                break;
            }
            case 7: {
                Component.Identifier.Axis axis = Component.Identifier.Axis.RX;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[0], nArray[1]));
                axis = Component.Identifier.Axis.RY;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[2], nArray[3]));
                axis = Component.Identifier.Axis.RZ;
                arrayList.add(new WinTabComponent(winTabContext, n, axis.getName(), axis, nArray[4], nArray[5]));
            }
        }
        return arrayList;
    }

    public static Collection<WinTabButtonComponent> createButtons(WinTabContext winTabContext, int n, int n2) {
        ArrayList<WinTabButtonComponent> arrayList = new ArrayList<WinTabButtonComponent>();
        int n3 = 0;
        while (n3 < n2) {
            try {
                Class<Component.Identifier.Button> clazz = Component.Identifier.Button.class;
                Field field = clazz.getField("_" + n3);
                Component.Identifier identifier = (Component.Identifier)field.get(null);
                arrayList.add(new WinTabButtonComponent(winTabContext, n, identifier.getName(), identifier, n3));
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            ++n3;
        }
        return arrayList;
    }

    public Event processPacket(WinTabPacket winTabPacket) {
        float f = this.lastKnownValue;
        if (this.getIdentifier() == Component.Identifier.Axis.X) {
            f = this.normalise(winTabPacket.PK_X);
        }
        if (this.getIdentifier() == Component.Identifier.Axis.Y) {
            f = this.normalise(winTabPacket.PK_Y);
        }
        if (this.getIdentifier() == Component.Identifier.Axis.Z) {
            f = this.normalise(winTabPacket.PK_Z);
        }
        if (this.getIdentifier() == Component.Identifier.Axis.X_FORCE) {
            f = this.normalise(winTabPacket.PK_NORMAL_PRESSURE);
        }
        if (this.getIdentifier() == Component.Identifier.Axis.Y_FORCE) {
            f = this.normalise(winTabPacket.PK_TANGENT_PRESSURE);
        }
        if (this.getIdentifier() == Component.Identifier.Axis.RX) {
            f = this.normalise(winTabPacket.PK_ORIENTATION_ALT);
        }
        if (this.getIdentifier() == Component.Identifier.Axis.RY) {
            f = this.normalise(winTabPacket.PK_ORIENTATION_AZ);
        }
        if (this.getIdentifier() == Component.Identifier.Axis.RZ) {
            f = this.normalise(winTabPacket.PK_ORIENTATION_TWIST);
        }
        if (f != this.getPollData()) {
            this.lastKnownValue = f;
            Event event = new Event();
            event.set(this, f, winTabPacket.PK_TIME * 1000L);
            return event;
        }
        return null;
    }

    private float normalise(float f) {
        if (this.max == this.min) {
            return f;
        }
        float f2 = this.max - this.min;
        return (f - (float)this.min) / f2;
    }

    public static Collection<WinTabCursorComponent> createCursors(WinTabContext winTabContext, int n, String[] stringArray) {
        ArrayList<WinTabCursorComponent> arrayList = new ArrayList<WinTabCursorComponent>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Component.Identifier.Button button = stringArray[n2].matches("Puck") ? Component.Identifier.Button.TOOL_FINGER : (stringArray[n2].matches("Eraser.*") ? Component.Identifier.Button.TOOL_RUBBER : Component.Identifier.Button.TOOL_PEN);
            arrayList.add(new WinTabCursorComponent(winTabContext, n, button.getName(), button, n2));
            ++n2;
        }
        return arrayList;
    }
}

