/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.istack.internal.FragmentContentHandler;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.unmarshaller.DOMScanner;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.message.AbstractMessageImpl;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.streaming.DOMStreamReader;
import com.sun.xml.internal.ws.util.DOMUtil;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class DOMMessage
extends AbstractMessageImpl {
    private MessageHeaders headers;
    private final Element payload;

    public DOMMessage(SOAPVersion sOAPVersion, Element element) {
        this(sOAPVersion, null, element);
    }

    public DOMMessage(SOAPVersion sOAPVersion, MessageHeaders messageHeaders, Element element) {
        this(sOAPVersion, messageHeaders, element, null);
    }

    public DOMMessage(SOAPVersion sOAPVersion, MessageHeaders messageHeaders, Element element, AttachmentSet attachmentSet) {
        super(sOAPVersion);
        this.headers = messageHeaders;
        this.payload = element;
        this.attachmentSet = attachmentSet;
        assert (element != null);
    }

    private DOMMessage(DOMMessage dOMMessage) {
        super(dOMMessage);
        this.headers = HeaderList.copy(dOMMessage.headers);
        this.payload = dOMMessage.payload;
    }

    @Override
    public boolean hasHeaders() {
        return this.getHeaders().hasHeaders();
    }

    @Override
    public MessageHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HeaderList(this.getSOAPVersion());
        }
        return this.headers;
    }

    @Override
    public String getPayloadLocalPart() {
        return this.payload.getLocalName();
    }

    @Override
    public String getPayloadNamespaceURI() {
        return this.payload.getNamespaceURI();
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    @Override
    public Source readPayloadAsSource() {
        return new DOMSource(this.payload);
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        if (this.hasAttachments()) {
            unmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerImpl(this.getAttachments()));
        }
        try {
            Object object = unmarshaller.unmarshal(this.payload);
            return (T)object;
        }
        finally {
            unmarshaller.setAttachmentUnmarshaller(null);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        return bridge.unmarshal(this.payload, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        DOMStreamReader dOMStreamReader = new DOMStreamReader();
        dOMStreamReader.setCurrentNode(this.payload);
        dOMStreamReader.nextTag();
        assert (dOMStreamReader.getEventType() == 1);
        return dOMStreamReader;
    }

    @Override
    public void writePayloadTo(XMLStreamWriter xMLStreamWriter) {
        try {
            if (this.payload != null) {
                DOMUtil.serializeNode(this.payload, xMLStreamWriter);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    @Override
    protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
        if (bl) {
            contentHandler = new FragmentContentHandler(contentHandler);
        }
        DOMScanner dOMScanner = new DOMScanner();
        dOMScanner.setContentHandler(contentHandler);
        dOMScanner.scan(this.payload);
    }

    @Override
    public Message copy() {
        return new DOMMessage(this);
    }
}

