/*
 * Decompiled with CFR 0.152.
 */
package system;

import components.cartridge.Cartridge;
import components.cpu.MemoryMap;
import components.input.InputDevice;
import java.io.File;
import java.lang.instrument.UnmodifiableClassException;
import system.SystemEventListener;
import util.list.IntList;

public interface EmulatableSystem
extends MemoryMap {
    public State getState();

    public State createMutableState();

    public void insertCartridge(Cartridge var1);

    public void ejectCartridge();

    public void shutdown();

    public void setState(State var1, boolean var2, boolean var3);

    public void loadSAV(File var1);

    public void reset();

    public int execute(int var1);

    public int executeOnce(int var1);

    public int getCyclesPerSecond();

    public int getCyclesPerFrame();

    public void uninitializeMemory(int var1);

    public int getRAMlength();

    public IntList getAllRAMaddresses();

    public int[] getRAM();

    public int[] getSRAM();

    public int[] getVRAM();

    public int peekByte(int var1);

    public int getByte(int var1);

    public int getByte(int var1, int var2);

    public void pokeByte(int var1, int var2);

    public void setByte(int var1, int var2, int var3);

    public String getMemoryName(int var1);

    public int getNumberOfPaletteBytes();

    public int getNumberOfPaletteEntries();

    public int getPaletteByte(int var1);

    public void setPaletteByte(int var1, int var2);

    public String getPaletteName(int var1);

    public String[] getRegisterNames();

    public int indexOfPC();

    public String[] getFlagNames();

    public int getNumberOfAdditionalMemoryLocations();

    public String getAdditionalMemoryLocationName(int var1);

    public int getAdditionalMemoryLocationLength(int var1);

    public String getAdditionalMemoryLocationAt(int var1);

    public boolean isAdditionalMemoryLocationMemoryMapped(String var1);

    public int[] getErrorCodes();

    public int getRegisterValue(int var1);

    public int getVRAMaddress();

    public boolean isAdditionalRegister(int var1);

    public String getAdditionalRegisterName(int var1);

    public int getAdditionalRegisterValue(int var1);

    public int getAdditionalRegisterSize(int var1);

    public boolean hasSRAM();

    public boolean isROMaddress(int var1);

    public boolean isROMaddress(int var1, boolean var2);

    public boolean isRAMaddress(int var1);

    public boolean isRAMaddress(int var1, boolean var2);

    public boolean isSRAMaddress(int var1);

    public boolean isVRAMaddress(int var1);

    public int mapAddress(int var1);

    public int mapAddress(int var1, int var2);

    public int mapAddress(int var1, int var2, boolean var3);

    public int mapVirtualAddress(int var1);

    public String cpuAddressToString(int var1);

    public String virtualAddressToString(int var1);

    public String romAddressToString(int var1);

    public String ramAddressToString(int var1);

    public String vramAddressToString(int var1);

    public String sramAddressToString(int var1);

    public String palAddressToString(int var1);

    public void plugInInputDevice(int var1, InputDevice var2);

    public void addSystemEventListener(SystemEventListener var1);

    public void removeSystemEventListener(SystemEventListener var1);

    public boolean isRamInitialized(int var1);

    public boolean isVramInitialized(int var1);

    public boolean isSramInitialized(int var1);

    public boolean isCpuMemoryInitialized(int var1);

    public boolean isPaletteInitialized(int var1);

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();
    }
}

