/*
 * Decompiled with CFR 0.152.
 */
package platform.viewers;

import common.CompatiblePixelBuffer;
import common.IntPixelBuffer;
import common.PixelBuffer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ViewerWindow
extends JComponent {
    private static final Insets INSETS = new Insets(0, 0, 0, 0);
    private BufferedImage image;
    private BufferedImage fontImage;
    private Font derivedFont;
    private PixelBuffer pixelBuffer;
    private float scale = 1.0f;
    private boolean integerScaling;
    private boolean hasHighlightCursor;
    private int highlightCursorX;
    private int highlightCursorY;
    private int highlightCursorW;
    private int highlightCursorH;
    private boolean hasSelectionCursor;
    private int selectionCursorX;
    private int selectionCursorY;
    private int selectionCursorW;
    private int selectionCursorH;
    private int cursor;

    public ViewerWindow() {
        this.setFont(new JLabel().getFont());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontImage = null;
        this.derivedFont = null;
    }

    public int getBackgroundRGB() {
        return this.getBackground().getRGB();
    }

    public int getFontHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    public int getCharWidth(char c) {
        return this.getFontMetrics(this.getFont()).charWidth(c);
    }

    public int getStringWidth(String string) {
        return this.getFontMetrics(this.getFont()).stringWidth(string);
    }

    public void fill(int n) {
        this.pixelBuffer.fill(n);
    }

    public void setCursor(int n, int n2) {
        this.cursor = n + n2 * this.image.getWidth();
    }

    public void setNextColor(int n) {
        this.pixelBuffer.setPixel(this.cursor++, n);
    }

    public void setColor(int n, int n2, int n3) {
        this.pixelBuffer.setPixel(n + n2 * this.image.getWidth(), n3);
    }

    public void setColor(int n, int n2, int n3, int n4) {
        this.pixelBuffer.fill(n + n2 * this.image.getWidth(), n + n2 * this.image.getWidth() + n3, n4);
    }

    public void xorColor(int n, int n2, int n3) {
        this.xorColor(n, n2, 1, n3);
    }

    public void xorColor(int n, int n2, int n3, int n4) {
        int n5 = n + n2 * this.image.getWidth();
        int n6 = 0;
        while (n6 < n3) {
            this.pixelBuffer.setPixel(n5 + n6, this.pixelBuffer.getPixel(n5 + n6) ^ n4);
            ++n6;
        }
    }

    public void drawString(String string, int n, int n2) {
        int n3 = (int)((float)this.image.getWidth() * this.scale);
        int n4 = (int)((float)this.image.getHeight() * this.scale);
        if (this.fontImage == null || this.fontImage.getWidth() != n3 || this.fontImage.getHeight() != n4) {
            this.derivedFont = this.getFont().deriveFont(this.getFont().getSize2D() * this.scale);
            this.fontImage = new BufferedImage(n3, n4, 2);
        }
        Graphics2D graphics2D = this.fontImage.createGraphics();
        graphics2D.setColor(this.getForeground());
        graphics2D.setFont(this.derivedFont);
        graphics2D.drawString(string, (float)n * this.scale, (float)(this.getFontMetrics(this.getFont()).getAscent() + n2) * this.scale);
        graphics2D.dispose();
    }

    public void drawLine(int n, int n2, int n3, int n4, Color color) {
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setColor(color);
        graphics2D.drawLine(n, n2, n3, n4);
        graphics2D.dispose();
    }

    public void hideHighlightCursor() {
        this.setHighlightCursor(0, 0, 0, 0);
        this.repaint();
    }

    public void setHighlightCursor(int n, int n2, int n3, int n4) {
        if (n != this.highlightCursorX || n2 != this.highlightCursorY || n3 != this.highlightCursorW || n4 != this.highlightCursorH) {
            this.hasHighlightCursor = n3 > 0 && n4 > 0 && n + n3 > 0 && n2 + n4 > 0;
            this.highlightCursorX = n;
            this.highlightCursorY = n2;
            this.highlightCursorW = n3;
            this.highlightCursorH = n4;
            this.repaint();
        }
    }

    public void setSelectionCursor(int n, int n2, int n3, int n4) {
        if (n != this.selectionCursorX || n2 != this.selectionCursorY || n3 != this.selectionCursorW || n4 != this.selectionCursorH) {
            this.hasSelectionCursor = n3 > 0 && n4 > 0 && n + n3 > 0 && n2 + n4 > 0;
            this.selectionCursorX = n;
            this.selectionCursorY = n2;
            this.selectionCursorW = n3;
            this.selectionCursorH = n4;
            this.repaint();
        }
    }

    private void setDimensions(int n, int n2) {
        if (this.image == null || n != this.image.getWidth() || n2 != this.image.getHeight()) {
            this.image = new BufferedImage(n, n2, 1);
            this.pixelBuffer = ViewerWindow.createPixelBuffer(this.image);
            this.hasHighlightCursor = false;
            this.fontImage = null;
        }
    }

    public void setDimensions(Dimension dimension) {
        this.setDimensions((int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public float getScale() {
        return this.scale;
    }

    public void setIntegerScaling(boolean bl) {
        this.integerScaling = bl;
        this.repaint();
    }

    public boolean isIntegerScaling() {
        return this.integerScaling;
    }

    private float getScaleX() {
        return (float)this.getContentWidth() / (float)this.image.getWidth();
    }

    private float getScaleY() {
        return (float)this.getContentHeight() / (float)this.image.getHeight();
    }

    private int getContentWidth() {
        Insets insets = this.getInsets(INSETS);
        return this.getWidth() - insets.left - insets.right;
    }

    private int getContentHeight() {
        Insets insets = this.getInsets(INSETS);
        return this.getHeight() - insets.top - insets.bottom;
    }

    public int toScreenX(int n) {
        if (this.image == null) {
            return 0;
        }
        Insets insets = this.getInsets(INSETS);
        int n2 = (int)((float)this.image.getWidth() * this.getScale());
        int n3 = Math.max(0, this.getContentWidth() - n2) / 2;
        int n4 = n - n3 - insets.left;
        if (n4 < 0) {
            n4 = (int)((float)n4 - this.getScale());
        }
        return (int)((float)n4 / this.getScale());
    }

    public int toScreenY(int n) {
        if (this.image == null) {
            return 0;
        }
        Insets insets = this.getInsets(INSETS);
        int n2 = (int)((float)this.image.getHeight() * this.getScale());
        int n3 = Math.max(0, this.getContentHeight() - n2) / 2;
        int n4 = n - n3 - insets.top;
        if (n4 < 0) {
            n4 = (int)((float)n4 - this.getScale());
        }
        return (int)((float)n4 / this.getScale());
    }

    public int toWindowX(int n) {
        if (this.image == null) {
            return 0;
        }
        Insets insets = this.getInsets(INSETS);
        int n2 = (int)((float)this.image.getWidth() * this.getScale());
        int n3 = Math.max(0, this.getContentWidth() - n2) / 2;
        return insets.left + (int)((float)n * this.getScale()) + n3;
    }

    public int toWindowY(int n) {
        if (this.image == null) {
            return 0;
        }
        Insets insets = this.getInsets(INSETS);
        int n2 = (int)((float)this.image.getHeight() * this.getScale());
        int n3 = Math.max(0, this.getContentHeight() - n2) / 2;
        return insets.top + (int)((float)n * this.getScale()) + n3;
    }

    private static PixelBuffer createPixelBuffer(BufferedImage bufferedImage) {
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            return new IntPixelBuffer((DataBufferInt)dataBuffer);
        }
        return new CompatiblePixelBuffer(bufferedImage);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.image == null) {
            return super.getMinimumSize();
        }
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return super.getPreferredSize();
        }
        return new Dimension((int)((float)this.image.getWidth() * this.scale), (int)((float)this.image.getHeight() * this.scale));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.image != null) {
            this.scale = Math.min(this.getScaleX(), this.getScaleY());
            if (this.integerScaling) {
                this.scale = Math.max(1, (int)this.scale);
            }
            Insets insets = this.getInsets(INSETS);
            int n = (int)((float)this.image.getWidth() * this.scale);
            int n2 = (int)((float)this.image.getHeight() * this.scale);
            int n3 = insets.left + (this.getContentWidth() - n) / 2;
            int n4 = insets.top + (this.getContentHeight() - n2) / 2;
            graphics.drawImage(this.image, n3, n4, n3 + n, n4 + n2, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
            if (this.fontImage != null) {
                graphics.drawImage(this.fontImage, n3, n4, null);
            }
            if (this.hasHighlightCursor) {
                graphics.setXORMode(Color.WHITE);
                graphics.drawRect(this.toWindowX(this.highlightCursorX), this.toWindowY(this.highlightCursorY), (int)((float)this.highlightCursorW * this.scale), (int)((float)this.highlightCursorH * this.scale));
                graphics.setPaintMode();
            }
            if (this.hasSelectionCursor) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics.setXORMode(Color.WHITE);
                graphics.drawRect(this.toWindowX(this.selectionCursorX), this.toWindowY(this.selectionCursorY), (int)((float)this.selectionCursorW * this.scale), (int)((float)this.selectionCursorH * this.scale));
                graphics.setPaintMode();
            }
        }
    }
}

