/*
 * Decompiled with CFR 0.152.
 */
package platform;

import common.ComponentWrapper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import platform.Emulicious;
import platform.SoundOutput;

class SoundRecordingSettingsDialog
extends JDialog {
    private final JTextField path;
    private final boolean[] channelsToRecord;

    public SoundRecordingSettingsDialog(JFrame jFrame, final SoundOutput soundOutput, boolean[] blArray) {
        super(jFrame, String.valueOf(Emulicious.TITLE) + " - Sound Recording Settings", true);
        this.channelsToRecord = Arrays.copyOf(blArray, soundOutput.getChannelNames().length + 1);
        this.setIconImages(jFrame.getIconImages());
        JTable jTable = new JTable(new AbstractTableModel(){
            private final String[] COLUMN_NAMES = new String[]{"", "Channel Name"};

            @Override
            public int getColumnCount() {
                return this.COLUMN_NAMES.length;
            }

            @Override
            public String getColumnName(int n) {
                return this.COLUMN_NAMES[n];
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return n == 0 ? Boolean.class : String.class;
            }

            @Override
            public int getRowCount() {
                return soundOutput.getChannelNames().length + 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return SoundRecordingSettingsDialog.this.channelsToRecord[n];
                }
                return n == 0 ? "Sum of Channels" : soundOutput.getChannelNames()[n - 1];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 0) {
                    boolean bl;
                    boolean bl2 = bl = object == Boolean.TRUE;
                    if (bl) {
                        ((SoundRecordingSettingsDialog)SoundRecordingSettingsDialog.this).channelsToRecord[n] = true;
                    } else {
                        int n3 = 0;
                        while (n3 < SoundRecordingSettingsDialog.this.channelsToRecord.length) {
                            if (n3 != n && SoundRecordingSettingsDialog.this.channelsToRecord[n3]) {
                                ((SoundRecordingSettingsDialog)SoundRecordingSettingsDialog.this).channelsToRecord[n] = false;
                                return;
                            }
                            ++n3;
                        }
                    }
                }
            }
        }){

            @Override
            public void updateUI() {
                super.updateUI();
                this.packColumns();
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                super.tableChanged(tableModelEvent);
                if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == -1 && tableModelEvent.getFirstRow() == -1) {
                    this.packColumns();
                }
            }

            private void packColumns() {
                if (this.getTableHeader() == null) {
                    return;
                }
                int n = this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                TableColumn tableColumn = this.getColumnModel().getColumn(0);
                tableColumn.setPreferredWidth(n);
                tableColumn.setMaxWidth(n);
                tableColumn = this.getColumnModel().getColumn(1);
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.getRowCount()) {
                    n2 = Math.max(n2, this.getCellRenderer((int)n3, (int)1).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n3, (int)1), (boolean)false, (boolean)false, (int)n3, (int)1).getPreferredSize().width);
                    ++n3;
                }
                tableColumn.setMaxWidth(n2 + this.getIntercellSpacing().width);
                tableColumn.setPreferredWidth(n2 + this.getIntercellSpacing().width);
                n3 = this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height;
                this.setRowHeight(Math.max(n3, this.getCellRenderer((int)0, (int)1).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)1), (boolean)false, (boolean)false, (int)0, (int)1).getPreferredSize().height));
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        jTable.setFillsViewportHeight(true);
        jTable.setShowGrid(false);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder("Channels to Export")));
        this.add((Component)jScrollPane, "West");
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Folder for Sound Recordings"));
        jPanel.add(new JPanel());
        jPanel.add(ComponentWrapper.wrapComponent(jPanel2));
        this.path = new JTextField(Emulicious.getSoundRecordingsDirectory().getAbsolutePath(), 40);
        jPanel2.add(this.path);
        JButton jButton = new JButton(FileSystemView.getFileSystemView().getSystemIcon(Emulicious.getSoundRecordingsDirectory()));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundRecordingSettingsDialog.this.showFolderFileChooser(SoundRecordingSettingsDialog.this);
            }
        });
        jPanel2.add(jButton);
        this.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                while (n < SoundRecordingSettingsDialog.this.channelsToRecord.length) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(SoundRecordingSettingsDialog.this.channelsToRecord[n]);
                    ++n;
                }
                Emulicious.getProperties().setProperty(Emulicious.getSoundRecorderProperty(), stringBuilder.toString());
                Emulicious.getProperties().setProperty("SoundRecordingsDir", SoundRecordingSettingsDialog.this.path.getText());
                SoundRecordingSettingsDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        jPanel3.add(jButton2);
        JButton jButton3 = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundRecordingSettingsDialog.this.dispose();
            }
        });
        jPanel3.add(jButton3);
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    final JDialog jDialog = new JDialog((Dialog)SoundRecordingSettingsDialog.this, true);
                    jDialog.setUndecorated(true);
                    jDialog.setSize(0, 0);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jDialog.dispose();
                        }
                    });
                    jDialog.setVisible(true);
                }
            });
        }
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", jButton3.getAction());
        this.add((Component)jPanel3, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setVisible(true);
    }

    void showFolderFileChooser(Component component) {
        JFileChooser jFileChooser = new JFileChooser(new File(this.path.getText()).getParentFile());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Save Sound Recordings To...");
        jFileChooser.setSelectedFile(new File(new File(this.path.getText()).getName()));
        if (jFileChooser.showSaveDialog(component) == 0) {
            this.path.setText(jFileChooser.getSelectedFile().getPath());
        }
    }
}

