/*
 * Decompiled with CFR 0.152.
 */
package debugfiles;

import debugfiles.AddressExpression;
import debugfiles.LValue;
import expressions.Token;

public class MemoryAccess
implements LValue {
    private final AddressExpression address;
    private final int size;
    private final boolean bigEndian;
    private final boolean elevated;

    MemoryAccess(Token[] tokenArray, AddressExpression addressExpression) {
        if (!"[".equals(tokenArray[0].getToken()) || !"]".equals(tokenArray[tokenArray.length - 1].getToken())) {
            throw new IllegalArgumentException("A memory access must begin and end with square brackets.");
        }
        this.address = addressExpression;
        this.elevated = "^".equals(tokenArray[tokenArray.length - 2].getToken());
        int n = this.elevated ? tokenArray.length - 3 : tokenArray.length - 2;
        this.bigEndian = "?".equals(tokenArray[n].getToken());
        this.size = n - 1 >= 0 && tokenArray[n - 1].getToken().equals(tokenArray[n].getToken()) ? 4 : (this.bigEndian || "!".equals(tokenArray[n].getToken()) ? 2 : 1);
    }

    public AddressExpression getAddress() {
        return this.address;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean isElevated() {
        return this.elevated;
    }
}

