/*
 * Decompiled with CFR 0.152.
 */
package assembler.sjasm;

import java.util.ArrayList;
import java.util.List;

public class SjasmPageMap {
    private final List<Integer> sizes = new ArrayList<Integer>();
    private final List<Integer> orgs = new ArrayList<Integer>();
    private final List<Integer> addresses = new ArrayList<Integer>();
    private int address;
    private int org;
    private int size;

    public int getPageSize(int n) {
        return this.sizes.get(n);
    }

    public int resolveAddress(int n, int n2) {
        if (n < this.orgs.size() && n2 >= this.orgs.get(n)) {
            return this.addresses.get(n) + (n2 & 0x3FFF);
        }
        return n2;
    }

    public void addPage(int n, int n2) {
        this.addresses.add(this.address);
        this.orgs.add(n);
        this.sizes.add(n2);
        this.size = n2;
        this.org = n;
        this.address = this.address + (n & 0x3FFF) + n2;
    }

    public void addPages(int n, int n2, int n3) {
        if (n2 < 0) {
            n2 = this.org;
        }
        if (n3 < 0) {
            n3 = this.size;
        }
        int n4 = 0;
        while (n4 < n) {
            this.addPage(n2, n3);
            ++n4;
        }
    }
}

