/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.file.attribute.FileTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipConstants;
import java.util.zip.ZipUtils;

public class ZipEntry
implements ZipConstants,
Cloneable {
    String name;
    long time = -1L;
    FileTime mtime;
    FileTime atime;
    FileTime ctime;
    long crc = -1L;
    long size = -1L;
    long csize = -1L;
    int method = -1;
    int flag = 0;
    byte[] extra;
    String comment;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String string) {
        Objects.requireNonNull(string, "name");
        if (string.length() > 65535) {
            throw new IllegalArgumentException("entry name too long");
        }
        this.name = string;
    }

    public ZipEntry(ZipEntry zipEntry) {
        Objects.requireNonNull(zipEntry, "entry");
        this.name = zipEntry.name;
        this.time = zipEntry.time;
        this.mtime = zipEntry.mtime;
        this.atime = zipEntry.atime;
        this.ctime = zipEntry.ctime;
        this.crc = zipEntry.crc;
        this.size = zipEntry.size;
        this.csize = zipEntry.csize;
        this.method = zipEntry.method;
        this.flag = zipEntry.flag;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
    }

    ZipEntry() {
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long l) {
        this.time = l;
        this.mtime = null;
    }

    public long getTime() {
        return this.time;
    }

    public ZipEntry setLastModifiedTime(FileTime fileTime) {
        Objects.requireNonNull(this.name, "time");
        this.mtime = fileTime;
        this.time = fileTime.to(TimeUnit.MILLISECONDS);
        return this;
    }

    public FileTime getLastModifiedTime() {
        if (this.mtime != null) {
            return this.mtime;
        }
        if (this.time == -1L) {
            return null;
        }
        return FileTime.from(this.time, TimeUnit.MILLISECONDS);
    }

    public ZipEntry setLastAccessTime(FileTime fileTime) {
        Objects.requireNonNull(this.name, "time");
        this.atime = fileTime;
        return this;
    }

    public FileTime getLastAccessTime() {
        return this.atime;
    }

    public ZipEntry setCreationTime(FileTime fileTime) {
        Objects.requireNonNull(this.name, "time");
        this.ctime = fileTime;
        return this;
    }

    public FileTime getCreationTime() {
        return this.ctime;
    }

    public void setSize(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = l;
    }

    public long getSize() {
        return this.size;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setCompressedSize(long l) {
        this.csize = l;
    }

    public void setCrc(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = l;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = n;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] byArray) {
        this.setExtra0(byArray, false);
    }

    void setExtra0(byte[] byArray, boolean bl) {
        if (byArray != null) {
            if (byArray.length > 65535) {
                throw new IllegalArgumentException("invalid extra field length");
            }
            int n = 0;
            int n2 = byArray.length;
            while (n + 4 < n2) {
                int n3;
                int n4 = ZipUtils.get16(byArray, n);
                if ((n += 4) + (n3 = ZipUtils.get16(byArray, n + 2)) > n2) break;
                switch (n4) {
                    case 1: {
                        if (!bl || n3 < 16) break;
                        this.size = ZipUtils.get64(byArray, n);
                        this.csize = ZipUtils.get64(byArray, n + 8);
                        break;
                    }
                    case 10: {
                        int n5 = n + 4;
                        if (ZipUtils.get16(byArray, n5) != 1 || ZipUtils.get16(byArray, n5 + 2) != 24) break;
                        this.mtime = ZipUtils.winTimeToFileTime(ZipUtils.get64(byArray, n5 + 4));
                        this.atime = ZipUtils.winTimeToFileTime(ZipUtils.get64(byArray, n5 + 12));
                        this.ctime = ZipUtils.winTimeToFileTime(ZipUtils.get64(byArray, n5 + 20));
                        break;
                    }
                    case 21589: {
                        int n6 = Byte.toUnsignedInt(byArray[n]);
                        int n7 = 1;
                        if ((n6 & 1) != 0 && n7 + 4 <= n3) {
                            this.mtime = ZipUtils.unixTimeToFileTime(ZipUtils.get32(byArray, n + n7));
                            n7 += 4;
                        }
                        if ((n6 & 2) != 0 && n7 + 4 <= n3) {
                            this.atime = ZipUtils.unixTimeToFileTime(ZipUtils.get32(byArray, n + n7));
                            n7 += 4;
                        }
                        if ((n6 & 4) == 0 || n7 + 4 > n3) break;
                        this.ctime = ZipUtils.unixTimeToFileTime(ZipUtils.get32(byArray, n + n7));
                        n7 += 4;
                        break;
                    }
                }
                n += n3;
            }
        }
        this.extra = byArray;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Object clone() {
        try {
            ZipEntry zipEntry = (ZipEntry)super.clone();
            zipEntry.extra = this.extra == null ? null : (byte[])this.extra.clone();
            return zipEntry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }
}

