/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.glassfish.external.statistics.impl;

import com.sun.org.glassfish.external.statistics.AverageRangeStatistic;
import com.sun.org.glassfish.external.statistics.impl.StatisticImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public final class AverageRangeStatisticImpl
extends StatisticImpl
implements AverageRangeStatistic,
InvocationHandler {
    private long currentVal = 0L;
    private long highWaterMark = Long.MIN_VALUE;
    private long lowWaterMark = Long.MAX_VALUE;
    private long numberOfSamples = 0L;
    private long runningTotal = 0L;
    private final long initCurrentVal;
    private final long initHighWaterMark;
    private final long initLowWaterMark;
    private final long initNumberOfSamples;
    private final long initRunningTotal;
    private final AverageRangeStatistic as = (AverageRangeStatistic)Proxy.newProxyInstance(AverageRangeStatistic.class.getClassLoader(), new Class[]{AverageRangeStatistic.class}, this);

    public AverageRangeStatisticImpl(long l, long l2, long l3, String string, String string2, String string3, long l4, long l5) {
        super(string, string2, string3, l4, l5);
        this.currentVal = l;
        this.initCurrentVal = l;
        this.highWaterMark = l2;
        this.initHighWaterMark = l2;
        this.lowWaterMark = l3;
        this.initLowWaterMark = l3;
        this.initNumberOfSamples = this.numberOfSamples = 0L;
        this.initRunningTotal = this.runningTotal = 0L;
    }

    public synchronized AverageRangeStatistic getStatistic() {
        return this.as;
    }

    @Override
    public synchronized String toString() {
        return super.toString() + NEWLINE + "Current: " + this.getCurrent() + NEWLINE + "LowWaterMark: " + this.getLowWaterMark() + NEWLINE + "HighWaterMark: " + this.getHighWaterMark() + NEWLINE + "Average:" + this.getAverage();
    }

    @Override
    public synchronized Map getStaticAsMap() {
        Map map = super.getStaticAsMap();
        map.put("current", this.getCurrent());
        map.put("lowwatermark", this.getLowWaterMark());
        map.put("highwatermark", this.getHighWaterMark());
        map.put("average", this.getAverage());
        return map;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.currentVal = this.initCurrentVal;
        this.highWaterMark = this.initHighWaterMark;
        this.lowWaterMark = this.initLowWaterMark;
        this.numberOfSamples = this.initNumberOfSamples;
        this.runningTotal = this.initRunningTotal;
        this.sampleTime = -1L;
    }

    @Override
    public synchronized long getAverage() {
        if (this.numberOfSamples == 0L) {
            return -1L;
        }
        return this.runningTotal / this.numberOfSamples;
    }

    @Override
    public synchronized long getCurrent() {
        return this.currentVal;
    }

    public synchronized void setCurrent(long l) {
        this.currentVal = l;
        this.lowWaterMark = l >= this.lowWaterMark ? this.lowWaterMark : l;
        this.highWaterMark = l >= this.highWaterMark ? l : this.highWaterMark;
        ++this.numberOfSamples;
        this.runningTotal += l;
        this.sampleTime = System.currentTimeMillis();
    }

    @Override
    public synchronized long getHighWaterMark() {
        return this.highWaterMark;
    }

    @Override
    public synchronized long getLowWaterMark() {
        return this.lowWaterMark;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        this.checkMethod(method);
        try {
            object2 = method.invoke(this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (Exception exception) {
            throw new RuntimeException("unexpected invocation exception: " + exception.getMessage());
        }
        return object2;
    }
}

