/*
 * Decompiled with CFR 0.152.
 */
package output;

import components.input.InputDevice;
import components.input.SMSLightPhaser;
import components.video.GGVDP;
import components.video.SMS2VDP;
import components.video.TMS9918A;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import output.PaletteRenderer;
import output.PixelProvider;
import output.SpriteRenderer;
import output.TilemapRenderer;
import output.TilesetRenderer;
import output.ViewerCache;
import platform.DisplayWindow;
import platform.viewers.ViewerWindow;

public class SMSDisplayWindow
implements PaletteRenderer,
TilesetRenderer,
TilemapRenderer,
SpriteRenderer,
PixelProvider {
    private static final String[] PALETTE_NAMES;
    private static final String[] BASE_ADDRESS_NAMES;
    private static final String[] TILE_BASE_ADDRESS_NAMES;
    public static final int GG_HIDE_LEFT_MOST_COLUMN = 1;
    public static final int GG_SHOW_HORIZONTAL_OFFSCREEN_AREA = 2;
    public static final int GG_SHOW_VERTICAL_OFFSCREEN_AREA = 4;
    public static final int GG_SHOW_WHOLE_OFFSCREEN_AREA = 6;
    static final int FLAG_SPRITE = 128;
    static final int FLAG_VISIBLE_PIXEL = 64;
    private static final int WIDTH = 256;
    private static final int CROSSHAIR_RADIUS = 3;
    protected final DisplayWindow displayWindow;
    protected Renderer renderer;
    private final SMSLightPhaser[] lightPhasers = new SMSLightPhaser[2];
    private boolean hasLightPhaser;
    protected final int[][] colorsBuffers = new int[171][32];
    protected final int[][] colorsPointersUnmodified = new int[142][];
    protected final int[][] colorsPointersModified = new int[142][];
    protected int[][] colorsPointers = this.colorsPointersUnmodified;
    protected int[] colors;
    protected int[] vram;
    protected TMS9918A vdp;
    protected final int ggShowOffscreenArea;
    protected final boolean smsHideBorders;
    protected final boolean emulateVDPconstraints;
    protected int[] spriteBuffer = new int[4];
    protected int spriteCount;
    protected int spriteToHighlight = -1;
    protected final int[][] lineBuffers = new int[241][256];
    protected int[] lineBuffer = this.lineBuffers[0];
    protected final int[][] patternData = new int[16384][8];
    protected final boolean[] patternDirty = new boolean[16384];
    protected final int[] colorWrites = new int[33];
    protected final int[] hScrollValues = new int[256];
    protected final int[] baseAddressValues = new int[256];
    protected final int[] modeBits = new int[256];
    protected final boolean[] displayOnValues = new boolean[256];
    protected final boolean[] largeSprites = new boolean[64];
    protected final boolean[] largeSpritesSet = new boolean[64];
    private static final int[] MIRRORED_BITS;
    private static final int[] STRETCHED_BITPLANE;
    private static final int[] TMS_COLORS;
    private static final int[] TMS_CROM;

    static {
        int n;
        int n2;
        PALETTE_NAMES = new String[]{"Auto", "TMS", "0", "1"};
        BASE_ADDRESS_NAMES = new String[]{"Auto", "3800", "3000", "2800", "2000", "1800", "1000", "800", "0"};
        TILE_BASE_ADDRESS_NAMES = new String[0];
        MIRRORED_BITS = new int[256];
        STRETCHED_BITPLANE = new int[256];
        TMS_COLORS = new int[16];
        int[] nArray = new int[16];
        nArray[2] = 8;
        nArray[3] = 12;
        nArray[4] = 16;
        nArray[5] = 48;
        nArray[6] = 1;
        nArray[7] = 60;
        nArray[8] = 2;
        nArray[9] = 3;
        nArray[10] = 5;
        nArray[11] = 15;
        nArray[12] = 4;
        nArray[13] = 51;
        nArray[14] = 21;
        nArray[15] = 63;
        TMS_CROM = nArray;
        int n3 = 0;
        while (n3 < MIRRORED_BITS.length) {
            n2 = n3;
            n = 8;
            while (n2 > 0) {
                int n4 = n3;
                MIRRORED_BITS[n4] = MIRRORED_BITS[n4] << 1;
                int n5 = n3;
                MIRRORED_BITS[n5] = MIRRORED_BITS[n5] | n2 & 1;
                n2 >>= 1;
                --n;
            }
            int n6 = n3++;
            MIRRORED_BITS[n6] = MIRRORED_BITS[n6] << n;
        }
        n3 = 0;
        while (n3 < STRETCHED_BITPLANE.length) {
            n2 = 0;
            while (n2 < 8) {
                if ((n3 & 1 << n2) != 0) {
                    int n7 = n3;
                    STRETCHED_BITPLANE[n7] = STRETCHED_BITPLANE[n7] | 1 << (n2 << 2);
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 1;
        while (n3 < TMS_CROM.length) {
            n2 = TMS_CROM[n3];
            n = (n2 & 0x30) >> 4;
            int n8 = (n2 & 0xC) >> 2;
            int n9 = n2 & 3;
            SMSDisplayWindow.TMS_COLORS[n3] = DisplayWindow.toPlatformColor(n9 * 255 / 3, n8 * 255 / 3, n * 255 / 3);
            ++n3;
        }
    }

    public SMSDisplayWindow(DisplayWindow displayWindow, int n, boolean bl) {
        this(displayWindow, n, bl, true);
    }

    protected SMSDisplayWindow(DisplayWindow displayWindow, int n, boolean bl, boolean bl2) {
        this.displayWindow = displayWindow;
        this.ggShowOffscreenArea = n;
        this.smsHideBorders = bl;
        this.emulateVDPconstraints = bl2;
        this.colorsPointersUnmodified[0] = this.colorsBuffers[this.colorsBuffers.length - 1];
        int n2 = 1;
        while (n2 < this.colorsPointersUnmodified.length) {
            this.colorsPointersUnmodified[n2] = this.colorsPointersUnmodified[0];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.colorsPointersModified.length) {
            this.colorsPointersModified[n2] = this.colorsBuffers[n2];
            ++n2;
        }
        this.colors = this.colorsPointers[0];
        Arrays.fill(this.colorWrites, -1);
    }

    public void makePatternDirty(int n) {
        this.patternDirty[n] = true;
        this.patternDirty[0x1000 | n] = true;
        this.patternDirty[0x2000 | n ^ 7] = true;
        this.patternDirty[0x3000 | n ^ 7] = true;
    }

    void updatePattern(int n) {
        if (this.patternDirty[n]) {
            int n2 = (n & 0xFFF) << 2;
            if ((n & 0x2000) != 0) {
                n2 ^= 0x1C;
            }
            int n3 = this.vram[n2];
            int n4 = this.vram[n2 | 1];
            int n5 = this.vram[n2 | 2];
            int n6 = this.vram[n2 | 3];
            if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0) {
                Arrays.fill(this.patternData[n], 0);
            } else {
                if ((n & 0x1000) == 0) {
                    n3 = MIRRORED_BITS[n3];
                    n4 = MIRRORED_BITS[n4];
                    n5 = MIRRORED_BITS[n5];
                    n6 = MIRRORED_BITS[n6];
                }
                int n7 = STRETCHED_BITPLANE[n6] << 3 | STRETCHED_BITPLANE[n5] << 2 | STRETCHED_BITPLANE[n4] << 1 | STRETCHED_BITPLANE[n3];
                int n8 = 0;
                while (n8 < 8) {
                    int n9 = n7 & 0xF;
                    n7 >>= 4;
                    this.patternData[n][n8] = n9;
                    ++n8;
                }
            }
            this.patternDirty[n] = false;
        }
    }

    private int[] getPatternData(int n) {
        int[] nArray = this.patternData[n];
        if (this.patternDirty[n]) {
            nArray = (int[])nArray.clone();
            int n2 = (n & 0xFFF) << 2;
            if ((n & 0x2000) != 0) {
                n2 ^= 0x1C;
            }
            int n3 = this.vram[n2];
            int n4 = this.vram[n2 | 1];
            int n5 = this.vram[n2 | 2];
            int n6 = this.vram[n2 | 3];
            if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0) {
                Arrays.fill(nArray, 0);
            } else {
                if ((n & 0x1000) == 0) {
                    n3 = MIRRORED_BITS[n3];
                    n4 = MIRRORED_BITS[n4];
                    n5 = MIRRORED_BITS[n5];
                    n6 = MIRRORED_BITS[n6];
                }
                int n7 = STRETCHED_BITPLANE[n6] << 3 | STRETCHED_BITPLANE[n5] << 2 | STRETCHED_BITPLANE[n4] << 1 | STRETCHED_BITPLANE[n3];
                int n8 = 0;
                while (n8 < 8) {
                    int n9 = n7 & 0xF;
                    n7 >>= 4;
                    nArray[n8] = n9;
                    ++n8;
                }
            }
        }
        return nArray;
    }

    public void updateColor(int n) {
        if (this.colorsPointers != this.colorsPointersModified) {
            this.colors = this.colorsPointers[0];
        }
        int n2 = this.vdp.getColorBlue(n);
        int n3 = this.vdp.getColorGreen(n);
        int n4 = this.vdp.getColorRed(n);
        int n5 = this.vdp.getColorMaxIntensity();
        this.colors[n] = DisplayWindow.toPlatformColor(n4 * 255 / n5, n3 * 255 / n5, n2 * 255 / n5);
        int n6 = 0;
        while (n6 < this.colorsBuffers.length) {
            System.arraycopy(this.colors, 0, this.colorsBuffers[n6], 0, this.colors.length);
            ++n6;
        }
        this.colorsPointers = this.colorsPointersModified;
    }

    public void updateColor(int n, int n2, boolean bl) {
        int n3;
        int n4;
        n2 -= 18;
        if ((n2 += ~n2 & 1) < 254) {
            n2 |= 2;
        }
        if (!(this.vdp instanceof GGVDP) && this.vdp.isDisplayOn() && (this.vdp.getLine() < 192 || this.vdp.getLine() == this.vdp.getScanlines() - 1)) {
            if (n2 < 229) {
                n2 = (n2 + 28 & 0xFFFFFFE0) + 3;
            } else if (n2 < 259) {
                n2 = (n2 + 28 & 0xFFFFFFE0) + 3 - 2;
            } else if (n2 >= 265) {
                n2 = 284;
            }
        }
        if (bl) {
            n4 = Math.max(0, (n2 - 1) / 2 + 1);
            if (this.colorsPointers != this.colorsPointersModified) {
                this.colors = this.colorsPointers[0];
                n3 = 0;
                while (n3 < n4 && n3 < this.colorsBuffers.length) {
                    System.arraycopy(this.colors, 0, this.colorsBuffers[n3], 0, this.colors.length);
                    ++n3;
                }
            }
            n3 = this.vdp.getColorBlue(n);
            int n5 = this.vdp.getColorGreen(n);
            int n6 = this.vdp.getColorRed(n);
            int n7 = this.vdp.getColorMaxIntensity();
            this.colors[n] = DisplayWindow.toPlatformColor(n6 * 255 / n7, n5 * 255 / n7, n3 * 255 / n7);
            int n8 = n4;
            while (n8 < this.colorsBuffers.length) {
                System.arraycopy(this.colors, 0, this.colorsBuffers[n8], 0, this.colors.length);
                ++n8;
            }
            this.colorsPointers = this.colorsPointersModified;
        }
        if (this.emulateVDPconstraints) {
            int n9 = n4 = !this.smsHideBorders && !(this.vdp instanceof GGVDP) ? 1 : 0;
            if (n4 == 0) {
                n2 -= 13;
            }
            if (n2 >= 0 && (n4 != 0 && n2 < 284 || n2 < 256)) {
                n3 = 0;
                while (this.colorWrites[n3] >= 0) {
                    n3 += 2;
                }
                if (n3 + 2 < this.colorWrites.length) {
                    this.colorWrites[n3++] = n2;
                    this.colorWrites[n3++] = this.colors[n];
                }
                this.colorWrites[n3] = -1;
            }
        }
    }

    public void setMode(int n) {
        int n2 = 28;
        this.spriteCount = 0;
        switch (n & 0xF) {
            case 0: {
                this.renderer = new Mode0Renderer();
                this.spriteBuffer = new int[4];
                break;
            }
            case 1: {
                this.renderer = new Mode1Renderer();
                this.spriteBuffer = new int[0];
                break;
            }
            case 2: {
                this.renderer = new Mode2Renderer();
                this.spriteBuffer = new int[4];
                break;
            }
            case 3: {
                this.renderer = new Mode1extRenderer();
                this.spriteBuffer = new int[0];
                break;
            }
            case 4: {
                this.renderer = new Mode3Renderer();
                this.spriteBuffer = new int[4];
                break;
            }
            case 6: {
                this.renderer = new Mode3extRenderer();
                this.spriteBuffer = new int[4];
                break;
            }
            case 5: 
            case 7: {
                this.renderer = new ModeInvalidRenderer();
                this.spriteBuffer = new int[0];
                break;
            }
            case 9: 
            case 13: {
                this.renderer = new ModeInvalidTextRenderer();
                this.spriteBuffer = new int[0];
                break;
            }
            case 11: 
            case 14: {
                n2 = 32;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                this.renderer = new Mode4Renderer(n2);
                this.spriteBuffer = new int[8];
                break;
            }
            default: {
                System.err.println("Invalid Mode: " + n);
            }
        }
    }

    protected int getTmsColor(int n) {
        if (this.vdp instanceof GGVDP) {
            return this.getColor(n, 8);
        }
        return TMS_COLORS[n];
    }

    public void renderLine() {
        if (this.vdp.isSyncEnabled()) {
            this.displayWindow.fill(0);
        } else if (!this.displayWindow.shouldSkipFrame()) {
            this.renderer.renderLine();
            this.colorsPointers = this.colorsPointersUnmodified;
            if (this.vdp.getLine() < this.hScrollValues.length) {
                this.hScrollValues[this.vdp.getLine()] = this.vdp.getHorizontalScroll();
                this.baseAddressValues[this.vdp.getLine()] = this.vdp.getScreenMapBaseAddress(0);
                this.displayOnValues[this.vdp.getLine()] = this.vdp.isDisplayOn();
                this.modeBits[this.vdp.getLine()] = this.vdp.getModeBits();
            }
        }
        if (this.emulateVDPconstraints) {
            this.colorWrites[0] = -1;
        }
        if (this.hasLightPhaser) {
            this.handleLightPhasers();
        }
        if (this.vdp.getLine() == 192) {
            this.displayWindow.renderFrame(this.vdp instanceof GGVDP);
            int n = 0;
            while (n < this.largeSprites.length) {
                if (!this.largeSpritesSet[n]) {
                    this.largeSprites[n] = this.vdp.isLargeSpritesEnabled();
                }
                ++n;
            }
            Arrays.fill(this.largeSpritesSet, false);
        }
    }

    private void handleLightPhasers() {
        this.handleLightPhaser(this.lightPhasers[0]);
        this.handleLightPhaser(this.lightPhasers[1]);
    }

    private void handleLightPhaser(SMSLightPhaser sMSLightPhaser) {
        if (sMSLightPhaser != null && sMSLightPhaser.getPointerInputProvider().isOnScreen()) {
            int n;
            int n2 = sMSLightPhaser.getPointerInputProvider().getY();
            int n3 = this.vdp.getLine();
            if (!this.smsHideBorders) {
                n2 += this.vdp.getLinesTopBorder();
                n3 = (n3 + this.vdp.getLinesTopBorder()) % this.vdp.getScanlines();
            }
            if ((n = Math.abs(n2 - n3)) <= 3) {
                int n4;
                int n5;
                int n6 = this.getAverageRGB(sMSLightPhaser.getPointerInputProvider().getX(), sMSLightPhaser.getPointerInputProvider().getY(), n);
                int n7 = n6 >> 8 & 0xFF;
                if (3 * n7 + 2 * (n5 = n6 >> 16) + (n4 = n6 & 0xFF) <= 510) {
                    return;
                }
                int n8 = sMSLightPhaser.getPointerInputProvider().getX() + 24;
                int n9 = (int)Math.round(Math.sqrt(9 - n * n));
                SMS2VDP sMS2VDP = (SMS2VDP)this.vdp;
                if (sMSLightPhaser == this.lightPhasers[0]) {
                    sMS2VDP.setTH0cycles(n8 - n9, n8 + n9 + 166);
                } else {
                    sMS2VDP.setTH1cycles(n8 - n9, n8 + n9 + 166);
                }
            }
        }
    }

    private int getAverageRGB(int n, int n2, int n3) {
        if (n2 < 1) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = (int)Math.round(Math.sqrt(9 - n3 * n3));
        int n9 = -n8;
        while (n9 <= n8) {
            int n10 = this.displayWindow.getColorDirect(n + n9, n2);
            n4 += n10 >> 16;
            n5 += n10 >> 8 & 0xFF;
            n6 += n10 & 0xFF;
            ++n7;
            ++n9;
        }
        return n4 / n7 << 16 | n5 / n7 << 8 | n6 / n7;
    }

    public void prepareSprites() {
        this.lineBuffer = this.lineBuffers[this.vdp.getLine()];
        Arrays.fill(this.lineBuffer, 0);
        this.renderer.prepareSprites();
    }

    @Override
    public boolean isWideSprites() {
        return this.renderer instanceof TMSRenderer;
    }

    @Override
    public int[][] getSpriteData(int[][] nArray) {
        int[][] nArray2;
        block6: {
            block5: {
                nArray2 = nArray;
                if (!(this.renderer instanceof TMSRenderer)) break block5;
                if (this.spriteBuffer.length == 0) {
                    return nArray != null && nArray.length == 0 ? (Object)nArray : new int[][]{};
                }
                nArray2 = nArray != null && nArray.length == 32 && nArray[0].length == 4 ? nArray : new int[32][4];
                int n = 0;
                while (n < 32) {
                    int n2 = this.vram[this.vdp.getSpriteAttributeTableAddress(n) | n << 2];
                    int n3 = this.vram[this.vdp.getSpriteAttributeTableAddress(n) | n << 2 | 1];
                    int n4 = this.vram[this.vdp.getSpriteAttributeTableAddress(n) | n << 2 | 2];
                    if (n2 >= 240) {
                        n2 -= 256;
                    }
                    nArray2[n][0] = n2;
                    nArray2[n][1] = n3;
                    nArray2[n][2] = n4;
                    nArray2[n][3] = this.vram[this.vdp.getSpriteAttributeTableAddress(n) | n << 2 | 3];
                    ++n;
                }
                break block6;
            }
            if (!(this.renderer instanceof Mode4Renderer)) break block6;
            SMS2VDP sMS2VDP = (SMS2VDP)this.vdp;
            nArray2 = nArray != null && nArray.length == 64 && nArray[0].length == 3 ? nArray : new int[64][3];
            int n = 0;
            while (n < 64) {
                int n5 = this.vram[sMS2VDP.getSpriteAttributeTableAddress(n) | n];
                int n6 = this.vram[sMS2VDP.getSpriteAttributeTableAddress(n) | 0x80 | n << 1] - (sMS2VDP.isSpriteShiftEnabled() ? 8 : 0);
                int n7 = this.vram[sMS2VDP.getSpriteAttributeTableAddress(n) | 0x80 | n << 1 | 1];
                if (n5 >= 240) {
                    n5 -= 256;
                }
                nArray2[n][0] = n5;
                nArray2[n][1] = n6;
                nArray2[n][2] = n7;
                ++n;
            }
        }
        return nArray2;
    }

    @Override
    public void setSpriteToHighlight(int n) {
        this.spriteToHighlight = n;
        this.highlightSprite(n);
    }

    private void highlightSprite(int n) {
        if (n < 0) {
            this.displayWindow.eraseSelectionCursor();
            return;
        }
        if (this.renderer instanceof TMSRenderer) {
            boolean bl;
            int n2 = this.vram[this.vdp.getSpriteAttributeTableAddress(n) | n << 2] + 1;
            int n3 = this.vram[this.vdp.getSpriteAttributeTableAddress(n) | n << 2 | 1];
            boolean bl2 = bl = (((TMSRenderer)this.renderer).getSpriteAttributes(n, 0) & 0x80) != 0;
            if (n2 >= 192) {
                n2 -= 256;
            }
            if (bl) {
                n3 -= 32;
            }
            if (((TMSRenderer)this.renderer).isSpriteXdoubled()) {
                n3 <<= 1;
            }
            boolean bl3 = this.vdp.isLargeSpritesEnabled();
            boolean bl4 = this.vdp.isDoubledSpritesEnabled();
            int n4 = 8;
            int n5 = 8;
            if (bl4) {
                n5 *= 2;
                n4 *= 2;
            }
            if (bl3) {
                n5 *= 2;
                n4 *= 2;
            }
            this.displayWindow.setSelectionCursor(n3, n2, n4, n5);
        } else {
            SMS2VDP sMS2VDP = (SMS2VDP)this.vdp;
            boolean bl = sMS2VDP.isLargeSpritesEnabled();
            boolean bl5 = sMS2VDP.isDoubledSpritesEnabled();
            int n6 = this.vram[sMS2VDP.getSpriteAttributeTableAddress(n) | n] + 1;
            int n7 = this.vram[sMS2VDP.getSpriteAttributeTableAddress(n) | 0x80 | n << 1] - (sMS2VDP.isSpriteShiftEnabled() ? 8 : 0);
            if (n6 >= sMS2VDP.getScreenHeight()) {
                n6 -= 256;
            }
            int n8 = 8;
            int n9 = 8;
            if (bl5) {
                n8 *= 2;
                n9 *= 2;
            }
            if (bl) {
                n9 *= 2;
            }
            this.displayWindow.setSelectionCursor(n7, n6, n8, n9);
        }
    }

    @Override
    public int getSpriteTile(int n, int[][] nArray) {
        if (this.isMode2Renderer()) {
            return 0x300 | nArray[n][2];
        }
        return this.vdp.getSpritePatternAddress() >> 5 | nArray[n][2];
    }

    @Override
    public String getSpriteAttributes(int n) {
        return "";
    }

    @Override
    public int getAddressOfSpriteVpos(int n) {
        return this.vdp.getSpriteAttributeTableAddress(n) | n;
    }

    @Override
    public int getAddressOfSpriteHpos(int n) {
        return this.vdp.getSpriteAttributeTableAddress(n) | 0x80 | n << 1;
    }

    @Override
    public int getAddressOfSpriteTile(int n) {
        return this.vdp.getSpriteAttributeTableAddress(n) | 0x80 | n << 1 | 1;
    }

    @Override
    public int getAddressOfSpriteAttributes(int n) {
        return -1;
    }

    @Override
    public String getCPUAddressOfSprite(int n) {
        return null;
    }

    @Override
    public boolean hasSpriteAttributes() {
        return false;
    }

    @Override
    public String getNameOfSpriteLocation() {
        return "VRAM";
    }

    @Override
    public int[] getTilemapData(int n, int[] nArray, ViewerCache viewerCache) {
        int[] nArray2;
        --n;
        int[] nArray3 = nArray2 = nArray != null && nArray.length == 1024 ? nArray : new int[1024];
        if (this.renderer instanceof TMSRenderer) {
            int n2 = n < 0 ? this.vdp.getScreenMapBaseAddress(0) : this.getBaseAddressNames().length - 2 - n << 11;
            System.arraycopy(this.vram, n2, nArray2, 0, Math.min(this.vram.length - n2, nArray2.length));
        } else if (this.renderer instanceof Mode4Renderer) {
            SMS2VDP sMS2VDP = (SMS2VDP)this.vdp;
            int n3 = n < 0 ? sMS2VDP.getScreenMapBaseAddress(0) : (n ^ 7) << 11;
            int n4 = 0;
            while (n4 < (sMS2VDP.getScreenHeight() > 192 ? 32 : 28)) {
                int n5 = n4 * 8 - sMS2VDP.getVerticalScroll();
                while (n5 < 0) {
                    n5 += sMS2VDP.getScreenHeight() > 192 ? 256 : 224;
                }
                int n6 = (n < 0 ? this.baseAddressValues[n5] : n3) + n4 * 64;
                int n7 = 0;
                while (n7 < 32) {
                    int n8 = (n6 | (n7 & 0x1F) << 1) & 0x3FFE;
                    nArray2[n4 * 32 + n7] = this.vram[n8 | 1] << 8 | this.vram[n8];
                    ++n7;
                }
                ++n4;
            }
        }
        return nArray2;
    }

    @Override
    public int getVRAMAddressOfTilemapEntry(int n, int n2, ViewerCache viewerCache) {
        int n3;
        if (this.vdp == null) {
            return 0;
        }
        int n4 = n3 = --n2 < 0 ? this.vdp.getScreenMapBaseAddress(0) : this.getBaseAddressNames().length - 2 - n2 << 11;
        if (!(this.vdp instanceof SMS2VDP)) {
            return n3 + n;
        }
        SMS2VDP sMS2VDP = (SMS2VDP)this.vdp;
        int n5 = n / 32 * 8 - sMS2VDP.getVerticalScroll();
        while (n5 < 0) {
            n5 += sMS2VDP.getScreenHeight() > 192 ? 256 : 224;
        }
        if (this.modeBits[n5] < 8) {
            return n3 + n;
        }
        int n6 = n2 < 0 ? this.baseAddressValues[n5] : n3;
        return n6 + (n << 1);
    }

    @Override
    public int getVRAMAddressOfTilemapEntryAttributes(int n, int n2, ViewerCache viewerCache) {
        return this.getVRAMAddressOfTilemapEntry(n, n2, viewerCache) + 1;
    }

    @Override
    public String getCPUAddressOfTilemapEntry(int n, int n2, ViewerCache viewerCache) {
        return null;
    }

    @Override
    public String getTilemapEntryAttributes(int n, int[] nArray) {
        if (!(this.vdp instanceof SMS2VDP)) {
            return "None";
        }
        int n2 = n / 32 * 8 - this.vdp.getVerticalScroll();
        while (n2 < 0) {
            n2 += this.vdp.getScreenHeight() > 192 ? 256 : 224;
        }
        if (this.modeBits[n2] < 8) {
            return "None";
        }
        return String.valueOf(String.format("$%02X", nArray[n] >> 8)) + " (hflip: " + SMSDisplayWindow.isTilemapEntryHflip(nArray[n]) + " | vflip: " + SMSDisplayWindow.isTilemapEntryVflip(nArray[n]) + " | palette: " + SMSDisplayWindow.getTilemapEntryPalette(nArray[n]) + " | priority: " + SMSDisplayWindow.isTilemapEntryPriority(nArray[n]) + ")";
    }

    private static boolean isTilemapEntryHflip(int n) {
        return (n & 0x200) != 0;
    }

    private static boolean isTilemapEntryVflip(int n) {
        return (n & 0x400) != 0;
    }

    private static int getTilemapEntryPalette(int n) {
        return (n & 0x800) >> 11;
    }

    private static boolean isTilemapEntryPriority(int n) {
        return (n & 0x1000) != 0;
    }

    @Override
    public boolean hasTilemapAttributes() {
        return true;
    }

    @Override
    public Dimension getTilemapDimension(boolean bl) {
        int n = this.getTilemapLines();
        if (n == 256) {
            return new Dimension(bl ? 287 : 256, bl ? n + (n - 1) / 8 : n);
        }
        int n2 = 0;
        while (n2 < this.modeBits.length) {
            if (this.modeBits[n2] != 1) {
                return new Dimension(bl ? 287 : 256, bl ? n + (n - 1) / 8 : n);
            }
            ++n2;
        }
        return new Dimension(bl ? 279 : 240, bl ? n + (n - 1) / 8 : n);
    }

    protected int getTilemapLines() {
        int n = 192;
        int n2 = 0;
        while (n2 < this.modeBits.length) {
            int n3 = this.modeBits[n2];
            if (n3 == 11 || n3 == 14) {
                return 256;
            }
            if (n3 >= 8) {
                n = Math.max(n, 224);
            }
            ++n2;
        }
        return n;
    }

    @Override
    public String[] getBaseAddressNames() {
        return BASE_ADDRESS_NAMES;
    }

    @Override
    public String[] getTileBaseAddressNames() {
        return TILE_BASE_ADDRESS_NAMES;
    }

    @Override
    public void renderTilemap(ViewerWindow viewerWindow, int n, int n2, boolean bl, boolean bl2, ViewerCache viewerCache) {
        if (this.vdp == null) {
            return;
        }
        --n;
        int n3 = this.getTilemapLines();
        int n4 = 0;
        while (n4 < n3) {
            this.renderTilemapLine(viewerWindow, n4, this.modeBits[n4], n, bl, bl2);
            ++n4;
        }
        if (this.vdp instanceof SMS2VDP && (this.modeBits[0] & 8) != 0) {
            SMS2VDP sMS2VDP = (SMS2VDP)this.vdp;
            boolean bl3 = sMS2VDP instanceof GGVDP && !((GGVDP)sMS2VDP).isSmsMode();
            int n5 = bl3 ? 144 : sMS2VDP.getScreenHeight();
            int n6 = 0;
            while (n6 < n5) {
                int n7;
                int n8;
                int n9;
                int n10;
                if (bl3) {
                    n10 = (n6 + this.getVerticalScroll() + (sMS2VDP.getScreenHeight() - n5) / 2) % (sMS2VDP.getScreenHeight() > 192 ? 256 : 224);
                    n9 = 160;
                    n8 = 48 - this.hScrollValues[n6 + (sMS2VDP.getScreenHeight() - n5) / 2] & 0xFF;
                } else {
                    n7 = sMS2VDP instanceof GGVDP && ((GGVDP)sMS2VDP).isSmsMode() ? 1 : 0;
                    n10 = (n6 + this.getVerticalScroll()) % (sMS2VDP.getScreenHeight() > 192 ? 256 : 224);
                    n9 = n7 != 0 ? 240 : (sMS2VDP.isLeftColumnBlank() ? 248 : 256);
                    n8 = (sMS2VDP.isLeftColumnBlank() || n7 != 0 ? 8 : 0) - this.hScrollValues[n6] & 0xFF;
                }
                n7 = n8 + n9 & 0xFF;
                if (n8 > 0) {
                    viewerWindow.xorColor(SMSDisplayWindow.toTilemapCoord(n8 - 1, bl), SMSDisplayWindow.toTilemapCoord(n10, bl), DisplayWindow.COLOR_WHITE);
                }
                if (n7 > 0) {
                    viewerWindow.xorColor(SMSDisplayWindow.toTilemapCoord(n7, bl), SMSDisplayWindow.toTilemapCoord(n10, bl), DisplayWindow.COLOR_WHITE);
                }
                if (n6 == 0 && n10 > 0) {
                    if (n7 < n8) {
                        viewerWindow.xorColor(SMSDisplayWindow.toTilemapCoord(n8 - 1, bl), SMSDisplayWindow.toTilemapCoord(n10 - 1, bl), SMSDisplayWindow.toTilemapCoord(256 - (n8 - 1), bl), DisplayWindow.COLOR_WHITE);
                        if (n7 > 0) {
                            viewerWindow.xorColor(SMSDisplayWindow.toTilemapCoord(0, bl), SMSDisplayWindow.toTilemapCoord(n10 - 1, bl), SMSDisplayWindow.toTilemapCoord(n7 + 1, bl), DisplayWindow.COLOR_WHITE);
                        }
                    } else {
                        viewerWindow.xorColor(SMSDisplayWindow.toTilemapCoord(Math.max(0, n8 - 1), bl), SMSDisplayWindow.toTilemapCoord(n10 - 1, bl), SMSDisplayWindow.toTilemapCoord(Math.min(256 - n8, n8 > 0 ? n9 + 2 : n9 + 1), bl), DisplayWindow.COLOR_WHITE);
                    }
                } else if (n6 == n5 - 1 && n10 < (sMS2VDP.getScreenHeight() > 192 ? 256 : 224) - 1) {
                    if (n7 < n8) {
                        viewerWindow.xorColor(SMSDisplayWindow.toTilemapCoord(n8 - 1, bl), SMSDisplayWindow.toTilemapCoord(n10 + 1, bl), SMSDisplayWindow.toTilemapCoord(255 - (n8 - 1), bl), DisplayWindow.COLOR_WHITE);
                        if (n7 > 0) {
                            viewerWindow.xorColor(SMSDisplayWindow.toTilemapCoord(0, bl), SMSDisplayWindow.toTilemapCoord(n10 + 1, bl), SMSDisplayWindow.toTilemapCoord(n7 + 1, bl), DisplayWindow.COLOR_WHITE);
                        }
                    } else {
                        viewerWindow.xorColor(SMSDisplayWindow.toTilemapCoord(Math.max(0, n8 - 1), bl), SMSDisplayWindow.toTilemapCoord(n10 + 1, bl), SMSDisplayWindow.toTilemapCoord(Math.min(256 - n8, n8 > 0 ? n9 + 2 : n9 + 1), bl), DisplayWindow.COLOR_WHITE);
                    }
                }
                ++n6;
            }
        }
    }

    protected void renderTilemapLine(ViewerWindow viewerWindow, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = n3 < 0 ? this.vdp.getScreenMapBaseAddress(0) : this.getBaseAddressNames().length - 2 - n3 << 11;
        int n5 = bl ? 9 : 8;
        int n6 = bl ? 9 : 8;
        switch (n2) {
            case 0: {
                int n7 = n / 8;
                int n8 = n4 + n7 * 32;
                int n9 = this.vdp.getColorTableAddress();
                int n10 = this.vdp.getPatternGeneratorTableAddress() + (n & 7);
                int n11 = 0;
                while (n11 < 32) {
                    int n12 = this.vram[n8 | n11];
                    int n13 = this.vram[n9 + (n12 >> 3)];
                    int n14 = this.vram[n10 + (n12 << 3)];
                    viewerWindow.setCursor(n11 * n5, n7 * n6 + (n & 7));
                    int n15 = 0;
                    while (n15 < 8) {
                        int n16 = (n14 >> (n15 ^ 7) & 1) != 0 ? n13 >> 4 : n13 & 0xF;
                        int n17 = n16 > 0 ? this.getTmsColor(n16) : this.getTmsColor(this.vdp.getBackDropColor());
                        viewerWindow.setNextColor(n17);
                        ++n15;
                    }
                    ++n11;
                }
                break;
            }
            case 1: {
                int n18 = n2 == this.modeBits[n] ? 40 : 80;
                int n19 = n / 8;
                int n20 = n4 + n19 * n18;
                int n21 = this.vdp.getPatternGeneratorTableAddress() + (n & 7);
                int n22 = this.vdp.getColorTableAddress();
                int n23 = 0;
                while (n23 < n18) {
                    int n24 = this.vram[n20 + n23] << 3;
                    int n25 = this.vram[n21 + n24];
                    viewerWindow.setCursor(n23 * (bl ? 7 : 6), n19 * n6 + (n & 7));
                    int n26 = 0;
                    while (n26 < 6) {
                        int n27 = (n25 >> (n26 ^ 7) & 1) != 0 ? this.vdp.getTextColor(n23, n22) : this.vdp.getBackDropColor(n23 * 6 + n26, n22);
                        int n28 = n27 > 0 ? this.getTmsColor(n27) : this.getTmsColor(this.vdp.getBackDropColor());
                        viewerWindow.setNextColor(n28);
                        ++n26;
                    }
                    ++n23;
                }
                break;
            }
            case 2: {
                int n29 = n / 8;
                int n30 = n4 + n29 * 32;
                int n31 = n29 / 8 * 256;
                int n32 = this.vdp.getColorTableAddress() + n31 * 8 + (n & 7);
                int n33 = this.vdp.getPatternGeneratorTableAddress() + n31 * 8 + (n & 7);
                int n34 = 0;
                while (n34 < 32) {
                    int n35 = this.vram[n30 | n34] << 3;
                    int n36 = this.vram[n32 + n35 & this.vdp.getColorTableMask()];
                    int n37 = this.vram[n33 + n35 & this.vdp.getPatternGeneratorTableMask()];
                    viewerWindow.setCursor(n34 * n5, n29 * n6 + (n & 7));
                    int n38 = 0;
                    while (n38 < 8) {
                        int n39 = (n37 >> (n38 ^ 7) & 1) != 0 ? n36 >> 4 : n36 & 0xF;
                        int n40 = n39 > 0 ? this.getTmsColor(n39) : this.getTmsColor(this.vdp.getBackDropColor());
                        viewerWindow.setNextColor(n40);
                        ++n38;
                    }
                    ++n34;
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                int n41 = n / 8;
                int n42 = n4 + n41 * 32;
                int n43 = this.vdp.getPatternGeneratorTableAddress() + (n41 & 3) * 2 + (n / 4 & 1);
                int n44 = 0;
                while (n44 < 32) {
                    int n45 = this.vram[n42 | n44] << 3;
                    int n46 = this.vram[n43 + n45];
                    int n47 = n46 >> 4;
                    int n48 = n47 > 0 ? this.getTmsColor(n47) : this.getTmsColor(this.vdp.getBackDropColor());
                    viewerWindow.setColor(n44 * n5, n + (bl ? n / 8 : 0), 4, n48);
                    n47 = n46 & 0xF;
                    n48 = n47 > 0 ? this.getTmsColor(n47) : this.getTmsColor(this.vdp.getBackDropColor());
                    viewerWindow.setColor(n44 * n5 + 4, n + (bl ? n / 8 : 0), 4, n48);
                    ++n44;
                }
                break;
            }
            case 6: {
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 9: 
            case 13: {
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                if (!(this.vdp instanceof SMS2VDP)) break;
                SMS2VDP sMS2VDP = (SMS2VDP)this.vdp;
                int n49 = n / 8;
                int n50 = 0;
                while (n50 < 32) {
                    int n51 = n - sMS2VDP.getVerticalScroll();
                    while (n51 < 0) {
                        n51 += sMS2VDP.getScreenHeight() > 192 ? 256 : 224;
                    }
                    int n52 = (n3 < 0 ? this.baseAddressValues[n51] : n4) + n49 * 64;
                    int n53 = n52 | (n50 & 0x1F) << 1;
                    if ((n53 | 1) < this.vram.length) {
                        int n54 = this.vram[n53 | 1] << 8 | this.vram[n53];
                        int n55 = (n54 & 0x7FF) << 3 | n & 7;
                        int[] nArray = this.getPatternData(n55);
                        viewerWindow.setCursor(n50 * n5, n49 * n6 + (n & 7));
                        int n56 = 0;
                        while (n56 < nArray.length) {
                            viewerWindow.setNextColor(bl2 ? this.getColor(nArray[n56], (n54 & 0x800) >> 8) : this.getTmsColor(nArray[n56]));
                            ++n56;
                        }
                    }
                    ++n50;
                }
                break;
            }
        }
    }

    protected static int toTilemapCoord(int n, boolean bl) {
        return bl ? Math.min(287, n + n / 8) : n;
    }

    protected int getNumTilesetPages() {
        if (this.renderer instanceof TMSRenderer) {
            return this.isMode2Renderer() ? 4 : (this.spriteBuffer.length > 0 ? 2 : 1);
        }
        return 2;
    }

    @Override
    public Dimension getTilesetDimension(int n, boolean bl, boolean bl2) {
        int n2;
        int n3 = this.getNumTilesetPages();
        int n4 = bl && this.renderer instanceof TMSRenderer ? (bl2 ? this.getTileWidth(bl) + 1 : this.getTileWidth(bl)) : (n2 = bl2 ? this.getTileWidth(bl) + 1 : this.getTileWidth(bl));
        int n5 = bl ? (bl2 ? 17 : 16) : (bl2 ? 9 : 8);
        return new Dimension(n2 * (bl && this.renderer instanceof TMSRenderer ? n / 2 : n) - (bl2 ? 1 : 0), n5 * (bl ? 128 : 256) * n3 / n + n3 - 1 - (bl2 ? 1 : 0));
    }

    @Override
    public int getTileWidth(boolean bl) {
        if (bl && this.renderer instanceof TMSRenderer) {
            return this.getTileWidth(false) * 2;
        }
        return this.renderer instanceof Mode1Renderer ? 6 : 8;
    }

    @Override
    public boolean isLayoutSupported(int n) {
        int n2 = this.renderer instanceof TMSRenderer ? 1 : 2;
        return 2048 * n2 % n == 0;
    }

    @Override
    public boolean is8x16supported() {
        return true;
    }

    @Override
    public int getTileAt(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        int n5 = n4 = bl2 ? this.getTileWidth(bl) + 1 : this.getTileWidth(bl);
        int n6 = bl ? (bl2 ? 17 : 16) : (bl2 ? 9 : 8);
        int n7 = n2 / n6 * (bl && this.renderer instanceof TMSRenderer ? n3 / 2 : n3) + n / n4 % n3;
        return bl ? n7 * (this.renderer instanceof TMSRenderer ? 4 : 2) : n7;
    }

    @Override
    public boolean isTileValid(int n) {
        if (this.isMode2Renderer()) {
            return n >= 0 && n < 1024;
        }
        return n >= 0 && n < 512;
    }

    @Override
    public int getTileX(int n, int n2, boolean bl, boolean bl2) {
        return (bl ? n >> (this.renderer instanceof TMSRenderer ? 2 : 1) : n) % (bl && this.renderer instanceof TMSRenderer ? n2 / 2 : n2) * (bl2 ? this.getTileWidth(bl) + 1 : this.getTileWidth(bl));
    }

    @Override
    public int getTileY(int n, int n2, boolean bl, boolean bl2) {
        if (bl) {
            return (n >> 1) / n2 * (bl2 ? 17 : 16) + n / 256;
        }
        return n / n2 * (bl2 ? 9 : 8) + n / 256;
    }

    @Override
    public int getTileVRAMaddress(int n) {
        if (this.vdp == null) {
            return 0;
        }
        if (this.renderer instanceof TMSRenderer) {
            return n / 256 == this.getTilesetSpritesPage() ? this.vdp.getSpritePatternAddress() + 8 * (n % 256) : this.vdp.getPatternGeneratorTableAddress() + 8 * n;
        }
        return this.vdp.getPatternGeneratorTableAddress() + 32 * n;
    }

    @Override
    public int getTilePixelColor(int n, int n2, int n3, ViewerCache viewerCache) {
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (this.renderer instanceof TMSRenderer) {
            return -1;
        }
        int[] nArray = (n3 -= 2) < 0 ? this.guessPalettes(viewerCache) : null;
        int n4 = nArray != null ? nArray[n] : n3;
        int n5 = n2 / this.getTileWidth(false);
        int n6 = n2 % this.getTileWidth(false);
        int n7 = (n4 & 1) << 11 | n;
        int n8 = (n7 & 0x7FF) << 3 | n5;
        int[] nArray2 = this.getPatternData(n8);
        int n9 = nArray2[n6];
        return 16 * n4 + n9;
    }

    @Override
    public int getTilePixelOffset(int n) {
        if (this.renderer instanceof Mode4Renderer) {
            return n / 8 * 4;
        }
        return 0;
    }

    @Override
    public String getTileCPUaddress(int n) {
        return null;
    }

    protected boolean isMode2Renderer() {
        return this.renderer instanceof Mode2Renderer;
    }

    protected int getTilesetSpritesPage() {
        return this.isMode2Renderer() ? 3 : (this.spriteBuffer.length > 0 && this.getNumTilesetPages() > 1 ? 1 : 0);
    }

    @Override
    public void renderTileset(ViewerWindow viewerWindow, int n, int n2, boolean bl, boolean bl2, ViewerCache viewerCache) {
        block29: {
            int n3;
            int n4;
            block28: {
                int n5;
                int n6 = n4 = bl2 ? 9 : 8;
                if (!(this.renderer instanceof TMSRenderer)) break block28;
                int n7 = n5 = this.renderer instanceof Mode1Renderer ? 6 : 8;
                int n8 = n == 3 ? Color.PINK.getRGB() : (n == 2 ? this.getTmsColor(1) : (n == 1 ? this.getTmsColor(this.vdp.getBackDropColor()) : viewerWindow.getBackgroundRGB()));
                int n9 = this.getTilesetSpritesPage();
                int n10 = 0;
                while (n10 < 256) {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    int n21;
                    if (bl) {
                        switch (n10 % 4) {
                            case 0: {
                                n21 = n10 / 4 * 2 % n2 / 2 * (bl2 ? n5 * 2 + 1 : n5 * 2);
                                n20 = n10 / 4 * 2 / n2 * 2 / 2 * (bl2 ? 17 : 16);
                                break;
                            }
                            case 1: {
                                n21 = n10 / 4 * 2 % n2 / 2 * (bl2 ? n5 * 2 + 1 : n5 * 2);
                                n20 = n10 / 4 * 2 / n2 * 2 / 2 * (bl2 ? 17 : 16) + 8;
                                break;
                            }
                            case 2: {
                                n21 = n10 / 4 * 2 % n2 / 2 * (bl2 ? n5 * 2 + 1 : n5 * 2) + n5;
                                n20 = n10 / 4 * 2 / n2 * 2 / 2 * (bl2 ? 17 : 16);
                                break;
                            }
                            default: {
                                n21 = n10 / 4 * 2 % n2 / 2 * (bl2 ? n5 * 2 + 1 : n5 * 2) + n5;
                                n20 = n10 / 4 * 2 / n2 * 2 / 2 * (bl2 ? 17 : 16) + 8;
                                break;
                            }
                        }
                    } else {
                        n21 = n10 % n2 * (bl2 ? n5 + 1 : n5);
                        n20 = n10 / n2 * n4;
                    }
                    if (this.renderer instanceof Mode0Renderer) {
                        n19 = this.vdp.getColorTableAddress();
                        n18 = 0;
                        while (n18 < 8) {
                            n17 = this.vdp.getPatternGeneratorTableAddress() + n18;
                            n16 = n10;
                            n15 = this.vram[n19 + (n16 >> 3)];
                            n14 = this.vram[n17 + (n16 << 3)];
                            viewerWindow.setCursor(n21, n20 + n18);
                            n13 = 0;
                            while (n13 < n5) {
                                n12 = (n14 >> (n13 ^ 7) & 1) != 0 ? n15 >> 4 : n15 & 0xF;
                                n11 = n12 > 0 ? this.getTmsColor(n12) : this.getTmsColor(this.vdp.getBackDropColor());
                                viewerWindow.setNextColor(n11);
                                ++n13;
                            }
                            ++n18;
                        }
                    } else if (this.renderer instanceof Mode1Renderer) {
                        n19 = this.vdp.getPatternGeneratorTableAddress();
                        n18 = this.vdp.getColorTableAddress();
                        n17 = n10 << 3;
                        n16 = 0;
                        while (n16 < 8) {
                            n15 = this.vram[n19 + n16 + n17];
                            viewerWindow.setCursor(n21, n20 + n16);
                            n14 = 0;
                            while (n14 < n5) {
                                n13 = (n15 >> (n14 ^ 7) & 1) != 0 ? this.vdp.getTextColor(n16, n18) : this.vdp.getBackDropColor();
                                n12 = n13 > 0 ? this.getTmsColor(n13) : this.getTmsColor(this.vdp.getBackDropColor());
                                viewerWindow.setNextColor(n12);
                                ++n14;
                            }
                            ++n16;
                        }
                    } else if (this.isMode2Renderer()) {
                        n19 = 0;
                        while (n19 < 3) {
                            n18 = n19 * 256;
                            n17 = 0;
                            while (n17 < n5) {
                                n16 = this.vdp.getColorTableAddress() + n18 * 8 + n17;
                                n15 = this.vdp.getPatternGeneratorTableAddress() + n18 * 8 + n17;
                                n14 = n10 << 3;
                                n13 = this.vram[n16 + n14 & this.vdp.getColorTableMask()];
                                n12 = this.vram[n15 + n14 & this.vdp.getPatternGeneratorTableMask()];
                                viewerWindow.setCursor(n21, n19 * (bl ? 256 / n2 * (n4 + 8) / 2 : 256 / n2 * n4) + n20 + n17 + n19);
                                n11 = 0;
                                while (n11 < 8) {
                                    int n22 = (n12 >> (n11 ^ 7) & 1) != 0 ? n13 >> 4 : n13 & 0xF;
                                    int n23 = n22 > 0 ? this.getTmsColor(n22) : this.getTmsColor(this.vdp.getBackDropColor());
                                    viewerWindow.setNextColor(n23);
                                    ++n11;
                                }
                                ++n17;
                            }
                            ++n19;
                        }
                    } else {
                        boolean cfr_ignored_0 = this.renderer instanceof Mode3Renderer;
                    }
                    if (this.spriteBuffer.length > 0) {
                        n19 = 0;
                        n18 = 0;
                        while (n18 < 32) {
                            n17 = this.largeSprites[n18] ? 252 : 255;
                            n16 = this.vram[this.vdp.getSpriteAttributeTableAddress(n18) | n18 << 2 | 2] & n17;
                            if (n16 == (n10 & n17)) {
                                n19 = n18;
                                break;
                            }
                            ++n18;
                        }
                        this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | n10 << 3, n19, n21, n9 * (bl ? 256 / n2 * (n4 + 8) / 2 : 256 / n2 * n4) + n20 + n9, n8, n == 4);
                    }
                    ++n10;
                }
                break block29;
            }
            if (!(this.renderer instanceof Mode4Renderer)) break block29;
            int n24 = n3 = bl2 ? 9 : 8;
            if ((n -= 2) == -2) {
                int[] nArray = this.guessPalettes(viewerCache);
                int n25 = 0;
                while (n25 < 512) {
                    this.renderCharacter(viewerWindow, (nArray[n25] & 1) << 11 | n25, (bl ? n25 >> 1 : n25) % n2 * n3, (bl ? (n25 >> 1) / n2 * (bl2 ? 17 : 16) + (n25 & 1) * 8 : n25 / n2 * n4) + n25 / 256, false);
                    ++n25;
                }
            } else {
                int n26 = 0;
                while (n26 < 512) {
                    this.renderCharacter(viewerWindow, (n & 1) << 11 | n26, (bl ? n26 >> 1 : n26) % n2 * n3, (bl ? (n26 >> 1) / n2 * (bl2 ? 17 : 16) + (n26 & 1) * 8 : n26 / n2 * n4) + n26 / 256, n < 0);
                    ++n26;
                }
            }
        }
    }

    @Override
    public void renderTile(ViewerWindow viewerWindow, int n, int n2, boolean bl, boolean bl2, ViewerCache viewerCache) {
        if (this.renderer instanceof Mode0Renderer) {
            int n3 = this.vdp.getColorTableAddress();
            int n4 = 0;
            while (n4 < 8) {
                int n5 = this.vdp.getPatternGeneratorTableAddress() + n4;
                int n6 = n;
                int n7 = this.vram[n3 + (n6 >> 3)];
                int n8 = this.vram[n5 + (n6 << 3)];
                viewerWindow.setCursor(0, n4);
                int n9 = 0;
                while (n9 < 8) {
                    int n10 = (n8 >> (n9 ^ 7) & 1) != 0 ? n7 >> 4 : n7 & 0xF;
                    int n11 = n10 > 0 ? this.getTmsColor(n10) : this.getTmsColor(this.vdp.getBackDropColor());
                    viewerWindow.setNextColor(n11);
                    ++n9;
                }
                ++n4;
            }
        } else if (this.renderer instanceof Mode1Renderer) {
            int n12 = this.vdp.getPatternGeneratorTableAddress();
            int n13 = this.vdp.getColorTableAddress();
            int n14 = n << 3;
            int n15 = 0;
            while (n15 < 8) {
                int n16 = this.vram[n12 + n15 + n14];
                viewerWindow.setCursor(0, n15);
                int n17 = 0;
                while (n17 < 6) {
                    int n18 = (n16 >> (n17 ^ 7) & 1) != 0 ? this.vdp.getTextColor(n15, n13) : this.vdp.getBackDropColor();
                    int n19 = n18 > 0 ? this.getTmsColor(n18) : this.getTmsColor(this.vdp.getBackDropColor());
                    viewerWindow.setNextColor(n19);
                    ++n17;
                }
                ++n15;
            }
        } else if (this.isMode2Renderer()) {
            if (n < 768) {
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25;
                int n26;
                int n27;
                int n28 = n & 0xFFFFFF00;
                n &= bl ? 252 : 255;
                int n29 = 0;
                while (n29 < 8) {
                    n27 = this.vdp.getColorTableAddress() + n28 * 8 + n29;
                    n26 = this.vdp.getPatternGeneratorTableAddress() + n28 * 8 + n29;
                    n25 = n << 3;
                    n24 = this.vram[n27 + n25 & this.vdp.getColorTableMask()];
                    n23 = this.vram[n26 + n25 & this.vdp.getPatternGeneratorTableMask()];
                    viewerWindow.setCursor(0, n29);
                    n22 = 0;
                    while (n22 < 8) {
                        n21 = (n23 >> (n22 ^ 7) & 1) != 0 ? n24 >> 4 : n24 & 0xF;
                        n20 = n21 > 0 ? this.getTmsColor(n21) : this.getTmsColor(this.vdp.getBackDropColor());
                        viewerWindow.setNextColor(n20);
                        ++n22;
                    }
                    ++n29;
                }
                if (bl) {
                    n29 = 1;
                    while (n29 < 4) {
                        n27 = 0;
                        while (n27 < 8) {
                            n26 = this.vdp.getColorTableAddress() + n28 * 8 + n27;
                            n25 = this.vdp.getPatternGeneratorTableAddress() + n28 * 8 + n27;
                            n24 = (n | n29) << 3;
                            n23 = this.vram[n26 + n24 & this.vdp.getColorTableMask()];
                            n22 = this.vram[n25 + n24 & this.vdp.getPatternGeneratorTableMask()];
                            viewerWindow.setCursor(8 * (n29 / 2), 8 * (n29 % 2) + n27);
                            n21 = 0;
                            while (n21 < 8) {
                                n20 = (n22 >> (n21 ^ 7) & 1) != 0 ? n23 >> 4 : n23 & 0xF;
                                int n30 = n20 > 0 ? this.getTmsColor(n20) : this.getTmsColor(this.vdp.getBackDropColor());
                                viewerWindow.setNextColor(n30);
                                ++n21;
                            }
                            ++n27;
                        }
                        ++n29;
                    }
                }
            } else {
                int n31 = 0;
                int n32 = 0;
                while (n32 < 32) {
                    int n33 = this.largeSprites[n32] ? 252 : 255;
                    int n34 = this.vram[this.vdp.getSpriteAttributeTableAddress(n32) | n32 << 2 | 2] & n33;
                    if (n34 == (n & n33)) {
                        n31 = n32;
                        break;
                    }
                    ++n32;
                }
                this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | n << 3, n31, 0, 0, viewerWindow.getBackgroundRGB(), n2 == 4);
                if (bl) {
                    this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | (n | 1) << 3, n31, 0, 8, viewerWindow.getBackgroundRGB(), n2 == 4);
                    this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | (n | 2) << 3, n31, 8, 0, viewerWindow.getBackgroundRGB(), n2 == 4);
                    this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | (n | 3) << 3, n31, 8, 8, viewerWindow.getBackgroundRGB(), n2 == 4);
                }
            }
        } else if (!(this.renderer instanceof Mode3Renderer)) {
            if (this.renderer instanceof Mode4Renderer) {
                if ((n2 -= 2) == -2) {
                    int[] nArray = this.guessPalettes(viewerCache);
                    this.renderCharacter(viewerWindow, (nArray[n] & 1) << 11 | (bl ? n & 0xFFFFFFFE : n), 0, 0, false);
                    if (bl) {
                        this.renderCharacter(viewerWindow, (nArray[n] & 1) << 11 | n | 1, 0, 8, false);
                    }
                } else {
                    this.renderCharacter(viewerWindow, (n2 & 1) << 11 | (bl ? n & 0xFFFFFFFE : n), 0, 0, n2 < 0);
                    if (bl) {
                        this.renderCharacter(viewerWindow, (n2 & 1) << 11 | n | 1, 0, 0, n2 < 0);
                    }
                }
            } else if (this.spriteBuffer.length > 0 && this.renderer instanceof TMSRenderer) {
                int n35 = 0;
                int n36 = 0;
                while (n36 < 32) {
                    int n37 = this.largeSprites[n36] ? 252 : 255;
                    int n38 = this.vram[this.vdp.getSpriteAttributeTableAddress(n36) | n36 << 2 | 2] & n37;
                    if (n38 == (n & n37)) {
                        n35 = n36;
                        break;
                    }
                    ++n36;
                }
                this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | n << 3, n35, 0, 0, viewerWindow.getBackgroundRGB(), n2 == 4);
                if (bl) {
                    this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | (n | 1) << 3, n35, 0, 8, viewerWindow.getBackgroundRGB(), n2 == 4);
                    this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | (n | 2) << 3, n35, 8, 0, viewerWindow.getBackgroundRGB(), n2 == 4);
                    this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | (n | 3) << 3, n35, 8, 8, viewerWindow.getBackgroundRGB(), n2 == 4);
                }
            }
        }
    }

    private int[] guessPalettes(ViewerCache viewerCache) {
        int[] nArray = viewerCache.getGuessedPalettes(512);
        int n = this.vdp.getSpritePatternAddress() >> 13;
        int n2 = 256;
        while (n2 < 512) {
            nArray[n2] = n;
            ++n2;
        }
        n ^= 1;
        n2 = 0;
        while (n2 < 256) {
            nArray[n2] = n;
            ++n2;
        }
        n2 = 0;
        while (n2 < (this.vdp.getScreenHeight() > 192 ? 32 : 28)) {
            int n3 = 0;
            while (n3 < 32) {
                int n4 = 0;
                while (n4 < 8) {
                    int n5 = n2 * 8 + n4 - this.vdp.getVerticalScroll();
                    while (n5 < 0) {
                        n5 += this.vdp.getScreenHeight() > 192 ? 256 : 224;
                    }
                    int n6 = this.baseAddressValues[n5] + n2 * 64;
                    int n7 = n6 | (n3 & 0x1F) << 1;
                    if ((n7 | 1) < this.vram.length) {
                        int n8 = this.vram[n7 | 1] << 8 | this.vram[n7];
                        nArray[n8 & 0x1FF] = (n8 & 0x800) >> 11;
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return nArray;
    }

    private void renderCharacter(ViewerWindow viewerWindow, int n, int n2, int n3, boolean bl) {
        int n4 = (n & 0x800) >> 8;
        int n5 = (n & 0x7FF) << 3;
        int n6 = 0;
        while (n6 < 8) {
            int[] nArray = this.getPatternData(n5++);
            viewerWindow.setCursor(n2, n3 + n6);
            int n7 = 0;
            while (n7 < nArray.length) {
                viewerWindow.setNextColor(bl ? this.getTmsColor(nArray[n7]) : this.getColor(nArray[n7], n4));
                ++n7;
            }
            ++n6;
        }
    }

    @Override
    public String[] getPaletteNames() {
        return PALETTE_NAMES;
    }

    @Override
    public Dimension getSpritesDimension(boolean bl) {
        if (this.renderer instanceof TMSRenderer) {
            return new Dimension(bl ? 271 : 256, bl ? 33 : 32);
        }
        return new Dimension(bl ? 143 : 128, bl ? 67 : 64);
    }

    @Override
    public int getSpriteWidth(int n) {
        if (this.renderer instanceof TMSRenderer) {
            return this.getSpriteHeight(n);
        }
        return 8;
    }

    @Override
    public int getSpriteHeight(int n) {
        if (n >= 0 && n < this.largeSprites.length) {
            return this.largeSprites[n] ? 16 : 8;
        }
        return 0;
    }

    @Override
    public void renderSprites(ViewerWindow viewerWindow, boolean bl) {
        this.renderSprites(viewerWindow, false, 0, bl);
    }

    @Override
    public void renderSprites(ViewerWindow viewerWindow, int n, boolean bl) {
        this.renderSprites(viewerWindow, true, n, bl);
    }

    private void renderSprites(ViewerWindow viewerWindow, boolean bl, int n, boolean bl2) {
        block15: {
            int n2;
            int n3;
            block16: {
                if (!bl) {
                    n = this.getColor(0, 8);
                }
                n3 = this.renderer instanceof TMSRenderer ? (bl2 ? 17 : 16) : (bl2 ? 9 : 8);
                int n4 = n2 = bl2 ? 17 : 16;
                if (!(this.renderer instanceof TMSRenderer)) break block16;
                if (this.spriteBuffer.length <= 0) break block15;
                int n5 = 0;
                while (n5 < 32) {
                    int n6;
                    int n7 = this.vram[this.vdp.getSpriteAttributeTableAddress(n5) | n5 << 2];
                    int n8 = this.vram[this.vdp.getSpriteAttributeTableAddress(n5) | n5 << 2 | 2];
                    if (n7 == this.vdp.getSpritesDoneY()) {
                        n6 = 0;
                        while (n6 < 16) {
                            viewerWindow.setColor(n5 % 16 * n3, n5 / 16 * (bl2 ? 17 : 16) + n6, 1, n ^ DisplayWindow.COLOR_WHITE);
                            ++n6;
                        }
                        break block15;
                    }
                    if (this.largeSprites[n5]) {
                        n6 = this.vdp.getSpritePatternAddress() | (n8 & 0xFC) << 3;
                        this.renderSpriteCharacter(viewerWindow, n6, n5, n5 % 16 * (bl2 ? 17 : 16), n5 / 16 * n2, n, false);
                        this.renderSpriteCharacter(viewerWindow, n6 | 0x10, n5, n5 % 16 * (bl2 ? 17 : 16) + 8, n5 / 16 * n2, n, false);
                        this.renderSpriteCharacter(viewerWindow, n6 | 8, n5, n5 % 16 * (bl2 ? 17 : 16), n5 / 16 * n2 + 8, n, false);
                        this.renderSpriteCharacter(viewerWindow, n6 | 0x18, n5, n5 % 16 * (bl2 ? 17 : 16) + 8, n5 / 16 * n2 + 8, n, false);
                    } else {
                        n6 = 0;
                        while (n6 < 8) {
                            viewerWindow.setColor(n5 % 16 * n3, n5 / 16 * n2 + 8 + n6, 8, n);
                            ++n6;
                        }
                        this.renderSpriteCharacter(viewerWindow, this.vdp.getSpritePatternAddress() | n8 << 3, n5, n5 % 16 * n3, n5 / 16 * n2, n, false);
                        n6 = 0;
                        while (n6 < 16) {
                            viewerWindow.setColor(n5 % 16 * n3 + 8, n5 / 16 * n2 + n6, 8, n);
                            ++n6;
                        }
                    }
                    ++n5;
                }
                break block15;
            }
            if (this.renderer instanceof Mode4Renderer) {
                int n9 = 0;
                while (n9 < 64) {
                    int n10;
                    int n11 = this.vram[this.vdp.getSpriteAttributeTableAddress(n9) | n9];
                    int n12 = this.vram[this.vdp.getSpriteAttributeTableAddress(n9) | 0x80 | n9 << 1 | 1];
                    if (n11 == this.vdp.getSpritesDoneY()) {
                        n10 = 0;
                        while (n10 < 16) {
                            viewerWindow.setColor(n9 % 16 * n3, n9 / 16 * (bl2 ? 17 : 16) + n10, 1, n ^ DisplayWindow.COLOR_WHITE);
                            ++n10;
                        }
                        break;
                    }
                    if (this.largeSprites[n9]) {
                        this.renderSpriteCharacter(viewerWindow, n12 & 0xFE, n9 % 16 * n3, n9 / 16 * n2, n);
                        this.renderSpriteCharacter(viewerWindow, n12 | 1, n9 % 16 * n3, n9 / 16 * n2 + 8, n);
                    } else {
                        this.renderSpriteCharacter(viewerWindow, n12, n9 % 16 * n3, n9 / 16 * n2, n);
                        n10 = 0;
                        while (n10 < 8) {
                            viewerWindow.setColor(n9 % 16 * n3, n9 / 16 * n2 + 8 + n10, 8, n);
                            ++n10;
                        }
                    }
                    ++n9;
                }
            }
        }
    }

    private void renderSpriteCharacter(ViewerWindow viewerWindow, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < 8) {
            int n6 = this.vdp.getSpritePatternAddress() | n << 5 | n5 << 2;
            int n7 = MIRRORED_BITS[this.vram[n6]];
            int n8 = MIRRORED_BITS[this.vram[n6 | 1]];
            int n9 = MIRRORED_BITS[this.vram[n6 | 2]];
            int n10 = MIRRORED_BITS[this.vram[n6 | 3]];
            int n11 = STRETCHED_BITPLANE[n10] << 3 | STRETCHED_BITPLANE[n9] << 2 | STRETCHED_BITPLANE[n8] << 1 | STRETCHED_BITPLANE[n7];
            viewerWindow.setCursor(n2, n3 + n5);
            int n12 = 0;
            while (n12 < 8) {
                int n13 = n11 & 0xF;
                n11 >>= 4;
                viewerWindow.setNextColor(n13 > 0 ? this.getColor(n13, 8) : n4);
                ++n12;
            }
            ++n5;
        }
    }

    private void renderSpriteCharacter(ViewerWindow viewerWindow, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = 0;
        while (n6 < 8) {
            int n7 = this.vram[n | n6];
            int n8 = this.getTmsSpriteAttributes(n2, n6);
            int n9 = bl ? Color.BLACK.getRGB() : this.getTmsColor(n8 & 0xF);
            viewerWindow.setCursor(n3, n4 + n6);
            int n10 = 0;
            while (n10 < 8) {
                viewerWindow.setNextColor((n7 >> (n10 ^ 7) & 1) != 0 ? n9 : n5);
                ++n10;
            }
            ++n6;
        }
    }

    protected int getTmsSpriteAttributes(int n, int n2) {
        return this.vram[this.vdp.getSpriteAttributeTableAddress(n) | n << 2 | 3];
    }

    @Override
    public Dimension getPaletteDimension(ViewerWindow viewerWindow) {
        return new Dimension(128, this.renderer instanceof TMSRenderer ? 8 : 16);
    }

    @Override
    public boolean hideColorIndex() {
        return false;
    }

    @Override
    public void renderPalettes(ViewerWindow viewerWindow) {
        block5: {
            block4: {
                if (!(this.renderer instanceof TMSRenderer)) break block4;
                int n = 0;
                while (n < 16) {
                    int n2 = 0;
                    while (n2 < 8) {
                        viewerWindow.setColor(n * 8, n2, 8, this.getTmsColor(n));
                        ++n2;
                    }
                    ++n;
                }
                break block5;
            }
            if (!(this.renderer instanceof Mode4Renderer)) break block5;
            int n = 0;
            while (n < 32) {
                int n3 = 0;
                while (n3 < 8) {
                    int n4 = n % 16 * 8;
                    int n5 = n / 16 * 8 + n3;
                    viewerWindow.setColor(n4, n5, 8, this.colors[n]);
                    ++n3;
                }
                ++n;
            }
        }
    }

    @Override
    public int getBlue(int n) {
        return this.vdp != null ? this.vdp.getColorBlue(n) : 0;
    }

    @Override
    public int getGreen(int n) {
        return this.vdp != null ? this.vdp.getColorGreen(n) : 0;
    }

    @Override
    public int getRed(int n) {
        return this.vdp != null ? this.vdp.getColorRed(n) : 0;
    }

    @Override
    public boolean isColorValid(int n) {
        if (this.renderer instanceof TMSRenderer) {
            return n >= 0 && n < 16;
        }
        return n >= 0 && n < this.colors.length;
    }

    @Override
    public int getColorAt(int n, int n2, ViewerWindow viewerWindow) {
        return n2 / 8 * 16 + n / 8;
    }

    @Override
    public int getColorX(int n, ViewerWindow viewerWindow) {
        return n % 16 * 8;
    }

    @Override
    public int getColorY(int n, ViewerWindow viewerWindow) {
        return n / 16 * 8;
    }

    @Override
    public int getColorEntrySize() {
        return 8;
    }

    @Override
    public int getBytesPerColor() {
        return this.vdp instanceof GGVDP ? 2 : 1;
    }

    @Override
    public int getColor(int n) {
        if (this.renderer instanceof TMSRenderer) {
            if (this.vdp instanceof GGVDP) {
                return this.vdp.getColor(0x10 | n);
            }
            if (n < TMS_CROM.length) {
                return TMS_CROM[n];
            }
            return 0;
        }
        return this.vdp != null ? this.vdp.getColor(n) : 0;
    }

    @Override
    public boolean isDisplayOn(int n) {
        if (this.vdp == null) {
            return false;
        }
        int n2 = n / 32 * 8 - this.vdp.getVerticalScroll();
        while (n2 < 0) {
            n2 += this.vdp.getScreenHeight() > 192 ? 256 : 224;
        }
        return this.displayOnValues[n2];
    }

    @Override
    public String getModeName(int n) {
        if (this.vdp == null) {
            return "";
        }
        int n2 = n / 32 * 8 - this.vdp.getVerticalScroll();
        while (n2 < 0) {
            n2 += this.vdp.getScreenHeight() > 192 ? 256 : 224;
        }
        n2 = Math.min(this.modeBits.length - 1, n2);
        return this.vdp.getModeName(this.modeBits[n2]);
    }

    @Override
    public boolean isModeNameDependsOnIndex() {
        return true;
    }

    @Override
    public int getHorizontalScroll(int n) {
        if (this.vdp == null) {
            return 0;
        }
        int n2 = n / 32 * 8 - this.vdp.getVerticalScroll();
        while (n2 < 0) {
            n2 += this.vdp.getScreenHeight() > 192 ? 256 : 224;
        }
        return this.hScrollValues[n2];
    }

    @Override
    public int getVerticalScroll() {
        if (this.vdp == null) {
            return 0;
        }
        return this.vdp.getVerticalScroll();
    }

    @Override
    public int getTilemapTileWidth(boolean bl) {
        if (this.renderer instanceof Mode1Renderer) {
            return bl ? 7 : 6;
        }
        return bl ? 9 : 8;
    }

    @Override
    public int getTilemapTileHeight(boolean bl) {
        return bl ? 9 : 8;
    }

    @Override
    public int getTilemapEntryTile(int n, int[] nArray, ViewerCache viewerCache) {
        return nArray != null && n < nArray.length ? nArray[n] & 0x1FF : 0;
    }

    @Override
    public int getTimestamp() {
        return this.getFrame() << 24 | this.vdp.getLine() << 8 | this.vdp.getTimer();
    }

    @Override
    public int getFrame() {
        return this.displayWindow.getFrameNumber();
    }

    @Override
    public void getPixels(int[] nArray) {
        int n = 0;
        int n2 = this.getColor(this.vdp.getBackDropColor(), 8);
        int n3 = this.vdp.getScreenHeight();
        int n4 = 13 - this.vdp.getDisplayAdjustHorizontal();
        int n5 = 15 + this.vdp.getDisplayAdjustHorizontal();
        int n6 = this.vdp.getLinesTopBorder() + this.vdp.getDisplayAdjustVertical();
        int n7 = this.vdp.getScanlines() - n6;
        int n8 = n3 + this.vdp.getLinesBottomBorder() - this.vdp.getDisplayAdjustVertical();
        int n9 = 0;
        while (n9 < this.getNumScanlines()) {
            if (n9 < n7 && n9 >= n8) {
                Arrays.fill(nArray, n, n + this.getDotsPerLine(), 0xBFFFFF);
                n += this.getDotsPerLine();
            } else {
                int n10 = 0;
                while (n10 < this.getDotsPerLine()) {
                    int n11 = (n10 + 342 - 18) % 342;
                    nArray[n++] = n11 >= 256 + n4 + n5 ? 14939101 : (n9 >= n7 ? (this.smsHideBorders || this.vdp instanceof GGVDP ? n2 : this.displayWindow.getColorDirect(n11, n9 - n7)) : (this.smsHideBorders || this.vdp instanceof GGVDP ? (n9 >= n3 || n11 < n4 || n11 - n4 >= 256 ? n2 : this.displayWindow.getColorDirect(n11 - n4, n9)) : this.displayWindow.getColorDirect(n11, n6 + n9)));
                    ++n10;
                }
            }
            ++n9;
        }
    }

    @Override
    public String getMode(int n, int n2) {
        int n3 = 13 - this.vdp.getDisplayAdjustHorizontal();
        int n4 = 15 + this.vdp.getDisplayAdjustHorizontal();
        n2 = (n2 + 342 - 18) % 342;
        if ((n = (n + this.vdp.getDisplayAdjustVertical() + this.getNumScanlines()) % this.getNumScanlines()) >= this.vdp.getScanlines() - this.vdp.getLinesTopBorder()) {
            if (n2 >= 256 + n3 + n4) {
                return "<font bgcolor=#e3f3dd>HBlank</font>";
            }
            return "Border";
        }
        if (n >= this.vdp.getScreenHeight() + this.vdp.getLinesBottomBorder()) {
            return "<font bgcolor=#bfffff>VBlank</font>";
        }
        if (n2 >= 256 + n3 + n4) {
            return "<font bgcolor=#e3f3dd>HBlank</font>";
        }
        if (n >= this.vdp.getScreenHeight() || n2 < n3 || n2 - n3 >= 256) {
            return "Border";
        }
        return this.vdp.getModeName(this.modeBits[n]);
    }

    @Override
    public String getPixelDescription(int n, int n2) {
        int n3 = 13 - this.vdp.getDisplayAdjustHorizontal();
        n2 = (n2 + 342 - 18) % 342;
        n = (n + this.vdp.getDisplayAdjustVertical() + this.getNumScanlines()) % this.getNumScanlines();
        if ((n2 -= n3) < 0 || n2 >= 256 || n >= this.vdp.getScreenHeight()) {
            return null;
        }
        int n4 = this.lineBuffers[n][n2];
        if ((n4 & 0xC0) == 192) {
            return String.valueOf(n4 >> 8) + " (Sprite " + (n4 & 0x3F) + ")";
        }
        if (!(this.renderer instanceof Mode4Renderer)) {
            return "Unsupported";
        }
        return String.valueOf(n4 >> 8) + " (Background)";
    }

    @Override
    public int getDotsPerLine() {
        return 342;
    }

    @Override
    public int getNumScanlines() {
        return this.vdp.getScanlines();
    }

    int getColor(int n, int n2) {
        return this.colors[n2 << 1 | n];
    }

    public void setInputDevice(int n, InputDevice inputDevice) {
        SMSLightPhaser sMSLightPhaser = this.lightPhasers[n & 1] = inputDevice instanceof SMSLightPhaser ? (SMSLightPhaser)inputDevice : null;
        if (this.lightPhasers[n & 1] != null) {
            this.lightPhasers[n & 1].setVDP((SMS2VDP)this.vdp);
        }
        this.displayWindow.setLightPhaser(0, this.lightPhasers[0], 3);
        this.displayWindow.setLightPhaser(1, this.lightPhasers[1], 3);
        this.hasLightPhaser = this.lightPhasers[0] != null || this.lightPhasers[1] != null;
    }

    public void setVDP(TMS9918A tMS9918A) {
        this.vdp = tMS9918A;
        this.vram = tMS9918A.getVRAM();
        if (!this.smsHideBorders && !(tMS9918A instanceof GGVDP)) {
            this.displayWindow.init(284, tMS9918A.getScreenHeight() + tMS9918A.getLinesTopBorder() + tMS9918A.getLinesBottomBorder());
        } else {
            this.displayWindow.init(256, tMS9918A.getScreenHeight());
        }
        this.renderer = new Mode0Renderer();
    }

    public TMS9918A getVDP() {
        return this.vdp;
    }

    class Mode0Renderer
    extends TMSRenderer {
        Mode0Renderer() {
        }

        @Override
        public void renderLine() {
            if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                if (SMSDisplayWindow.this.vdp.isDisplayOn()) {
                    int n = SMSDisplayWindow.this.vdp.getLine() / 8;
                    int n2 = SMSDisplayWindow.this.vdp.getColorTableAddress();
                    int n3 = SMSDisplayWindow.this.vdp.getPatternGeneratorTableAddress() + (SMSDisplayWindow.this.vdp.getLine() & 7);
                    int n4 = 0;
                    while (n4 < 32) {
                        int n5 = SMSDisplayWindow.this.vdp.getScreenMapBaseAddress(n4) + n * 32;
                        int n6 = SMSDisplayWindow.this.vram[n5 | n4];
                        int n7 = SMSDisplayWindow.this.vram[n2 + (n6 >> 3)];
                        int n8 = SMSDisplayWindow.this.vram[n3 + (n6 << 3)];
                        int n9 = 0;
                        while (n9 < 8) {
                            int n10;
                            int n11 = n10 = (n8 >> (n9 ^ 7) & 1) != 0 ? n7 >> 4 : n7 & 0xF;
                            if (n10 > 0) {
                                SMSDisplayWindow.this.displayWindow.setColor(n4 * 8 + n9, SMSDisplayWindow.this.vdp.getLine(), this.getColor(n10));
                            } else {
                                SMSDisplayWindow.this.displayWindow.setColor(n4 * 8 + n9, SMSDisplayWindow.this.vdp.getLine(), this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor()));
                            }
                            ++n9;
                        }
                        ++n4;
                    }
                    this.renderVerticalBorders();
                    this.renderSprites();
                } else {
                    this.renderDisabledLine();
                }
            } else if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT + SMSDisplayWindow.this.vdp.getLinesBottomBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLinesTopBorder() + SMSDisplayWindow.this.vdp.getLine());
                } else if (SMSDisplayWindow.this.vdp.getLine() >= SMSDisplayWindow.this.vdp.getScanlines() - SMSDisplayWindow.this.vdp.getLinesTopBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLine() - SMSDisplayWindow.this.vdp.getScanlines() + SMSDisplayWindow.this.vdp.getLinesTopBorder());
                }
            }
        }
    }

    class Mode1Renderer
    extends TMSRenderer {
        private final int columns;

        public Mode1Renderer() {
            this(40);
        }

        protected Mode1Renderer(int n) {
            this.columns = n;
        }

        @Override
        public void renderLine() {
            if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                if (SMSDisplayWindow.this.vdp.isDisplayOn()) {
                    int n = SMSDisplayWindow.this.vdp.getLine() / 8;
                    int n2 = SMSDisplayWindow.this.vdp.getPatternGeneratorTableAddress() + (SMSDisplayWindow.this.vdp.getLine() & 7);
                    int n3 = SMSDisplayWindow.this.vdp.getColorTableAddress();
                    SMSDisplayWindow.this.displayWindow.setColor(0, SMSDisplayWindow.this.vdp.getLine(), 8, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(0, n3)));
                    int n4 = 0;
                    while (n4 < this.columns) {
                        int n5 = SMSDisplayWindow.this.vdp.getScreenMapBaseAddress(n4 * 32 / this.columns) + n * this.columns;
                        int n6 = SMSDisplayWindow.this.vram[n5 + n4] << 3;
                        int n7 = SMSDisplayWindow.this.vram[n2 + n6];
                        int n8 = SMSDisplayWindow.this.vdp.getTextColor(n4, n3);
                        int n9 = 0;
                        while (n9 < 6) {
                            int n10 = n8 > 0 && (n7 >> (n9 ^ 7) & 1) != 0 ? n8 : SMSDisplayWindow.this.vdp.getBackDropColor(n4 * 6 + n9, n3);
                            SMSDisplayWindow.this.displayWindow.setNextColor(this.getColor(n10));
                            ++n9;
                        }
                        ++n4;
                    }
                    n4 = 0;
                    while (n4 < 8) {
                        SMSDisplayWindow.this.displayWindow.setNextColor(this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(this.columns * 6 + n4, n3)));
                        ++n4;
                    }
                    this.renderVerticalBorders();
                } else {
                    this.renderDisabledLine();
                }
            } else if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT + SMSDisplayWindow.this.vdp.getLinesBottomBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLinesTopBorder() + SMSDisplayWindow.this.vdp.getLine());
                } else if (SMSDisplayWindow.this.vdp.getLine() >= SMSDisplayWindow.this.vdp.getScanlines() - SMSDisplayWindow.this.vdp.getLinesTopBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLine() - SMSDisplayWindow.this.vdp.getScanlines() + SMSDisplayWindow.this.vdp.getLinesTopBorder());
                }
            }
        }
    }

    class Mode1extRenderer
    extends TMSRenderer {
        private final int columns;

        public Mode1extRenderer() {
            this(40);
        }

        protected Mode1extRenderer(int n) {
            this.columns = n;
        }

        @Override
        public void renderLine() {
            if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                if (SMSDisplayWindow.this.vdp.isDisplayOn()) {
                    int n = SMSDisplayWindow.this.vdp.getLine() / 8;
                    int n2 = n / 8 * 256;
                    int n3 = SMSDisplayWindow.this.vdp.getPatternGeneratorTableAddress() + n2 * 8 + (SMSDisplayWindow.this.vdp.getLine() & 7);
                    int n4 = SMSDisplayWindow.this.vdp.getColorTableAddress();
                    SMSDisplayWindow.this.displayWindow.setColor(0, SMSDisplayWindow.this.vdp.getLine(), 8, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(0, n4)));
                    int n5 = 0;
                    while (n5 < this.columns) {
                        int n6 = SMSDisplayWindow.this.vdp.getScreenMapBaseAddress(n5 * 32 / this.columns) + n * this.columns;
                        int n7 = SMSDisplayWindow.this.vram[n6 + n5] << 3;
                        int n8 = SMSDisplayWindow.this.vram[n3 + n7 & SMSDisplayWindow.this.vdp.getPatternGeneratorTableMask()];
                        int n9 = SMSDisplayWindow.this.vdp.getTextColor(n5, n4);
                        int n10 = 0;
                        while (n10 < 6) {
                            int n11 = n9 > 0 && (n8 >> (n10 ^ 7) & 1) != 0 ? n9 : SMSDisplayWindow.this.vdp.getBackDropColor(n5 * 6 + n10, n4);
                            SMSDisplayWindow.this.displayWindow.setNextColor(this.getColor(n11));
                            ++n10;
                        }
                        ++n5;
                    }
                    n5 = 0;
                    while (n5 < 8) {
                        SMSDisplayWindow.this.displayWindow.setNextColor(this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(this.columns * 6 + n5, n4)));
                        ++n5;
                    }
                    this.renderVerticalBorders();
                } else {
                    this.renderDisabledLine();
                }
            } else if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT + SMSDisplayWindow.this.vdp.getLinesBottomBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLinesTopBorder() + SMSDisplayWindow.this.vdp.getLine());
                } else if (SMSDisplayWindow.this.vdp.getLine() >= SMSDisplayWindow.this.vdp.getScanlines() - SMSDisplayWindow.this.vdp.getLinesTopBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLine() - SMSDisplayWindow.this.vdp.getScanlines() + SMSDisplayWindow.this.vdp.getLinesTopBorder());
                }
            }
        }
    }

    class Mode2Renderer
    extends TMSRenderer {
        Mode2Renderer() {
        }

        @Override
        public void renderLine() {
            if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                if (SMSDisplayWindow.this.vdp.isDisplayOn()) {
                    int n = SMSDisplayWindow.this.vdp.getLine() + SMSDisplayWindow.this.vdp.getDisplayOffset() & 0xFF;
                    boolean bl = SMSDisplayWindow.this.vdp.hasTransparency();
                    int n2 = n / 8;
                    int n3 = n2 / 8 * 256;
                    int n4 = SMSDisplayWindow.this.vdp.getColorTableAddress() + n3 * 8 + (n & 7);
                    int n5 = SMSDisplayWindow.this.vdp.getPatternGeneratorTableAddress() + n3 * 8 + (n & 7);
                    int n6 = 0;
                    while (n6 < 32) {
                        int n7 = SMSDisplayWindow.this.vdp.getScreenMapBaseAddress(n6) + n2 * 32;
                        int n8 = SMSDisplayWindow.this.vram[n7 | n6] << 3;
                        int n9 = SMSDisplayWindow.this.vram[n4 + n8 & SMSDisplayWindow.this.vdp.getColorTableMask()];
                        int n10 = SMSDisplayWindow.this.vram[n5 + n8 & SMSDisplayWindow.this.vdp.getPatternGeneratorTableMask()];
                        int n11 = 0;
                        while (n11 < 8) {
                            int n12;
                            int n13 = n12 = (n10 >> (n11 ^ 7) & 1) != 0 ? n9 >> 4 : n9 & 0xF;
                            if (!bl || n12 > 0) {
                                SMSDisplayWindow.this.displayWindow.setColor(n6 * 8 + n11, SMSDisplayWindow.this.vdp.getLine(), this.getColor(n12));
                            } else {
                                SMSDisplayWindow.this.displayWindow.setColor(n6 * 8 + n11, SMSDisplayWindow.this.vdp.getLine(), this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor()));
                            }
                            ++n11;
                        }
                        ++n6;
                    }
                    this.renderVerticalBorders();
                    this.renderSprites();
                } else {
                    this.renderDisabledLine();
                }
            } else if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT + SMSDisplayWindow.this.vdp.getLinesBottomBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLinesTopBorder() + SMSDisplayWindow.this.vdp.getLine());
                } else if (SMSDisplayWindow.this.vdp.getLine() >= SMSDisplayWindow.this.vdp.getScanlines() - SMSDisplayWindow.this.vdp.getLinesTopBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLine() - SMSDisplayWindow.this.vdp.getScanlines() + SMSDisplayWindow.this.vdp.getLinesTopBorder());
                }
            }
        }
    }

    class Mode3Renderer
    extends TMSRenderer {
        Mode3Renderer() {
        }

        @Override
        public void renderLine() {
            if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                if (SMSDisplayWindow.this.vdp.isDisplayOn()) {
                    int n = SMSDisplayWindow.this.vdp.getLine() / 8;
                    int n2 = SMSDisplayWindow.this.vdp.getPatternGeneratorTableAddress() + (n & 3) * 2 + (SMSDisplayWindow.this.vdp.getLine() / 4 & 1);
                    int n3 = 0;
                    while (n3 < 32) {
                        int n4 = SMSDisplayWindow.this.vdp.getScreenMapBaseAddress(n3) + n * 32;
                        int n5 = SMSDisplayWindow.this.vram[n4 | n3] << 3;
                        int n6 = SMSDisplayWindow.this.vram[n2 + n5];
                        int n7 = n6 >> 4;
                        if (n7 > 0) {
                            SMSDisplayWindow.this.displayWindow.setColor(n3 * 8, SMSDisplayWindow.this.vdp.getLine(), 4, this.getColor(n7));
                        } else {
                            SMSDisplayWindow.this.displayWindow.setColor(n3 * 8, SMSDisplayWindow.this.vdp.getLine(), 4, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor()));
                        }
                        n7 = n6 & 0xF;
                        if (n7 > 0) {
                            SMSDisplayWindow.this.displayWindow.setColor(n3 * 8 + 4, SMSDisplayWindow.this.vdp.getLine(), 4, this.getColor(n7));
                        } else {
                            SMSDisplayWindow.this.displayWindow.setColor(n3 * 8 + 4, SMSDisplayWindow.this.vdp.getLine(), 4, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor()));
                        }
                        ++n3;
                    }
                    this.renderVerticalBorders();
                    this.renderSprites();
                } else {
                    this.renderDisabledLine();
                }
            } else if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT + SMSDisplayWindow.this.vdp.getLinesBottomBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLinesTopBorder() + SMSDisplayWindow.this.vdp.getLine());
                } else if (SMSDisplayWindow.this.vdp.getLine() >= SMSDisplayWindow.this.vdp.getScanlines() - SMSDisplayWindow.this.vdp.getLinesTopBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLine() - SMSDisplayWindow.this.vdp.getScanlines() + SMSDisplayWindow.this.vdp.getLinesTopBorder());
                }
            }
        }
    }

    class Mode3extRenderer
    extends TMSRenderer {
        Mode3extRenderer() {
        }

        @Override
        public void renderLine() {
            if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                if (SMSDisplayWindow.this.vdp.isDisplayOn()) {
                    int n = SMSDisplayWindow.this.vdp.getLine() / 8;
                    int n2 = n / 8 * 256;
                    int n3 = SMSDisplayWindow.this.vdp.getPatternGeneratorTableAddress() + n2 * 8 + (n & 3) * 2 + (SMSDisplayWindow.this.vdp.getLine() / 4 & 1);
                    int n4 = 0;
                    while (n4 < 32) {
                        int n5 = SMSDisplayWindow.this.vdp.getScreenMapBaseAddress(n4) + n * 32;
                        int n6 = SMSDisplayWindow.this.vram[n5 | n4] << 3;
                        int n7 = SMSDisplayWindow.this.vram[n3 + n6 & SMSDisplayWindow.this.vdp.getPatternGeneratorTableMask()];
                        int n8 = n7 >> 4;
                        if (n8 > 0) {
                            SMSDisplayWindow.this.displayWindow.setColor(n4 * 8, SMSDisplayWindow.this.vdp.getLine(), 4, this.getColor(n8));
                        } else {
                            SMSDisplayWindow.this.displayWindow.setColor(n4 * 8, SMSDisplayWindow.this.vdp.getLine(), 4, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor()));
                        }
                        n8 = n7 & 0xF;
                        if (n8 > 0) {
                            SMSDisplayWindow.this.displayWindow.setColor(n4 * 8 + 4, SMSDisplayWindow.this.vdp.getLine(), 4, this.getColor(n8));
                        } else {
                            SMSDisplayWindow.this.displayWindow.setColor(n4 * 8 + 4, SMSDisplayWindow.this.vdp.getLine(), 4, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor()));
                        }
                        ++n4;
                    }
                    this.renderVerticalBorders();
                    this.renderSprites();
                } else {
                    this.renderDisabledLine();
                }
            } else if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT + SMSDisplayWindow.this.vdp.getLinesBottomBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLinesTopBorder() + SMSDisplayWindow.this.vdp.getLine());
                } else if (SMSDisplayWindow.this.vdp.getLine() >= SMSDisplayWindow.this.vdp.getScanlines() - SMSDisplayWindow.this.vdp.getLinesTopBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLine() - SMSDisplayWindow.this.vdp.getScanlines() + SMSDisplayWindow.this.vdp.getLinesTopBorder());
                }
            }
        }
    }

    private class Mode4Renderer
    implements Renderer {
        private final int ROWS;
        private final int HEIGHT;
        private final int LINES_TOP_BORDER;
        private final SMS2VDP vdp;

        public Mode4Renderer(int n) {
            this.vdp = (SMS2VDP)SMSDisplayWindow.this.vdp;
            this.ROWS = n;
            this.HEIGHT = this.vdp.getScreenHeight();
            if (!SMSDisplayWindow.this.smsHideBorders && !(this.vdp instanceof GGVDP)) {
                this.LINES_TOP_BORDER = this.vdp.getLinesTopBorder();
                SMSDisplayWindow.this.displayWindow.setBorders(13, this.LINES_TOP_BORDER, 15, this.vdp.getLinesBottomBorder());
            } else {
                this.LINES_TOP_BORDER = 0;
                SMSDisplayWindow.this.displayWindow.setHeight(this.HEIGHT);
            }
            if (this.vdp instanceof GGVDP) {
                GGVDP gGVDP = (GGVDP)this.vdp;
                int n2 = 160;
                int n3 = 144;
                int n4 = 0;
                if (gGVDP.isSmsMode() || (SMSDisplayWindow.this.ggShowOffscreenArea & 2) != 0) {
                    n2 = 256;
                    if ((SMSDisplayWindow.this.ggShowOffscreenArea & 1) != 0) {
                        n4 = 8;
                    }
                    if ((SMSDisplayWindow.this.ggShowOffscreenArea & 2) == 0) {
                        n4 = 0;
                        n2 -= 16;
                    }
                }
                if (gGVDP.isSmsMode() || (SMSDisplayWindow.this.ggShowOffscreenArea & 4) != 0) {
                    n3 = this.HEIGHT;
                }
                SMSDisplayWindow.this.displayWindow.setViewport(n4 + (256 - n2) / 2, (this.HEIGHT - n3) / 2, n2 - n4, n3);
            }
            SMSDisplayWindow.this.colorWrites[0] = -1;
        }

        @Override
        public void renderLine() {
            block22: {
                block23: {
                    block21: {
                        int n;
                        int n2;
                        if (this.vdp.getLine() >= this.HEIGHT) break block21;
                        SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[0];
                        int n3 = this.vdp.getVerticalScroll();
                        int n4 = (this.vdp.getLine() + n3) / 8;
                        int n5 = this.vdp.getHorizontalScroll() & 7;
                        int n6 = this.vdp.getLine() + n3 & 7;
                        int n7 = -this.vdp.getHorizontalScroll() / 8;
                        int n8 = 0;
                        while (n8 < n5) {
                            if ((SMSDisplayWindow.this.lineBuffer[n8] & 0x80) == 0) {
                                SMSDisplayWindow.this.displayWindow.setColor(n8, this.vdp.getLine(), this.getLeftMostColumnPatternColor(n8));
                            } else {
                                SMSDisplayWindow.this.displayWindow.setColor(n8, this.vdp.getLine(), SMSDisplayWindow.this.getColor(SMSDisplayWindow.this.lineBuffer[n8] >> 8, 8));
                            }
                            ++n8;
                        }
                        if (n5 == 0) {
                            SMSDisplayWindow.this.displayWindow.setCursor(0, this.vdp.getLine());
                        }
                        n8 = 0;
                        while (n8 < 24) {
                            n2 = this.vdp.getScreenMapBaseAddress(n8) + n4 % this.ROWS * 64;
                            n = n2 | (n7 & 0x1F) << 1;
                            this.renderBackgroundCharacter(SMSDisplayWindow.this.vram[n | 1] << 8 | SMSDisplayWindow.this.vram[n], n5, n6);
                            ++n8;
                            n5 += 8;
                            ++n7;
                        }
                        if (this.vdp.isVertScrollInhibited()) {
                            n4 = this.vdp.getLine() / 8;
                            n6 = this.vdp.getLine() & 7;
                        }
                        n8 = 24;
                        while (n8 < 32) {
                            n2 = this.vdp.getScreenMapBaseAddress(n8) + n4 % this.ROWS * 64;
                            n = n2 | (n7 & 0x1F) << 1;
                            this.renderBackgroundCharacter(SMSDisplayWindow.this.vram[n | 1] << 8 | SMSDisplayWindow.this.vram[n], n5, n6);
                            ++n8;
                            n5 += 8;
                            ++n7;
                        }
                        if (SMSDisplayWindow.this.spriteToHighlight >= 0 && SMSDisplayWindow.this.spriteCount > 0) {
                            this.highlightSprite(SMSDisplayWindow.this.spriteToHighlight);
                        }
                        if (!SMSDisplayWindow.this.smsHideBorders && !(this.vdp instanceof GGVDP)) {
                            n8 = this.LINES_TOP_BORDER + this.vdp.getLine();
                            n2 = 0;
                            while (n2 < 15) {
                                SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[(269 + n2) / 2];
                                SMSDisplayWindow.this.displayWindow.setColorDirect(269 + n2, n8, SMSDisplayWindow.this.getColor(this.vdp.getBackDropColor(269 + n2), 8));
                                ++n2;
                            }
                            n2 = 0;
                            while (n2 < 13) {
                                SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[n2 / 2];
                                SMSDisplayWindow.this.displayWindow.setColorDirect(n2, n8, SMSDisplayWindow.this.getColor(this.vdp.getBackDropColor(n2), 8));
                                ++n2;
                            }
                        }
                        if (this.vdp.isLeftColumnBlank()) {
                            SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[0];
                            n8 = 0;
                            while (n8 < 8) {
                                SMSDisplayWindow.this.displayWindow.setColor(n8, this.vdp.getLine(), SMSDisplayWindow.this.getColor(this.vdp.getBackDropColor(n8), 8));
                                ++n8;
                            }
                        }
                        if (!SMSDisplayWindow.this.emulateVDPconstraints) break block22;
                        if (!SMSDisplayWindow.this.smsHideBorders && !(this.vdp instanceof GGVDP)) {
                            n8 = this.LINES_TOP_BORDER + this.vdp.getLine();
                            n2 = 0;
                            while (SMSDisplayWindow.this.colorWrites[n2] >= 0) {
                                SMSDisplayWindow.this.displayWindow.setColorDirect(SMSDisplayWindow.this.colorWrites[n2], n8, SMSDisplayWindow.this.colorWrites[n2 + 1]);
                                n2 += 2;
                            }
                        } else {
                            n8 = 0;
                            while (SMSDisplayWindow.this.colorWrites[n8] >= 0) {
                                SMSDisplayWindow.this.displayWindow.setColorDirect(SMSDisplayWindow.this.colorWrites[n8], this.vdp.getLine(), SMSDisplayWindow.this.colorWrites[n8 + 1]);
                                n8 += 2;
                            }
                        }
                        break block22;
                    }
                    if (SMSDisplayWindow.this.smsHideBorders || this.vdp instanceof GGVDP) break block22;
                    if (this.vdp.getLine() >= this.HEIGHT + this.vdp.getLinesBottomBorder()) break block23;
                    int n = this.LINES_TOP_BORDER + this.vdp.getLine();
                    this.renderBlankLine(n);
                    if (!SMSDisplayWindow.this.emulateVDPconstraints) break block22;
                    int n9 = 0;
                    while (SMSDisplayWindow.this.colorWrites[n9] >= 0) {
                        SMSDisplayWindow.this.displayWindow.setColorDirect(SMSDisplayWindow.this.colorWrites[n9], n, SMSDisplayWindow.this.colorWrites[n9 + 1]);
                        n9 += 2;
                    }
                    break block22;
                }
                if (this.vdp.getLine() >= this.vdp.getScanlines() - this.LINES_TOP_BORDER) {
                    int n = this.vdp.getLine() - this.vdp.getScanlines() + this.LINES_TOP_BORDER;
                    this.renderBlankLine(n);
                    if (SMSDisplayWindow.this.emulateVDPconstraints) {
                        int n10 = 0;
                        while (SMSDisplayWindow.this.colorWrites[n10] >= 0) {
                            SMSDisplayWindow.this.displayWindow.setColorDirect(SMSDisplayWindow.this.colorWrites[n10], n, SMSDisplayWindow.this.colorWrites[n10 + 1]);
                            n10 += 2;
                        }
                    }
                }
            }
        }

        private void highlightSprite(int n) {
            int n2;
            boolean bl = this.vdp.isLargeSpritesEnabled();
            boolean bl2 = this.vdp.isDoubledSpritesEnabled();
            int n3 = SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n) | n] + 1;
            int n4 = SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n) | 0x80 | n << 1] - (this.vdp.isSpriteShiftEnabled() ? 8 : 0);
            int n5 = this.vdp.getLine() - n3 & 0xFF;
            if (bl2) {
                n5 /= 2;
            }
            SMSDisplayWindow.this.displayWindow.eraseSelectionCursor();
            int n6 = n2 = bl ? 15 : 7;
            if (n5 >= 0 && n5 <= n2) {
                int n7;
                int n8 = n7 = bl2 ? 2 : 1;
                if (n5 == 0 || n5 == n2) {
                    SMSDisplayWindow.this.displayWindow.setColor(n4, this.vdp.getLine(), 8 * n7, DisplayWindow.COLOR_WHITE);
                } else {
                    SMSDisplayWindow.this.displayWindow.setColor(n4, this.vdp.getLine(), DisplayWindow.COLOR_WHITE);
                    SMSDisplayWindow.this.displayWindow.setColor(n4 + 8 * n7 - 1, this.vdp.getLine(), DisplayWindow.COLOR_WHITE);
                }
            }
        }

        private void renderBlankLine(int n) {
            int n2 = SMSDisplayWindow.this.smsHideBorders ? 269 : 284;
            int n3 = 0;
            int n4 = 0;
            while (n3 < SMSDisplayWindow.this.colorsPointers.length && n4 < n2) {
                SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[n3];
                int n5 = 0;
                while (n5 < 2 && n4 < n2) {
                    if (SMSDisplayWindow.this.smsHideBorders && n4 >= 13) {
                        SMSDisplayWindow.this.displayWindow.setColorDirect(n4 - 13, n, SMSDisplayWindow.this.getColor(this.vdp.getBackDropColor(n4), 8));
                    } else {
                        SMSDisplayWindow.this.displayWindow.setColorDirect(n4, n, SMSDisplayWindow.this.getColor(this.vdp.getBackDropColor(n4), 8));
                    }
                    ++n5;
                    ++n4;
                }
                ++n3;
            }
        }

        private void parseSpriteAttributeTable() {
            boolean bl = this.vdp.isLargeSpritesEnabled();
            int n = this.vdp.getLine();
            SMSDisplayWindow.this.spriteCount = 0;
            int n2 = 0;
            while (n2 < 64) {
                int n3 = SMSDisplayWindow.this.vram[this.vdp.getPrevSpriteAttributeTableAddress(n2) | n2];
                if (n3 >= 240) {
                    n3 -= 256;
                }
                if (n3 == this.vdp.getSpritesDoneY()) break;
                int n4 = n - (n3 + 1) & 0xFF;
                if (this.vdp.isDoubledSpritesEnabled()) {
                    n4 /= 2;
                }
                if (bl && n4 >= 0 && n4 < 16 || !bl && n4 >= 0 && n4 < 8) {
                    if (SMSDisplayWindow.this.spriteCount >= SMSDisplayWindow.this.spriteBuffer.length) {
                        if (n2 < 14) {
                            this.vdp.setSpriteOverflowFlag(n2 + 1 >> 1);
                            break;
                        }
                        this.vdp.setSpriteOverflowFlag(n2 >> 1);
                        break;
                    }
                    SMSDisplayWindow.this.spriteBuffer[SMSDisplayWindow.this.spriteCount++] = n2;
                }
                ++n2;
            }
        }

        private void renderBackgroundCharacter(int n, int n2, int n3) {
            boolean bl = (n & 0x1000) != 0;
            int n4 = (n & 0x800) >> 8;
            int n5 = (n & 0x7FF) << 3 | n3;
            int n6 = Math.min(8, 256 - n2);
            boolean bl2 = this.vdp.isDisplayOn(n2 - 8) && this.vdp.isDisplayOn(n2 - 11);
            SMSDisplayWindow.this.updatePattern(n5);
            if (!bl2) {
                int n7 = 0;
                while (n7 < n6) {
                    SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[(n2 + 13) / 2];
                    if (this.vdp.isDisplayOn(n2)) {
                        SMSDisplayWindow.this.displayWindow.setNextColor(SMSDisplayWindow.this.getColor(0, 0));
                    } else {
                        SMSDisplayWindow.this.displayWindow.setNextColor(SMSDisplayWindow.this.getColor(this.vdp.getBackDropColor(n2), 8));
                    }
                    ++n7;
                    ++n2;
                }
            } else {
                int n8 = 0;
                while (n8 < n6) {
                    SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[(n2 + 13) / 2];
                    if (this.vdp.isDisplayOn(n2)) {
                        if ((SMSDisplayWindow.this.lineBuffer[n2] & 0x80) == 0 || bl && SMSDisplayWindow.this.patternData[n5][n8] > 0) {
                            int n9 = SMSDisplayWindow.this.patternData[n5][n8];
                            SMSDisplayWindow.this.displayWindow.setNextColor(SMSDisplayWindow.this.getColor(n9, n4));
                            SMSDisplayWindow.this.lineBuffer[n2] = n4 << 12 | n9 << 8;
                        } else {
                            SMSDisplayWindow.this.displayWindow.setNextColor(SMSDisplayWindow.this.getColor(SMSDisplayWindow.this.lineBuffer[n2] >> 8, 8));
                        }
                    } else {
                        SMSDisplayWindow.this.displayWindow.setNextColor(SMSDisplayWindow.this.getColor(this.vdp.getBackDropColor(n2), 8));
                    }
                    ++n8;
                    ++n2;
                }
            }
        }

        private int getLeftMostColumnPatternColor(int n) {
            int n2 = 0;
            if (SMSDisplayWindow.this.spriteCount <= 0) {
                while (n2 + 1 < 63 && SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) + n2] != 208) {
                    ++n2;
                }
                n2 = n2 + 1 & 0x3E;
            }
            int n3 = SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) | 0x80 | n2 << 1];
            int n4 = SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) | 0x80 | n2 << 1 | 1];
            int n5 = SMSDisplayWindow.this.vram[this.vdp.getSpritePatternAddress() | n4 << 5 | (this.vdp.getLine() - n3 & 7) << 2 | 1];
            int n6 = (n5 & 2) != 0 ? n + 1 : 6 - n;
            int n7 = SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) + 12] >> n6 & 1;
            n7 |= (SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) + 13] >> n6 & 1) << 1;
            n7 |= (SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) + 14] >> n6 & 1) << 2;
            return SMSDisplayWindow.this.getColor(n7 |= (SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) + 15] >> n6 & 1) << 3, n5 & 8);
        }

        @Override
        public void prepareSprites() {
            this.parseSpriteAttributeTable();
            if (!this.vdp.isDisplayOn()) {
                return;
            }
            if (this.vdp.getLine() == 0 && SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(0)] == 240 && SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(0) | 1] == 240 && SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(0) | 2] == 208 && SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(0) | 0x80] == 124 && SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(0) | 0x80 | 2] == 124 && SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(0) | 0x80 | 1] == 65 && SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(0) | 0x80 | 2 | 1] == 65) {
                this.vdp.setSpriteCollisionX(124);
            }
            boolean bl = this.vdp.isLargeSpritesEnabled();
            int n = SMSDisplayWindow.this.spriteCount - 1;
            while (n >= 0) {
                int n2 = SMSDisplayWindow.this.spriteBuffer[n];
                int n3 = SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) | n2] + 1;
                int n4 = SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) | 0x80 | n2 << 1] - (this.vdp.isSpriteShiftEnabled() ? 8 : 0);
                int n5 = SMSDisplayWindow.this.vram[this.vdp.getSpriteAttributeTableAddress(n2) | 0x80 | n2 << 1 | 1];
                int n6 = this.vdp.getLine() - n3 & 0xFF;
                if (this.vdp.isDoubledSpritesEnabled()) {
                    n6 /= 2;
                }
                SMSDisplayWindow.this.largeSprites[n2] = bl;
                SMSDisplayWindow.this.largeSpritesSet[n2] = true;
                if (bl) {
                    if (n6 >= 0 && n6 < 8) {
                        this.prepareSpriteCharacter(n2, n5 & 0xFE, n4, n6);
                    } else if (n6 >= 8 && n6 < 16) {
                        this.prepareSpriteCharacter(n2, n5 | 1, n4, n6);
                    }
                } else {
                    this.prepareSpriteCharacter(n2, n5, n4, n6);
                }
                --n;
            }
        }

        private void prepareSpriteCharacter(int n, int n2, int n3, int n4) {
            int n5 = (this.vdp.getSpritePatternAddress() >> 5 | n2) << 3 | n4;
            SMSDisplayWindow.this.updatePattern(n5);
            int[] nArray = SMSDisplayWindow.this.patternData[n5];
            if (this.vdp.isDoubledSpritesEnabled()) {
                int n6 = Math.min(8, (256 - n3) / 2);
                int n7 = n3 < 0 ? -n3 : 0;
                while (n7 < n6) {
                    if (nArray[n7] > 0) {
                        if ((SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2 + 1] & 0x80) != 0) {
                            if ((SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2 + 1] & 0x40) != 0) {
                                this.vdp.setSpriteCollisionX(n3 + n7 * 2 + 1);
                            }
                            if ((SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2 + 1] & 0x3F) > n) {
                                SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2 + 1] = 0x1000 | nArray[n7] << 8 | 0x80 | 0x40 | n;
                            }
                        } else if ((SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2 + 1] & 0x40) == 0) {
                            SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2 + 1] = 0x1000 | nArray[n7] << 8 | 0x80 | 0x40 | n;
                        } else {
                            int n8 = n3 + n7 * 2 + 1;
                            SMSDisplayWindow.this.lineBuffer[n8] = SMSDisplayWindow.this.lineBuffer[n8] | 0x80;
                        }
                        if ((SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2] & 0x80) != 0) {
                            if ((SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2] & 0x40) != 0) {
                                this.vdp.setSpriteCollisionX(n3 + n7 * 2);
                            }
                            if ((SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2] & 0x3F) > n) {
                                SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2] = 0x1000 | nArray[n7] << 8 | 0x80 | 0x40 | n;
                            }
                        } else if ((SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2] & 0x40) == 0) {
                            SMSDisplayWindow.this.lineBuffer[n3 + n7 * 2] = 0x1000 | nArray[n7] << 8 | 0x80 | 0x40 | n;
                        } else {
                            int n9 = n3 + n7 * 2;
                            SMSDisplayWindow.this.lineBuffer[n9] = SMSDisplayWindow.this.lineBuffer[n9] | 0x80;
                        }
                    }
                    ++n7;
                }
            } else {
                int n10 = Math.min(8, 256 - n3);
                int n11 = n3 < 0 ? -n3 : 0;
                while (n11 < n10) {
                    if (nArray[n11] > 0) {
                        if ((SMSDisplayWindow.this.lineBuffer[n3 + n11] & 0x80) != 0) {
                            if ((SMSDisplayWindow.this.lineBuffer[n3 + n11] & 0x40) != 0) {
                                this.vdp.setSpriteCollisionX(n3 + n11);
                            }
                            if ((SMSDisplayWindow.this.lineBuffer[n3 + n11] & 0x3F) > n) {
                                SMSDisplayWindow.this.lineBuffer[n3 + n11] = 0x1000 | nArray[n11] << 8 | 0x80 | 0x40 | n;
                            }
                        } else if ((SMSDisplayWindow.this.lineBuffer[n3 + n11] & 0x40) == 0) {
                            SMSDisplayWindow.this.lineBuffer[n3 + n11] = 0x1000 | nArray[n11] << 8 | 0x80 | 0x40 | n;
                        } else {
                            int n12 = n3 + n11;
                            SMSDisplayWindow.this.lineBuffer[n12] = SMSDisplayWindow.this.lineBuffer[n12] | 0x80;
                        }
                    }
                    ++n11;
                }
            }
        }
    }

    class ModeInvalidRenderer
    extends TMSRenderer {
        private final int columns;

        public ModeInvalidRenderer() {
            this(40);
        }

        protected ModeInvalidRenderer(int n) {
            this.columns = n;
        }

        @Override
        public void renderLine() {
            if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                if (SMSDisplayWindow.this.vdp.isDisplayOn()) {
                    int n = SMSDisplayWindow.this.vdp.getColorTableAddress();
                    SMSDisplayWindow.this.displayWindow.setColor(0, SMSDisplayWindow.this.vdp.getLine(), 8, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(0, n)));
                    int n2 = 0;
                    while (n2 < this.columns) {
                        int n3;
                        int n4 = 0;
                        while (n4 < 4) {
                            n3 = SMSDisplayWindow.this.vdp.getTextColor(n2, n);
                            if (n3 > 0) {
                                SMSDisplayWindow.this.displayWindow.setNextColor(this.getColor(n3));
                            } else {
                                SMSDisplayWindow.this.displayWindow.setNextColor(DisplayWindow.COLOR_BLACK);
                            }
                            ++n4;
                        }
                        n4 = 4;
                        while (n4 < 6) {
                            n3 = SMSDisplayWindow.this.vdp.getBackDropColor(this.columns * 6 + n2, n);
                            if (n3 > 0) {
                                SMSDisplayWindow.this.displayWindow.setNextColor(this.getColor(n3));
                            } else {
                                SMSDisplayWindow.this.displayWindow.setNextColor(DisplayWindow.COLOR_BLACK);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < 8) {
                        SMSDisplayWindow.this.displayWindow.setNextColor(this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(this.columns * 6 + n2, n)));
                        ++n2;
                    }
                    this.renderVerticalBorders();
                }
                this.renderDisabledLine();
            } else if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT + SMSDisplayWindow.this.vdp.getLinesBottomBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLinesTopBorder() + SMSDisplayWindow.this.vdp.getLine());
                } else if (SMSDisplayWindow.this.vdp.getLine() >= SMSDisplayWindow.this.vdp.getScanlines() - SMSDisplayWindow.this.vdp.getLinesTopBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLine() - SMSDisplayWindow.this.vdp.getScanlines() + SMSDisplayWindow.this.vdp.getLinesTopBorder());
                }
            }
        }
    }

    class ModeInvalidTextRenderer
    extends TMSRenderer {
        private final int columns;

        public ModeInvalidTextRenderer() {
            this(40);
        }

        protected ModeInvalidTextRenderer(int n) {
            this.columns = n;
        }

        @Override
        public void renderLine() {
            if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                int n = SMSDisplayWindow.this.vdp.getLine() / 8;
                int n2 = SMSDisplayWindow.this.vdp.getPatternGeneratorTableAddress() + (SMSDisplayWindow.this.vdp.getLine() & 7);
                int n3 = SMSDisplayWindow.this.vdp.getColorTableAddress();
                SMSDisplayWindow.this.displayWindow.setColor(0, SMSDisplayWindow.this.vdp.getLine(), 8, SMSDisplayWindow.this.getColor(SMSDisplayWindow.this.vdp.isDisplayOn() ? 0 : SMSDisplayWindow.this.vdp.getBackDropColor(0, n3), 8));
                int n4 = 0;
                while (n4 < this.columns) {
                    int n5 = SMSDisplayWindow.this.vdp.getScreenMapBaseAddress(n4 * 32 / this.columns) + n * this.columns;
                    int n6 = SMSDisplayWindow.this.vram[n5 + n4] << 3;
                    int n7 = SMSDisplayWindow.this.vram[n2 + n6];
                    int n8 = 0;
                    while (n8 < 6) {
                        int n9;
                        int n10 = n9 = (n7 >> (n8 ^ 7) & 1) != 0 ? SMSDisplayWindow.this.vdp.getTextColor(n4, n3) : SMSDisplayWindow.this.vdp.getBackDropColor(this.columns * 6 + n8, n3);
                        if (n9 > 0) {
                            SMSDisplayWindow.this.displayWindow.setNextColor(SMSDisplayWindow.this.getColor(n9, 8));
                        } else {
                            SMSDisplayWindow.this.displayWindow.setNextColor(SMSDisplayWindow.this.getColor(SMSDisplayWindow.this.vdp.isDisplayOn() ? 0 : SMSDisplayWindow.this.vdp.getBackDropColor(this.columns * 6 + n8, n3), 8));
                        }
                        ++n8;
                    }
                    ++n4;
                }
                n4 = 0;
                while (n4 < 8) {
                    SMSDisplayWindow.this.displayWindow.setNextColor(SMSDisplayWindow.this.getColor(SMSDisplayWindow.this.vdp.isDisplayOn() ? 0 : SMSDisplayWindow.this.vdp.getBackDropColor(0, n3), 8));
                    ++n4;
                }
                this.renderVerticalBorders();
            } else if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                if (SMSDisplayWindow.this.vdp.getLine() < this.HEIGHT + SMSDisplayWindow.this.vdp.getLinesBottomBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLinesTopBorder() + SMSDisplayWindow.this.vdp.getLine());
                } else if (SMSDisplayWindow.this.vdp.getLine() >= SMSDisplayWindow.this.vdp.getScanlines() - SMSDisplayWindow.this.vdp.getLinesTopBorder()) {
                    this.renderBlankLine(SMSDisplayWindow.this.vdp.getLine() - SMSDisplayWindow.this.vdp.getScanlines() + SMSDisplayWindow.this.vdp.getLinesTopBorder());
                }
            }
        }
    }

    private static interface Renderer {
        public void renderLine();

        public void prepareSprites();
    }

    protected abstract class TMSRenderer
    implements Renderer {
        protected final int HEIGHT;

        protected TMSRenderer() {
            this.HEIGHT = SMSDisplayWindow.this.vdp.getScreenHeight();
            if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                SMSDisplayWindow.this.displayWindow.setBorders(13, SMSDisplayWindow.this.vdp.getLinesTopBorder(), 15, SMSDisplayWindow.this.vdp.getLinesBottomBorder());
            } else {
                SMSDisplayWindow.this.displayWindow.setHeight(this.HEIGHT);
            }
            if (SMSDisplayWindow.this.vdp instanceof GGVDP) {
                GGVDP gGVDP = (GGVDP)SMSDisplayWindow.this.vdp;
                int n = 160;
                int n2 = 144;
                int n3 = 0;
                if (gGVDP.isSmsMode() || (SMSDisplayWindow.this.ggShowOffscreenArea & 2) != 0) {
                    n = 256;
                    if ((SMSDisplayWindow.this.ggShowOffscreenArea & 1) != 0) {
                        n3 = 8;
                    }
                }
                if (gGVDP.isSmsMode() || (SMSDisplayWindow.this.ggShowOffscreenArea & 4) != 0) {
                    n2 = this.HEIGHT;
                }
                SMSDisplayWindow.this.displayWindow.setViewport(n3 + (256 - n) / 2, (this.HEIGHT - n2) / 2, n - n3, n2);
            }
        }

        protected void renderDisabledLine() {
            int n = SMSDisplayWindow.this.smsHideBorders || SMSDisplayWindow.this.vdp instanceof GGVDP ? 256 : 284;
            int n2 = SMSDisplayWindow.this.smsHideBorders || SMSDisplayWindow.this.vdp instanceof GGVDP ? 0 : SMSDisplayWindow.this.vdp.getLinesTopBorder();
            SMSDisplayWindow.this.displayWindow.setColorDirect(0, n2 + SMSDisplayWindow.this.vdp.getLine(), n, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor()));
        }

        protected void parseSpriteAttributeTable() {
            SMSDisplayWindow.this.spriteCount = 0;
            if (SMSDisplayWindow.this.vdp.isSpritesDisabled()) {
                return;
            }
            boolean bl = SMSDisplayWindow.this.vdp.isLargeSpritesEnabled();
            int n = SMSDisplayWindow.this.vdp.getLine();
            int n2 = 0;
            while (n2 < 32) {
                int n3 = SMSDisplayWindow.this.vram[SMSDisplayWindow.this.vdp.getSpriteAttributeTableAddress(n2) | n2 << 2];
                if (n3 >= 240) {
                    n3 -= 256;
                }
                if (n3 == SMSDisplayWindow.this.vdp.getSpritesDoneY()) break;
                int n4 = (n + SMSDisplayWindow.this.vdp.getDisplayOffset() & 0xFF) - (n3 + 1) & 0xFF;
                if (SMSDisplayWindow.this.vdp.isDoubledSpritesEnabled()) {
                    n4 /= 2;
                }
                if (bl && n4 >= 0 && n4 < 16 || !bl && n4 >= 0 && n4 < 8) {
                    if (SMSDisplayWindow.this.spriteCount >= SMSDisplayWindow.this.spriteBuffer.length) {
                        SMSDisplayWindow.this.vdp.setSpriteOverflowFlag(SMSDisplayWindow.this.spriteCount);
                        break;
                    }
                    SMSDisplayWindow.this.spriteBuffer[SMSDisplayWindow.this.spriteCount++] = n2;
                }
                ++n2;
            }
        }

        protected int getColor(int n) {
            return SMSDisplayWindow.this.getTmsColor(n);
        }

        protected void renderVerticalBorders() {
            if (!SMSDisplayWindow.this.smsHideBorders && !(SMSDisplayWindow.this.vdp instanceof GGVDP)) {
                int n = SMSDisplayWindow.this.vdp.getColorTableAddress();
                int n2 = SMSDisplayWindow.this.vdp.getLinesTopBorder() + SMSDisplayWindow.this.vdp.getLine();
                int n3 = 13 - SMSDisplayWindow.this.vdp.getDisplayAdjustHorizontal();
                int n4 = 15 + SMSDisplayWindow.this.vdp.getDisplayAdjustHorizontal();
                int n5 = 0;
                while (n5 < n4) {
                    SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[(256 + n3 + n5) / 2];
                    SMSDisplayWindow.this.displayWindow.setColorDirect(256 + n3 + n5, n2, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(256 + n3 + n5, n)));
                    ++n5;
                }
                n5 = 0;
                while (n5 < n3) {
                    SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[n5 / 2];
                    SMSDisplayWindow.this.displayWindow.setColorDirect(n5, n2, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(256 + n5, n)));
                    ++n5;
                }
            }
        }

        protected void renderBlankLine(int n) {
            int n2 = SMSDisplayWindow.this.vdp.getColorTableAddress();
            int n3 = SMSDisplayWindow.this.smsHideBorders ? 269 : 284;
            int n4 = 0;
            int n5 = 0;
            while (n4 < SMSDisplayWindow.this.colorsPointers.length && n5 < n3) {
                SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[n4];
                int n6 = 0;
                while (n6 < 2 && n5 < n3) {
                    if (SMSDisplayWindow.this.smsHideBorders && n5 >= 13) {
                        SMSDisplayWindow.this.displayWindow.setColorDirect(n5 - 13, n, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(n5, n2)));
                    } else {
                        SMSDisplayWindow.this.displayWindow.setColorDirect(n5, n, this.getColor(SMSDisplayWindow.this.vdp.getBackDropColor(n5, n2)));
                    }
                    ++n6;
                    ++n5;
                }
                ++n4;
            }
            SMSDisplayWindow.this.colors = SMSDisplayWindow.this.colorsPointers[SMSDisplayWindow.this.colorsPointers.length - 1];
        }

        protected void renderSprites() {
            if (SMSDisplayWindow.this.spriteCount > 0) {
                SMSDisplayWindow.this.displayWindow.setCursor(0, SMSDisplayWindow.this.vdp.getLine());
                int n = 0;
                while (n < SMSDisplayWindow.this.lineBuffer.length) {
                    int n2 = SMSDisplayWindow.this.lineBuffer[n];
                    if ((n2 & 0x80) != 0) {
                        if ((n2 & 0x40) != 0) {
                            SMSDisplayWindow.this.displayWindow.setNextColor(this.getSpriteColor(n2 >> 8));
                        } else {
                            SMSDisplayWindow.this.displayWindow.skipNextColor();
                        }
                    } else {
                        SMSDisplayWindow.this.displayWindow.skipNextColor();
                        if (this.isSpriteXdoubled()) {
                            SMSDisplayWindow.this.displayWindow.skipNextColor();
                        }
                    }
                    ++n;
                }
                if (SMSDisplayWindow.this.spriteToHighlight >= 0) {
                    this.highlightSprite(SMSDisplayWindow.this.spriteToHighlight);
                }
            }
        }

        protected int getSpriteColor(int n) {
            return this.getColor(n);
        }

        protected int getSpriteAttributes(int n, int n2) {
            return SMSDisplayWindow.this.vram[SMSDisplayWindow.this.vdp.getSpriteAttributeTableAddress(n) | n << 2 | 3];
        }

        private void highlightSprite(int n) {
            int n2;
            boolean bl;
            int n3 = SMSDisplayWindow.this.vram[SMSDisplayWindow.this.vdp.getSpriteAttributeTableAddress(n) | n << 2];
            int n4 = SMSDisplayWindow.this.vram[SMSDisplayWindow.this.vdp.getSpriteAttributeTableAddress(n) | n << 2 | 1];
            if (n3 >= 240) {
                n3 -= 256;
            }
            boolean bl2 = SMSDisplayWindow.this.vdp.isLargeSpritesEnabled();
            boolean bl3 = SMSDisplayWindow.this.vdp.isDoubledSpritesEnabled();
            int n5 = (SMSDisplayWindow.this.vdp.getLine() + SMSDisplayWindow.this.vdp.getDisplayOffset() & 0xFF) - (n3 + 1) & 0xFF;
            boolean bl4 = bl = (this.getSpriteAttributes(n, n5) & 0x80) != 0;
            if (bl) {
                n4 -= 32;
            }
            if (this.isSpriteXdoubled()) {
                n4 <<= 1;
            }
            if (bl3) {
                n5 /= 2;
            }
            int n6 = bl2 ? 16 : 8;
            SMSDisplayWindow.this.displayWindow.eraseSelectionCursor();
            int n7 = n2 = bl2 ? 15 : 7;
            if (n5 >= 0 && n5 <= n2) {
                int n8;
                int n9 = n8 = bl3 ? 2 : 1;
                if (n5 == 0 || n5 == n2) {
                    SMSDisplayWindow.this.displayWindow.setColor(n4, SMSDisplayWindow.this.vdp.getLine(), n6 * n8, DisplayWindow.COLOR_WHITE);
                } else {
                    SMSDisplayWindow.this.displayWindow.setColor(n4, SMSDisplayWindow.this.vdp.getLine(), DisplayWindow.COLOR_WHITE);
                    SMSDisplayWindow.this.displayWindow.setColor(n4 + n6 * n8 - 1, SMSDisplayWindow.this.vdp.getLine(), DisplayWindow.COLOR_WHITE);
                }
            }
        }

        @Override
        public void prepareSprites() {
            this.parseSpriteAttributeTable();
            if (!SMSDisplayWindow.this.vdp.isDisplayOn()) {
                return;
            }
            boolean bl = SMSDisplayWindow.this.vdp.isLargeSpritesEnabled();
            int n = SMSDisplayWindow.this.vdp.getLine();
            int n2 = SMSDisplayWindow.this.spriteCount - 1;
            while (n2 >= 0) {
                boolean bl2;
                int n3 = SMSDisplayWindow.this.spriteBuffer[n2];
                int n4 = SMSDisplayWindow.this.vram[SMSDisplayWindow.this.vdp.getSpriteAttributeTableAddress(n3) | n3 << 2];
                int n5 = SMSDisplayWindow.this.vram[SMSDisplayWindow.this.vdp.getSpriteAttributeTableAddress(n3) | n3 << 2 | 1];
                int n6 = SMSDisplayWindow.this.vram[SMSDisplayWindow.this.vdp.getSpriteAttributeTableAddress(n3) | n3 << 2 | 2];
                if (n4 >= 240) {
                    n4 -= 256;
                }
                int n7 = (n + SMSDisplayWindow.this.vdp.getDisplayOffset() & 0xFF) - (n4 + 1) & 0xFF;
                if (SMSDisplayWindow.this.vdp.isDoubledSpritesEnabled()) {
                    n7 /= 2;
                }
                int n8 = this.getSpriteAttributes(n3, n7) & 0xF;
                boolean bl3 = bl2 = (this.getSpriteAttributes(n3, n7) & 0x80) != 0;
                if (bl2) {
                    n5 -= 32;
                }
                SMSDisplayWindow.this.largeSprites[n3] = bl;
                SMSDisplayWindow.this.largeSpritesSet[n3] = true;
                if (n8 != 0) {
                    if (bl) {
                        int n9;
                        if (n7 >= 0 && n7 < 8) {
                            n9 = SMSDisplayWindow.this.vdp.getSpritePatternAddress() | (n6 & 0xFC) << 3 | n7 & 7;
                            if (SMSDisplayWindow.this.vdp.isDoubledSpritesEnabled()) {
                                this.processSpriteCharacterDouble(n3, SMSDisplayWindow.this.vram[n9], n5, n7, n8);
                                this.processSpriteCharacterDouble(n3, SMSDisplayWindow.this.vram[n9 | 0x10], n5 + 16, n7, n8);
                            } else {
                                this.processSpriteCharacter(n3, SMSDisplayWindow.this.vram[n9], n5, n7, n8);
                                this.processSpriteCharacter(n3, SMSDisplayWindow.this.vram[n9 | 0x10], n5 + 8, n7, n8);
                            }
                        } else if (n7 >= 8 && n7 < 16) {
                            n9 = SMSDisplayWindow.this.vdp.getSpritePatternAddress() | (n6 & 0xFC) << 3 | 8 | n7 & 7;
                            if (SMSDisplayWindow.this.vdp.isDoubledSpritesEnabled()) {
                                this.processSpriteCharacterDouble(n3, SMSDisplayWindow.this.vram[n9], n5, n7, n8);
                                this.processSpriteCharacterDouble(n3, SMSDisplayWindow.this.vram[n9 | 0x10], n5 + 16, n7, n8);
                            } else {
                                this.processSpriteCharacter(n3, SMSDisplayWindow.this.vram[n9], n5, n7, n8);
                                this.processSpriteCharacter(n3, SMSDisplayWindow.this.vram[n9 | 0x10], n5 + 8, n7, n8);
                            }
                        }
                    } else if (n7 >= 0 && n7 < 8) {
                        if (SMSDisplayWindow.this.vdp.isDoubledSpritesEnabled()) {
                            this.processSpriteCharacterDouble(n3, SMSDisplayWindow.this.vram[SMSDisplayWindow.this.vdp.getSpritePatternAddress() | n6 << 3 | n7 & 7], n5, n7, n8);
                        } else {
                            this.processSpriteCharacter(n3, SMSDisplayWindow.this.vram[SMSDisplayWindow.this.vdp.getSpritePatternAddress() | n6 << 3 | n7 & 7], n5, n7, n8);
                        }
                    }
                }
                --n2;
            }
        }

        private void processSpriteCharacter(int n, int n2, int n3, int n4, int n5) {
            int n6 = 0;
            while (n6 < 8 && n3 + n6 < 256) {
                this.setSpritePixel(n, n3 + n6, n4, n5, (n2 >> (n6 ^ 7) & 1) != 0);
                ++n6;
            }
        }

        private void processSpriteCharacterDouble(int n, int n2, int n3, int n4, int n5) {
            int n6 = 0;
            while (n6 < 8 && n3 + n6 * 2 < 256) {
                boolean bl = (n2 >> (n6 ^ 7) & 1) != 0;
                this.setSpritePixel(n, n3 + n6 * 2, n4, n5, bl);
                this.setSpritePixel(n, n3 + n6 * 2 + 1, n4, n5, bl);
                ++n6;
            }
        }

        private void setSpritePixel(int n, int n2, int n3, int n4, boolean bl) {
            if (n2 < 0 || n2 >= SMSDisplayWindow.this.lineBuffer.length) {
                return;
            }
            if ((SMSDisplayWindow.this.lineBuffer[n2] & 0x80) != 0) {
                this.handleSpriteCollision(n, SMSDisplayWindow.this.lineBuffer[n2] & 0x3F, n2, n3, n4, bl);
            } else {
                SMSDisplayWindow.this.lineBuffer[n2] = bl ? n4 << 8 | 0x80 | 0x40 | n : 128;
            }
        }

        protected boolean isSpriteXdoubled() {
            return false;
        }

        protected boolean isIgnoreSpriteCollisions(int n, int n2) {
            return false;
        }

        protected void handleSpriteCollision(int n, int n2, int n3, int n4, int n5, boolean bl) {
            if (bl) {
                if ((SMSDisplayWindow.this.lineBuffer[n3] & 0x40) != 0) {
                    SMSDisplayWindow.this.vdp.setSpriteCollisionX(n3);
                }
                SMSDisplayWindow.this.lineBuffer[n3] = n5 << 8 | 0x80 | 0x40 | n;
            }
        }
    }
}

