/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

final class DataQueue<T> {
    private final T[] elements;
    private int position;
    private int limit;

    public DataQueue(int n, Class<T> clazz) {
        this.elements = (Object[])Array.newInstance(clazz, n);
        int n2 = 0;
        while (n2 < this.elements.length) {
            try {
                this.elements[n2] = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            ++n2;
        }
        this.clear();
    }

    public final void clear() {
        this.position = 0;
        this.limit = this.elements.length;
    }

    public final int position() {
        return this.position;
    }

    public final int limit() {
        return this.limit;
    }

    public final T get(int n) {
        assert (n < this.limit);
        return this.elements[n];
    }

    public final T get() {
        if (!this.hasRemaining()) {
            return null;
        }
        return this.get(this.position++);
    }

    public final void compact() {
        int n = 0;
        while (this.hasRemaining()) {
            this.swap(this.position, n);
            ++this.position;
            ++n;
        }
        this.position = n;
        this.limit = this.elements.length;
    }

    private final void swap(int n, int n2) {
        T t = this.elements[n];
        this.elements[n] = this.elements[n2];
        this.elements[n2] = t;
    }

    public final void flip() {
        this.limit = this.position;
        this.position = 0;
    }

    public final boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final void position(int n) {
        this.position = n;
    }

    public final T[] getElements() {
        return this.elements;
    }
}

