/*
 * Decompiled with CFR 0.152.
 */
package components.input;

import components.input.AbstractSMSInputDevice;
import components.input.ButtonInputProvider;

public class SMSJoypad
extends AbstractSMSInputDevice {
    private static final int[][] BUTTON_IDENTIFIERS = new int[][]{{8, 9, 10, 11, 12, 13}, {14, 15, 16, 17, 18, 19}};
    protected ButtonInputProvider buttonInputProvider;
    private final int[] buttonIdentifiers;

    public SMSJoypad(int n, ButtonInputProvider buttonInputProvider) {
        this(n, buttonInputProvider, 0);
    }

    protected SMSJoypad(int n, ButtonInputProvider buttonInputProvider, int n2) {
        super(BUTTON_IDENTIFIERS[n & 1].length + n2);
        if (buttonInputProvider == null) {
            throw new IllegalArgumentException("buttonInputProvider must not be null");
        }
        this.buttonInputProvider = buttonInputProvider;
        this.buttonIdentifiers = BUTTON_IDENTIFIERS[n & 1];
    }

    protected int getButtonCount() {
        return this.buttonIdentifiers.length;
    }

    @Override
    public int readData(int n) {
        int n2 = 192;
        int n3 = 0;
        while (n3 < this.buttonIdentifiers.length) {
            if (!this.isButtonDown(n3)) {
                n2 |= 1 << n3;
            }
            ++n3;
        }
        return n2;
    }

    @Override
    protected boolean isButtonPressed(int n) {
        return this.buttonInputProvider.isButtonDown(this.buttonIdentifiers[n]);
    }
}

