/*
 * Decompiled with CFR 0.152.
 */
package util.queue;

import java.util.EmptyStackException;

public class CyclicLongStack {
    private final long[] elements;
    private final int MASK;
    private int head;
    private int tail;

    public CyclicLongStack(int n) {
        --n;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        if (++n < 0) {
            n >>>= 1;
        }
        this.elements = new long[n];
        this.MASK = this.elements.length - 1;
    }

    public void push(long l) {
        this.tail = this.tail + 1 & this.MASK;
        this.elements[this.tail] = l;
        if (this.tail == this.head) {
            this.head = this.head + 1 & this.MASK;
        }
    }

    public long peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.elements[this.tail];
    }

    public long pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        long l = this.elements[this.tail];
        this.tail = this.tail - 1 & this.MASK;
        return l;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public void clear() {
        this.tail = 0;
        this.head = 0;
    }
}

