/*
 * Decompiled with CFR 0.152.
 */
package treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import treetable.TreeTable;
import treetable.TreeTableModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private final TreeTable treeTable;
    protected int visibleRow;

    public TreeTableCellRenderer(final TreeTable treeTable, TreeTableModel treeTableModel) {
        super(treeTableModel);
        this.treeTable = treeTable;
        this.setRowHeight(this.getRowHeight());
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Color getTextSelectionColor() {
                return treeTable.getSelectionForeground();
            }

            @Override
            public Color getTextNonSelectionColor() {
                return treeTable.getForeground();
            }

            @Override
            public Color getBackgroundSelectionColor() {
                return treeTable.getSelectionBackground();
            }

            @Override
            public Color getBackgroundNonSelectionColor() {
                return treeTable.getBackground();
            }

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                return super.getTreeCellRendererComponent(jTree, ((TreeTableModel)jTree.getModel()).getValueAt(object, 0), bl, bl2, bl3, n, bl4);
            }
        });
    }

    @Override
    public void setRowHeight(int n) {
        if (n > 0) {
            super.setRowHeight(n);
            if (this.treeTable != null && this.treeTable.getRowHeight() != n) {
                this.treeTable.setRowHeight(n);
            }
            if (this.getCellRenderer() != null && this.getMaxIconHeight() != n - 2) {
                try {
                    this.scaleIcons((float)(n - 2) / (float)this.getMaxDefaultIconHeight());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private int getMaxIconHeight() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        if (defaultTreeCellRenderer == null) {
            return 0;
        }
        return Math.max(TreeTableCellRenderer.getIconHeight(defaultTreeCellRenderer.getOpenIcon()), Math.max(TreeTableCellRenderer.getIconHeight(defaultTreeCellRenderer.getClosedIcon()), TreeTableCellRenderer.getIconHeight(defaultTreeCellRenderer.getLeafIcon())));
    }

    private static int getIconHeight(Icon icon) {
        if (icon == null) {
            return 0;
        }
        return icon.getIconHeight();
    }

    private int getMaxDefaultIconHeight() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        if (defaultTreeCellRenderer == null) {
            return 0;
        }
        return Math.max(TreeTableCellRenderer.getIconHeight(defaultTreeCellRenderer.getDefaultOpenIcon()), Math.max(TreeTableCellRenderer.getIconHeight(defaultTreeCellRenderer.getDefaultClosedIcon()), TreeTableCellRenderer.getIconHeight(defaultTreeCellRenderer.getDefaultLeafIcon())));
    }

    private Icon scaleIcon(Icon icon, float f) {
        if (icon == null || (int)((float)icon.getIconWidth() * f) >= Integer.MAX_VALUE || (int)((float)icon.getIconHeight() * f) >= Integer.MAX_VALUE) {
            return icon;
        }
        BufferedImage bufferedImage = new BufferedImage(Math.round((float)icon.getIconWidth() * f), Math.round((float)icon.getIconHeight() * f), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(f, f);
        icon.paintIcon(this, graphics2D, 0, 0);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private void scaleIcons(float f) {
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        if (defaultTreeCellRenderer != null) {
            if (defaultTreeCellRenderer.getOpenIcon() != null) {
                defaultTreeCellRenderer.setOpenIcon(this.scaleIcon(defaultTreeCellRenderer.getDefaultOpenIcon(), f));
            }
            if (defaultTreeCellRenderer.getClosedIcon() != null) {
                defaultTreeCellRenderer.setClosedIcon(this.scaleIcon(defaultTreeCellRenderer.getDefaultClosedIcon(), f));
            }
            if (defaultTreeCellRenderer.getLeafIcon() != null) {
                defaultTreeCellRenderer.setLeafIcon(this.scaleIcon(defaultTreeCellRenderer.getDefaultLeafIcon(), f));
            }
        }
    }

    public void setHideIcons(boolean bl) {
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        if (defaultTreeCellRenderer != null) {
            defaultTreeCellRenderer.setOpenIcon(bl ? null : defaultTreeCellRenderer.getDefaultOpenIcon());
            defaultTreeCellRenderer.setClosedIcon(bl ? null : defaultTreeCellRenderer.getDefaultClosedIcon());
            defaultTreeCellRenderer.setLeafIcon(bl ? null : defaultTreeCellRenderer.getDefaultLeafIcon());
            this.setRowHeight(this.getCellRenderer().getTreeCellRendererComponent((JTree)this, (Object)this.treeTable.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (boolean)false, (int)0, (boolean)false).getPreferredSize().height);
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, 0, n3, this.treeTable.getHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(graphics);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Rectangle rectangle;
        if (bl) {
            this.setForeground(jTable.getSelectionForeground());
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setForeground(jTable.getForeground());
            this.setBackground(jTable.getBackground());
        }
        this.setFont(jTable.getFont());
        if (n2 == 0 && (rectangle = this.getUI().getPathBounds(this, this.getPathForRow(n))) != null) {
            Dimension dimension = this.getCellRenderer().getTreeCellRendererComponent(this, object, bl, false, false, n, bl2).getPreferredSize();
            dimension.width += rectangle.x;
            this.setPreferredSize(dimension);
        }
        this.visibleRow = n;
        return this;
    }
}

