/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger.messages;

import components.video.TMS9918A;
import expressions.Expression;
import expressions.FunctionProvider;
import expressions.ParseException;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import platform.debugger.SystemDebugger;
import platform.debugger.messages.MessageHandler;
import system.DebuggableSystem;
import system.EmulatableSystem;
import system.MSX;
import system.MasterSystem;

public class Z80MessageHandler
implements MessageHandler {
    private static Z80MessageHandler instance;
    private static final FunctionProvider functions;
    protected int counterReference;

    static {
        functions = new FunctionProvider(){

            @Override
            public int call(String string, int[] nArray) {
                return 0;
            }

            @Override
            public boolean isConstant(String string) {
                return true;
            }

            @Override
            public boolean isBoolean(String string) {
                return false;
            }
        };
    }

    Z80MessageHandler() {
    }

    public static Z80MessageHandler getInstance() {
        if (instance == null) {
            instance = new Z80MessageHandler();
        }
        return instance;
    }

    @Override
    public String handleMessage(EmulatableSystem emulatableSystem, String string) {
        int n = string.indexOf(37);
        int n2 = string.indexOf(37, n + 1);
        if ((string.indexOf(32, n + 1) & Integer.MAX_VALUE) > n2) {
            while (n2 >= 0) {
                int n3 = string.indexOf(59, n2 + 1);
                int n4 = string.indexOf(59, n3 + 1);
                int n5 = n4 > 0 ? (n2 = n4 + 1) : n2 + 1;
                string = String.valueOf(string.substring(0, n)) + this.evaluate((DebuggableSystem)emulatableSystem, string.substring(n + 1, n2)) + string.substring(Math.min(string.length(), n5));
                n = string.indexOf(37);
                n2 = string.indexOf(37, n + 1);
            }
        }
        return string;
    }

    private String evaluate(final DebuggableSystem debuggableSystem, String string) {
        if (string.isEmpty()) {
            return string;
        }
        if ("ZEROCLKS".equals(string)) {
            this.counterReference = this.getCounter(debuggableSystem);
            return "";
        }
        if ("ALLREGS".equals(string)) {
            return this.allRegsToString(debuggableSystem);
        }
        VariableProvider variableProvider = new VariableProvider(){

            @Override
            public int readValue(int n, boolean bl, boolean bl2) {
                return debuggableSystem.peekByte(n);
            }

            @Override
            public int readLocation(String string, int n, boolean bl) throws UnknownVariableException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getBankAt(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long mapBank(int n, int n2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConstantRead(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConstant(String string) throws UnknownVariableException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getValue(String string, boolean bl) throws UnknownVariableException {
                if (string.length() <= 2) {
                    String[] stringArray = debuggableSystem.getRegisterNames();
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].equalsIgnoreCase(string)) {
                            return debuggableSystem.getRegisterValue(n);
                        }
                        if (stringArray[n].length() == 2) {
                            if (stringArray[n].substring(0, 1).equalsIgnoreCase(string)) {
                                return debuggableSystem.getRegisterValue(n) >> 8;
                            }
                            if (stringArray[n].substring(1).equalsIgnoreCase(string)) {
                                return debuggableSystem.getRegisterValue(n) & 0xFF;
                            }
                        }
                        ++n;
                    }
                }
                if ("SCANLINE".equals(string)) {
                    return debuggableSystem.getScanline();
                }
                if ("ROMBANK".equals(string)) {
                    return Z80MessageHandler.this.getRomBank(debuggableSystem);
                }
                if ("SRAMBANK".equals(string)) {
                    return Z80MessageHandler.this.getSramBank(debuggableSystem);
                }
                if ("VRAMBANK".equals(string)) {
                    return Z80MessageHandler.this.getVramBank(debuggableSystem);
                }
                if ("WRAMBANK".equals(string)) {
                    return Z80MessageHandler.this.getWramBank(debuggableSystem);
                }
                if ("TOTALCLKS".equals(string)) {
                    return Z80MessageHandler.this.getCounter(debuggableSystem);
                }
                if ("CLKS2VBLANK".equals(string)) {
                    return Z80MessageHandler.this.calcCyclesUntilVBlank(debuggableSystem);
                }
                if ("LASTCLKS".equals(string)) {
                    return Z80MessageHandler.this.getCounter(debuggableSystem) - Z80MessageHandler.this.counterReference & Z80MessageHandler.this.getCounterMask(debuggableSystem);
                }
                throw new UnknownVariableException(string);
            }
        };
        if (string.charAt(string.length() - 1) == ';') {
            int n = string.indexOf(37);
            int n2 = string.indexOf(59, n);
            String string2 = string.substring(n + 1, n2);
            String string3 = string.substring(n2 + 1, string.indexOf(59, n2 + 1));
            string = string.substring(0, n);
            try {
                return new Expression(string.charAt(0) == '(' ? "@" + string : string, SystemDebugger.getTokenizer()).isTrue(variableProvider, functions) ? string2 : string3;
            }
            catch (UnknownVariableException unknownVariableException) {
                return string;
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        try {
            return String.format("%02X", new Expression(string.charAt(0) == '(' ? "@" + string : string, SystemDebugger.getTokenizer()).getValue(variableProvider, functions));
        }
        catch (UnknownVariableException unknownVariableException) {
            return string;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return string;
        }
    }

    protected String allRegsToString(DebuggableSystem debuggableSystem) {
        return String.format("af=%04X bc=%04X de=%04X hl=%04X ix=%04X iy=%04X sp=%04X pc=%04X", debuggableSystem.getRegisterValue(3), debuggableSystem.getRegisterValue(0), debuggableSystem.getRegisterValue(1), debuggableSystem.getRegisterValue(2), debuggableSystem.getRegisterValue(4), debuggableSystem.getRegisterValue(5), debuggableSystem.getRegisterValue(6), debuggableSystem.getPrevPC());
    }

    protected int calcCyclesUntilVBlank(DebuggableSystem debuggableSystem) {
        if (debuggableSystem instanceof MasterSystem) {
            return Z80MessageHandler.calcCyclesUntilVBlank((MasterSystem)debuggableSystem);
        }
        if (debuggableSystem instanceof MSX) {
            return Z80MessageHandler.calcCyclesUntilVBlank((MSX)debuggableSystem);
        }
        return 0;
    }

    private static int calcCyclesUntilVBlank(MasterSystem masterSystem) {
        boolean bl = masterSystem.getCyclesPerSecond() == 3546895;
        int n = bl ? 313 : 262;
        TMS9918A.State state = masterSystem.getState().getVDPstate();
        int n2 = state.getTimer();
        if (state.getLine() > 192) {
            return n2 + (n - state.getLine() - 1 + 192) * 228;
        }
        if (state.getLine() < 192) {
            return n2 + (192 - state.getLine() - 1) * 228;
        }
        return n2;
    }

    private static int calcCyclesUntilVBlank(MSX mSX) {
        boolean bl = mSX.getCyclesPerSecond() != 3579545;
        int n = bl ? 313 : 262;
        TMS9918A.State state = mSX.getState().getVDPstate();
        int n2 = state.getTimer();
        if (state.getLine() > 192) {
            return n2 + (n - state.getLine() - 1 + 192) * 228;
        }
        if (state.getLine() < 192) {
            return n2 + (192 - state.getLine() - 1) * 228;
        }
        return n2;
    }

    protected int getRomBank(DebuggableSystem debuggableSystem) {
        return debuggableSystem.getBank2();
    }

    protected int getSramBank(DebuggableSystem debuggableSystem) {
        return debuggableSystem.getSRAMbank();
    }

    protected int getVramBank(DebuggableSystem debuggableSystem) {
        return 0;
    }

    protected int getWramBank(DebuggableSystem debuggableSystem) {
        return 0;
    }

    protected int getCounter(DebuggableSystem debuggableSystem) {
        return debuggableSystem.getCyclesPerFrame() - this.calcCyclesUntilVBlank(debuggableSystem);
    }

    protected int getCounterMask(DebuggableSystem debuggableSystem) {
        return 131071;
    }
}

