/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger.messages;

import platform.debugger.messages.Z80MessageHandler;
import system.DebuggableSystem;
import system.GameBoy;
import system.GameBoyColor;

public final class BGBMessageHandler
extends Z80MessageHandler {
    private static BGBMessageHandler instance;

    private BGBMessageHandler() {
    }

    public static BGBMessageHandler getInstance() {
        if (instance == null) {
            instance = new BGBMessageHandler();
        }
        return instance;
    }

    @Override
    protected String allRegsToString(DebuggableSystem debuggableSystem) {
        return String.format("af=%04X bc=%04X de=%04X hl=%04X sp=%04X pc=%04X", debuggableSystem.getRegisterValue(3), debuggableSystem.getRegisterValue(0), debuggableSystem.getRegisterValue(1), debuggableSystem.getRegisterValue(2), debuggableSystem.getRegisterValue(4), debuggableSystem.getPrevPC());
    }

    @Override
    protected int getRomBank(DebuggableSystem debuggableSystem) {
        return debuggableSystem.getBank1();
    }

    @Override
    protected int getVramBank(DebuggableSystem debuggableSystem) {
        if (!(debuggableSystem instanceof GameBoyColor)) {
            return super.getVramBank(debuggableSystem);
        }
        GameBoyColor gameBoyColor = (GameBoyColor)debuggableSystem;
        return gameBoyColor.getState().getLCDstate().getRegVBK();
    }

    @Override
    protected int getWramBank(DebuggableSystem debuggableSystem) {
        if (!(debuggableSystem instanceof GameBoyColor)) {
            return super.getWramBank(debuggableSystem);
        }
        GameBoyColor gameBoyColor = (GameBoyColor)debuggableSystem;
        return gameBoyColor.getState().getRegSVBK();
    }

    @Override
    protected int calcCyclesUntilVBlank(DebuggableSystem debuggableSystem) {
        if (!(debuggableSystem instanceof GameBoy)) {
            return super.calcCyclesUntilVBlank(debuggableSystem);
        }
        GameBoy gameBoy = (GameBoy)debuggableSystem;
        return gameBoy.calcDotsUntilVBlank() >> 1;
    }

    @Override
    protected int getCounter(DebuggableSystem debuggableSystem) {
        if (!(debuggableSystem instanceof GameBoy)) {
            return super.getCounter(debuggableSystem);
        }
        GameBoy gameBoy = (GameBoy)debuggableSystem;
        return gameBoy.getState().getCounter() >> (gameBoy instanceof GameBoyColor && gameBoy.getState().isDoubleSpeed() ? 2 : 1);
    }

    @Override
    protected int getCounterMask(DebuggableSystem debuggableSystem) {
        if (!(debuggableSystem instanceof GameBoy)) {
            return super.getCounterMask(debuggableSystem);
        }
        GameBoy gameBoy = (GameBoy)debuggableSystem;
        return gameBoy instanceof GameBoyColor && gameBoy.getState().isDoubleSpeed() ? 65535 : 131071;
    }

    public static /* bridge */ /* synthetic */ Z80MessageHandler getInstance() {
        return BGBMessageHandler.getInstance();
    }
}

