/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import common.ScreenUtilities;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import platform.Emulicious;
import platform.debugger.PlotterIcons;
import platform.plotting.ArrayPlotModel;
import plotting.Plot;

class PlotterWindow {
    static final String[] TYPES = new String[]{"Signed 1 Byte", "Signed 2 Bytes", "Unsigned 1 Byte", "Unsigned 2 Bytes"};
    static final int[] TYPE_VALUES = new int[]{129, 130, 1, 2};
    private static PlotterWindow plotterWindow;
    private final ArrayPlotModel model;
    private final Plot plot;
    private final JPanel south;
    private final LinkedList<JPanel> rows = new LinkedList();
    private final LinkedList<JLabel> fillers = new LinkedList();
    private JPanel buttons;
    private JButton removeButton = new JButton(new PlotterIcons.RemoveIcon(true));
    final Window window;

    private PlotterWindow(Window window, int[] nArray, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Plotter");
        this.model = new ArrayPlotModel(nArray);
        this.plot = new Plot(this.model);
        this.window.add((Component)this.plot, "Center");
        this.plot.setMinX(0.0);
        this.plot.setMinY(-128.0);
        this.plot.setMaxY(127.0);
        this.plot.setMaxX(100.0);
        this.south = new JPanel();
        this.window.add((Component)this.south, "South");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotterWindow.this.removeDataRow();
            }
        });
        this.removeButton.setDisabledIcon(new PlotterIcons.RemoveIcon(false));
        JButton jButton = new JButton(new PlotterIcons.AddIcon(true));
        jButton.setDisabledIcon(new PlotterIcons.AddIcon(false));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotterWindow.this.addDataRow();
            }
        });
        this.buttons = new JPanel();
        this.buttons.add(jButton);
        this.buttons.add(this.removeButton);
        if (plotterWindow == null || !plotterWindow.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    void addDataRow() {
        this.addDataRow(null, null);
    }

    private void addDataRow(Integer n, Integer n2) {
        JComponent jComponent;
        final Plot plot = this.plot;
        final ArrayPlotModel arrayPlotModel = this.model;
        final int n3 = arrayPlotModel.getDataCount();
        if (!this.rows.isEmpty()) {
            this.rows.getLast().remove(this.buttons);
            jComponent = new JLabel();
            this.fillers.add((JLabel)jComponent);
            this.rows.getLast().add(jComponent);
        }
        this.south.setLayout(new GridLayout(n3 + 1, 1));
        jComponent = new JPanel(new GridLayout(1, 5));
        this.rows.add((JPanel)jComponent);
        final JTextField jTextField = new JTextField(8);
        if (n != null) {
            jTextField.setText(Integer.toHexString(n));
        }
        final JTextField jTextField2 = new JTextField(8);
        if (n2 != null) {
            jTextField2.setText(Integer.toHexString(n2));
        }
        final JTextField jTextField3 = new JTextField(3);
        jTextField3.setText("1");
        final JComboBox<String> jComboBox = new JComboBox<String>(TYPES);
        this.removeButton.setEnabled(n3 > 0);
        arrayPlotModel.add(n, n2);
        if (n != null && n2 != null) {
            plot.zoomFit();
        }
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    int n = Integer.parseInt(jTextField.getText(), 16);
                    arrayPlotModel.setStart(n3, n);
                    if (n3 == 0) {
                        plot.scrollDataPointToVisible(n, arrayPlotModel.getY(n3, n));
                    }
                }
                catch (Exception exception) {}
            }
        });
        jTextField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    arrayPlotModel.setEnd(n3, Integer.parseInt(jTextField2.getText(), 16));
                    if (n3 == 0) {
                        plot.scrollDataPointToVisible(Integer.parseInt(jTextField.getText(), 16), arrayPlotModel.getY(n3, Integer.parseInt(jTextField.getText(), 16)));
                    }
                }
                catch (Exception exception) {}
            }
        });
        jTextField3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    arrayPlotModel.setStepSize(n3, Integer.parseInt(jTextField3.getText()));
                    plot.scrollDataPointToVisible(Integer.parseInt(jTextField.getText(), 16), 0.0);
                }
                catch (Exception exception) {}
            }
        });
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    arrayPlotModel.setDataType(n3, TYPE_VALUES[jComboBox.getSelectedIndex()]);
                    plot.scrollDataPointToVisible(Integer.parseInt(jTextField.getText(), 16), 0.0);
                }
                catch (Exception exception) {}
            }
        });
        JPanel jPanel = new JPanel();
        jComponent.add(jPanel);
        jPanel.add(new JLabel("Start"));
        jPanel.add(jTextField);
        JPanel jPanel2 = new JPanel();
        jComponent.add(jPanel2);
        jPanel2.add(new JLabel("End"));
        jPanel2.add(jTextField2);
        JPanel jPanel3 = new JPanel();
        jComponent.add(jPanel3);
        jPanel3.add(new JLabel("Stepsize"));
        jPanel3.add(jTextField3);
        JPanel jPanel4 = new JPanel();
        jComponent.add(jPanel4);
        jPanel4.add(new JLabel("Type"));
        jPanel4.add(jComboBox);
        jComponent.add(this.buttons);
        this.south.add(jComponent);
        this.window.pack();
    }

    void removeDataRow() {
        if (this.model.getDataCount() > 1) {
            this.model.removeLast();
            this.south.remove(this.rows.pollLast());
            this.rows.getLast().remove(this.fillers.pollLast());
            this.rows.getLast().add(this.buttons);
            this.south.setLayout(new GridLayout(this.model.getDataCount(), 1));
            this.removeButton.setEnabled(this.model.getDataCount() > 1);
            this.window.pack();
        }
    }

    public static void update() {
        if (plotterWindow != null) {
            PlotterWindow.plotterWindow.model.firePlotModelChanged();
        }
    }

    public static void open(Window window, int[] nArray, boolean bl) {
        PlotterWindow.open(window, nArray, null, null, bl);
    }

    public static void open(Window window, int[] nArray, Integer n, Integer n2, boolean bl) {
        if (plotterWindow == null) {
            plotterWindow = new PlotterWindow(window, nArray, Emulicious.isUseFrames());
            PlotterWindow.plotterWindow.window.setIconImages(window.getIconImages());
            plotterWindow.addDataRow(n, n2);
            plotterWindow.setVisible(true);
        } else {
            if (!bl) {
                plotterWindow.setVisible(true);
            }
            if (n != null) {
                plotterWindow.addDataRow(n, n2);
            }
        }
    }

    public static void close() {
        if (plotterWindow != null) {
            Emulicious.getProperties().setProperty("Window" + plotterWindow.getClass().getSimpleName() + "Open", "" + plotterWindow.isVisible());
            Emulicious.getProperties().setProperty("Window" + plotterWindow.getClass().getSimpleName() + "X", "" + plotterWindow.getX());
            Emulicious.getProperties().setProperty("Window" + plotterWindow.getClass().getSimpleName() + "Y", "" + plotterWindow.getY());
            Emulicious.getProperties().setProperty("Window" + plotterWindow.getClass().getSimpleName() + "Width", "" + plotterWindow.getWidth());
            Emulicious.getProperties().setProperty("Window" + plotterWindow.getClass().getSimpleName() + "Height", "" + plotterWindow.getHeight());
            plotterWindow.dispose();
            plotterWindow = null;
        }
    }
}

