/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import java.awt.Desktop;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import platform.Emulicious;
import platform.debugger.Debugger;
import platform.debugger.IsConstantException;
import replay.ParseException;
import replay.ParseExceptionHandler;
import testing.AssertionChecker;
import testing.Bk2TestCaseRunner;
import testing.MultiTestCaseRunner;
import testing.TestCaseExecutor;
import testing.TestCaseRunner;

public class DebuggerTestCaseExecutor
implements TestCaseExecutor,
AssertionChecker,
ParseExceptionHandler {
    private final Debugger debugger;
    private final Window debuggerWindow;
    private TestCaseRunner testCaseRunner;
    private File testCaseDir;

    public DebuggerTestCaseExecutor(Window window, Debugger debugger) {
        this.debuggerWindow = window;
        this.debugger = debugger;
    }

    @Override
    public TestCaseRunner executeTestCase(File file) throws IOException {
        Bk2TestCaseRunner bk2TestCaseRunner = new Bk2TestCaseRunner(file, this);
        Emulicious.replayInputLog(bk2TestCaseRunner.getInputLog(), this);
        return bk2TestCaseRunner;
    }

    private void runTestCase(File file) throws IOException {
        if (file.isDirectory()) {
            this.testCaseRunner = new MultiTestCaseRunner(file, this);
            this.testCaseDir = file;
        } else {
            this.testCaseRunner = this.executeTestCase(file);
            this.testCaseDir = file.getParentFile();
        }
        this.debugger.resume();
        Emulicious.toTop();
    }

    @Override
    public boolean checkAssertion(String string) throws Exception {
        Debugger.Expression expression = this.debugger.parseExpression(string);
        if (expression.isConstant()) {
            throw new IsConstantException(expression.isTrue() ? "true" : "false");
        }
        return expression.isTrue();
    }

    @Override
    public void handleParseException(ParseException parseException) {
        throw new RuntimeException(parseException);
    }

    public void frameFinished() {
        if (this.testCaseRunner != null) {
            this.testCaseRunner.frameStarted();
            if (!this.testCaseRunner.isRunning()) {
                this.debugger.suspend();
                this.writeAndShowTestResults(this.testCaseRunner);
                this.testCaseRunner = null;
            }
        }
    }

    void showTestCaseFileChooser() {
        JFileChooser jFileChooser = new JFileChooser(Emulicious.getROMfile().getParentFile());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Testcase (*.zip)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".zip") || file.isDirectory();
            }
        });
        if (jFileChooser.showOpenDialog(this.debuggerWindow) == 0) {
            try {
                this.runTestCase(jFileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.debuggerWindow, iOException.getMessage(), "Failed to load input log", 0);
            }
        }
    }

    void showMultiTestCaseFileChooser() {
        JFileChooser jFileChooser = new JFileChooser(Emulicious.getROMfile().getParentFile());
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(this.debuggerWindow) == 0) {
            try {
                this.runTestCase(jFileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void writeAndShowTestResults(TestCaseRunner testCaseRunner) {
        this.showTestResults(testCaseRunner, this.writeTestResults(testCaseRunner));
    }

    private File writeTestResults(TestCaseRunner testCaseRunner) {
        int n;
        MultiTestCaseRunner multiTestCaseRunner;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyyMMdd-HHmmss");
        File file = new File(this.testCaseDir, "reports");
        file.mkdir();
        String string = Emulicious.getROMfile().getName();
        int n2 = string.lastIndexOf(46);
        String string2 = n2 >= 0 ? string.substring(0, n2) : string;
        Date date = new Date();
        File file2 = new File(file, String.valueOf(string2) + " " + simpleDateFormat2.format(date) + ".html");
        int n3 = 0;
        int n4 = 0;
        if (testCaseRunner instanceof MultiTestCaseRunner) {
            multiTestCaseRunner = (MultiTestCaseRunner)testCaseRunner;
            n = multiTestCaseRunner.getNumberOfTestCases();
            int n5 = 0;
            while (n5 < n) {
                int n6 = multiTestCaseRunner.getResult(n5);
                if (n6 > 0) {
                    ++n3;
                }
                if (n6 < 0) {
                    ++n4;
                }
                ++n5;
            }
        } else {
            multiTestCaseRunner = null;
            n = 1;
            if (testCaseRunner.getResult() > 0) {
                ++n3;
            } else if (testCaseRunner.getResult() < 0) {
                ++n4;
            }
        }
        String string3 = "Pass " + (n - n3 - n4) + " Failure " + n3 + " Error " + n4;
        String[] stringArray = new String[]{"Testcase", "Result", "Frame", "Detail"};
        String[] stringArray2 = new String[]{"Error", "Success", "Failure"};
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file2)));
            printStream.println("<html>");
            printStream.println("<head>");
            printStream.println("<link type=\"text/css\" rel=\"stylesheet\" href=\"report.css\"");
            printStream.println("</head>");
            printStream.println("<h1>Emulicious Test Report</h1>");
            printStream.println("<p><b>File:</b> " + string2 + "</p>");
            printStream.println("<p><b>Start Time:</b> " + simpleDateFormat.format(date) + "</p>");
            printStream.println("<p><b>Status:</b> " + string3 + "</p>");
            printStream.println("<table class=\"report\">");
            printStream.println("<thead>");
            printStream.println("<tr>");
            String[] stringArray3 = stringArray;
            int n7 = stringArray.length;
            int n8 = 0;
            while (n8 < n7) {
                String string4 = stringArray3[n8];
                printStream.println("<th>" + string4 + "</th>");
                ++n8;
            }
            printStream.println("</tr>");
            printStream.println("</thead>");
            printStream.println("<tbody>");
            int n9 = 0;
            while (n9 < n) {
                n8 = multiTestCaseRunner != null ? multiTestCaseRunner.getResult(n9) : testCaseRunner.getResult();
                printStream.println("<tr class=\"" + stringArray2[n8 + 1].toLowerCase() + "\">");
                printStream.println("<td>" + (multiTestCaseRunner != null ? multiTestCaseRunner.getTestCaseName(n9) : testCaseRunner.getTestCaseName()) + "</td>");
                printStream.println("<td>" + stringArray2[n8 + 1] + "</td>");
                printStream.println("<td>" + ((multiTestCaseRunner != null ? multiTestCaseRunner.getFrame(n9) : testCaseRunner.getFrame()) - 1) + "</td>");
                if (n8 > 0) {
                    printStream.println("<td>Assertion failed: " + (multiTestCaseRunner != null ? multiTestCaseRunner.getFailedAssertion(n9) : testCaseRunner.getFailedAssertion()) + "</td>");
                } else if (n8 < 0) {
                    printStream.println("<td>" + (multiTestCaseRunner != null ? multiTestCaseRunner.getException(n9).getMessage() : testCaseRunner.getException().getMessage()) + "</td>");
                } else {
                    printStream.println("<td></td>");
                }
                printStream.println("</tr>");
                ++n9;
            }
            printStream.println("</tbody>");
            printStream.println("</table>");
            printStream.println("</html>");
            printStream.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.debuggerWindow, "Failed to write report to file " + file2 + "\n" + iOException.getMessage());
        }
        return file2;
    }

    private void showTestResults(TestCaseRunner testCaseRunner, File file) {
        int n;
        Object object;
        if (testCaseRunner instanceof MultiTestCaseRunner) {
            int n2;
            object = (MultiTestCaseRunner)testCaseRunner;
            int n3 = ((MultiTestCaseRunner)object).getNumberOfTestCases();
            int n4 = 0;
            boolean bl = false;
            int n5 = 0;
            while (n5 < n3) {
                n2 = ((MultiTestCaseRunner)object).getResult(n5);
                if (n2 != 0) {
                    ++n4;
                }
                if (n2 < 0) {
                    bl = true;
                }
                ++n5;
            }
            if (n4 == 0) {
                n = JOptionPane.showConfirmDialog(this.debuggerWindow, "All " + n3 + " Test Cases finished without errors!", "Test Cases successful", 0, 1);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(n4).append(" / ").append(n3).append(" Test Cases failed.").append("\n\n");
                stringBuilder.append("The following Test Cases failed:\n");
                n2 = 0;
                int n6 = 0;
                while (n6 < n3) {
                    int n7 = ((MultiTestCaseRunner)object).getResult(n6);
                    if (n7 != 0) {
                        if (n2++ >= 10) {
                            stringBuilder.append("...\n");
                            break;
                        }
                        stringBuilder.append("- ").append(((MultiTestCaseRunner)object).getTestCaseName(n6)).append(" (");
                        if (n7 < 0) {
                            stringBuilder.append(((MultiTestCaseRunner)object).getException(n6).getMessage());
                        } else {
                            stringBuilder.append("Assertion failed: " + ((MultiTestCaseRunner)object).getFailedAssertion(n6));
                        }
                        stringBuilder.append(")\n");
                    }
                    ++n6;
                }
                stringBuilder.append("\nReport saved to\n" + file + "\n\n");
                stringBuilder.append("Do you want to open it now?");
                n = JOptionPane.showConfirmDialog(this.debuggerWindow, stringBuilder.toString(), "Test Cases failed", 0, bl ? 0 : 2);
            }
        } else {
            n = testCaseRunner.getResult() == 0 ? JOptionPane.showConfirmDialog(this.debuggerWindow, "Test Case finished without errors!\n\nReport saved to\n" + file + "\n\nDo you want to open it now?", "Test Case successful", 0, 1) : (testCaseRunner.getResult() > 0 ? JOptionPane.showConfirmDialog(this.debuggerWindow, "Test Case failed because an assertion failed!\n" + testCaseRunner.getFailedAssertion() + "\n\nReport saved to\n" + file + "\n\nDo you want to open it now?", "Test Case failed", 0, 2) : JOptionPane.showConfirmDialog(this.debuggerWindow, "Test Case failed because an error occurred!\n" + testCaseRunner.getException().getMessage() + "\n\nReport saved to\n" + file + "\n\nDo you want to open it now?", "Test Case failed", 0, 0));
        }
        if (n == 0 && ((Desktop)(object = Desktop.getDesktop())).isSupported(Desktop.Action.BROWSE)) {
            try {
                ((Desktop)object).browse(file.toURI());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

