/*
 * Decompiled with CFR 0.152.
 */
package platform;

import components.cartridge.GBCartridge;
import components.sound.GBSoundController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import patching.IPS;

public class StdioVinGBCartridge
extends GBCartridge
implements GBSoundController.VinProvider {
    private static final String[] A_HEX_STRINGS = new String[65536];
    private static final String[] HEX_STRINGS = new String[65536];
    private static final String[] HEX_STRINGS2 = new String[256];
    private final Process process;
    private final PrintStream out;
    private final InputStream in;
    final PrintStream errorStream;
    private boolean running;
    private final byte[] wordBuffer = new byte[4];
    private int advancedCycles;
    private int samples;

    static {
        int n = 0;
        while (n < HEX_STRINGS.length) {
            StdioVinGBCartridge.A_HEX_STRINGS[n] = String.format("a%04X", n);
            StdioVinGBCartridge.HEX_STRINGS[n] = A_HEX_STRINGS[n].substring(1);
            ++n;
        }
        n = 0;
        while (n < HEX_STRINGS2.length) {
            StdioVinGBCartridge.HEX_STRINGS2[n] = HEX_STRINGS[n].substring(2);
            ++n;
        }
    }

    public StdioVinGBCartridge(String string, IPS iPS, final Process process, PrintStream printStream, final Runnable runnable) throws IOException {
        super(string, iPS);
        this.process = process;
        this.out = new PrintStream(process.getOutputStream(), true);
        this.in = process.getInputStream();
        if (printStream == null) {
            printStream = System.err;
        }
        this.errorStream = printStream;
        this.running = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        StdioVinGBCartridge.this.errorStream.println(string);
                        string = bufferedReader.readLine();
                    }
                    StdioVinGBCartridge.this.errorStream.println("GBVinCartridgeProcess exited with exit code " + process.exitValue() + ".");
                    StdioVinGBCartridge.this.running = false;
                    if (runnable != null) {
                        runnable.run();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, "GBVinCartridgeProcess stderr reader").start();
    }

    @Override
    public void processWrite(int n, int n2, int n3) {
        super.processWrite(n, n2, n3);
        if (this.running) {
            this.out.println("w" + HEX_STRINGS[n] + HEX_STRINGS2[n2]);
            try {
                this.readAck();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void shutdown() {
        this.process.destroy();
    }

    private void readAck() throws IOException {
        long l = System.currentTimeMillis();
        while (this.in.available() <= 0 && System.currentTimeMillis() - l < 1000L) {
            Thread.yield();
        }
        if (this.in.available() > 0) {
            this.in.read();
        } else {
            this.errorStream.println("GBVinCartridgeProcess failed to send ACK within 1 second after write request.");
        }
    }

    private int readWord() throws IOException {
        long l = System.currentTimeMillis();
        int n = 0;
        while (System.currentTimeMillis() - l < 16L && n >= 0 && n < this.wordBuffer.length) {
            n += this.in.available() > 0 ? this.in.read(this.wordBuffer, n, this.wordBuffer.length - n) : 0;
            Thread.yield();
        }
        if (n < 0) {
            return 0;
        }
        try {
            if (n != this.wordBuffer.length) {
                throw new NumberFormatException();
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4;
                n2 <<= 4;
                byte by = this.wordBuffer[n3];
                int n5 = by >= 97 ? by - 97 + 10 : (n4 = by >= 65 ? by - 65 + 10 : by - 48);
                if (n4 < 0 || n4 >= 16) {
                    throw new NumberFormatException();
                }
                n2 |= n4;
                ++n3;
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            String string = (String.valueOf(Character.toString((char)this.wordBuffer[0])) + (char)this.wordBuffer[1] + (char)this.wordBuffer[2] + (char)this.wordBuffer[3]).substring(0, n);
            this.errorStream.println("GBVinCartridgeProcess failed to send requested word. Expected 4 hex characters but received: \"" + string + "\"");
            return 0;
        }
    }

    private void flush() {
        try {
            int n = this.in.available();
            while (n > 0) {
                this.in.read();
                --n;
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public void preAdvance(int n) {
        if (this.running) {
            if (this.advancedCycles == 0) {
                this.flush();
            }
            this.out.println(A_HEX_STRINGS[n]);
            this.advancedCycles += n;
        }
    }

    @Override
    public void advance(int n) {
        if (!this.running) {
            this.samples = 0;
            return;
        }
        if (n > 0) {
            try {
                this.samples = this.readWord();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.advancedCycles -= n;
        }
    }

    @Override
    public int getSamples() {
        return this.samples;
    }
}

