/*
 * Decompiled with CFR 0.152.
 */
package platform;

import components.communication.GearToGear;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import system.GameGear;

public class StdioGearToGear
implements GearToGear {
    private static final String[] HEX_STRINGS = new String[65536];
    private static final String[] HEX_STRINGS2 = new String[256];
    private final Process process;
    private final PrintStream out;
    private final InputStream in;
    final PrintStream errorStream;
    private final byte[] byteBuffer = new byte[2];
    private int cycleCount;

    static {
        int n = 0;
        while (n < HEX_STRINGS.length) {
            StdioGearToGear.HEX_STRINGS[n] = String.format("%04X", n);
            ++n;
        }
        n = 0;
        while (n < HEX_STRINGS2.length) {
            StdioGearToGear.HEX_STRINGS2[n] = HEX_STRINGS[n].substring(2);
            ++n;
        }
    }

    public StdioGearToGear(final GameGear gameGear, final Process process, PrintStream printStream, final Runnable runnable) {
        this.process = process;
        this.out = new PrintStream(process.getOutputStream(), true);
        this.in = process.getInputStream();
        if (printStream == null) {
            printStream = System.err;
        }
        this.errorStream = printStream;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        if ("NMI".equals(string)) {
                            if (!gameGear.assertNmi()) {
                                StdioGearToGear.this.errorStream.println("Failed to assert NMI because an NMI is still pending.");
                            }
                        } else {
                            StdioGearToGear.this.errorStream.println(string);
                        }
                        string = bufferedReader.readLine();
                    }
                    StdioGearToGear.this.errorStream.println("GearToGearProcess exited with exit code " + process.exitValue() + ".");
                    if (runnable != null) {
                        runnable.run();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, "GearToGearProcess stderr reader").start();
    }

    @Override
    public int readPort(int n, int n2) {
        this.flush();
        this.out.println("r" + n + HEX_STRINGS[(n2 += this.cycleCount) >>> 16] + HEX_STRINGS[n2 & 0xFFFF]);
        try {
            return this.readByte();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 255;
        }
    }

    @Override
    public void writePort(int n, int n2, int n3) {
        this.flush();
        this.out.println("w" + n + HEX_STRINGS2[n2] + HEX_STRINGS[(n3 += this.cycleCount) >>> 16] + HEX_STRINGS[n3 & 0xFFFF]);
        try {
            this.readAck();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void update(int n) {
        this.cycleCount += n;
    }

    @Override
    public void shutdown() {
        this.process.destroy();
    }

    private void readAck() throws IOException {
        long l = System.currentTimeMillis();
        while (this.in.available() <= 0 && System.currentTimeMillis() - l < 1000L) {
            Thread.yield();
        }
        if (this.in.available() > 0) {
            this.in.read();
        } else {
            this.errorStream.println("GearToGearProcess failed to send ACK within 1 second after write request.");
        }
    }

    private int readByte() throws IOException {
        long l = System.currentTimeMillis();
        int n = 0;
        while (System.currentTimeMillis() - l < 16L && n >= 0 && n < this.byteBuffer.length) {
            n += this.in.available() > 0 ? this.in.read(this.byteBuffer, n, this.byteBuffer.length - n) : 0;
            Thread.yield();
        }
        if (n < 0) {
            return 255;
        }
        try {
            if (n != this.byteBuffer.length) {
                throw new NumberFormatException();
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4;
                n2 <<= 4;
                byte by = this.byteBuffer[n3];
                int n5 = by >= 97 ? by - 97 + 10 : (n4 = by >= 65 ? by - 65 + 10 : by - 48);
                if (n4 < 0 || n4 >= 16) {
                    throw new NumberFormatException();
                }
                n2 |= n4;
                ++n3;
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            String string = (String.valueOf(Character.toString((char)this.byteBuffer[0])) + (char)this.byteBuffer[1]).substring(0, n);
            this.errorStream.println("GearToGearProcess failed to send requested byte. Expected 2 hex characters but received: \"" + string + "\"");
            return 255;
        }
    }

    private void flush() {
        try {
            int n = this.in.available();
            while (n > 0) {
                this.in.read();
                --n;
            }
        }
        catch (IOException iOException) {}
    }
}

