/*
 * Decompiled with CFR 0.152.
 */
package output;

import components.sound.SMSAudioMixer;
import components.sound.SN76489;
import components.sound.YM2413;
import java.util.Arrays;
import platform.SoundOutput;

public class SMSSoundOutput
extends SoundOutput {
    private static final String[] CHANNEL_NAMES = new String[]{"Square Wave Channel 1", "Square Wave Channel 2", "Square Wave Channel 3", "Noise Channel", "FM Chip"};
    private static final int[] CHANNEL_MIN_VALUES;
    private static final int[] CHANNEL_MAX_VALUES;
    private SN76489 psg;
    private YM2413 fm;
    private SMSAudioMixer audioMixer;
    private int prevCycles;
    private int subSampleCycles;
    private double sampleError;
    private double cyclesPerSample;
    private final int sampleRate;
    private float[] fmSampleBuffer;
    private final float[][] fmSamples = new float[14][];
    private int fmSubCycles;
    private float fmSample;
    private int fmAmplitude;
    private int fmPos;
    private int fmSamplesProduced;
    private final int channels;
    private boolean[] channelMuted;
    private int throttle = 100;
    private int[] sample;

    static {
        int[] nArray = new int[5];
        nArray[4] = -3072;
        CHANNEL_MIN_VALUES = nArray;
        CHANNEL_MAX_VALUES = new int[]{2048, 2048, 2048, 2048, 3072};
    }

    public SMSSoundOutput(String string, int n, int n2, int n3) {
        super(string, n, n2, n3);
        this.sampleRate = n;
        this.channels = n3;
    }

    private void setPSG(SN76489 sN76489) {
        this.psg = sN76489;
        this.channelMuted = new boolean[this.getNumberOfChannels()];
        this.sample = new int[this.getNumberOfChannels()];
        this.buffer = new byte[this.getBufferSize()];
        this.updateCyclesPerSample(this.throttle);
    }

    private void setFM(YM2413 yM2413) {
        this.fm = yM2413;
        if (yM2413 != null) {
            this.fmSampleBuffer = new float[(int)Math.ceil((double)this.psg.getCyclesPerSecond() / (double)this.psg.getFramesPerSecond() / 72.0)];
        }
        this.channelMuted = new boolean[this.getNumberOfChannels()];
        this.sample = new int[this.getNumberOfChannels()];
    }

    public void setAudioMixer(SMSAudioMixer sMSAudioMixer) {
        this.audioMixer = sMSAudioMixer;
        this.setPSG(sMSAudioMixer.getPSG());
        this.setFM(sMSAudioMixer.getFM());
    }

    @Override
    public void setChannelMuted(int n, boolean bl) {
        if (n >= 0 && n < this.channelMuted.length) {
            this.channelMuted[n] = bl;
        }
    }

    @Override
    public String[] getChannelNames() {
        return CHANNEL_NAMES;
    }

    @Override
    public int[] getChannelMinValues() {
        return CHANNEL_MIN_VALUES;
    }

    @Override
    public int[] getChannelMaxValues() {
        return CHANNEL_MAX_VALUES;
    }

    @Override
    protected void updateCyclesPerSample(int n) {
        if (this.psg != null) {
            double d = (double)(this.psg.getCyclesPerSecond() * n / 100) / (double)this.sampleRate;
            if (d >= 1.0) {
                this.cyclesPerSample = d;
            } else {
                System.err.println("Updating cycles per sample with throttle " + n + " would have lead to " + d);
                return;
            }
        }
        this.throttle = n;
    }

    public void updateBuffer(int n) {
        int n2;
        int n3 = (int)this.cyclesPerSample;
        int n4 = n - this.prevCycles;
        int n5 = this.getNumberOfChannels();
        if (this.fm != null) {
            this.fmPos = 0;
            n2 = Math.min(this.fmSampleBuffer.length, n4 / 72 + (n4 % 72 >= this.fmSubCycles ? 1 : 0));
            if (n2 > 0) {
                Arrays.fill(this.fmSampleBuffer, 0, n2, 0.0f);
                Arrays.fill((Object[])this.fmSamples, this.fmSampleBuffer);
                this.fm.generateChannels(this.fmSamples, n2);
            }
            this.fmSamplesProduced = n2;
        }
        while (n4 >= n3 - this.subSampleCycles) {
            n2 = 0;
            int n6 = 0;
            this.sampleError += this.cyclesPerSample - (double)n3;
            if (this.sampleError >= 1.0) {
                --this.subSampleCycles;
                this.sampleError -= 1.0;
            }
            int n7 = Math.max(0, n3 - this.subSampleCycles);
            int n8 = Math.max(n3, n7);
            this.advance(n7);
            n4 -= n7;
            int n9 = 0;
            while (n9 < n5) {
                int n10 = (this.sample[n9] + this.getSamples(n9)) / n8;
                this.sample[n9] = 0;
                this.fireAmplitude(n9, false, n10);
                if (this.channels > 1) {
                    this.fireAmplitude(n9, true, n10);
                }
                if (!this.channelMuted[n9]) {
                    if (this.isLeftEnabled(n9)) {
                        n2 += n10;
                    }
                    if (this.isRightEnabled(n9)) {
                        n6 += n10;
                    }
                }
                ++n9;
            }
            if (this.soundEnabled) {
                this.writeSample16bit(n2);
                if (this.channels > 1) {
                    this.writeSample16bit(n6);
                }
            }
            this.subSampleCycles = 0;
        }
        if (n4 > 0) {
            this.advance(n4);
            n2 = 0;
            while (n2 < n5) {
                int n11 = n2;
                this.sample[n11] = this.sample[n11] + this.getSamples(n2);
                ++n2;
            }
            this.subSampleCycles += n4;
        }
        this.prevCycles = n;
    }

    protected void advance(int n) {
        this.psg.advanceChannels(n);
        if (this.fm != null) {
            this.advanceFm(n);
        }
    }

    protected int getNumberOfChannels() {
        return this.fm != null ? 5 : 4;
    }

    protected int getSamples(int n) {
        if (n == 4) {
            return this.fmAmplitude;
        }
        return this.psg.getSamples(n);
    }

    protected boolean isLeftEnabled(int n) {
        return n >= 4 && this.audioMixer.isFmEnabled() || this.audioMixer.isPsgEnabled() && this.psg.isChannelEnabled(false, n);
    }

    protected boolean isRightEnabled(int n) {
        return n >= 4 && this.audioMixer.isFmEnabled() || this.audioMixer.isPsgEnabled() && this.psg.isChannelEnabled(true, n);
    }

    private void advanceFm(int n) {
        float f = this.fmSample * (float)this.fmSubCycles;
        this.fmSubCycles -= n;
        while (this.fmSubCycles <= 0) {
            if (this.fmPos < this.fmSamplesProduced) {
                this.fmSample = this.fmSampleBuffer[this.fmPos++];
            } else {
                this.fmSampleBuffer[0] = 0.0f;
                Arrays.fill((Object[])this.fmSamples, this.fmSampleBuffer);
                this.fm.generateChannels(this.fmSamples, 1);
            }
            f += this.fmSample * 72.0f;
            this.fmSubCycles += 72;
        }
        this.fmAmplitude = (int)(f -= this.fmSample * (float)this.fmSubCycles);
    }

    public void finishFrame() {
        this.play();
        this.prevCycles = 0;
    }
}

