/*
 * Decompiled with CFR 0.152.
 */
package msx;

import components.sound.YM2413;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import msx.MSXDevice;
import util.io.IOUtilities;

public class MSXFmPac
implements MSXDevice {
    private final byte[] rom;
    private final String ramFilename;
    private final YM2413 fm;
    private int[] ram = new int[8192];
    private int bank;
    private int enable;
    private boolean ramChanged;

    public MSXFmPac(File file, YM2413 yM2413, String string) throws FileNotFoundException, IOException {
        this.rom = IOUtilities.toByteArray(new FileInputStream(file));
        this.ramFilename = string;
        this.fm = yM2413;
        this.readRAMfromFile();
    }

    @Override
    public int readByte(int n, int n2) {
        switch (n &= 0x3FFF) {
            case 16374: {
                return this.enable;
            }
            case 16375: {
                return this.bank;
            }
        }
        if (this.isRamEnabled()) {
            if (n < this.ram.length) {
                return this.ram[n];
            }
            return 255;
        }
        return this.rom[this.bank * 16384 | n] & 0xFF;
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        switch (n &= 0x3FFF) {
            case 16372: 
            case 16373: {
                if ((this.enable & 1) == 0) break;
                this.fm.processInput(n & 1, n2, n3);
                break;
            }
            case 16374: {
                this.enable = n2 & 0x11;
                if ((n2 & 0x10) == 0) break;
                this.ram[8191] = 0;
                this.ram[8190] = 0;
                break;
            }
            case 16375: {
                this.bank = n2 & 3;
                break;
            }
            default: {
                if (n >= this.ram.length || !this.isRamEnabled() && n < 8190) break;
                if (this.ram[n] != n2) {
                    this.ramChanged = true;
                }
                this.ram[n] = n2;
            }
        }
    }

    @Override
    public void reset() {
        this.enable = 0;
        this.bank = 0;
        this.ram[8191] = 0;
        this.ram[8190] = 0;
    }

    public int[] getRAM() {
        return this.ram;
    }

    private boolean isRamEnabled() {
        return this.ram[8190] == 77 && this.ram[8191] == 105;
    }

    @Override
    public int getByte(int n) {
        return this.readByte(n, 0);
    }

    public void shutdown() {
        this.writeRAMtoFile();
    }

    private boolean readRAMfromFile() {
        try {
            byte[] byArray = IOUtilities.toByteArray(new FileInputStream(this.ramFilename));
            this.ram = new int[byArray.length];
            int n = 0;
            while (n < this.ram.length) {
                this.ram[n] = byArray[n] & 0xFF;
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    private void writeRAMtoFile() {
        if (!this.ramChanged) {
            return;
        }
        if (this.ramFilename != null) {
            try {
                File file = new File(this.ramFilename);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[this.ram.length];
                int n = 0;
                while (n < byArray.length) {
                    byArray[n] = (byte)this.ram[n];
                    ++n;
                }
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.ramChanged = false;
    }
}

