/*
 * Decompiled with CFR 0.152.
 */
package expressions;

import expressions.ASTNode;
import expressions.Expression;
import expressions.FunctionProvider;
import expressions.ParseException;
import expressions.Tokenizer;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FormatStringExpression
extends Expression {
    private final CharSequence format;

    public FormatStringExpression(CharSequence charSequence, Tokenizer tokenizer) throws ParseException {
        super(FormatStringExpression.getExpression(charSequence), tokenizer);
        this.format = FormatStringExpression.getFormat(charSequence);
    }

    private FormatStringExpression(ASTNode aSTNode, CharSequence charSequence) {
        super(aSTNode);
        this.format = charSequence;
    }

    private static CharSequence getExpression(CharSequence charSequence) {
        int n = 0;
        while (n < charSequence.length() && charSequence.charAt(n) != ':') {
            ++n;
        }
        return charSequence.subSequence(n < charSequence.length() ? n + 1 : 0, charSequence.length());
    }

    private static CharSequence getFormat(CharSequence charSequence) {
        int n = 0;
        while (n < charSequence.length() && charSequence.charAt(n) != ':') {
            ++n;
        }
        return n < charSequence.length() ? charSequence.subSequence(0, n) : null;
    }

    @Override
    public Expression optimize(VariableProvider variableProvider, FunctionProvider functionProvider, boolean bl) throws UnknownVariableException {
        return new FormatStringExpression(FormatStringExpression.optimize(this.root, variableProvider, functionProvider, bl), this.format);
    }

    @Override
    public String getValueString(VariableProvider variableProvider, FunctionProvider functionProvider) {
        block31: {
            if (this.format == null) {
                return super.getValueString(variableProvider, functionProvider);
            }
            try {
                boolean bl;
                int n = 0;
                char c = this.format.charAt(n);
                while (c >= '0' && c <= '9' || "+-# ".indexOf(c) >= 0) {
                    c = this.format.charAt(++n);
                }
                int n2 = n;
                c = this.format.charAt(n);
                if (c == 's') {
                    int n3;
                    StringBuilder stringBuilder = new StringBuilder();
                    int n4 = (int)this.getValue(variableProvider, functionProvider, false);
                    int n5 = 0;
                    while (n5 < 4096) {
                        if ((n3 = (int)variableProvider.readValue(n4++, false, false)) == 0) break;
                        stringBuilder.append((char)n3);
                        ++n5;
                    }
                    String string = stringBuilder.toString();
                    stringBuilder.setLength(0);
                    stringBuilder.append('%');
                    n3 = 0;
                    while (n3 < n) {
                        stringBuilder.append(this.format.charAt(n3));
                        ++n3;
                    }
                    stringBuilder.append(c);
                    return String.format(stringBuilder.toString(), string);
                }
                int n6 = 2;
                if (c == 'h') {
                    n6 = 1;
                    c = this.format.charAt(++n);
                } else if (c == 'l') {
                    n6 = 4;
                    if ((c = (char)this.format.charAt(++n)) == 'l') {
                        n6 = 8;
                        c = this.format.charAt(++n);
                    }
                }
                if (c == 'i') {
                    c = 'd';
                }
                boolean bl2 = bl = c == 'd';
                if (c == 'u') {
                    c = 'd';
                }
                if (c == 'f') {
                    n6 *= 2;
                }
                long l = this.getValue(variableProvider, functionProvider, false);
                if (bl) {
                    switch (n6) {
                        case 1: {
                            l = (byte)l;
                            break;
                        }
                        case 2: {
                            l = (short)l;
                            break;
                        }
                        case 4: {
                            l = (int)l;
                        }
                    }
                } else if (n6 < 8) {
                    l &= (1L << n6 * 8) - 1L;
                }
                if (c == 'c') {
                    return Character.toString((char)l);
                }
                if (c == 'b') {
                    int n7 = 0;
                    if (this.format.charAt(n7) == '-') {
                        StringBuilder stringBuilder = new StringBuilder();
                        n7 = 0;
                        while (n7 < n2) {
                            stringBuilder.append(this.format.charAt(n7));
                            ++n7;
                        }
                        stringBuilder.append('s');
                        return String.format(stringBuilder.toString(), Long.toBinaryString(l));
                    }
                    if (this.format.charAt(n7) == ' ' || this.format.charAt(n7) == '0') {
                        char c2 = this.format.charAt(n7);
                        StringBuilder stringBuilder = new StringBuilder("%");
                        ++n7;
                        while (n7 < n2) {
                            stringBuilder.append(this.format.charAt(n7));
                            ++n7;
                        }
                        stringBuilder.append('s');
                        return String.format(stringBuilder.toString(), Long.toBinaryString(l)).replace(' ', c2);
                    }
                    break block31;
                }
                StringBuilder stringBuilder = new StringBuilder("%");
                int n8 = 0;
                while (n8 < n2) {
                    stringBuilder.append(this.format.charAt(n8));
                    ++n8;
                }
                stringBuilder.append(c);
                if (c == 'f') {
                    if (n6 == 8) {
                        return String.format(stringBuilder.toString(), ByteBuffer.wrap(new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)}).order(ByteOrder.LITTLE_ENDIAN).getDouble());
                    }
                    return String.format(stringBuilder.toString(), Float.valueOf(ByteBuffer.wrap(new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL)}).order(ByteOrder.LITTLE_ENDIAN).getFloat()));
                }
                return String.format(stringBuilder.toString(), l);
            }
            catch (Exception exception) {
                return exception.toString();
            }
        }
        return "";
    }
}

