/*
 * Decompiled with CFR 0.152.
 */
package components.sound;

import components.sound.SMSAudioMixer;
import components.sound.SN76489;
import components.sound.YM2413;

public class SMSJapaneseAudioMixer
implements SMSAudioMixer {
    private final SN76489 psg;
    private final YM2413 fm;
    private boolean psgEnabled;
    private boolean fmEnabled;

    public SMSJapaneseAudioMixer(SN76489 sN76489, YM2413 yM2413) {
        this.psg = sN76489;
        this.fm = yM2413;
        this.reset();
    }

    @Override
    public void reset() {
        this.psgEnabled = true;
        this.fmEnabled = false;
    }

    @Override
    public int readPort(int n) {
        return (int)Math.round(Math.random() * 7.0) << 5 | (this.fmEnabled == this.psgEnabled ? 2 : 0) | (this.fmEnabled ? 1 : 0);
    }

    @Override
    public void writePort(int n, int n2) {
        this.fmEnabled = (n2 & 1) != 0;
        this.psgEnabled = this.fmEnabled == ((n2 & 2) != 0);
    }

    @Override
    public boolean isPsgEnabled() {
        return this.psgEnabled || this.fm == null;
    }

    @Override
    public boolean isFmEnabled() {
        return this.fmEnabled;
    }

    @Override
    public SN76489 getPSG() {
        return this.psg;
    }

    @Override
    public YM2413 getFM() {
        return this.fm;
    }

    @Override
    public void setState(boolean bl, boolean bl2) {
        this.psgEnabled = bl;
        this.fmEnabled = bl2;
    }
}

