/*
 * Decompiled with CFR 0.152.
 */
package components.sound;

import components.OutputListener;
import java.util.Arrays;
import java.util.LinkedList;

public class SCC {
    public static final int SIGNATURE = 0x550000;
    public static final int REGISTER_WRITE = 0x550000;
    public static final int UPDATE = 5570687;
    private final int CYCLES_PER_SECOND;
    private final LinkedList<OutputListener> listenerList = new LinkedList();
    private OutputListener[] listeners = new OutputListener[0];
    private final byte[] waveforms = new byte[128];
    private final int[] frequencies = new int[5];
    private final int[] volumes = new int[5];
    private int channelsEnabled;
    private final int[] index = new int[5];
    private final int[] counter = new int[5];
    private final int[] samples = new int[5];

    public SCC(int n) {
        this.CYCLES_PER_SECOND = n;
    }

    public int getCyclesPerSecond() {
        return this.CYCLES_PER_SECOND;
    }

    private int getVolume(int n) {
        if (n == 3) {
            return Math.min(15, this.volumes[n] + 1);
        }
        return this.volumes[n];
    }

    private int getCyclesPerSample(int n) {
        return Math.max(1, this.frequencies[n]);
    }

    public void writeByte(int n, int n2, int n3) {
        if ((n &= 0xF8FF) < 38912 || n > 39167) {
            return;
        }
        this.fireOutputAvailable(5570687, n3);
        if (n < 39040) {
            this.waveforms[n & 0x7F] = (byte)n2;
        } else if ((n &= 0xFFFFFFEF) < 39050) {
            this.frequencies[(n & 0xF) >> 1] = this.frequencies[(n & 0xF) >> 1] & ~(255 << (n & 1) * 8) | n2 << (n & 1) * 8;
        } else if (n < 39055) {
            this.volumes[n - 39050] = n2;
        } else if (n == 39055) {
            this.channelsEnabled = n2;
        }
    }

    public int readByte(int n, int n2) {
        if ((n &= 0xF8FF) < 38912 || n >= 39040) {
            return 255;
        }
        return this.waveforms[n & 0x7F] & 0xFF;
    }

    public boolean isChannelEnabled(int n) {
        return (this.channelsEnabled & 1 << n) != 0;
    }

    public int getSamples(int n) {
        return this.isChannelEnabled(n) ? this.samples[n] : 0;
    }

    public void advanceChannels(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < this.counter.length) {
            this.advanceChannel(n2, n);
            ++n2;
        }
    }

    private void advanceChannel(int n, int n2) {
        int n3 = this.counter[n];
        int n4 = Math.min(3, n) * 32;
        int n5 = this.getCyclesPerSample(n);
        int n6 = this.waveforms[n4 + this.index[n]] * n3;
        int n7 = n;
        this.counter[n7] = this.counter[n7] - n2;
        while (this.counter[n] <= 0) {
            int n8 = n;
            this.counter[n8] = this.counter[n8] + n5;
            this.index[n] = this.index[n] + 1 & 0x1F;
            n6 += this.waveforms[n4 + this.index[n]] * n5;
        }
        this.samples[n] = (n6 -= this.waveforms[n4 + this.index[n]] * this.counter[n]) * this.getVolume(n);
    }

    public void reset() {
        Arrays.fill(this.volumes, 15);
        Arrays.fill(this.frequencies, 0);
    }

    public void setReg(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    protected void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = this.listeners;
        int n3 = this.listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, 0);
            ++n4;
        }
    }

    public void addOutputListener(OutputListener outputListener) {
        if (!this.listenerList.contains(outputListener)) {
            this.listenerList.addFirst(outputListener);
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public void removeOutputListener(OutputListener outputListener) {
        if (this.listenerList.remove(outputListener)) {
            this.listeners = this.listenerList.toArray(new OutputListener[this.listenerList.size()]);
        }
    }

    public State getState() {
        return new State(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getRegVolume(int n) {
                return SCC.this.volumes[n];
            }

            @Override
            public int getRegTone(int n) {
                return SCC.this.frequencies[n];
            }

            @Override
            public int getRegStereo() {
                return SCC.this.channelsEnabled;
            }
        };
    }

    public void setState(State state) {
        int n = 0;
        while (n < this.volumes.length) {
            this.volumes[n] = state.getRegVolume(n);
            ++n;
        }
        n = 0;
        while (n < this.frequencies.length) {
            this.frequencies[n] = state.getRegTone(n);
            ++n;
        }
        this.channelsEnabled = state.getRegStereo();
    }

    public static interface State {
        public State clone();

        public int getRegVolume(int var1);

        public int getRegTone(int var1);

        public int getRegStereo();
    }

    private static class StateClone
    implements State {
        private final int[] regVolume = new int[4];
        private final int[] regTone = new int[3];
        private final int regStereo;

        public StateClone(State state) {
            int n = 0;
            while (n < this.regVolume.length) {
                this.regVolume[n] = state.getRegVolume(n);
                ++n;
            }
            n = 0;
            while (n < this.regTone.length) {
                this.regTone[n] = state.getRegTone(n);
                ++n;
            }
            this.regStereo = state.getRegStereo();
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getRegVolume(int n) {
            return this.regVolume[n];
        }

        @Override
        public int getRegTone(int n) {
            return this.regTone[n];
        }

        @Override
        public int getRegStereo() {
            return this.regStereo;
        }
    }
}

