/*
 * Decompiled with CFR 0.152.
 */
package components.sound;

import platform.MidiNoteInputProvider;

public class MSXAudioMidiInterface {
    private final MidiNoteInputProvider inputProvider;
    private int latchedRegister;
    private final int[] regs = new int[256];

    public MSXAudioMidiInterface(MidiNoteInputProvider midiNoteInputProvider) {
        this.inputProvider = midiNoteInputProvider;
    }

    public void processInput(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                this.latchedRegister = n2;
                break;
            }
            case 1: {
                this.regs[this.latchedRegister] = n2;
            }
        }
    }

    public int readByte(int n) {
        if (n == 1 && this.latchedRegister == 5) {
            return this.readMidi();
        }
        return 255;
    }

    private int readMidi() {
        int n = 255;
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 1 << n2;
            if ((this.regs[6] & n3) != 0) {
                int n4 = 0;
                while (n4 < 8) {
                    if (this.inputProvider.isNoteOn(MSXAudioMidiInterface.mapNoteNumber(n2 * 8 + n4))) {
                        n &= ~(1 << n4);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return n;
    }

    public static int mapNoteNumber(int n) {
        int n2 = (n += 39) / 12;
        return n2 * 12 + (n + 9) % 12;
    }
}

