/*
 * Decompiled with CFR 0.152.
 */
package components.input;

import components.input.SMSInputDevice;

public abstract class AbstractSMSInputDevice
implements SMSInputDevice {
    private boolean pinTR = true;
    private boolean pinTH = true;
    private final boolean[] buttonDownOverride;

    protected AbstractSMSInputDevice() {
        this(0);
    }

    protected AbstractSMSInputDevice(int n) {
        this.buttonDownOverride = new boolean[n];
    }

    @Override
    public abstract int readData(int var1);

    protected void handleRisingEdgeTR(int n) {
    }

    protected void handleFallingEdgeTR(int n) {
    }

    protected void handleRisingEdgeTH(int n) {
    }

    protected void handleFallingEdgeTH(int n) {
    }

    protected boolean isTHhigh() {
        return this.pinTH;
    }

    protected boolean isTRhigh() {
        return this.pinTR;
    }

    @Override
    public void setPins(boolean bl, boolean bl2, int n) {
        if (bl ^ this.pinTR) {
            this.pinTR = bl;
            if (bl) {
                this.handleRisingEdgeTR(n);
            } else {
                this.handleFallingEdgeTR(n);
            }
        }
        if (bl2 ^ this.pinTH) {
            this.pinTH = bl2;
            if (bl2) {
                this.handleRisingEdgeTH(n);
            } else {
                this.handleFallingEdgeTH(n);
            }
        }
    }

    @Override
    public void setTH(boolean bl, int n) {
        this.setPins(this.pinTR, bl, n);
    }

    @Override
    public void update(int n) {
    }

    @Override
    public void frameFinished() {
    }

    protected boolean isButtonPressed(int n) {
        return false;
    }

    @Override
    public final boolean isButtonDown(int n) {
        boolean bl = this.isButtonPressed(n);
        if (bl) {
            this.buttonDownOverride[n] = false;
        }
        return bl || this.buttonDownOverride[n];
    }

    @Override
    public final void setButtonDownOverride(int n, boolean bl) {
        if (n >= 0 && n < this.buttonDownOverride.length) {
            this.buttonDownOverride[n] = bl;
        }
    }

    @Override
    public final int getState() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.buttonDownOverride.length) {
            if (this.isButtonDown(n2)) {
                n |= 1 << n2;
            }
            ++n2;
        }
        return n;
    }

    @Override
    public final void setState(long l) {
        int n = 0;
        while (n < this.buttonDownOverride.length) {
            this.setButtonDownOverride(n, (l & (long)(1 << n)) != 0L);
            ++n;
        }
    }
}

