/*
 * Decompiled with CFR 0.152.
 */
package components.cpu;

import components.cpu.CPU;
import components.cpu.MemoryMap;
import components.cpu.PortMap;
import components.cpu.Z80Info;
import java.lang.instrument.UnmodifiableClassException;

public class Z80
extends CPU {
    private static final String[] REGISTER_NAMES = new String[]{"BC", "DE", "HL", "AF", "IX", "IY", "SP", "PC", "BC'", "DE'", "HL'", "AF'"};
    private static final String[] FLAG_NAMES = new String[]{"C", "N", "P/V", "3", "H", "5", "Z", "S"};
    public static final int PORT_MESSAGE = 338;
    public static final int PORT_HALT = 374;
    public static final int PORT_BREAKPOINT = 256;
    protected static final int FLAG_C = 1;
    protected static final int FLAG_N = 2;
    protected static final int FLAG_PV = 4;
    protected static final int FLAG_3 = 8;
    protected static final int FLAG_H = 16;
    protected static final int FLAG_5 = 32;
    protected static final int FLAG_Z = 64;
    protected static final int FLAG_S = 128;
    protected static final int FLAG_PV_Z = 68;
    protected static final int FLAG_3_5 = 40;
    protected static final int FLAG_3_5_S = 168;
    private static final int[] FLAGS_PV_3_5_Z_S = new int[256];
    private static final int[] FLAGS_INC = new int[256];
    private static final int[] FLAGS_DEC = new int[256];
    public static final int INTERRUPT_LINE_INT = 1;
    public static final int INTERRUPT_LINE_NMI = 2;
    protected static final int[] CYCLES;
    protected static final int[] CYCLES_CB;
    private static final int[] CYCLES_ED;
    private final boolean HAS_IFF_FETCH_BUG = true;
    private final boolean CMOS = false;
    private final int WAIT_CYCLES;
    private int waitedCycles;
    protected int regAF;
    protected int regBC;
    protected int regDE;
    protected int regHL;
    private int regAFex;
    private int regBCex;
    private int regDEex;
    private int regHLex;
    private int regR;
    private int regRbit7;
    private int regI;
    private int regIX;
    private int regIY;
    private int regWZ;
    protected boolean afterEI;
    private boolean afterIFFfetch;
    private boolean pinINT;
    private boolean pinNMI;
    private boolean nmiPending;
    private boolean interruptFlipFlop1;
    private boolean interruptFlipFlop2;
    private int interruptMode;
    protected boolean halted;
    protected int prevPC;
    protected int prevSP;

    static {
        int n = 0;
        while (n < FLAGS_PV_3_5_Z_S.length) {
            int n2 = n == 0 ? 68 : (Z80.FLAGS_PV_3_5_Z_S[n] = n & 0xA8 | ((Integer.bitCount(n) & 1) == 0 ? 4 : 0));
            int n3 = n == 0 ? 80 : (Z80.FLAGS_INC[n] = (n == 128 ? 4 : 0) | n & 0xA8 | ((n & 0xF) == 0 ? 16 : 0));
            Z80.FLAGS_DEC[n] = 2 | (n == 0 ? 64 : (n == 127 ? 4 : 0) | n & 0xA8 | ((n & 0xF) == 15 ? 16 : 0));
            ++n;
        }
        CYCLES = new int[256];
        CYCLES_CB = new int[256];
        CYCLES_ED = new int[256];
    }

    public Z80(MemoryMap memoryMap, PortMap portMap) {
        this(Z80Info.getInstance(), memoryMap, portMap);
    }

    public Z80(Z80Info z80Info, MemoryMap memoryMap, PortMap portMap) {
        super(memoryMap, portMap, Z80.cyclesFromInfo(z80Info));
        int n = 0;
        while (n < CYCLES_CB.length) {
            Z80.CYCLES_CB[n] = z80Info.getMinCycles(n, 203) - CYCLES[203];
            ++n;
        }
        n = 0;
        while (n < CYCLES_ED.length) {
            Z80.CYCLES_ED[n] = z80Info.getMinCycles(n, 237) - CYCLES[237];
            ++n;
        }
        this.WAIT_CYCLES = z80Info.getWaitCycles();
    }

    private static int[] cyclesFromInfo(Z80Info z80Info) {
        int n = 0;
        while (n < CYCLES.length) {
            Z80.CYCLES[n] = z80Info.getMinCycles(n, 0);
            ++n;
        }
        return CYCLES;
    }

    @Override
    public void reset() {
        this.regPC = 0;
        this.regSP = 57328;
        this.regAF = 65535;
        this.regAFex = 65535;
        this.regWZ = 0;
        this.regR = 0;
        this.regI = 0;
        this.regRbit7 = 0;
        this.pinINT = false;
        this.pinNMI = false;
        this.nmiPending = false;
        this.interruptMode = 0;
        this.halted = false;
        this.afterEI = false;
        this.setInterruptsEnabled(false);
    }

    public boolean isHalted() {
        return this.halted;
    }

    public int getPrevPC() {
        return this.prevPC;
    }

    public int getPrevSP() {
        return this.prevSP;
    }

    @Override
    public String[] getRegisterNames() {
        return REGISTER_NAMES;
    }

    @Override
    public int indexOfPC() {
        return 7;
    }

    @Override
    public int getRegisterValue(int n) {
        switch (n) {
            case 0: {
                return this.regBC;
            }
            case 1: {
                return this.regDE;
            }
            case 2: {
                return this.regHL;
            }
            case 3: {
                return this.regAF;
            }
            case 4: {
                return this.regIX;
            }
            case 5: {
                return this.regIY;
            }
            case 6: {
                return this.regSP;
            }
            case 7: {
                return this.regPC;
            }
            case 8: {
                return this.regBCex;
            }
            case 9: {
                return this.regDEex;
            }
            case 10: {
                return this.regHLex;
            }
            case 11: {
                return this.regAFex;
            }
            case 12: {
                return this.regRbit7 | this.regR & 0x7F;
            }
            case 13: {
                return this.regI;
            }
        }
        return -1;
    }

    @Override
    public boolean isAdditionalRegister(int n) {
        return n >= 8;
    }

    public void setRegValue(int n, int n2) {
        switch (n) {
            case 0: {
                this.regBC = n2 & 0xFFFF;
                break;
            }
            case 1: {
                this.regDE = n2 & 0xFFFF;
                break;
            }
            case 2: {
                this.regHL = n2 & 0xFFFF;
                break;
            }
            case 3: {
                this.regAF = n2 & 0xFFFF;
                break;
            }
            case 4: {
                this.regIX = n2 & 0xFFFF;
                break;
            }
            case 5: {
                this.regIY = n2 & 0xFFFF;
                break;
            }
            case 6: {
                this.regSP = n2 & 0xFFFF;
                break;
            }
            case 7: {
                this.prevPC = this.regPC = n2 & 0xFFFF;
                break;
            }
            case 8: {
                this.regBCex = n2 & 0xFFFF;
                break;
            }
            case 9: {
                this.regDEex = n2 & 0xFFFF;
                break;
            }
            case 10: {
                this.regHLex = n2 & 0xFFFF;
                break;
            }
            case 11: {
                this.regAFex = n2 & 0xFFFF;
                break;
            }
            case 12: {
                this.regR = n2 & 0xFF;
                this.regRbit7 = this.regR & 0x80;
                break;
            }
            case 13: {
                this.regI = n2 & 0xFF;
            }
        }
    }

    @Override
    public String[] getFlagNames() {
        return FLAG_NAMES;
    }

    @Override
    public boolean isFlagSet(int n) {
        return (this.regAF & 1 << n) != 0;
    }

    private void handleIdleLoops() {
    }

    @Override
    protected void executeInstruction(int n) {
        ++this.regR;
        this.afterEI = false;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.regBC = this.READ_WORD();
                break;
            }
            case 2: {
                this.regWZ = this.regBC;
                this.WRITE_BYTE(this.regWZ++, this.regAF >> 8);
                this.regWZ = this.regAF & 0xFF00 | this.regWZ & 0xFF;
                break;
            }
            case 3: {
                this.regBC = Z80.INC_WORD(this.regBC);
                break;
            }
            case 4: {
                this.regBC = this.INC_HIBYTE(this.regBC);
                break;
            }
            case 5: {
                this.regBC = this.DEC_HIBYTE(this.regBC);
                break;
            }
            case 6: {
                this.regBC = this.READ_BYTE() << 8 | this.regBC & 0xFF;
                break;
            }
            case 7: {
                this.regAF = (this.regAF & 0x7F00) << 1 | (this.regAF & 0x8000) >> 7 | this.regAF >> 15 | this.regAF >> 7 & 0x28 | this.regAF & 0xC4;
                break;
            }
            case 8: {
                int n2 = this.regAF;
                this.regAF = this.regAFex;
                this.regAFex = n2;
                break;
            }
            case 9: {
                this.ADD_WORD_HL(this.regBC);
                break;
            }
            case 10: {
                this.regWZ = this.regBC;
                this.regAF = this.READ_BYTE(this.regWZ++) << 8 | this.regAF & 0xFF;
                break;
            }
            case 11: {
                this.regBC = Z80.DEC_WORD(this.regBC);
                break;
            }
            case 12: {
                this.regBC = this.INC_LOBYTE(this.regBC);
                break;
            }
            case 13: {
                this.regBC = this.DEC_LOBYTE(this.regBC);
                break;
            }
            case 14: {
                this.regBC = this.regBC & 0xFF00 | this.READ_BYTE();
                break;
            }
            case 15: {
                this.regAF = (this.regAF & 0x100) << 7 | (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1 | this.regAF >> 9 & 0x28 | this.regAF & 0xC4;
                break;
            }
            case 16: {
                this.regBC = this.regBC - 256 & 0xFFFF;
                if ((this.regBC & 0xFF00) != 0) {
                    this.regPC = this.regWZ = this.regPC + (byte)this.READ_BYTE(this.regPC) & 0xFFFF;
                    this.cycleCount -= 5;
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 17: {
                this.regDE = this.READ_WORD();
                break;
            }
            case 18: {
                this.regWZ = this.regDE;
                this.WRITE_BYTE(this.regWZ++, this.regAF >> 8);
                this.regWZ = this.regDE & 0xFF00 | this.regWZ & 0xFF;
                break;
            }
            case 19: {
                this.regDE = Z80.INC_WORD(this.regDE);
                break;
            }
            case 20: {
                this.regDE = this.INC_HIBYTE(this.regDE);
                break;
            }
            case 21: {
                this.regDE = this.DEC_HIBYTE(this.regDE);
                break;
            }
            case 22: {
                this.regDE = this.READ_BYTE() << 8 | this.regDE & 0xFF;
                break;
            }
            case 23: {
                this.regAF = (this.regAF & 0x7F00) << 1 | (this.regAF & 1) << 8 | this.regAF >> 15 | this.regAF >> 7 & 0x28 | this.regAF & 0xC4;
                break;
            }
            case 24: {
                this.regPC = this.regWZ = this.regPC + (byte)this.READ_BYTE(this.regPC) + 1 & 0xFFFF;
                break;
            }
            case 25: {
                this.ADD_WORD_HL(this.regDE);
                break;
            }
            case 26: {
                this.regWZ = this.regDE;
                this.regAF = this.READ_BYTE(this.regWZ++) << 8 | this.regAF & 0xFF;
                break;
            }
            case 27: {
                this.regDE = Z80.DEC_WORD(this.regDE);
                break;
            }
            case 28: {
                this.regDE = this.INC_LOBYTE(this.regDE);
                break;
            }
            case 29: {
                this.regDE = this.DEC_LOBYTE(this.regDE);
                break;
            }
            case 30: {
                this.regDE = this.regDE & 0xFF00 | this.READ_BYTE();
                break;
            }
            case 31: {
                this.regAF = (this.regAF & 0xFE00) >> 1 | (this.regAF & 1) << 15 | this.regAF >> 8 & 1 | this.regAF >> 9 & 0x28 | this.regAF & 0xC4;
                break;
            }
            case 32: {
                if ((this.regAF & 0x40) == 0) {
                    this.regPC = this.regWZ = this.regPC + (byte)this.READ_BYTE(this.regPC) & 0xFFFF;
                    this.cycleCount -= 5;
                    if (this.regPC < this.prevPC) {
                        this.handleIdleLoops();
                    }
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 33: {
                this.regHL = this.READ_WORD();
                break;
            }
            case 34: {
                this.regWZ = this.READ_WORD();
                this.WRITE_WORD(this.regWZ++, this.regHL);
                break;
            }
            case 35: {
                this.regHL = Z80.INC_WORD(this.regHL);
                break;
            }
            case 36: {
                this.regHL = this.INC_HIBYTE(this.regHL);
                break;
            }
            case 37: {
                this.regHL = this.DEC_HIBYTE(this.regHL);
                break;
            }
            case 38: {
                this.regHL = this.READ_BYTE() << 8 | this.regHL & 0xFF;
                break;
            }
            case 39: {
                this.DAA();
                break;
            }
            case 40: {
                if ((this.regAF & 0x40) != 0) {
                    this.regPC = this.regWZ = this.regPC + (byte)this.READ_BYTE(this.regPC) & 0xFFFF;
                    this.cycleCount -= 5;
                    if (this.regPC < this.prevPC) {
                        this.handleIdleLoops();
                    }
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 41: {
                this.ADD_WORD_HL(this.regHL);
                break;
            }
            case 42: {
                this.regWZ = this.READ_WORD();
                this.regHL = this.READ_WORD(this.regWZ++);
                break;
            }
            case 43: {
                this.regHL = Z80.DEC_WORD(this.regHL);
                break;
            }
            case 44: {
                this.regHL = this.INC_LOBYTE(this.regHL);
                break;
            }
            case 45: {
                this.regHL = this.DEC_LOBYTE(this.regHL);
                break;
            }
            case 46: {
                this.regHL = this.regHL & 0xFF00 | this.READ_BYTE();
                break;
            }
            case 47: {
                this.regAF = (this.regAF ^ 0xFF00) & 0xFF00 | this.regAF & 0xD7 | 2 | 0x10 | (this.regAF ^ 0xFF00) >> 8 & 0x28;
                break;
            }
            case 48: {
                if ((this.regAF & 1) == 0) {
                    this.regPC = this.regWZ = this.regPC + (byte)this.READ_BYTE(this.regPC) & 0xFFFF;
                    this.cycleCount -= 5;
                    if (this.regPC < this.prevPC) {
                        this.handleIdleLoops();
                    }
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 49: {
                this.prevSP = this.regSP;
                this.regSP = this.READ_WORD();
                break;
            }
            case 50: {
                this.regWZ = this.READ_WORD();
                this.WRITE_BYTE(this.regWZ++, this.regAF >> 8);
                this.regWZ = this.regAF & 0xFF00 | this.regWZ & 0xFF;
                break;
            }
            case 51: {
                this.regSP = this.regSP + 1 & 0xFFFF;
                break;
            }
            case 52: {
                this.WRITE_BYTE(this.regHL, this.INC_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 53: {
                this.WRITE_BYTE(this.regHL, this.DEC_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 54: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE());
                break;
            }
            case 55: {
                this.regAF = this.regAF & 0xFFED | this.regAF >> 8 & 0x28 | 1;
                break;
            }
            case 56: {
                if ((this.regAF & 1) != 0) {
                    this.regPC = this.regWZ = this.regPC + (byte)this.READ_BYTE(this.regPC) & 0xFFFF;
                    this.cycleCount -= 5;
                    if (this.regPC < this.prevPC) {
                        this.handleIdleLoops();
                    }
                }
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 57: {
                this.ADD_WORD_HL(this.regSP);
                break;
            }
            case 58: {
                this.regWZ = this.READ_WORD();
                this.regAF = this.READ_BYTE(this.regWZ++) << 8 | this.regAF & 0xFF;
                break;
            }
            case 59: {
                this.regSP = this.regSP - 1 & 0xFFFF;
                break;
            }
            case 60: {
                this.regAF = this.regAF + 256 & 0xFF01;
                this.regAF |= FLAGS_INC[this.regAF >> 8];
                break;
            }
            case 61: {
                this.regAF = this.regAF - 256 & 0xFF01;
                this.regAF |= FLAGS_DEC[this.regAF >> 8];
                break;
            }
            case 62: {
                this.regAF = this.READ_BYTE() << 8 | this.regAF & 0xFF;
                break;
            }
            case 63: {
                this.regAF = (this.regAF & 0xFFED | this.regAF >> 8 & 0x28 | (this.regAF & 1) << 4) ^ 1;
                break;
            }
            case 64: {
                this.WRITE_PORT(256, 0);
                break;
            }
            case 65: {
                this.regBC = (this.regBC & 0xFF) << 8 | this.regBC & 0xFF;
                break;
            }
            case 66: {
                this.regBC = this.regDE & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 67: {
                this.regBC = (this.regDE & 0xFF) << 8 | this.regBC & 0xFF;
                break;
            }
            case 68: {
                this.regBC = this.regHL & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 69: {
                this.regBC = (this.regHL & 0xFF) << 8 | this.regBC & 0xFF;
                break;
            }
            case 70: {
                this.regBC = this.READ_BYTE(this.regHL) << 8 | this.regBC & 0xFF;
                break;
            }
            case 71: {
                this.regBC = this.regAF & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 72: {
                this.regBC = this.regBC & 0xFF00 | this.regBC >> 8;
                break;
            }
            case 73: {
                break;
            }
            case 74: {
                this.regBC = this.regBC & 0xFF00 | this.regDE >> 8;
                break;
            }
            case 75: {
                this.regBC = this.regBC & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 76: {
                this.regBC = this.regBC & 0xFF00 | this.regHL >> 8;
                break;
            }
            case 77: {
                this.regBC = this.regBC & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 78: {
                this.regBC = this.regBC & 0xFF00 | this.READ_BYTE(this.regHL);
                break;
            }
            case 79: {
                this.regBC = this.regBC & 0xFF00 | this.regAF >> 8;
                break;
            }
            case 80: {
                this.regDE = this.regBC & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 81: {
                this.regDE = (this.regBC & 0xFF) << 8 | this.regDE & 0xFF;
                break;
            }
            case 82: {
                if (this.READ_WORD(this.regPC + 2) != 25700) break;
                this.WRITE_PORT(338, 0);
                break;
            }
            case 83: {
                this.regDE = (this.regDE & 0xFF) << 8 | this.regDE & 0xFF;
                break;
            }
            case 84: {
                this.regDE = this.regHL & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 85: {
                this.regDE = (this.regHL & 0xFF) << 8 | this.regDE & 0xFF;
                break;
            }
            case 86: {
                this.regDE = this.READ_BYTE(this.regHL) << 8 | this.regDE & 0xFF;
                break;
            }
            case 87: {
                this.regDE = this.regAF & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 88: {
                this.regDE = this.regDE & 0xFF00 | this.regBC >> 8;
                break;
            }
            case 89: {
                this.regDE = this.regDE & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 90: {
                this.regDE = this.regDE & 0xFF00 | this.regDE >> 8;
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                this.regDE = this.regDE & 0xFF00 | this.regHL >> 8;
                break;
            }
            case 93: {
                this.regDE = this.regDE & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 94: {
                this.regDE = this.regDE & 0xFF00 | this.READ_BYTE(this.regHL);
                break;
            }
            case 95: {
                this.regDE = this.regDE & 0xFF00 | this.regAF >> 8;
                break;
            }
            case 96: {
                this.regHL = this.regBC & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 97: {
                this.regHL = (this.regBC & 0xFF) << 8 | this.regHL & 0xFF;
                break;
            }
            case 98: {
                this.regHL = this.regDE & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 99: {
                this.regHL = (this.regDE & 0xFF) << 8 | this.regHL & 0xFF;
                break;
            }
            case 100: {
                break;
            }
            case 101: {
                this.regHL = (this.regHL & 0xFF) << 8 | this.regHL & 0xFF;
                break;
            }
            case 102: {
                this.regHL = this.READ_BYTE(this.regHL) << 8 | this.regHL & 0xFF;
                break;
            }
            case 103: {
                this.regHL = this.regAF & 0xFF00 | this.regHL & 0xFF;
                break;
            }
            case 104: {
                this.regHL = this.regHL & 0xFF00 | this.regBC >> 8;
                break;
            }
            case 105: {
                this.regHL = this.regHL & 0xFF00 | this.regBC & 0xFF;
                break;
            }
            case 106: {
                this.regHL = this.regHL & 0xFF00 | this.regDE >> 8;
                break;
            }
            case 107: {
                this.regHL = this.regHL & 0xFF00 | this.regDE & 0xFF;
                break;
            }
            case 108: {
                this.regHL = this.regHL & 0xFF00 | this.regHL >> 8;
                break;
            }
            case 109: {
                break;
            }
            case 110: {
                this.regHL = this.regHL & 0xFF00 | this.READ_BYTE(this.regHL);
                break;
            }
            case 111: {
                this.regHL = this.regHL & 0xFF00 | this.regAF >> 8;
                break;
            }
            case 112: {
                this.WRITE_BYTE(this.regHL, this.regBC >> 8);
                break;
            }
            case 113: {
                this.WRITE_BYTE(this.regHL, this.regBC & 0xFF);
                break;
            }
            case 114: {
                this.WRITE_BYTE(this.regHL, this.regDE >> 8);
                break;
            }
            case 115: {
                this.WRITE_BYTE(this.regHL, this.regDE & 0xFF);
                break;
            }
            case 116: {
                this.WRITE_BYTE(this.regHL, this.regHL >> 8);
                break;
            }
            case 117: {
                this.WRITE_BYTE(this.regHL, this.regHL & 0xFF);
                break;
            }
            case 118: {
                --this.regPC;
                if (!this.halted) {
                    this.WRITE_PORT(374, 1);
                }
                if (this.cycleCount > 0) {
                    this.regR += this.cycleCount / CYCLES[n];
                    this.cycleCount %= CYCLES[n];
                }
                this.halted = true;
                break;
            }
            case 119: {
                this.WRITE_BYTE(this.regHL, this.regAF >> 8);
                break;
            }
            case 120: {
                this.regAF = this.regBC & 0xFF00 | this.regAF & 0xFF;
                break;
            }
            case 121: {
                this.regAF = (this.regBC & 0xFF) << 8 | this.regAF & 0xFF;
                break;
            }
            case 122: {
                this.regAF = this.regDE & 0xFF00 | this.regAF & 0xFF;
                break;
            }
            case 123: {
                this.regAF = (this.regDE & 0xFF) << 8 | this.regAF & 0xFF;
                break;
            }
            case 124: {
                this.regAF = this.regHL & 0xFF00 | this.regAF & 0xFF;
                break;
            }
            case 125: {
                this.regAF = (this.regHL & 0xFF) << 8 | this.regAF & 0xFF;
                break;
            }
            case 126: {
                this.regAF = this.READ_BYTE(this.regHL) << 8 | this.regAF & 0xFF;
                break;
            }
            case 127: {
                break;
            }
            case 128: {
                this.ADD_HIBYTE(this.regBC);
                break;
            }
            case 129: {
                this.ADD_LOBYTE(this.regBC);
                break;
            }
            case 130: {
                this.ADD_HIBYTE(this.regDE);
                break;
            }
            case 131: {
                this.ADD_LOBYTE(this.regDE);
                break;
            }
            case 132: {
                this.ADD_HIBYTE(this.regHL);
                break;
            }
            case 133: {
                this.ADD_LOBYTE(this.regHL);
                break;
            }
            case 134: {
                this.ADD_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 135: {
                this.ADD_HIBYTE(this.regAF);
                break;
            }
            case 136: {
                this.ADC_HIBYTE(this.regBC);
                break;
            }
            case 137: {
                this.ADC_LOBYTE(this.regBC);
                break;
            }
            case 138: {
                this.ADC_HIBYTE(this.regDE);
                break;
            }
            case 139: {
                this.ADC_LOBYTE(this.regDE);
                break;
            }
            case 140: {
                this.ADC_HIBYTE(this.regHL);
                break;
            }
            case 141: {
                this.ADC_LOBYTE(this.regHL);
                break;
            }
            case 142: {
                this.ADC_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 143: {
                this.ADC_HIBYTE(this.regAF);
                break;
            }
            case 144: {
                this.SUB_HIBYTE(this.regBC);
                break;
            }
            case 145: {
                this.SUB_LOBYTE(this.regBC);
                break;
            }
            case 146: {
                this.SUB_HIBYTE(this.regDE);
                break;
            }
            case 147: {
                this.SUB_LOBYTE(this.regDE);
                break;
            }
            case 148: {
                this.SUB_HIBYTE(this.regHL);
                break;
            }
            case 149: {
                this.SUB_LOBYTE(this.regHL);
                break;
            }
            case 150: {
                this.SUB_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 151: {
                this.regAF = 66;
                break;
            }
            case 152: {
                this.SBC_HIBYTE(this.regBC);
                break;
            }
            case 153: {
                this.SBC_LOBYTE(this.regBC);
                break;
            }
            case 154: {
                this.SBC_HIBYTE(this.regDE);
                break;
            }
            case 155: {
                this.SBC_LOBYTE(this.regDE);
                break;
            }
            case 156: {
                this.SBC_HIBYTE(this.regHL);
                break;
            }
            case 157: {
                this.SBC_LOBYTE(this.regHL);
                break;
            }
            case 158: {
                this.SBC_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 159: {
                this.SBC_HIBYTE(this.regAF);
                break;
            }
            case 160: {
                this.AND_HIBYTE(this.regBC);
                break;
            }
            case 161: {
                this.AND_LOBYTE(this.regBC);
                break;
            }
            case 162: {
                this.AND_HIBYTE(this.regDE);
                break;
            }
            case 163: {
                this.AND_LOBYTE(this.regDE);
                break;
            }
            case 164: {
                this.AND_HIBYTE(this.regHL);
                break;
            }
            case 165: {
                this.AND_LOBYTE(this.regHL);
                break;
            }
            case 166: {
                this.AND_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 167: {
                this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[this.regAF >> 8] | 0x10;
                break;
            }
            case 168: {
                this.XOR_HIBYTE(this.regBC);
                break;
            }
            case 169: {
                this.XOR_LOBYTE(this.regBC);
                break;
            }
            case 170: {
                this.XOR_HIBYTE(this.regDE);
                break;
            }
            case 171: {
                this.XOR_LOBYTE(this.regDE);
                break;
            }
            case 172: {
                this.XOR_HIBYTE(this.regHL);
                break;
            }
            case 173: {
                this.XOR_LOBYTE(this.regHL);
                break;
            }
            case 174: {
                this.XOR_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 175: {
                this.regAF = 68;
                break;
            }
            case 176: {
                this.OR_HIBYTE(this.regBC);
                break;
            }
            case 177: {
                this.OR_LOBYTE(this.regBC);
                break;
            }
            case 178: {
                this.OR_HIBYTE(this.regDE);
                break;
            }
            case 179: {
                this.OR_LOBYTE(this.regDE);
                break;
            }
            case 180: {
                this.OR_HIBYTE(this.regHL);
                break;
            }
            case 181: {
                this.OR_LOBYTE(this.regHL);
                break;
            }
            case 182: {
                this.OR_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 183: {
                this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[this.regAF >> 8];
                break;
            }
            case 184: {
                this.CP_HIBYTE(this.regBC);
                break;
            }
            case 185: {
                this.CP_LOBYTE(this.regBC);
                break;
            }
            case 186: {
                this.CP_HIBYTE(this.regDE);
                break;
            }
            case 187: {
                this.CP_LOBYTE(this.regDE);
                break;
            }
            case 188: {
                this.CP_HIBYTE(this.regHL);
                break;
            }
            case 189: {
                this.CP_LOBYTE(this.regHL);
                break;
            }
            case 190: {
                this.CP_LOBYTE(this.READ_BYTE(this.regHL));
                break;
            }
            case 191: {
                this.regAF = this.regAF & 0xFF00 | 0x40 | 2 | this.regAF >> 8 & 0x28;
                break;
            }
            case 192: {
                if ((this.regAF & 0x40) != 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 193: {
                this.regBC = this.POP();
                break;
            }
            case 194: {
                this.regWZ = this.READ_WORD();
                if ((this.regAF & 0x40) != 0) break;
                this.regPC = this.regWZ;
                break;
            }
            case 195: {
                this.regPC = this.regWZ = this.READ_WORD();
                break;
            }
            case 196: {
                if ((this.regAF & 0x40) == 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 197: {
                this.PUSH(this.regBC);
                break;
            }
            case 198: {
                this.ADD_LOBYTE(this.READ_BYTE());
                break;
            }
            case 199: {
                this.RST(0);
                break;
            }
            case 200: {
                if ((this.regAF & 0x40) == 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 201: {
                this.RET();
                break;
            }
            case 202: {
                if ((this.regAF & 0x40) != 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 203: {
                n = this.READ_BYTE();
                this.cycleCount -= CYCLES_CB[n];
                ++this.regR;
                this.executeInstructionCB(n);
                break;
            }
            case 204: {
                if ((this.regAF & 0x40) != 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 205: {
                this.CALL();
                break;
            }
            case 206: {
                this.ADC_LOBYTE(this.READ_BYTE());
                break;
            }
            case 207: {
                this.RST(8);
                break;
            }
            case 208: {
                if ((this.regAF & 1) != 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 209: {
                this.regDE = this.POP();
                break;
            }
            case 210: {
                if ((this.regAF & 1) == 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 211: {
                this.regWZ = this.READ_BYTE();
                this.WRITE_PORT(this.regWZ++, this.regAF >> 8);
                this.regWZ = this.regAF & 0xFF00 | this.regWZ & 0xFF;
                break;
            }
            case 212: {
                if ((this.regAF & 1) == 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 213: {
                this.PUSH(this.regDE);
                break;
            }
            case 214: {
                this.SUB_LOBYTE(this.READ_BYTE());
                break;
            }
            case 215: {
                this.RST(16);
                break;
            }
            case 216: {
                if ((this.regAF & 1) == 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 217: {
                int n3 = this.regBC;
                this.regBC = this.regBCex;
                this.regBCex = n3;
                n3 = this.regDE;
                this.regDE = this.regDEex;
                this.regDEex = n3;
                n3 = this.regHL;
                this.regHL = this.regHLex;
                this.regHLex = n3;
                break;
            }
            case 218: {
                if ((this.regAF & 1) != 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 219: {
                this.regWZ = this.READ_BYTE();
                this.regAF = this.READ_PORT(this.regWZ++) << 8 | this.regAF & 0xFF;
                break;
            }
            case 220: {
                if ((this.regAF & 1) != 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 221: {
                ++this.regR;
                this.executeInstructionDD(this.READ_BYTE());
                break;
            }
            case 222: {
                this.SBC_LOBYTE(this.READ_BYTE());
                break;
            }
            case 223: {
                this.RST(24);
                break;
            }
            case 224: {
                if ((this.regAF & 4) != 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 225: {
                this.regHL = this.POP();
                break;
            }
            case 226: {
                if ((this.regAF & 4) == 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 227: {
                this.regWZ = this.READ_WORD(this.regSP);
                this.WRITE_WORD(this.regSP, this.regHL);
                this.regHL = this.regWZ;
                break;
            }
            case 228: {
                if ((this.regAF & 4) == 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 229: {
                this.PUSH(this.regHL);
                break;
            }
            case 230: {
                this.AND_LOBYTE(this.READ_BYTE());
                break;
            }
            case 231: {
                this.RST(32);
                break;
            }
            case 232: {
                if ((this.regAF & 4) == 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 233: {
                this.regPC = this.regHL;
                break;
            }
            case 234: {
                if ((this.regAF & 4) != 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 235: {
                int n4 = this.regDE;
                this.regDE = this.regHL;
                this.regHL = n4;
                break;
            }
            case 236: {
                if ((this.regAF & 4) != 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 237: {
                n = this.READ_BYTE();
                this.cycleCount -= CYCLES_ED[n];
                ++this.regR;
                this.executeInstructionED(n);
                break;
            }
            case 238: {
                this.XOR_LOBYTE(this.READ_BYTE());
                break;
            }
            case 239: {
                this.RST(40);
                break;
            }
            case 240: {
                if ((this.regAF & 0x80) != 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 241: {
                this.regAF = this.POP();
                break;
            }
            case 242: {
                if ((this.regAF & 0x80) == 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 243: {
                this.setInterruptsEnabled(false);
                break;
            }
            case 244: {
                if ((this.regAF & 0x80) == 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 245: {
                this.PUSH(this.regAF);
                break;
            }
            case 246: {
                this.OR_LOBYTE(this.READ_BYTE());
                break;
            }
            case 247: {
                this.RST(48);
                break;
            }
            case 248: {
                if ((this.regAF & 0x80) == 0) break;
                this.RET();
                this.cycleCount -= 6;
                break;
            }
            case 249: {
                this.prevSP = this.regSP;
                this.regSP = this.regHL;
                break;
            }
            case 250: {
                if ((this.regAF & 0x80) != 0) {
                    this.regPC = this.READ_WORD();
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 251: {
                this.afterEI = true;
                this.setInterruptsEnabled(true);
                break;
            }
            case 252: {
                if ((this.regAF & 0x80) != 0) {
                    this.CALL();
                    this.cycleCount -= 7;
                    break;
                }
                this.regPC += 2;
                break;
            }
            case 253: {
                ++this.regR;
                this.executeInstructionFD(this.READ_BYTE());
                break;
            }
            case 254: {
                this.CP_LOBYTE(this.READ_BYTE());
                break;
            }
            case 255: {
                this.RST(56);
            }
        }
        this.prevPC = this.regPC;
    }

    protected void executeInstructionCB(int n) {
        switch (n) {
            case 0: {
                this.regBC = this.RLC_HIBYTE(this.regBC);
                break;
            }
            case 1: {
                this.regBC = this.RLC_LOBYTE(this.regBC);
                break;
            }
            case 2: {
                this.regDE = this.RLC_HIBYTE(this.regDE);
                break;
            }
            case 3: {
                this.regDE = this.RLC_LOBYTE(this.regDE);
                break;
            }
            case 4: {
                this.regHL = this.RLC_HIBYTE(this.regHL);
                break;
            }
            case 5: {
                this.regHL = this.RLC_LOBYTE(this.regHL);
                break;
            }
            case 6: {
                this.WRITE_BYTE(this.regHL, this.RLC_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 7: {
                this.regAF = (this.regAF & 0x7F00) << 1 | (this.regAF & 0x8000) >> 7 | this.regAF >> 15;
                this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
                break;
            }
            case 8: {
                this.regBC = this.RRC_HIBYTE(this.regBC);
                break;
            }
            case 9: {
                this.regBC = this.RRC_LOBYTE(this.regBC);
                break;
            }
            case 10: {
                this.regDE = this.RRC_HIBYTE(this.regDE);
                break;
            }
            case 11: {
                this.regDE = this.RRC_LOBYTE(this.regDE);
                break;
            }
            case 12: {
                this.regHL = this.RRC_HIBYTE(this.regHL);
                break;
            }
            case 13: {
                this.regHL = this.RRC_LOBYTE(this.regHL);
                break;
            }
            case 14: {
                this.WRITE_BYTE(this.regHL, this.RRC_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 15: {
                this.regAF = (this.regAF & 0x100) << 7 | (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1;
                this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
                break;
            }
            case 16: {
                this.regBC = this.RL_HIBYTE(this.regBC);
                break;
            }
            case 17: {
                this.regBC = this.RL_LOBYTE(this.regBC);
                break;
            }
            case 18: {
                this.regDE = this.RL_HIBYTE(this.regDE);
                break;
            }
            case 19: {
                this.regDE = this.RL_LOBYTE(this.regDE);
                break;
            }
            case 20: {
                this.regHL = this.RL_HIBYTE(this.regHL);
                break;
            }
            case 21: {
                this.regHL = this.RL_LOBYTE(this.regHL);
                break;
            }
            case 22: {
                this.WRITE_BYTE(this.regHL, this.RL_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 23: {
                this.regAF = (this.regAF & 0x7F00) << 1 | (this.regAF & 1) << 8 | this.regAF >> 15;
                this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
                break;
            }
            case 24: {
                this.regBC = this.RR_HIBYTE(this.regBC);
                break;
            }
            case 25: {
                this.regBC = this.RR_LOBYTE(this.regBC);
                break;
            }
            case 26: {
                this.regDE = this.RR_HIBYTE(this.regDE);
                break;
            }
            case 27: {
                this.regDE = this.RR_LOBYTE(this.regDE);
                break;
            }
            case 28: {
                this.regHL = this.RR_HIBYTE(this.regHL);
                break;
            }
            case 29: {
                this.regHL = this.RR_LOBYTE(this.regHL);
                break;
            }
            case 30: {
                this.WRITE_BYTE(this.regHL, this.RR_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 31: {
                this.regAF = (this.regAF & 1) << 15 | (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1;
                this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
                break;
            }
            case 32: {
                this.regBC = this.SLA_HIBYTE(this.regBC);
                break;
            }
            case 33: {
                this.regBC = this.SLA_LOBYTE(this.regBC);
                break;
            }
            case 34: {
                this.regDE = this.SLA_HIBYTE(this.regDE);
                break;
            }
            case 35: {
                this.regDE = this.SLA_LOBYTE(this.regDE);
                break;
            }
            case 36: {
                this.regHL = this.SLA_HIBYTE(this.regHL);
                break;
            }
            case 37: {
                this.regHL = this.SLA_LOBYTE(this.regHL);
                break;
            }
            case 38: {
                this.WRITE_BYTE(this.regHL, this.SLA_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 39: {
                this.regAF = (this.regAF & 0x7F00) << 1 | this.regAF >> 15;
                this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
                break;
            }
            case 40: {
                this.regBC = this.SRA_HIBYTE(this.regBC);
                break;
            }
            case 41: {
                this.regBC = this.SRA_LOBYTE(this.regBC);
                break;
            }
            case 42: {
                this.regDE = this.SRA_HIBYTE(this.regDE);
                break;
            }
            case 43: {
                this.regDE = this.SRA_LOBYTE(this.regDE);
                break;
            }
            case 44: {
                this.regHL = this.SRA_HIBYTE(this.regHL);
                break;
            }
            case 45: {
                this.regHL = this.SRA_LOBYTE(this.regHL);
                break;
            }
            case 46: {
                this.WRITE_BYTE(this.regHL, this.SRA_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 47: {
                this.regAF = this.regAF & 0x8000 | (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1;
                this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
                break;
            }
            case 48: {
                this.regBC = this.SLL_HIBYTE(this.regBC);
                break;
            }
            case 49: {
                this.regBC = this.SLL_LOBYTE(this.regBC);
                break;
            }
            case 50: {
                this.regDE = this.SLL_HIBYTE(this.regDE);
                break;
            }
            case 51: {
                this.regDE = this.SLL_LOBYTE(this.regDE);
                break;
            }
            case 52: {
                this.regHL = this.SLL_HIBYTE(this.regHL);
                break;
            }
            case 53: {
                this.regHL = this.SLL_LOBYTE(this.regHL);
                break;
            }
            case 54: {
                this.WRITE_BYTE(this.regHL, this.SLL_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 55: {
                this.regAF = (this.regAF & 0x7F00) << 1 | 0x100 | this.regAF >> 15;
                this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
                break;
            }
            case 56: {
                this.regBC = this.SRL_HIBYTE(this.regBC);
                break;
            }
            case 57: {
                this.regBC = this.SRL_LOBYTE(this.regBC);
                break;
            }
            case 58: {
                this.regDE = this.SRL_HIBYTE(this.regDE);
                break;
            }
            case 59: {
                this.regDE = this.SRL_LOBYTE(this.regDE);
                break;
            }
            case 60: {
                this.regHL = this.SRL_HIBYTE(this.regHL);
                break;
            }
            case 61: {
                this.regHL = this.SRL_LOBYTE(this.regHL);
                break;
            }
            case 62: {
                this.WRITE_BYTE(this.regHL, this.SRL_LOBYTE(this.READ_BYTE(this.regHL)));
                break;
            }
            case 63: {
                this.regAF = (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1;
                this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
                break;
            }
            case 64: {
                this.BIT(0, this.regBC >> 8);
                break;
            }
            case 65: {
                this.BIT(0, this.regBC & 0xFF);
                break;
            }
            case 66: {
                this.BIT(0, this.regDE >> 8);
                break;
            }
            case 67: {
                this.BIT(0, this.regDE & 0xFF);
                break;
            }
            case 68: {
                this.BIT(0, this.regHL >> 8);
                break;
            }
            case 69: {
                this.BIT(0, this.regHL & 0xFF);
                break;
            }
            case 70: {
                this.BIT_HL(0);
                break;
            }
            case 71: {
                this.BIT(0, this.regAF >> 8);
                break;
            }
            case 72: {
                this.BIT(1, this.regBC >> 8);
                break;
            }
            case 73: {
                this.BIT(1, this.regBC & 0xFF);
                break;
            }
            case 74: {
                this.BIT(1, this.regDE >> 8);
                break;
            }
            case 75: {
                this.BIT(1, this.regDE & 0xFF);
                break;
            }
            case 76: {
                this.BIT(1, this.regHL >> 8);
                break;
            }
            case 77: {
                this.BIT(1, this.regHL & 0xFF);
                break;
            }
            case 78: {
                this.BIT_HL(1);
                break;
            }
            case 79: {
                this.BIT(1, this.regAF >> 8);
                break;
            }
            case 80: {
                this.BIT(2, this.regBC >> 8);
                break;
            }
            case 81: {
                this.BIT(2, this.regBC & 0xFF);
                break;
            }
            case 82: {
                this.BIT(2, this.regDE >> 8);
                break;
            }
            case 83: {
                this.BIT(2, this.regDE & 0xFF);
                break;
            }
            case 84: {
                this.BIT(2, this.regHL >> 8);
                break;
            }
            case 85: {
                this.BIT(2, this.regHL & 0xFF);
                break;
            }
            case 86: {
                this.BIT_HL(2);
                break;
            }
            case 87: {
                this.BIT(2, this.regAF >> 8);
                break;
            }
            case 88: {
                this.BIT(3, this.regBC >> 8);
                break;
            }
            case 89: {
                this.BIT(3, this.regBC & 0xFF);
                break;
            }
            case 90: {
                this.BIT(3, this.regDE >> 8);
                break;
            }
            case 91: {
                this.BIT(3, this.regDE & 0xFF);
                break;
            }
            case 92: {
                this.BIT(3, this.regHL >> 8);
                break;
            }
            case 93: {
                this.BIT(3, this.regHL & 0xFF);
                break;
            }
            case 94: {
                this.BIT_HL(3);
                break;
            }
            case 95: {
                this.BIT(3, this.regAF >> 8);
                break;
            }
            case 96: {
                this.BIT(4, this.regBC >> 8);
                break;
            }
            case 97: {
                this.BIT(4, this.regBC & 0xFF);
                break;
            }
            case 98: {
                this.BIT(4, this.regDE >> 8);
                break;
            }
            case 99: {
                this.BIT(4, this.regDE & 0xFF);
                break;
            }
            case 100: {
                this.BIT(4, this.regHL >> 8);
                break;
            }
            case 101: {
                this.BIT(4, this.regHL & 0xFF);
                break;
            }
            case 102: {
                this.BIT_HL(4);
                break;
            }
            case 103: {
                this.BIT(4, this.regAF >> 8);
                break;
            }
            case 104: {
                this.BIT(5, this.regBC >> 8);
                break;
            }
            case 105: {
                this.BIT(5, this.regBC & 0xFF);
                break;
            }
            case 106: {
                this.BIT(5, this.regDE >> 8);
                break;
            }
            case 107: {
                this.BIT(5, this.regDE & 0xFF);
                break;
            }
            case 108: {
                this.BIT(5, this.regHL >> 8);
                break;
            }
            case 109: {
                this.BIT(5, this.regHL & 0xFF);
                break;
            }
            case 110: {
                this.BIT_HL(5);
                break;
            }
            case 111: {
                this.BIT(5, this.regAF >> 8);
                break;
            }
            case 112: {
                this.BIT(6, this.regBC >> 8);
                break;
            }
            case 113: {
                this.BIT(6, this.regBC & 0xFF);
                break;
            }
            case 114: {
                this.BIT(6, this.regDE >> 8);
                break;
            }
            case 115: {
                this.BIT(6, this.regDE & 0xFF);
                break;
            }
            case 116: {
                this.BIT(6, this.regHL >> 8);
                break;
            }
            case 117: {
                this.BIT(6, this.regHL & 0xFF);
                break;
            }
            case 118: {
                this.BIT_HL(6);
                break;
            }
            case 119: {
                this.BIT(6, this.regAF >> 8);
                break;
            }
            case 120: {
                this.BIT(7, this.regBC >> 8);
                break;
            }
            case 121: {
                this.BIT(7, this.regBC & 0xFF);
                break;
            }
            case 122: {
                this.BIT(7, this.regDE >> 8);
                break;
            }
            case 123: {
                this.BIT(7, this.regDE & 0xFF);
                break;
            }
            case 124: {
                this.BIT(7, this.regHL >> 8);
                break;
            }
            case 125: {
                this.BIT(7, this.regHL & 0xFF);
                break;
            }
            case 126: {
                this.BIT_HL(7);
                break;
            }
            case 127: {
                this.BIT(7, this.regAF >> 8);
                break;
            }
            case 128: {
                this.regBC &= 0xFEFF;
                break;
            }
            case 129: {
                this.regBC &= 0xFFFE;
                break;
            }
            case 130: {
                this.regDE &= 0xFEFF;
                break;
            }
            case 131: {
                this.regDE &= 0xFFFE;
                break;
            }
            case 132: {
                this.regHL &= 0xFEFF;
                break;
            }
            case 133: {
                this.regHL &= 0xFFFE;
                break;
            }
            case 134: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xFE);
                break;
            }
            case 135: {
                this.regAF &= 0xFEFF;
                break;
            }
            case 136: {
                this.regBC &= 0xFDFF;
                break;
            }
            case 137: {
                this.regBC &= 0xFFFD;
                break;
            }
            case 138: {
                this.regDE &= 0xFDFF;
                break;
            }
            case 139: {
                this.regDE &= 0xFFFD;
                break;
            }
            case 140: {
                this.regHL &= 0xFDFF;
                break;
            }
            case 141: {
                this.regHL &= 0xFFFD;
                break;
            }
            case 142: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xFD);
                break;
            }
            case 143: {
                this.regAF &= 0xFDFF;
                break;
            }
            case 144: {
                this.regBC &= 0xFBFF;
                break;
            }
            case 145: {
                this.regBC &= 0xFFFB;
                break;
            }
            case 146: {
                this.regDE &= 0xFBFF;
                break;
            }
            case 147: {
                this.regDE &= 0xFFFB;
                break;
            }
            case 148: {
                this.regHL &= 0xFBFF;
                break;
            }
            case 149: {
                this.regHL &= 0xFFFB;
                break;
            }
            case 150: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xFB);
                break;
            }
            case 151: {
                this.regAF &= 0xFBFF;
                break;
            }
            case 152: {
                this.regBC &= 0xF7FF;
                break;
            }
            case 153: {
                this.regBC &= 0xFFF7;
                break;
            }
            case 154: {
                this.regDE &= 0xF7FF;
                break;
            }
            case 155: {
                this.regDE &= 0xFFF7;
                break;
            }
            case 156: {
                this.regHL &= 0xF7FF;
                break;
            }
            case 157: {
                this.regHL &= 0xFFF7;
                break;
            }
            case 158: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xF7);
                break;
            }
            case 159: {
                this.regAF &= 0xF7FF;
                break;
            }
            case 160: {
                this.regBC &= 0xEFFF;
                break;
            }
            case 161: {
                this.regBC &= 0xFFEF;
                break;
            }
            case 162: {
                this.regDE &= 0xEFFF;
                break;
            }
            case 163: {
                this.regDE &= 0xFFEF;
                break;
            }
            case 164: {
                this.regHL &= 0xEFFF;
                break;
            }
            case 165: {
                this.regHL &= 0xFFEF;
                break;
            }
            case 166: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xEF);
                break;
            }
            case 167: {
                this.regAF &= 0xEFFF;
                break;
            }
            case 168: {
                this.regBC &= 0xDFFF;
                break;
            }
            case 169: {
                this.regBC &= 0xFFDF;
                break;
            }
            case 170: {
                this.regDE &= 0xDFFF;
                break;
            }
            case 171: {
                this.regDE &= 0xFFDF;
                break;
            }
            case 172: {
                this.regHL &= 0xDFFF;
                break;
            }
            case 173: {
                this.regHL &= 0xFFDF;
                break;
            }
            case 174: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xDF);
                break;
            }
            case 175: {
                this.regAF &= 0xDFFF;
                break;
            }
            case 176: {
                this.regBC &= 0xBFFF;
                break;
            }
            case 177: {
                this.regBC &= 0xFFBF;
                break;
            }
            case 178: {
                this.regDE &= 0xBFFF;
                break;
            }
            case 179: {
                this.regDE &= 0xFFBF;
                break;
            }
            case 180: {
                this.regHL &= 0xBFFF;
                break;
            }
            case 181: {
                this.regHL &= 0xFFBF;
                break;
            }
            case 182: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0xBF);
                break;
            }
            case 183: {
                this.regAF &= 0xBFFF;
                break;
            }
            case 184: {
                this.regBC &= Short.MAX_VALUE;
                break;
            }
            case 185: {
                this.regBC &= 0xFF7F;
                break;
            }
            case 186: {
                this.regDE &= Short.MAX_VALUE;
                break;
            }
            case 187: {
                this.regDE &= 0xFF7F;
                break;
            }
            case 188: {
                this.regHL &= Short.MAX_VALUE;
                break;
            }
            case 189: {
                this.regHL &= 0xFF7F;
                break;
            }
            case 190: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) & 0x7F);
                break;
            }
            case 191: {
                this.regAF &= Short.MAX_VALUE;
                break;
            }
            case 192: {
                this.regBC |= 0x100;
                break;
            }
            case 193: {
                this.regBC |= 1;
                break;
            }
            case 194: {
                this.regDE |= 0x100;
                break;
            }
            case 195: {
                this.regDE |= 1;
                break;
            }
            case 196: {
                this.regHL |= 0x100;
                break;
            }
            case 197: {
                this.regHL |= 1;
                break;
            }
            case 198: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 1);
                break;
            }
            case 199: {
                this.regAF |= 0x100;
                break;
            }
            case 200: {
                this.regBC |= 0x200;
                break;
            }
            case 201: {
                this.regBC |= 2;
                break;
            }
            case 202: {
                this.regDE |= 0x200;
                break;
            }
            case 203: {
                this.regDE |= 2;
                break;
            }
            case 204: {
                this.regHL |= 0x200;
                break;
            }
            case 205: {
                this.regHL |= 2;
                break;
            }
            case 206: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 2);
                break;
            }
            case 207: {
                this.regAF |= 0x200;
                break;
            }
            case 208: {
                this.regBC |= 0x400;
                break;
            }
            case 209: {
                this.regBC |= 4;
                break;
            }
            case 210: {
                this.regDE |= 0x400;
                break;
            }
            case 211: {
                this.regDE |= 4;
                break;
            }
            case 212: {
                this.regHL |= 0x400;
                break;
            }
            case 213: {
                this.regHL |= 4;
                break;
            }
            case 214: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 4);
                break;
            }
            case 215: {
                this.regAF |= 0x400;
                break;
            }
            case 216: {
                this.regBC |= 0x800;
                break;
            }
            case 217: {
                this.regBC |= 8;
                break;
            }
            case 218: {
                this.regDE |= 0x800;
                break;
            }
            case 219: {
                this.regDE |= 8;
                break;
            }
            case 220: {
                this.regHL |= 0x800;
                break;
            }
            case 221: {
                this.regHL |= 8;
                break;
            }
            case 222: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 8);
                break;
            }
            case 223: {
                this.regAF |= 0x800;
                break;
            }
            case 224: {
                this.regBC |= 0x1000;
                break;
            }
            case 225: {
                this.regBC |= 0x10;
                break;
            }
            case 226: {
                this.regDE |= 0x1000;
                break;
            }
            case 227: {
                this.regDE |= 0x10;
                break;
            }
            case 228: {
                this.regHL |= 0x1000;
                break;
            }
            case 229: {
                this.regHL |= 0x10;
                break;
            }
            case 230: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 0x10);
                break;
            }
            case 231: {
                this.regAF |= 0x1000;
                break;
            }
            case 232: {
                this.regBC |= 0x2000;
                break;
            }
            case 233: {
                this.regBC |= 0x20;
                break;
            }
            case 234: {
                this.regDE |= 0x2000;
                break;
            }
            case 235: {
                this.regDE |= 0x20;
                break;
            }
            case 236: {
                this.regHL |= 0x2000;
                break;
            }
            case 237: {
                this.regHL |= 0x20;
                break;
            }
            case 238: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 0x20);
                break;
            }
            case 239: {
                this.regAF |= 0x2000;
                break;
            }
            case 240: {
                this.regBC |= 0x4000;
                break;
            }
            case 241: {
                this.regBC |= 0x40;
                break;
            }
            case 242: {
                this.regDE |= 0x4000;
                break;
            }
            case 243: {
                this.regDE |= 0x40;
                break;
            }
            case 244: {
                this.regHL |= 0x4000;
                break;
            }
            case 245: {
                this.regHL |= 0x40;
                break;
            }
            case 246: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 0x40);
                break;
            }
            case 247: {
                this.regAF |= 0x4000;
                break;
            }
            case 248: {
                this.regBC |= 0x8000;
                break;
            }
            case 249: {
                this.regBC |= 0x80;
                break;
            }
            case 250: {
                this.regDE |= 0x8000;
                break;
            }
            case 251: {
                this.regDE |= 0x80;
                break;
            }
            case 252: {
                this.regHL |= 0x8000;
                break;
            }
            case 253: {
                this.regHL |= 0x80;
                break;
            }
            case 254: {
                this.WRITE_BYTE(this.regHL, this.READ_BYTE(this.regHL) | 0x80);
                break;
            }
            case 255: {
                this.regAF |= 0x8000;
            }
        }
    }

    private void executeInstructionED(int n) {
        switch (n) {
            case 64: {
                int n2 = this.READ_PORT(this.regBC & 0xFF);
                this.regBC = n2 << 8 | this.regBC & 0xFF;
                this.regAF = this.regAF & 0xFF01 | FLAGS_PV_3_5_Z_S[n2];
                break;
            }
            case 65: {
                this.WRITE_PORT(this.regBC & 0xFF, this.regBC >> 8);
                break;
            }
            case 66: {
                this.SBC_WORD(this.regBC);
                break;
            }
            case 67: {
                this.regWZ = this.READ_WORD();
                this.WRITE_WORD(this.regWZ++, this.regBC);
                break;
            }
            case 68: {
                this.NEG();
                break;
            }
            case 69: {
                this.RETN();
                break;
            }
            case 70: {
                this.interruptMode = 0;
                break;
            }
            case 71: {
                this.regI = this.regAF >> 8;
                break;
            }
            case 72: {
                int n3 = this.READ_PORT(this.regBC & 0xFF);
                this.regBC = this.regBC & 0xFF00 | n3;
                this.regAF = this.regAF & 0xFF01 | FLAGS_PV_3_5_Z_S[n3];
                break;
            }
            case 73: {
                this.WRITE_PORT(this.regBC & 0xFF, this.regBC & 0xFF);
                break;
            }
            case 74: {
                this.ADC_WORD(this.regBC);
                break;
            }
            case 75: {
                this.regWZ = this.READ_WORD();
                this.regBC = this.READ_WORD(this.regWZ++);
                break;
            }
            case 76: {
                this.NEG();
                break;
            }
            case 77: {
                this.RET();
                break;
            }
            case 79: {
                this.regR = this.regAF >> 8;
                this.regRbit7 = this.regR & 0x80;
                break;
            }
            case 80: {
                int n4 = this.READ_PORT(this.regBC & 0xFF);
                this.regDE = n4 << 8 | this.regDE & 0xFF;
                this.regAF = this.regAF & 0xFF01 | FLAGS_PV_3_5_Z_S[n4];
                break;
            }
            case 81: {
                this.WRITE_PORT(this.regBC & 0xFF, this.regDE >> 8);
                break;
            }
            case 82: {
                this.SBC_WORD(this.regDE);
                break;
            }
            case 83: {
                this.regWZ = this.READ_WORD();
                this.WRITE_WORD(this.regWZ++, this.regDE);
                break;
            }
            case 84: {
                this.NEG();
                break;
            }
            case 85: {
                this.RETN();
                break;
            }
            case 86: {
                this.interruptMode = 1;
                break;
            }
            case 87: {
                this.regAF = this.regI << 8 | this.regAF & 1 | (this.regI == 0 ? 64 : this.regI & 0x80) | (this.interruptFlipFlop2 ? 4 : 0);
                this.afterIFFfetch = true;
                break;
            }
            case 88: {
                int n5 = this.READ_PORT(this.regBC & 0xFF);
                this.regDE = this.regDE & 0xFF00 | n5;
                this.regAF = this.regAF & 0xFF01 | FLAGS_PV_3_5_Z_S[n5];
                break;
            }
            case 89: {
                this.WRITE_PORT(this.regBC & 0xFF, this.regDE & 0xFF);
                break;
            }
            case 90: {
                this.ADC_WORD(this.regDE);
                break;
            }
            case 91: {
                this.regWZ = this.READ_WORD();
                this.regDE = this.READ_WORD(this.regWZ++);
                break;
            }
            case 92: {
                this.NEG();
                break;
            }
            case 93: {
                this.RETN();
                break;
            }
            case 94: {
                this.interruptMode = 2;
                break;
            }
            case 95: {
                this.regR = this.regRbit7 | this.regR & 0x7F;
                this.regAF = this.regR << 8 | (this.regR == 0 ? 68 : this.regR & 0xA8) | this.regAF & 1 | (this.interruptFlipFlop2 ? 4 : 0);
                this.afterIFFfetch = true;
                break;
            }
            case 96: {
                int n6 = this.READ_PORT(this.regBC & 0xFF);
                this.regHL = n6 << 8 | this.regHL & 0xFF;
                this.regAF = this.regAF & 0xFF01 | FLAGS_PV_3_5_Z_S[n6];
                break;
            }
            case 97: {
                this.WRITE_PORT(this.regBC & 0xFF, this.regHL >> 8);
                break;
            }
            case 98: {
                this.SBC_WORD(this.regHL);
                break;
            }
            case 99: {
                this.regWZ = this.READ_WORD();
                this.WRITE_WORD(this.regWZ++, this.regHL);
                break;
            }
            case 100: {
                this.NEG();
                break;
            }
            case 101: {
                this.RETN();
                break;
            }
            case 102: {
                this.interruptMode = 0;
                break;
            }
            case 103: {
                this.RRD();
                break;
            }
            case 104: {
                int n7 = this.READ_PORT(this.regBC & 0xFF);
                this.regHL = this.regHL & 0xFF00 | n7;
                this.regAF = this.regAF & 0xFF01 | FLAGS_PV_3_5_Z_S[n7];
                break;
            }
            case 105: {
                this.WRITE_PORT(this.regBC & 0xFF, this.regHL & 0xFF);
                break;
            }
            case 106: {
                this.ADC_WORD(this.regHL);
                break;
            }
            case 107: {
                this.regWZ = this.READ_WORD();
                this.regHL = this.READ_WORD(this.regWZ++);
                break;
            }
            case 108: {
                this.NEG();
                break;
            }
            case 109: {
                this.RETN();
                break;
            }
            case 111: {
                this.RLD();
                break;
            }
            case 112: {
                int n8 = this.READ_PORT(this.regBC & 0xFF);
                this.regAF = this.regAF & 0xFF01 | FLAGS_PV_3_5_Z_S[n8];
                break;
            }
            case 113: {
                this.WRITE_PORT(this.regBC & 0xFF, 0);
                break;
            }
            case 114: {
                this.SBC_WORD(this.regSP);
                break;
            }
            case 115: {
                this.regWZ = this.READ_WORD();
                this.WRITE_WORD(this.regWZ++, this.regSP);
                break;
            }
            case 116: {
                this.NEG();
                break;
            }
            case 117: {
                this.RETN();
                break;
            }
            case 118: {
                this.interruptMode = 1;
                break;
            }
            case 120: {
                int n9 = this.READ_PORT(this.regBC & 0xFF);
                this.regWZ = this.regBC + 1;
                this.regAF = n9 << 8 | this.regAF & 1 | FLAGS_PV_3_5_Z_S[n9];
                break;
            }
            case 121: {
                this.WRITE_PORT(this.regBC & 0xFF, this.regAF >> 8);
                this.regWZ = this.regBC + 1;
                break;
            }
            case 122: {
                this.ADC_WORD(this.regSP);
                break;
            }
            case 123: {
                this.regWZ = this.READ_WORD();
                this.prevSP = this.regSP;
                this.regSP = this.READ_WORD(this.regWZ++);
                break;
            }
            case 124: {
                this.NEG();
                break;
            }
            case 125: {
                this.RETN();
                break;
            }
            case 126: {
                this.interruptMode = 2;
                break;
            }
            case 160: {
                this.LDI();
                break;
            }
            case 161: {
                this.CPI();
                break;
            }
            case 162: {
                this.INI();
                break;
            }
            case 163: {
                this.OUTI();
                break;
            }
            case 168: {
                this.LDD();
                break;
            }
            case 169: {
                this.CPD();
                break;
            }
            case 170: {
                this.IND();
                break;
            }
            case 171: {
                this.OUTD();
                break;
            }
            case 176: {
                this.LDI();
                if (this.regBC <= 0) break;
                this.regPC -= 2;
                this.regWZ = this.regPC + 1;
                this.cycleCount -= 5;
                break;
            }
            case 177: {
                this.CPI();
                if (this.regBC <= 0 || (this.regAF & 0x40) != 0) break;
                this.regPC -= 2;
                this.regWZ = this.regPC + 1;
                this.cycleCount -= 5;
                break;
            }
            case 178: {
                this.INI();
                if ((this.regBC & 0xFF00) <= 0) break;
                this.regPC -= 2;
                this.cycleCount -= 5;
                break;
            }
            case 179: {
                this.OUTI();
                if ((this.regBC & 0xFF00) <= 0) break;
                this.regPC -= 2;
                this.cycleCount -= 5;
                break;
            }
            case 184: {
                this.LDD();
                if (this.regBC <= 0) break;
                this.regPC -= 2;
                this.regWZ = this.regPC + 1;
                this.cycleCount -= 5;
                break;
            }
            case 185: {
                this.CPD();
                if (this.regBC <= 0 || (this.regAF & 0x40) != 0) break;
                this.regPC -= 2;
                this.regWZ = this.regPC + 1;
                this.cycleCount -= 5;
                break;
            }
            case 186: {
                this.IND();
                if ((this.regBC & 0xFF00) <= 0) break;
                this.regPC -= 2;
                this.cycleCount -= 5;
                break;
            }
            case 187: {
                this.OUTD();
                if ((this.regBC & 0xFF00) <= 0) break;
                this.regPC -= 2;
                this.cycleCount -= 5;
                break;
            }
            default: {
                System.err.println(String.valueOf(Integer.toHexString(this.regPC - 2)) + "\t" + Integer.toHexString(0xED00 | n).toUpperCase());
            }
        }
    }

    private void executeInstructionDD(int n) {
        switch (n) {
            case 9: {
                this.ADD_WORD_IX(this.regBC);
                this.cycleCount -= 11;
                break;
            }
            case 25: {
                this.ADD_WORD_IX(this.regDE);
                this.cycleCount -= 11;
                break;
            }
            case 33: {
                this.regIX = this.READ_WORD();
                this.cycleCount -= 10;
                break;
            }
            case 34: {
                this.regWZ = this.READ_WORD();
                this.WRITE_WORD(this.regWZ++, this.regIX);
                this.cycleCount -= 16;
                break;
            }
            case 35: {
                this.regIX = Z80.INC_WORD(this.regIX);
                this.cycleCount -= 6;
                break;
            }
            case 36: {
                this.regIX = this.INC_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 37: {
                this.regIX = this.DEC_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 38: {
                this.regIX = this.READ_BYTE() << 8 | this.regIX & 0xFF;
                this.cycleCount -= 7;
                break;
            }
            case 41: {
                this.ADD_WORD_IX(this.regIX);
                this.cycleCount -= 11;
                break;
            }
            case 42: {
                this.regWZ = this.READ_WORD();
                this.regIX = this.READ_WORD(this.regWZ++);
                this.cycleCount -= 16;
                break;
            }
            case 43: {
                this.regIX = Z80.DEC_WORD(this.regIX);
                this.cycleCount -= 6;
                break;
            }
            case 44: {
                this.regIX = this.INC_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 45: {
                this.regIX = this.DEC_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 46: {
                this.regIX = this.regIX & 0xFF00 | this.READ_BYTE();
                this.cycleCount -= 7;
                break;
            }
            case 52: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.READ_BYTE(this.regWZ) + 1 & 0xFF);
                this.regAF = this.regAF & 0xFF01 | FLAGS_INC[this.READ_BYTE(this.regWZ)];
                this.cycleCount -= 19;
                break;
            }
            case 53: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.READ_BYTE(this.regWZ) - 1 & 0xFF);
                this.regAF = this.regAF & 0xFF01 | FLAGS_DEC[this.READ_BYTE(this.regWZ)];
                this.cycleCount -= 19;
                break;
            }
            case 54: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 57: {
                this.ADD_WORD_IX(this.regSP);
                this.cycleCount -= 11;
                break;
            }
            case 68: {
                this.regBC = this.regIX & 0xFF00 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 69: {
                this.regBC = (this.regIX & 0xFF) << 8 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 70: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.regBC = this.READ_BYTE(this.regWZ) << 8 | this.regBC & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 76: {
                this.regBC = this.regBC & 0xFF00 | this.regIX >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 77: {
                this.regBC = this.regBC & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 78: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.regBC = this.regBC & 0xFF00 | this.READ_BYTE(this.regWZ);
                this.cycleCount -= 15;
                break;
            }
            case 84: {
                this.regDE = this.regIX & 0xFF00 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 85: {
                this.regDE = (this.regIX & 0xFF) << 8 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 86: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.regDE = this.READ_BYTE(this.regWZ) << 8 | this.regDE & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 92: {
                this.regDE = this.regDE & 0xFF00 | this.regIX >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 93: {
                this.regDE = this.regDE & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 94: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.regDE = this.regDE & 0xFF00 | this.READ_BYTE(this.regWZ);
                this.cycleCount -= 15;
                break;
            }
            case 96: {
                this.regIX = this.regBC & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 97: {
                this.regIX = (this.regBC & 0xFF) << 8 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 98: {
                this.regIX = this.regDE & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 99: {
                this.regIX = (this.regDE & 0xFF) << 8 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 100: {
                this.cycleCount -= 4;
                break;
            }
            case 101: {
                this.regIX = (this.regIX & 0xFF) << 8 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 102: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.regHL = this.READ_BYTE(this.regWZ) << 8 | this.regHL & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 103: {
                this.regIX = this.regAF & 0xFF00 | this.regIX & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 104: {
                this.regIX = this.regIX & 0xFF00 | this.regBC >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 105: {
                this.regIX = this.regIX & 0xFF00 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 106: {
                this.regIX = this.regIX & 0xFF00 | this.regDE >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 107: {
                this.regIX = this.regIX & 0xFF00 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 108: {
                this.regIX = this.regIX & 0xFF00 | this.regIX >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 109: {
                this.cycleCount -= 4;
                break;
            }
            case 110: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.regHL = this.regHL & 0xFF00 | this.READ_BYTE(this.regWZ);
                this.cycleCount -= 15;
                break;
            }
            case 111: {
                this.regIX = this.regIX & 0xFF00 | this.regAF >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 112: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regBC >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 113: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regBC & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 114: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regDE >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 115: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regDE & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 116: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regHL >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 117: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regHL & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 119: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regAF >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 124: {
                this.regAF = this.regIX & 0xFF00 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 125: {
                this.regAF = (this.regIX & 0xFF) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 126: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.regAF = this.READ_BYTE(this.regWZ) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 132: {
                this.ADD_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 133: {
                this.ADD_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 134: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.ADD_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 140: {
                this.ADC_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 141: {
                this.ADC_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 142: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.ADC_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 148: {
                this.SUB_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 149: {
                this.SUB_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 150: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.SUB_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 156: {
                this.SBC_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 157: {
                this.SBC_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 158: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.SBC_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 164: {
                this.AND_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 165: {
                this.AND_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 166: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.AND_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 172: {
                this.XOR_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 173: {
                this.XOR_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 174: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.XOR_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 180: {
                this.OR_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 181: {
                this.OR_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 182: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.OR_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 188: {
                this.CP_HIBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 189: {
                this.CP_LOBYTE(this.regIX);
                this.cycleCount -= 4;
                break;
            }
            case 190: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.CP_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 203: {
                this.regWZ = this.regIX + (byte)this.READ_BYTE();
                this.executeInstructionDDCBorFDCB(this.regWZ, this.READ_BYTE());
                break;
            }
            case 225: {
                this.regIX = this.POP();
                this.cycleCount -= 10;
                break;
            }
            case 227: {
                this.regWZ = this.READ_WORD(this.regSP);
                this.WRITE_WORD(this.regSP, this.regIX);
                this.regIX = this.regWZ;
                this.cycleCount -= 19;
                break;
            }
            case 229: {
                this.PUSH(this.regIX);
                this.cycleCount -= 11;
                break;
            }
            case 233: {
                this.regPC = this.regIX;
                this.cycleCount -= 4;
                break;
            }
            case 249: {
                this.prevSP = this.regSP;
                this.regSP = this.regIX;
                this.cycleCount -= 6;
                break;
            }
            default: {
                --this.regPC;
                --this.regR;
            }
        }
    }

    private void executeInstructionDDCBorFDCB(int n, int n2) {
        this.cycleCount -= (n2 & 0xC0) == 64 ? 16 : 19;
        int n3 = this.READ_BYTE(n);
        switch (n2) {
            case 0: {
                this.regBC = this.RLC_LOBYTE(n3) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 1: {
                this.regBC = this.regBC & 0xFF00 | this.RLC_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 2: {
                this.regDE = this.RLC_LOBYTE(n3) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 3: {
                this.regDE = this.regDE & 0xFF00 | this.RLC_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 4: {
                this.regHL = this.RLC_LOBYTE(n3) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 5: {
                this.regHL = this.regHL & 0xFF00 | this.RLC_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 6: {
                this.WRITE_BYTE(n, this.RLC_LOBYTE(n3));
                break;
            }
            case 7: {
                this.regAF = this.RLC_LOBYTE(n3) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 8: {
                this.regBC = this.RRC_LOBYTE(n3) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 9: {
                this.regBC = this.regBC & 0xFF00 | this.RRC_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 10: {
                this.regDE = this.RRC_LOBYTE(n3) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 11: {
                this.regDE = this.regDE & 0xFF00 | this.RRC_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 12: {
                this.regHL = this.RRC_LOBYTE(n3) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 13: {
                this.regHL = this.regHL & 0xFF00 | this.RRC_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 14: {
                this.WRITE_BYTE(n, this.RRC_LOBYTE(n3));
                break;
            }
            case 15: {
                this.regAF = this.RRC_LOBYTE(n3) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 16: {
                this.regBC = this.RL_LOBYTE(n3) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 17: {
                this.regBC = this.regBC & 0xFF00 | this.RL_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 18: {
                this.regDE = this.RL_LOBYTE(n3) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 19: {
                this.regDE = this.regDE & 0xFF00 | this.RL_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 20: {
                this.regHL = this.RL_LOBYTE(n3) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 21: {
                this.regHL = this.regHL & 0xFF00 | this.RL_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 22: {
                this.WRITE_BYTE(n, this.RL_LOBYTE(n3));
                break;
            }
            case 23: {
                this.regAF = this.RL_LOBYTE(n3) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 24: {
                this.regBC = this.RR_LOBYTE(n3) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 25: {
                this.regBC = this.regBC & 0xFF00 | this.RR_LOBYTE(n3) << 8;
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 26: {
                this.regDE = this.RR_LOBYTE(n3) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 27: {
                this.regDE = this.regDE & 0xFF00 | this.RR_LOBYTE(n3) << 8;
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 28: {
                this.regHL = this.RR_LOBYTE(n3) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 29: {
                this.regHL = this.regHL & 0xFF00 | this.RR_LOBYTE(n3) << 8;
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 30: {
                this.WRITE_BYTE(n, this.RR_LOBYTE(n3));
                break;
            }
            case 31: {
                this.regAF = this.RR_LOBYTE(n3) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 32: {
                this.regBC = this.SLA_LOBYTE(n3) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 33: {
                this.regBC = this.regBC & 0xFF00 | this.SLA_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 34: {
                this.regDE = this.SLA_LOBYTE(n3) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 35: {
                this.regDE = this.regDE & 0xFF00 | this.SLA_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 36: {
                this.regHL = this.SLA_LOBYTE(n3) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 37: {
                this.regHL = this.regHL & 0xFF00 | this.SLA_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 38: {
                this.WRITE_BYTE(n, this.SLA_LOBYTE(n3));
                break;
            }
            case 39: {
                this.regAF = this.SLA_LOBYTE(n3) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 40: {
                this.regBC = this.SRA_LOBYTE(n3) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 41: {
                this.regBC = this.regBC & 0xFF00 | this.SRA_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 42: {
                this.regDE = this.SRA_LOBYTE(n3) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 43: {
                this.regDE = this.regDE & 0xFF00 | this.SRA_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 44: {
                this.regHL = this.SRA_LOBYTE(n3) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 45: {
                this.regHL = this.regHL & 0xFF00 | this.SRA_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 46: {
                this.WRITE_BYTE(n, this.SRA_LOBYTE(n3));
                break;
            }
            case 47: {
                this.regAF = this.SRA_LOBYTE(n3) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 48: {
                this.regBC = this.SLL_LOBYTE(n3) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 49: {
                this.regBC = this.regBC & 0xFF00 | this.SLL_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 50: {
                this.regDE = this.SLL_LOBYTE(n3) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 51: {
                this.regDE = this.regDE & 0xFF00 | this.SLL_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 52: {
                this.regHL = this.SLL_LOBYTE(n3) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 53: {
                this.regHL = this.regHL & 0xFF00 | this.SLL_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 54: {
                this.WRITE_BYTE(n, this.SLL_LOBYTE(n3));
                break;
            }
            case 55: {
                this.regAF = this.SLL_LOBYTE(n3) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 56: {
                this.regBC = this.SRL_LOBYTE(n3) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 57: {
                this.regBC = this.regBC & 0xFF00 | this.SRL_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 58: {
                this.regDE = this.SRL_LOBYTE(n3) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 59: {
                this.regDE = this.regDE & 0xFF00 | this.SRL_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 60: {
                this.regHL = this.SRL_LOBYTE(n3) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 61: {
                this.regHL = this.regHL & 0xFF00 | this.SRL_LOBYTE(n3);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 62: {
                this.WRITE_BYTE(n, this.SRL_LOBYTE(n3));
                break;
            }
            case 63: {
                this.regAF = this.SRL_LOBYTE(n3) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                this.BIT_IX_IY(0, n3, n);
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                this.BIT_IX_IY(1, n3, n);
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                this.BIT_IX_IY(2, n3, n);
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.BIT_IX_IY(3, n3, n);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                this.BIT_IX_IY(4, n3, n);
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this.BIT_IX_IY(5, n3, n);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.BIT_IX_IY(6, n3, n);
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.BIT_IX_IY(7, n3, n);
                break;
            }
            case 128: {
                this.regBC = (n3 & 0xFE) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 129: {
                this.regBC = this.regBC & 0xFF00 | n3 & 0xFE;
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 130: {
                this.regDE = (n3 & 0xFE) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 131: {
                this.regDE = this.regDE & 0xFF00 | n3 & 0xFE;
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 132: {
                this.regHL = (n3 & 0xFE) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 133: {
                this.regHL = this.regHL & 0xFF00 | n3 & 0xFE;
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 134: {
                this.WRITE_BYTE(n, n3 & 0xFE);
                break;
            }
            case 135: {
                this.regAF = (n3 & 0xFE) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 136: {
                this.regBC = (n3 & 0xFD) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 137: {
                this.regBC = this.regBC & 0xFF00 | n3 & 0xFD;
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 138: {
                this.regDE = (n3 & 0xFD) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 139: {
                this.regDE = this.regDE & 0xFF00 | n3 & 0xFD;
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 140: {
                this.regHL = (n3 & 0xFD) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 141: {
                this.regHL = this.regHL & 0xFF00 | n3 & 0xFD;
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 142: {
                this.WRITE_BYTE(n, n3 & 0xFD);
                break;
            }
            case 143: {
                this.regAF = (n3 & 0xFD) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 144: {
                this.regBC = (n3 & 0xFB) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 145: {
                this.regBC = this.regBC & 0xFF00 | n3 & 0xFB;
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 146: {
                this.regDE = (n3 & 0xFB) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 147: {
                this.regDE = this.regDE & 0xFF00 | n3 & 0xFB;
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 148: {
                this.regHL = (n3 & 0xFB) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 149: {
                this.regHL = this.regHL & 0xFF00 | n3 & 0xFB;
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 150: {
                this.WRITE_BYTE(n, n3 & 0xFB);
                break;
            }
            case 151: {
                this.regAF = (n3 & 0xFB) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 152: {
                this.regBC = (n3 & 0xF7) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 153: {
                this.regBC = this.regBC & 0xFF00 | n3 & 0xF7;
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 154: {
                this.regDE = (n3 & 0xF7) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 155: {
                this.regDE = this.regDE & 0xFF00 | (n3 & 0xF7) << 8;
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 156: {
                this.regHL = (n3 & 0xF7) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 157: {
                this.regHL = this.regHL & 0xFF00 | n3 & 0xF7;
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 158: {
                this.WRITE_BYTE(n, n3 & 0xF7);
                break;
            }
            case 159: {
                this.regAF = (n3 & 0xF7) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 160: {
                this.regBC = n3 & 0xEF | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 161: {
                this.regBC = this.regBC & 0xFF00 | n3 & 0xEF;
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 162: {
                this.regDE = n3 & 0xEF | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 163: {
                this.regDE = this.regDE & 0xFF00 | n3 & 0xEF;
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 164: {
                this.regHL = n3 & 0xEF | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 165: {
                this.regHL = this.regHL & 0xFF00 | n3 & 0xEF;
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 166: {
                this.WRITE_BYTE(n, n3 & 0xEF);
                break;
            }
            case 167: {
                this.regAF = n3 & 0xEF | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 168: {
                this.regBC = (n3 & 0xDF) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 169: {
                this.regBC = this.regBC & 0xFF00 | n3 & 0xDF;
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 170: {
                this.regDE = (n3 & 0xDF) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 171: {
                this.regDE = this.regDE & 0xFF00 | n3 & 0xDF;
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 172: {
                this.regHL = (n3 & 0xDF) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 173: {
                this.regHL = this.regHL & 0xFF00 | n3 & 0xDF;
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 174: {
                this.WRITE_BYTE(n, n3 & 0xDF);
                break;
            }
            case 175: {
                this.regAF = (n3 & 0xDF) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 176: {
                this.regBC = (n3 & 0xBF) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 177: {
                this.regBC = this.regBC & 0xFF00 | n3 & 0xBF;
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 178: {
                this.regDE = (n3 & 0xBF) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 179: {
                this.regDE = this.regDE & 0xFF00 | n3 & 0xBF;
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 180: {
                this.regHL = (n3 & 0xBF) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 181: {
                this.regHL = this.regHL & 0xFF00 | n3 & 0xBF;
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 182: {
                this.WRITE_BYTE(n, n3 & 0xBF);
                break;
            }
            case 183: {
                this.regAF = (n3 & 0xBF) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 184: {
                this.regBC = (n3 & 0x7F) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 185: {
                this.regBC = this.regBC & 0xFF00 | n3 & 0x7F;
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 186: {
                this.regDE = (n3 & 0x7F) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 187: {
                this.regDE = this.regDE & 0xFF00 | n3 & 0x7F;
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 188: {
                this.regHL = (n3 & 0x7F) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 189: {
                this.regHL = this.regHL & 0xFF00 | n3 & 0x7F;
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 190: {
                this.WRITE_BYTE(n, n3 & 0x7F);
                break;
            }
            case 191: {
                this.regAF = (n3 & 0x7F) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 192: {
                this.regBC = (n3 | 1) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 193: {
                this.regBC = this.regBC & 0xFF00 | (n3 | 1);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 194: {
                this.regDE = (n3 | 1) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 195: {
                this.regDE = this.regDE & 0xFF00 | (n3 | 1);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 196: {
                this.regHL = (n3 | 1) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 197: {
                this.regHL = this.regHL & 0xFF00 | (n3 | 1);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 198: {
                this.WRITE_BYTE(n, n3 | 1);
                break;
            }
            case 199: {
                this.regAF = (n3 | 1) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 200: {
                this.regBC = (n3 | 2) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 201: {
                this.regBC = this.regBC & 0xFF00 | (n3 | 2);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 202: {
                this.regDE = (n3 | 2) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 203: {
                this.regDE = this.regDE & 0xFF00 | (n3 | 2);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 204: {
                this.regHL = (n3 | 2) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 205: {
                this.regHL = this.regHL & 0xFF00 | (n3 | 2);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 206: {
                this.WRITE_BYTE(n, n3 | 2);
                break;
            }
            case 207: {
                this.regAF = (n3 | 2) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 208: {
                this.regBC = (n3 | 4) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 209: {
                this.regBC = this.regBC & 0xFF00 | (n3 | 4);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 210: {
                this.regDE = (n3 | 4) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 211: {
                this.regDE = this.regDE & 0xFF00 | (n3 | 4);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 212: {
                this.regHL = (n3 | 4) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 213: {
                this.regHL = this.regHL & 0xFF00 | (n3 | 4);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 214: {
                this.WRITE_BYTE(n, n3 | 4);
                break;
            }
            case 215: {
                this.regAF = (n3 | 4) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 216: {
                this.regBC = (n3 | 8) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 217: {
                this.regBC = this.regBC & 0xFF00 | (n3 | 8);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 218: {
                this.regDE = (n3 | 8) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 219: {
                this.regDE = this.regDE & 0xFF00 | (n3 | 8);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 220: {
                this.regHL = (n3 | 8) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 221: {
                this.regHL = this.regHL & 0xFF00 | (n3 | 8);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 222: {
                this.WRITE_BYTE(n, n3 | 8);
                break;
            }
            case 223: {
                this.regAF = (n3 | 8) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 224: {
                this.regBC = (n3 | 0x10) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 225: {
                this.regBC = this.regBC & 0xFF00 | (n3 | 0x10);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 226: {
                this.regDE = (n3 | 0x10) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 227: {
                this.regDE = this.regDE & 0xFF00 | (n3 | 0x10);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 228: {
                this.regHL = (n3 | 0x10) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 229: {
                this.regHL = this.regHL & 0xFF00 | (n3 | 0x10);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 230: {
                this.WRITE_BYTE(n, n3 | 0x10);
                break;
            }
            case 231: {
                this.regAF = (n3 | 0x10) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 232: {
                this.regBC = (n3 | 0x20) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 233: {
                this.regBC = this.regBC & 0xFF00 | (n3 | 0x20);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 234: {
                this.regDE = (n3 | 0x20) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 235: {
                this.regDE = this.regDE & 0xFF00 | (n3 | 0x20);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 236: {
                this.regHL = (n3 | 0x20) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 237: {
                this.regHL = this.regHL & 0xFF00 | (n3 | 0x20);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 238: {
                this.WRITE_BYTE(n, n3 | 0x20);
                break;
            }
            case 239: {
                this.regAF = (n3 | 0x20) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 240: {
                this.regBC = (n3 | 0x40) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 241: {
                this.regBC = this.regBC & 0xFF00 | (n3 | 0x40);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 242: {
                this.regDE = (n3 | 0x40) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 243: {
                this.regDE = this.regDE & 0xFF00 | (n3 | 0x40);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 244: {
                this.regHL = (n3 | 0x40) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 245: {
                this.regHL = this.regHL & 0xFF00 | (n3 | 0x40);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 246: {
                this.WRITE_BYTE(n, n3 | 0x40);
                break;
            }
            case 247: {
                this.regAF = (n3 | 0x40) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
                break;
            }
            case 248: {
                this.regBC = (n3 | 0x80) << 8 | this.regBC & 0xFF;
                this.WRITE_BYTE(n, this.regBC >> 8);
                break;
            }
            case 249: {
                this.regBC = this.regBC & 0xFF00 | (n3 | 0x80);
                this.WRITE_BYTE(n, this.regBC & 0xFF);
                break;
            }
            case 250: {
                this.regDE = (n3 | 0x80) << 8 | this.regDE & 0xFF;
                this.WRITE_BYTE(n, this.regDE >> 8);
                break;
            }
            case 251: {
                this.regDE = this.regDE & 0xFF00 | (n3 | 0x80);
                this.WRITE_BYTE(n, this.regDE & 0xFF);
                break;
            }
            case 252: {
                this.regHL = (n3 | 0x80) << 8 | this.regHL & 0xFF;
                this.WRITE_BYTE(n, this.regHL >> 8);
                break;
            }
            case 253: {
                this.regHL = this.regHL & 0xFF00 | (n3 | 0x80);
                this.WRITE_BYTE(n, this.regHL & 0xFF);
                break;
            }
            case 254: {
                this.WRITE_BYTE(n, n3 | 0x80);
                break;
            }
            case 255: {
                this.regAF = (n3 | 0x80) << 8 | this.regAF & 0xFF;
                this.WRITE_BYTE(n, this.regAF >> 8);
            }
        }
    }

    private void executeInstructionFD(int n) {
        switch (n) {
            case 9: {
                this.ADD_WORD_IY(this.regBC);
                this.cycleCount -= 11;
                break;
            }
            case 25: {
                this.ADD_WORD_IY(this.regDE);
                this.cycleCount -= 11;
                break;
            }
            case 33: {
                this.regIY = this.READ_WORD();
                this.cycleCount -= 10;
                break;
            }
            case 34: {
                this.regWZ = this.READ_WORD();
                this.WRITE_WORD(this.regWZ++, this.regIY);
                this.cycleCount -= 16;
                break;
            }
            case 35: {
                this.regIY = Z80.INC_WORD(this.regIY);
                this.cycleCount -= 6;
                break;
            }
            case 36: {
                this.regIY = this.INC_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 37: {
                this.regIY = this.DEC_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 38: {
                this.regIY = this.READ_BYTE() << 8 | this.regIY & 0xFF;
                this.cycleCount -= 7;
                break;
            }
            case 41: {
                this.ADD_WORD_IY(this.regIY);
                this.cycleCount -= 11;
                break;
            }
            case 42: {
                this.regWZ = this.READ_WORD();
                this.regIY = this.READ_WORD(this.regWZ++);
                this.cycleCount -= 16;
                break;
            }
            case 43: {
                this.regIY = Z80.DEC_WORD(this.regIY);
                this.cycleCount -= 6;
                break;
            }
            case 44: {
                this.regIY = this.INC_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 45: {
                this.regIY = this.DEC_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 46: {
                this.regIY = this.regIY & 0xFF00 | this.READ_BYTE();
                this.cycleCount -= 7;
                break;
            }
            case 52: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.READ_BYTE(this.regWZ) + 1 & 0xFF);
                this.regAF = this.regAF & 0xFF01 | FLAGS_INC[this.READ_BYTE(this.regWZ)];
                this.cycleCount -= 19;
                break;
            }
            case 53: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.READ_BYTE(this.regWZ) - 1 & 0xFF);
                this.regAF = this.regAF & 0xFF01 | FLAGS_DEC[this.READ_BYTE(this.regWZ)];
                this.cycleCount -= 19;
                break;
            }
            case 54: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.READ_BYTE());
                this.cycleCount -= 15;
                break;
            }
            case 57: {
                this.ADD_WORD_IY(this.regSP);
                this.cycleCount -= 11;
                break;
            }
            case 68: {
                this.regBC = this.regIY & 0xFF00 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 69: {
                this.regBC = (this.regIY & 0xFF) << 8 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 70: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.regBC = this.READ_BYTE(this.regWZ) << 8 | this.regBC & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 76: {
                this.regBC = this.regBC & 0xFF00 | this.regIY >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 77: {
                this.regBC = this.regBC & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 78: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.regBC = this.regBC & 0xFF00 | this.READ_BYTE(this.regWZ);
                this.cycleCount -= 15;
                break;
            }
            case 84: {
                this.regDE = this.regIY & 0xFF00 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 85: {
                this.regDE = (this.regIY & 0xFF) << 8 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 86: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.regDE = this.READ_BYTE(this.regWZ) << 8 | this.regDE & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 92: {
                this.regDE = this.regDE & 0xFF00 | this.regIY >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 93: {
                this.regDE = this.regDE & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 94: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.regDE = this.regDE & 0xFF00 | this.READ_BYTE(this.regWZ);
                this.cycleCount -= 15;
                break;
            }
            case 96: {
                this.regIY = this.regBC & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 97: {
                this.regIY = (this.regBC & 0xFF) << 8 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 98: {
                this.regIY = this.regDE & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 99: {
                this.regIY = (this.regDE & 0xFF) << 8 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 100: {
                this.cycleCount -= 4;
                break;
            }
            case 101: {
                this.regIY = (this.regIY & 0xFF) << 8 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 102: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.regHL = this.READ_BYTE(this.regWZ) << 8 | this.regHL & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 103: {
                this.regIY = this.regAF & 0xFF00 | this.regIY & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 104: {
                this.regIY = this.regIY & 0xFF00 | this.regBC >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 105: {
                this.regIY = this.regIY & 0xFF00 | this.regBC & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 106: {
                this.regIY = this.regIY & 0xFF00 | this.regDE >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 107: {
                this.regIY = this.regIY & 0xFF00 | this.regDE & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 108: {
                this.regIY = this.regIY & 0xFF00 | this.regIY >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 109: {
                this.cycleCount -= 4;
                break;
            }
            case 110: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.regHL = this.regHL & 0xFF00 | this.READ_BYTE(this.regWZ);
                this.cycleCount -= 15;
                break;
            }
            case 111: {
                this.regIY = this.regIY & 0xFF00 | this.regAF >> 8;
                this.cycleCount -= 4;
                break;
            }
            case 112: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regBC >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 113: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regBC & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 114: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regDE >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 115: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regDE & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 116: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regHL >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 117: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regHL & 0xFF);
                this.cycleCount -= 15;
                break;
            }
            case 119: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.WRITE_BYTE(this.regWZ, this.regAF >> 8);
                this.cycleCount -= 15;
                break;
            }
            case 124: {
                this.regAF = this.regIY & 0xFF00 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 125: {
                this.regAF = (this.regIY & 0xFF) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 126: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.regAF = this.READ_BYTE(this.regWZ) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 15;
                break;
            }
            case 132: {
                this.ADD_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 133: {
                this.ADD_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 134: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.ADD_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 140: {
                this.ADC_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 141: {
                this.ADC_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 142: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.ADC_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 148: {
                this.SUB_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 149: {
                this.SUB_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 150: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.SUB_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 156: {
                this.SBC_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 157: {
                this.SBC_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 158: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.SBC_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 164: {
                this.AND_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 165: {
                this.AND_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 166: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.AND_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 172: {
                this.XOR_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 173: {
                this.XOR_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 174: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.XOR_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 180: {
                this.OR_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 181: {
                this.OR_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 182: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.OR_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 188: {
                this.CP_HIBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 189: {
                this.CP_LOBYTE(this.regIY);
                this.cycleCount -= 4;
                break;
            }
            case 190: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.CP_LOBYTE(this.READ_BYTE(this.regWZ));
                this.cycleCount -= 15;
                break;
            }
            case 203: {
                this.regWZ = this.regIY + (byte)this.READ_BYTE();
                this.executeInstructionDDCBorFDCB(this.regWZ, this.READ_BYTE());
                break;
            }
            case 225: {
                this.regIY = this.POP();
                this.cycleCount -= 10;
                break;
            }
            case 227: {
                this.regWZ = this.READ_WORD(this.regSP);
                this.WRITE_WORD(this.regSP, this.regIY);
                this.regIY = this.regWZ;
                this.cycleCount -= 19;
                break;
            }
            case 229: {
                this.PUSH(this.regIY);
                this.cycleCount -= 11;
                break;
            }
            case 233: {
                this.regPC = this.regIY;
                this.cycleCount -= 4;
                break;
            }
            case 249: {
                this.prevSP = this.regSP;
                this.regSP = this.regIY;
                this.cycleCount -= 6;
                break;
            }
            default: {
                --this.regPC;
                --this.regR;
            }
        }
    }

    public boolean isInterruptsEnabled() {
        return this.interruptFlipFlop1 && !this.afterEI;
    }

    public void setInterruptsEnabled(boolean bl) {
        this.interruptFlipFlop2 = this.interruptFlipFlop1 = bl;
    }

    @Override
    public void setInterruptLine(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.pinINT = bl;
                break;
            }
            case 2: {
                if (!this.pinNMI && bl) {
                    this.nmiPending = true;
                }
                this.pinNMI = bl;
            }
        }
    }

    @Override
    protected void handleInterrupts() {
        if (this.WAIT_CYCLES > 0 && this.waitedCycles > 0) {
            this.cycleCount += this.waitedCycles;
            this.waitedCycles = 0;
        }
        if (this.pinINT && !this.afterEI && this.interruptFlipFlop1 || this.nmiPending) {
            if (this.halted) {
                ++this.regPC;
                this.halted = false;
                this.WRITE_PORT(374, 0);
                this.cyclesToExecute -= this.cycleCount;
                this.cycleCount = 0;
            }
            this.interruptFlipFlop1 = false;
            if (this.nmiPending) {
                this.nmiPending = false;
                this.cycleCount -= CYCLES[255];
                this.RST(102);
                this.prevPC = this.regPC;
            } else if (this.pinINT) {
                this.cycleCount -= 2;
                this.interruptFlipFlop2 = false;
                if (this.afterIFFfetch) {
                    this.regAF &= 0xFFFFFFFB;
                }
                switch (this.interruptMode) {
                    case 0: {
                        this.cycleCount -= CYCLES[255] - this.WAIT_CYCLES;
                        this.RST(56);
                        break;
                    }
                    case 1: {
                        this.cycleCount -= CYCLES[255] - this.WAIT_CYCLES;
                        this.RST(56);
                        break;
                    }
                    case 2: {
                        this.regWZ = this.READ_WORD(this.regI << 8 | 0xFF);
                        this.cycleCount -= CYCLES[205] - this.WAIT_CYCLES;
                        this.RST(this.regWZ);
                    }
                }
                this.prevPC = this.regPC;
            }
        } else if (this.WAIT_CYCLES > 0 && this.cycleCount == this.WAIT_CYCLES) {
            this.waitedCycles = this.cycleCount;
            this.cycleCount = 0;
        }
        this.afterIFFfetch = false;
    }

    private final void DAA() {
        int n = this.regAF >> 8;
        if ((this.regAF & 2) != 0) {
            if ((this.regAF & 0x10) != 0 || (n & 0xF) > 9) {
                this.regAF = this.regAF - 1536 & 0xFFFF;
            }
            if ((this.regAF & 1) != 0 || n > 153) {
                this.regAF = this.regAF - 24576 & 0xFFFF | 1;
            }
        } else {
            if ((this.regAF & 0x10) != 0 || (n & 0xF) > 9) {
                this.regAF = this.regAF + 1536 & 0xFFFF;
            }
            if ((this.regAF & 1) != 0 || n > 153) {
                this.regAF = this.regAF + 24576 & 0xFFFF | 1;
            }
        }
        this.regAF = this.regAF & 0xFF03 | FLAGS_PV_3_5_Z_S[this.regAF >> 8] | (this.regAF >> 8 ^ n) & 0x10;
    }

    private final void INI() {
        int n = this.READ_PORT(this.regBC & 0xFF);
        this.cycleCount -= 3;
        this.regWZ = this.regBC + 1;
        this.WRITE_BYTE(this.regHL, n);
        this.regBC = this.DEC_HIBYTE(this.regBC);
        this.regHL = Z80.INC_WORD(this.regHL);
        int n2 = (this.regBC + 1 & 0xFF) + n;
        this.regAF &= 0xFFC0;
        if ((n & 0x80) != 0) {
            this.regAF |= 2;
        }
        if (n2 > 255) {
            this.regAF |= 0x11;
        }
        this.regAF |= FLAGS_PV_3_5_Z_S[this.regBC >> 8 ^ n2 & 7] & 4;
    }

    private final void LDI() {
        int n = this.READ_BYTE(this.regHL);
        this.WRITE_BYTE(this.regDE, n);
        this.regDE = Z80.INC_WORD(this.regDE);
        this.regHL = Z80.INC_WORD(this.regHL);
        this.regBC = Z80.DEC_WORD(this.regBC);
        int n2 = this.regAF = this.regBC > 0 ? this.regAF & 0xFFC1 | 4 : this.regAF & 0xFFC1;
        if (((this.regAF >> 8) + n & 2) != 0) {
            this.regAF |= 0x20;
        }
        if (((this.regAF >> 8) + n & 8) != 0) {
            this.regAF |= 8;
        }
    }

    private final void LDD() {
        int n = this.READ_BYTE(this.regHL);
        this.WRITE_BYTE(this.regDE, n);
        this.regDE = Z80.DEC_WORD(this.regDE);
        this.regHL = Z80.DEC_WORD(this.regHL);
        this.regBC = Z80.DEC_WORD(this.regBC);
        int n2 = this.regAF = this.regBC > 0 ? this.regAF & 0xFFC1 | 4 : this.regAF & 0xFFC1;
        if (((this.regAF >> 8) + n & 2) != 0) {
            this.regAF |= 0x20;
        }
        if (((this.regAF >> 8) + n & 8) != 0) {
            this.regAF |= 8;
        }
    }

    private final void OUTI() {
        int n = this.READ_BYTE(this.regHL);
        this.WRITE_PORT(this.regBC & 0xFF, n);
        this.regWZ = this.regBC + 1;
        this.regBC = this.DEC_HIBYTE(this.regBC);
        this.regHL = Z80.INC_WORD(this.regHL);
        int n2 = n + (this.regHL & 0xFF);
        this.regAF &= 0xFFC0;
        if ((n & 0x80) != 0) {
            this.regAF |= 2;
        }
        if (n2 > 255) {
            this.regAF |= 0x11;
        }
        this.regAF |= FLAGS_PV_3_5_Z_S[this.regBC >> 8 ^ n2 & 7] & 4;
    }

    private final void IND() {
        int n = this.READ_PORT(this.regBC & 0xFF);
        this.cycleCount -= 3;
        this.regWZ = this.regBC - 1;
        this.WRITE_BYTE(this.regHL, n);
        this.regHL = Z80.DEC_WORD(this.regHL);
        this.regBC = this.DEC_HIBYTE(this.regBC);
        int n2 = (this.regBC - 1 & 0xFF) + n;
        this.regAF &= 0xFFC0;
        if ((n & 0x80) != 0) {
            this.regAF |= 2;
        }
        if (n2 > 255) {
            this.regAF |= 0x11;
        }
        this.regAF |= FLAGS_PV_3_5_Z_S[this.regBC >> 8 ^ n2 & 7] & 4;
    }

    private final void OUTD() {
        int n = this.READ_BYTE(this.regHL);
        this.WRITE_PORT(this.regBC & 0xFF, n);
        this.regWZ = this.regBC - 1;
        this.regHL = Z80.DEC_WORD(this.regHL);
        this.regBC = this.DEC_HIBYTE(this.regBC);
        int n2 = n + (this.regHL & 0xFF);
        this.regAF &= 0xFFC0;
        if ((n & 0x80) != 0) {
            this.regAF |= 2;
        }
        if (n2 > 255) {
            this.regAF |= 0x11;
        }
        this.regAF |= FLAGS_PV_3_5_Z_S[this.regBC >> 8 ^ n2 & 7] & 4;
    }

    private final void ADD_LOBYTE(int n) {
        int n2;
        this.regAF = n2 << 8 | ((n2 = (this.regAF >> 8) + n & 0xFF) < this.regAF >> 8 ? 1 : 0) | (((n & 0xFF ^ this.regAF >> 8 ^ 0x80) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) < (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0xA8);
    }

    private final void ADD_HIBYTE(int n) {
        this.ADD_LOBYTE(n >> 8);
    }

    private final void ADD_WORD_HL(int n) {
        this.regWZ = this.regHL + 1;
        this.regAF = this.regAF & 0xFFC4 | (this.regHL ^ this.regHL + n ^ n) >> 8 & 0x10 | this.regHL + n >> 16;
        this.regHL = this.regHL + n & 0xFFFF;
        this.regAF |= this.regHL >> 8 & 0x28;
    }

    private final void ADD_WORD_IX(int n) {
        this.regWZ = this.regIX + 1;
        this.regAF = this.regAF & 0xFFC4 | (this.regIX ^ this.regIX + n ^ n) >> 8 & 0x10 | this.regIX + n >> 16;
        this.regIX = this.regIX + n & 0xFFFF;
        this.regAF |= this.regIX >> 8 & 0x28;
    }

    private final void ADD_WORD_IY(int n) {
        this.regWZ = this.regIY + 1;
        this.regAF = this.regAF & 0xFFC4 | (this.regIY ^ this.regIY + n ^ n) >> 8 & 0x10 | this.regIY + n >> 16;
        this.regIY = this.regIY + n & 0xFFFF;
        this.regAF |= this.regIY >> 8 & 0x28;
    }

    private final void ADC_WORD(int n) {
        int n2;
        this.regWZ = this.regHL + 1;
        this.regAF = this.regAF & 0xFF00 | n2 >> 8 & 0xA8 | (((n2 = this.regHL + n + (this.regAF & 1)) & 0xFFFF) == 0 ? 64 : 0) | (this.regHL ^ n2 ^ n) >> 8 & 0x10 | ((n ^ this.regHL ^ 0x8000) & (n ^ n2) & 0x8000) >> 13 | n2 >> 16 & 1;
        this.regHL = n2 & 0xFFFF;
    }

    private final void ADC_LOBYTE(int n) {
        if ((this.regAF & 1) != 0) {
            int n2 = (this.regAF >> 8) + n + 1 & 0xFF;
            this.regAF = (n2 <= this.regAF >> 8 ? 1 : 0) | (((n & 0xFF ^ this.regAF >> 8 ^ 0x80) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) <= (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0xA8) | n2 << 8;
        } else {
            this.ADD_LOBYTE(n);
        }
    }

    private final void ADC_HIBYTE(int n) {
        this.ADC_LOBYTE(n >> 8);
    }

    private final void SUB_LOBYTE(int n) {
        int n2 = (this.regAF >> 8) - n & 0xFF;
        this.regAF = (n2 > this.regAF >> 8 ? 3 : 2) | (((n & 0xFF ^ this.regAF >> 8) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) > (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0xA8) | n2 << 8;
    }

    private final void SUB_HIBYTE(int n) {
        this.SUB_LOBYTE(n >> 8);
    }

    private final void SBC_WORD(int n) {
        int n2;
        this.regWZ = this.regHL + 1;
        this.regAF = this.regAF & 0xFF00 | n2 >> 8 & 0xA8 | (((n2 = this.regHL - n - (this.regAF & 1)) & 0xFFFF) == 0 ? 66 : 2) | (this.regHL ^ n2 ^ n) >> 8 & 0x10 | ((n ^ this.regHL) & (this.regHL ^ n2) & 0x8000) >> 13 | n2 >> 16 & 1;
        this.regHL = n2 & 0xFFFF;
    }

    private final void SBC_LOBYTE(int n) {
        if ((this.regAF & 1) != 0) {
            int n2 = (this.regAF >> 8) - n - 1 & 0xFF;
            this.regAF = (n2 >= this.regAF >> 8 ? 3 : 2) | (((n & 0xFF ^ this.regAF >> 8) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) >= (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0xA8) | n2 << 8;
        } else {
            this.SUB_LOBYTE(n);
        }
    }

    private final void SBC_HIBYTE(int n) {
        this.SBC_LOBYTE(n >> 8);
    }

    private final void AND_LOBYTE(int n) {
        this.AND_HIBYTE(n << 8);
    }

    private final void AND_HIBYTE(int n) {
        this.regAF = this.regAF & n & 0xFF00;
        this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8] | 0x10;
    }

    private final void XOR_LOBYTE(int n) {
        this.XOR_HIBYTE(n << 8);
    }

    private final void XOR_HIBYTE(int n) {
        this.regAF = (this.regAF ^ n) & 0xFF00;
        this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
    }

    private final void OR_LOBYTE(int n) {
        this.OR_HIBYTE(n << 8);
    }

    private final void OR_HIBYTE(int n) {
        this.regAF = (this.regAF | n) & 0xFF00;
        this.regAF |= FLAGS_PV_3_5_Z_S[this.regAF >> 8];
    }

    private final void CPI() {
        int n = (this.regAF >> 8) - this.READ_BYTE(this.regHL) & 0xFF;
        ++this.regWZ;
        this.regHL = Z80.INC_WORD(this.regHL);
        this.regBC = Z80.DEC_WORD(this.regBC);
        this.regAF = this.regAF & 0xFF01 | (n == 0 ? 64 : n & 0x80) | ((n & 0xF) > (this.regAF & 0xF00) >> 8 ? 16 : 0) | (this.regBC > 0 ? 6 : 2);
        if ((this.regAF & 0x10) != 0) {
            --n;
        }
        if ((n & 2) != 0) {
            this.regAF |= 0x20;
        }
        if ((n & 8) != 0) {
            this.regAF |= 8;
        }
    }

    private final void CPD() {
        int n = (this.regAF >> 8) - this.READ_BYTE(this.regHL) & 0xFF;
        --this.regWZ;
        this.regHL = Z80.DEC_WORD(this.regHL);
        this.regBC = Z80.DEC_WORD(this.regBC);
        this.regAF = this.regAF & 0xFF01 | (n == 0 ? 64 : n & 0x80) | ((n & 0xF) > (this.regAF & 0xF00) >> 8 ? 16 : 0) | (this.regBC > 0 ? 6 : 2);
        if ((this.regAF & 0x10) != 0) {
            --n;
        }
        if ((n & 2) != 0) {
            this.regAF |= 0x20;
        }
        if ((n & 8) != 0) {
            this.regAF |= 8;
        }
    }

    private final void CP_LOBYTE(int n) {
        int n2 = (this.regAF >> 8) - n & 0xFF;
        this.regAF = this.regAF & 0xFF00 | (n2 > this.regAF >> 8 ? 3 : 2) | (((n & 0xFF ^ this.regAF >> 8) & (this.regAF >> 8 ^ n2) & 0x80) != 0 ? 4 : 0) | ((n2 & 0xF) > (this.regAF & 0xF00) >> 8 ? 16 : 0) | (n2 == 0 ? 64 : n2 & 0x80) | n & 0x28;
    }

    private final void CP_HIBYTE(int n) {
        this.CP_LOBYTE(n >> 8);
    }

    private final int RLC_LOBYTE(int n) {
        n = n & 0xFF00 | (n & 0x7F) << 1 | (n & 0x80) >> 7;
        this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[n & 0xFF] | n & 1;
        return n;
    }

    private final int RLC_HIBYTE(int n) {
        n = (n & 0x7F00) << 1 | (n & 0x8000) >> 7 | n & 0xFF;
        this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[n >> 8] | (n & 0x100) >> 8;
        return n;
    }

    private final int RRC_LOBYTE(int n) {
        n = n & 0xFF00 | (n & 1) << 7 | (n & 0xFE) >> 1;
        this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[n & 0xFF] | n >> 7 & 1;
        return n;
    }

    private final int RRC_HIBYTE(int n) {
        n = (n & 0x100) << 7 | (n & 0xFE00) >> 1 | n & 0xFF;
        this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[n >> 8] | n >> 15;
        return n;
    }

    private final int RL_LOBYTE(int n) {
        int n2 = n >> 7 & 1;
        n = n & 0xFF00 | (n & 0x7F) << 1 | this.regAF & 1;
        this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[n & 0xFF] | n2;
        return n;
    }

    private final int RL_HIBYTE(int n) {
        int n2 = n >> 15;
        n = (n & 0x7F00) << 1 | (this.regAF & 1) << 8 | n & 0xFF;
        this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[n >> 8] | n2;
        return n;
    }

    private final int RR_LOBYTE(int n) {
        int n2 = n & 1;
        n = n & 0xFF00 | (this.regAF & 1) << 7 | (n & 0xFF) >> 1;
        this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[n & 0xFF] | n2;
        return n;
    }

    private final int RR_HIBYTE(int n) {
        int n2 = n >> 8 & 1;
        n = (this.regAF & 1) << 15 | (n & 0xFE00) >> 1 | n & 0xFF;
        this.regAF = this.regAF & 0xFF00 | FLAGS_PV_3_5_Z_S[n >> 8] | n2;
        return n;
    }

    private final int SLA_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 7 & 1;
        n = n & 0xFF00 | (n & 0x7F) << 1;
        this.regAF |= FLAGS_PV_3_5_Z_S[n & 0xFF];
        return n;
    }

    private final int SLA_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 15;
        n = (n & 0x7F00) << 1 | n & 0xFF;
        this.regAF |= FLAGS_PV_3_5_Z_S[n >> 8];
        return n;
    }

    private final int SRA_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n & 1;
        n = n & 0xFF00 | n & 0x80 | (n & 0xFE) >> 1;
        this.regAF |= FLAGS_PV_3_5_Z_S[n & 0xFF];
        return n;
    }

    private final int SRA_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 8 & 1;
        n = n & 0x8000 | (n & 0xFE00) >> 1 | n & 0xFF;
        this.regAF |= FLAGS_PV_3_5_Z_S[n >> 8];
        return n;
    }

    private final int SLL_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 7 & 1;
        n = n & 0xFF00 | (n & 0x7F) << 1 | 1;
        this.regAF |= FLAGS_PV_3_5_Z_S[n & 0xFF];
        return n;
    }

    private final int SLL_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 15;
        n = (n & 0x7F00) << 1 | 0x100 | n & 0xFF;
        this.regAF |= FLAGS_PV_3_5_Z_S[n >> 8];
        return n;
    }

    private final int SRL_LOBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n & 1;
        n = n & 0xFF00 | (n & 0xFE) >> 1;
        this.regAF |= FLAGS_PV_3_5_Z_S[n & 0xFF];
        return n;
    }

    private final int SRL_HIBYTE(int n) {
        this.regAF = this.regAF & 0xFF00 | n >> 8 & 1;
        n = (n & 0xFE00) >> 1 | n & 0xFF;
        this.regAF |= FLAGS_PV_3_5_Z_S[n >> 8];
        return n;
    }

    private final void BIT(int n, int n2) {
        int n3 = n2 & 1 << n;
        this.regAF = this.regAF & 0xFF01 | 0x10 | (n3 == 0 ? 68 : n3 & 0x80) | n2 & 0x28;
    }

    private final void BIT_HL(int n) {
        int n2 = this.READ_BYTE(this.regHL) & 1 << n;
        this.regAF = this.regAF & 0xFF01 | 0x10 | (n2 == 0 ? 68 : n2 & 0x80) | this.regWZ >> 8 & 0x28;
    }

    private final void BIT_IX_IY(int n, int n2, int n3) {
        this.regAF = this.regAF & 0xFF01 | 0x10 | ((n2 &= 1 << n) == 0 ? 68 : n2 & 0x80) | n3 >> 8 & 0x28;
    }

    private final int INC_LOBYTE(int n) {
        n = n & 0xFF00 | n + 1 & 0xFF;
        this.regAF = this.regAF & 0xFF01 | FLAGS_INC[n & 0xFF];
        return n;
    }

    private final int INC_HIBYTE(int n) {
        n = n + 256 & 0xFFFF;
        this.regAF = this.regAF & 0xFF01 | FLAGS_INC[n >> 8];
        return n;
    }

    private static final int INC_WORD(int n) {
        return n + 1 & 0xFFFF;
    }

    private final int DEC_LOBYTE(int n) {
        n = n & 0xFF00 | n - 1 & 0xFF;
        this.regAF = this.regAF & 0xFF01 | FLAGS_DEC[n & 0xFF];
        return n;
    }

    private final int DEC_HIBYTE(int n) {
        n = n - 256 & 0xFFFF;
        this.regAF = this.regAF & 0xFF01 | FLAGS_DEC[n >> 8];
        return n;
    }

    private static final int DEC_WORD(int n) {
        return n - 1 & 0xFFFF;
    }

    private final void NEG() {
        int n = this.regAF;
        this.regAF = 0;
        this.SUB_HIBYTE(n);
    }

    private final void RRD() {
        int n = this.READ_BYTE(this.regHL);
        this.regWZ = this.regHL + 1;
        this.WRITE_BYTE(this.regHL, n >> 4 | this.regAF >> 4 & 0xF0);
        this.regAF = this.regAF & 0xF001 | (n & 0xF) << 8;
        this.regAF = this.regAF & 0xFF01 | FLAGS_PV_3_5_Z_S[this.regAF >> 8];
    }

    private final void RLD() {
        int n = this.READ_BYTE(this.regHL);
        this.regWZ = this.regHL + 1;
        this.WRITE_BYTE(this.regHL, n << 4 & 0xF0 | this.regAF >> 8 & 0xF);
        this.regAF = this.regAF & 0xF001 | (n & 0xF0) << 4;
        this.regAF = this.regAF & 0xFF01 | FLAGS_PV_3_5_Z_S[this.regAF >> 8];
    }

    private final void CALL() {
        this.regWZ = this.READ_WORD(this.regPC);
        this.PUSH(this.regPC + 2);
        this.regPC = this.regWZ;
    }

    private final void RST(int n) {
        this.regWZ = n;
        this.PUSH(this.regPC);
        this.regPC = this.regWZ;
    }

    private final void RET() {
        this.regPC = this.regWZ = this.POP();
    }

    private final void RETN() {
        this.regPC = this.regWZ = this.POP();
        this.interruptFlipFlop1 = this.interruptFlipFlop2;
    }

    private final void PUSH(int n) {
        this.WRITE_BYTE(this.DEC_SP(), n >> 8);
        this.WRITE_BYTE(this.DEC_SP(), n & 0xFF);
    }

    private final int POP() {
        return this.READ_BYTE(this.INC_SP()) | this.READ_BYTE(this.INC_SP()) << 8;
    }

    protected final int DEC_SP() {
        this.regSP = this.regSP - 1 & 0xFFFF;
        return this.regSP;
    }

    protected final int INC_SP() {
        int n = this.regSP;
        this.regSP = this.regSP + 1 & 0xFFFF;
        return n;
    }

    @Override
    protected int incPC() {
        int n = this.regPC;
        this.regPC = this.regPC + 1 & 0xFFFF;
        return n;
    }

    public State getState() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getRegAF() {
                return Z80.this.regAF;
            }

            @Override
            public int getRegBC() {
                return Z80.this.regBC;
            }

            @Override
            public int getRegDE() {
                return Z80.this.regDE;
            }

            @Override
            public int getRegHL() {
                return Z80.this.regHL;
            }

            @Override
            public int getRegAFex() {
                return Z80.this.regAFex;
            }

            @Override
            public int getRegBCex() {
                return Z80.this.regBCex;
            }

            @Override
            public int getRegDEex() {
                return Z80.this.regDEex;
            }

            @Override
            public int getRegHLex() {
                return Z80.this.regHLex;
            }

            @Override
            public int getRegR() {
                return Z80.this.regR;
            }

            @Override
            public int getRegRbit7() {
                return Z80.this.regRbit7;
            }

            @Override
            public int getRegI() {
                return Z80.this.regI;
            }

            @Override
            public int getRegIX() {
                return Z80.this.regIX;
            }

            @Override
            public int getRegIY() {
                return Z80.this.regIY;
            }

            @Override
            public int getRegWZ() {
                return Z80.this.regWZ;
            }

            @Override
            public int getRegPC() {
                return Z80.this.regPC;
            }

            @Override
            public int getRegSP() {
                return Z80.this.regSP;
            }

            @Override
            public boolean isAfterEI() {
                return Z80.this.afterEI;
            }

            @Override
            public boolean isPinINT() {
                return Z80.this.pinINT;
            }

            @Override
            public boolean isPinNMI() {
                return Z80.this.pinNMI;
            }

            @Override
            public boolean isNmiPending() {
                return Z80.this.nmiPending;
            }

            @Override
            public boolean isInterruptFlipFlop1() {
                return Z80.this.interruptFlipFlop1;
            }

            @Override
            public boolean isInterruptFlipFlop2() {
                return Z80.this.interruptFlipFlop2;
            }

            @Override
            public int getInterruptMode() {
                return Z80.this.interruptMode;
            }

            @Override
            public int getCycleCount() {
                return Z80.this.cycleCount;
            }

            @Override
            public boolean isHalted() {
                return Z80.this.halted;
            }
        };
    }

    public void setState(State state) {
        this.regAF = state.getRegAF();
        this.regBC = state.getRegBC();
        this.regDE = state.getRegDE();
        this.regHL = state.getRegHL();
        this.regAFex = state.getRegAFex();
        this.regBCex = state.getRegBCex();
        this.regDEex = state.getRegDEex();
        this.regHLex = state.getRegHLex();
        this.regR = state.getRegR();
        this.regRbit7 = state.getRegRbit7();
        this.regI = state.getRegI();
        this.regIX = state.getRegIX();
        this.regIY = state.getRegIY();
        this.regWZ = state.getRegWZ();
        this.regPC = state.getRegPC();
        this.regSP = state.getRegSP();
        this.prevPC = this.regPC;
        this.prevSP = this.regSP;
        this.afterEI = state.isAfterEI();
        this.pinINT = state.isPinINT();
        this.pinNMI = state.isPinNMI();
        this.nmiPending = state.isNmiPending();
        this.interruptFlipFlop1 = state.isInterruptFlipFlop1();
        this.interruptFlipFlop2 = state.isInterruptFlipFlop2();
        this.interruptMode = state.getInterruptMode();
        this.cycleCount = state.getCycleCount();
        this.halted = state.isHalted();
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getRegAF();

        public int getRegBC();

        public int getRegDE();

        public int getRegHL();

        public int getRegAFex();

        public int getRegBCex();

        public int getRegDEex();

        public int getRegHLex();

        public int getRegR();

        public int getRegRbit7();

        public int getRegI();

        public int getRegIX();

        public int getRegIY();

        public int getRegWZ();

        public int getRegPC();

        public int getRegSP();

        public boolean isAfterEI();

        public boolean isPinINT();

        public boolean isPinNMI();

        public boolean isNmiPending();

        public boolean isInterruptFlipFlop1();

        public boolean isInterruptFlipFlop2();

        public int getInterruptMode();

        public int getCycleCount();

        public boolean isHalted();
    }

    private static class StateClone
    implements State {
        private int regAF;
        private int regBC;
        private int regDE;
        private int regHL;
        private int regAFex;
        private int regBCex;
        private int regDEex;
        private int regHLex;
        private int regR;
        private int regRbit7;
        private int regI;
        private int regIX;
        private int regIY;
        private int regWZ;
        private int regPC;
        private int regSP;
        private boolean afterEI;
        private boolean pinINT;
        private boolean pinNMI;
        private boolean nmiPending;
        private boolean interruptFlipFlop1;
        private boolean interruptFlipFlop2;
        private int interruptMode;
        private int cycleCount;
        private boolean halted;

        public StateClone(State state) {
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            this.regAF = state.getRegAF();
            this.regBC = state.getRegBC();
            this.regDE = state.getRegDE();
            this.regHL = state.getRegHL();
            this.regAFex = state.getRegAFex();
            this.regBCex = state.getRegBCex();
            this.regDEex = state.getRegDEex();
            this.regHLex = state.getRegHLex();
            this.regR = state.getRegR();
            this.regRbit7 = state.getRegRbit7();
            this.regI = state.getRegI();
            this.regIX = state.getRegIX();
            this.regIY = state.getRegIY();
            this.regWZ = state.getRegWZ();
            this.regPC = state.getRegPC();
            this.regSP = state.getRegSP();
            this.afterEI = state.isAfterEI();
            this.pinINT = state.isPinINT();
            this.pinNMI = state.isPinNMI();
            this.nmiPending = state.isNmiPending();
            this.interruptFlipFlop1 = state.isInterruptFlipFlop1();
            this.interruptFlipFlop2 = state.isInterruptFlipFlop2();
            this.interruptMode = state.getInterruptMode();
            this.cycleCount = state.getCycleCount();
            this.halted = state.isHalted();
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getRegAF() {
            return this.regAF;
        }

        @Override
        public int getRegBC() {
            return this.regBC;
        }

        @Override
        public int getRegDE() {
            return this.regDE;
        }

        @Override
        public int getRegHL() {
            return this.regHL;
        }

        @Override
        public int getRegAFex() {
            return this.regAFex;
        }

        @Override
        public int getRegBCex() {
            return this.regBCex;
        }

        @Override
        public int getRegDEex() {
            return this.regDEex;
        }

        @Override
        public int getRegHLex() {
            return this.regHLex;
        }

        @Override
        public int getRegR() {
            return this.regR;
        }

        @Override
        public int getRegRbit7() {
            return this.regRbit7;
        }

        @Override
        public int getRegI() {
            return this.regI;
        }

        @Override
        public int getRegIX() {
            return this.regIX;
        }

        @Override
        public int getRegIY() {
            return this.regIY;
        }

        @Override
        public int getRegWZ() {
            return this.regWZ;
        }

        @Override
        public int getRegPC() {
            return this.regPC;
        }

        @Override
        public int getRegSP() {
            return this.regSP;
        }

        @Override
        public boolean isAfterEI() {
            return this.afterEI;
        }

        @Override
        public boolean isPinINT() {
            return this.pinINT;
        }

        @Override
        public boolean isPinNMI() {
            return this.pinNMI;
        }

        @Override
        public boolean isNmiPending() {
            return this.nmiPending;
        }

        @Override
        public boolean isInterruptFlipFlop1() {
            return this.interruptFlipFlop1;
        }

        @Override
        public boolean isInterruptFlipFlop2() {
            return this.interruptFlipFlop2;
        }

        @Override
        public int getInterruptMode() {
            return this.interruptMode;
        }

        @Override
        public int getCycleCount() {
            return this.cycleCount;
        }

        @Override
        public boolean isHalted() {
            return this.halted;
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

