/*
 * Decompiled with CFR 0.152.
 */
package components.cpu;

import components.cpu.LR35902Info;
import components.cpu.MemoryMap;
import components.cpu.PortMap;
import components.cpu.Z80;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;

public class LR35902
extends Z80 {
    private static final String[] REGISTER_NAMES = new String[]{"BC", "DE", "HL", "AF", "SP", "PC"};
    private static final String[] FLAG_NAMES = new String[]{"C", "H", "N", "Z"};
    protected static final int MEMORY_FLAG_READ_ONLY = 1;
    protected static final int MEMORY_FLAG_PORT = 2;
    public static final int PORT_HALT_BUG = 630;
    public static final int PORT_STOP = 376;
    public static final int PORT_ILLEGAL_INSTRUCTION = 477;
    public static final int INT_VBLANK = 1;
    public static final int INT_LCD_STAT = 2;
    public static final int INT_TIMER = 4;
    public static final int INT_SERIAL = 8;
    public static final int INT_JOYPAD = 16;
    private final int[] memory;
    private final int[] memoryFlags;
    private final boolean cgb;
    private final OamBugHandler oamBugHandler;
    private boolean flagIME;
    private boolean justHalted;
    private boolean lockedUp;
    private boolean consumeCyclesBeforeWrite;
    private boolean accurateTiming;
    private boolean skip;

    public LR35902(boolean bl, OamBugHandler oamBugHandler, MemoryMap memoryMap, PortMap portMap, int[] nArray) {
        super(LR35902Info.getInstance(), memoryMap, portMap);
        this.oamBugHandler = oamBugHandler;
        this.cgb = bl;
        this.memory = nArray;
        this.memoryFlags = new int[nArray.length];
        this.setMemoryFlags(0, 128, 2);
        this.setMemoryFlags(3, 1, 1);
        this.setMemoryFlags(8, 7, 1);
        this.setMemoryFlags(21, 1, 1);
        this.setMemoryFlags(31, 1, 1);
        this.setMemoryFlags(39, 9, 1);
        this.setMemoryFlags(120, 8, 1);
        CYCLES[52] = CYCLES[52] - 4;
        CYCLES[53] = CYCLES[53] - 4;
        CYCLES_CB[6] = CYCLES_CB[6] - 4;
        CYCLES_CB[14] = CYCLES_CB[14] - 4;
        CYCLES_CB[22] = CYCLES_CB[22] - 4;
        CYCLES_CB[30] = CYCLES_CB[30] - 4;
        CYCLES_CB[38] = CYCLES_CB[38] - 4;
        CYCLES_CB[46] = CYCLES_CB[46] - 4;
        CYCLES_CB[54] = CYCLES_CB[54] - 4;
        CYCLES_CB[62] = CYCLES_CB[62] - 4;
        CYCLES_CB[134] = CYCLES_CB[134] - 4;
        CYCLES_CB[142] = CYCLES_CB[142] - 4;
        CYCLES_CB[150] = CYCLES_CB[150] - 4;
        CYCLES_CB[158] = CYCLES_CB[158] - 4;
        CYCLES_CB[166] = CYCLES_CB[166] - 4;
        CYCLES_CB[174] = CYCLES_CB[174] - 4;
        CYCLES_CB[182] = CYCLES_CB[182] - 4;
        CYCLES_CB[190] = CYCLES_CB[190] - 4;
        CYCLES_CB[198] = CYCLES_CB[198] - 4;
        CYCLES_CB[206] = CYCLES_CB[206] - 4;
        CYCLES_CB[214] = CYCLES_CB[214] - 4;
        CYCLES_CB[222] = CYCLES_CB[222] - 4;
        CYCLES_CB[230] = CYCLES_CB[230] - 4;
        CYCLES_CB[238] = CYCLES_CB[238] - 4;
        CYCLES_CB[246] = CYCLES_CB[246] - 4;
        CYCLES_CB[254] = CYCLES_CB[254] - 4;
        LR35902.CYCLES[33] = 4;
        LR35902.CYCLES[196] = 4;
        LR35902.CYCLES[204] = 4;
        LR35902.CYCLES[205] = 4;
        LR35902.CYCLES[212] = 4;
        LR35902.CYCLES[220] = 4;
        LR35902.CYCLES[194] = 4;
        LR35902.CYCLES[195] = 4;
        LR35902.CYCLES[202] = 4;
        LR35902.CYCLES[210] = 4;
        LR35902.CYCLES[218] = 4;
        LR35902.CYCLES[192] = 4;
        LR35902.CYCLES[200] = 4;
        LR35902.CYCLES[201] = 4;
        LR35902.CYCLES[208] = 4;
        LR35902.CYCLES[216] = 4;
        LR35902.CYCLES[217] = 4;
        LR35902.CYCLES[199] = 4;
        LR35902.CYCLES[207] = 4;
        LR35902.CYCLES[215] = 4;
        LR35902.CYCLES[223] = 4;
        LR35902.CYCLES[231] = 4;
        LR35902.CYCLES[239] = 4;
        LR35902.CYCLES[247] = 4;
        LR35902.CYCLES[255] = 4;
        LR35902.CYCLES[193] = 4;
        LR35902.CYCLES[197] = 4;
        LR35902.CYCLES[209] = 4;
        LR35902.CYCLES[213] = 4;
        LR35902.CYCLES[225] = 4;
        LR35902.CYCLES[229] = 4;
        LR35902.CYCLES[241] = 4;
        LR35902.CYCLES[245] = 4;
        LR35902.CYCLES[232] = 4;
        LR35902.CYCLES[248] = 4;
        LR35902.CYCLES[250] = 4;
    }

    private final void setMemoryFlags(int n, int n2, int n3) {
        Arrays.fill(this.memoryFlags, n, n + n2, n3);
    }

    @Override
    public void reset() {
        super.reset();
        this.memory[15] = 224;
        this.memory[3] = 255;
        Arrays.fill(this.memory, 8, 15, 255);
        this.memory[21] = 255;
        this.memory[31] = 255;
        Arrays.fill(this.memory, 39, 48, 255);
        Arrays.fill(this.memory, 118, 128, 255);
        this.flagIME = false;
        this.halted = false;
        this.justHalted = false;
        this.consumeCyclesBeforeWrite = false;
        this.lockedUp = false;
        this.skip = false;
        this.regAF = 0;
        this.regSP = 0;
    }

    public boolean isAccurateTiming() {
        return this.accurateTiming;
    }

    public final void reduceCycleCount(int n) {
        this.cycleCount -= n;
    }

    public final void sync() {
        if (this.cycleCount > 0) {
            this.cyclesToExecute -= this.cycleCount;
            this.cycleCount = 0;
        }
    }

    public int readByte(int n) {
        if ((this.memoryFlags[n &= 0xFF] & 2) != 0) {
            this.READ_PORT(n);
        }
        return this.memory[n];
    }

    public void writeByte(int n, int n2) {
        n &= 0xFF;
        if (this.consumeCyclesBeforeWrite) {
            this.cycleCount -= 4;
            this.consumeCyclesBeforeWrite = false;
        }
        if ((this.memoryFlags[n] & 2) != 0) {
            this.WRITE_PORT(n & 0xFF, n2);
        } else if ((this.memoryFlags[n] & 1) == 0) {
            this.memory[n] = n2;
        }
    }

    @Override
    public String[] getRegisterNames() {
        return REGISTER_NAMES;
    }

    @Override
    public int indexOfPC() {
        return 5;
    }

    @Override
    public int getRegisterValue(int n) {
        switch (n) {
            case 0: {
                return this.regBC;
            }
            case 1: {
                return this.regDE;
            }
            case 2: {
                return this.regHL;
            }
            case 3: {
                return this.getRegAF();
            }
            case 4: {
                return this.regSP;
            }
            case 5: {
                return this.regPC;
            }
            case 6: {
                return this.regSP;
            }
            case 7: {
                return this.regPC;
            }
        }
        return -1;
    }

    @Override
    public void setRegValue(int n, int n2) {
        n2 &= 0xFFFF;
        switch (n) {
            case 0: {
                this.regBC = n2;
                break;
            }
            case 1: {
                this.regDE = n2;
                break;
            }
            case 2: {
                this.regHL = n2;
                break;
            }
            case 3: {
                this.setRegAF(n2);
                break;
            }
            case 4: {
                this.regSP = n2;
                break;
            }
            case 5: {
                this.prevPC = this.regPC = n2;
                break;
            }
            case 6: {
                this.regSP = n2;
                break;
            }
            case 7: {
                this.regPC = n2;
            }
        }
    }

    @Override
    public String[] getFlagNames() {
        return FLAG_NAMES;
    }

    @Override
    public boolean isFlagSet(int n) {
        return (this.getRegAF() & 1 << n + 4) != 0;
    }

    @Override
    protected void executeInstruction(int n) {
        if (this.skip) {
            --this.regPC;
            this.skip = false;
        }
        boolean bl = this.afterEI;
        this.afterEI = false;
        switch (n) {
            case 3: 
            case 11: {
                this.handleOamBugInc(this.regBC);
                super.executeInstruction(n);
                break;
            }
            case 19: 
            case 27: {
                this.handleOamBugInc(this.regDE);
                super.executeInstruction(n);
                break;
            }
            case 35: 
            case 43: {
                this.handleOamBugInc(this.regHL);
                super.executeInstruction(n);
                break;
            }
            case 51: 
            case 59: {
                this.handleOamBugInc(this.regSP);
                super.executeInstruction(n);
                break;
            }
            case 7: {
                this.regAF = (this.regAF & 0x7F00) << 1 | (this.regAF & 0x8000) >> 7 | this.regAF >> 15;
                break;
            }
            case 8: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.WRITE_WORD(this.READ_WORD(), this.regSP);
                this.cycleCount -= 4;
                break;
            }
            case 15: {
                this.regAF = (this.regAF & 0x100) << 7 | (this.regAF & 0xFE00) >> 1 | this.regAF >> 8 & 1;
                break;
            }
            case 16: {
                this.READ_BYTE();
                this.WRITE_PORT(376, 0);
                break;
            }
            case 23: {
                this.regAF = (this.regAF & 0x7F00) << 1 | (this.regAF & 1) << 8 | this.regAF >> 15;
                break;
            }
            case 31: {
                this.regAF = (this.regAF & 0xFE00) >> 1 | (this.regAF & 1) << 15 | this.regAF >> 8 & 1;
                break;
            }
            case 32: {
                super.executeInstruction(n);
                if ((this.regAF & 0x40) != 0) break;
                ++this.cycleCount;
                break;
            }
            case 40: {
                super.executeInstruction(n);
                if ((this.regAF & 0x40) == 0) break;
                ++this.cycleCount;
                break;
            }
            case 48: {
                super.executeInstruction(n);
                if ((this.regAF & 1) != 0) break;
                ++this.cycleCount;
                break;
            }
            case 56: {
                super.executeInstruction(n);
                if ((this.regAF & 1) == 0) break;
                ++this.cycleCount;
                break;
            }
            case 33: {
                this.accurateTiming = true;
                this.regHL = this.READ_BYTE();
                this.cycleCount -= 4;
                this.regHL |= this.READ_BYTE() << 8;
                this.cycleCount -= 4;
                break;
            }
            case 34: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.WRITE_BYTE(this.regHL, this.regAF >> 8);
                this.regHL = this.regHL + 1 & 0xFFFF;
                this.cycleCount -= 4;
                break;
            }
            case 39: {
                this.DAA();
                break;
            }
            case 42: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.handleOAMbugIncRead(this.regHL);
                this.regAF = this.READ_BYTE(this.regHL) << 8 | this.regAF & 0xFF;
                this.regHL = this.regHL + 1 & 0xFFFF;
                this.cycleCount -= 4;
                break;
            }
            case 50: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.WRITE_BYTE(this.regHL, this.regAF >> 8);
                this.regHL = this.regHL - 1 & 0xFFFF;
                this.cycleCount -= 4;
                break;
            }
            case 52: 
            case 53: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.consumeCyclesBeforeWrite = true;
                super.executeInstruction(n);
                this.cycleCount -= 4;
                break;
            }
            case 58: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.handleOAMbugIncRead(this.regHL);
                this.regAF = this.READ_BYTE(this.regHL) << 8 | this.regAF & 0xFF;
                this.regHL = this.regHL - 1 & 0xFFFF;
                this.cycleCount -= 4;
                break;
            }
            case 63: {
                this.regAF = this.regAF & 0xFF41 ^ 1;
                break;
            }
            case 2: 
            case 10: 
            case 18: 
            case 26: 
            case 54: 
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 102: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 126: 
            case 134: 
            case 142: 
            case 150: 
            case 158: 
            case 166: 
            case 174: 
            case 182: 
            case 190: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                super.executeInstruction(n);
                this.cycleCount -= 4;
                break;
            }
            case 118: {
                if ((this.memory[255] & this.memory[15] & 0x1F) == 0) {
                    --this.regPC;
                    if (this.halted) {
                        this.justHalted = false;
                    } else if (!this.justHalted && this.cycleCount <= 0) {
                        this.justHalted = true;
                    } else {
                        if (!this.halted) {
                            this.WRITE_PORT(374, 1);
                        }
                        this.halted = true;
                    }
                    if (this.cycleCount <= 0) break;
                    this.cycleCount %= CYCLES[n];
                    break;
                }
                if (bl) {
                    --this.regPC;
                    break;
                }
                if (this.flagIME) break;
                if (this.justHalted) {
                    this.cycleCount += 4;
                }
                if (!this.halted) {
                    this.skip = true;
                    this.WRITE_PORT(630, 1);
                }
                this.halted = false;
                this.justHalted = false;
                break;
            }
            case 192: {
                this.RET_CC((this.regAF & 0x40) == 0);
                break;
            }
            case 193: {
                this.regBC = this.POP();
                break;
            }
            case 194: {
                this.JP_CC((this.regAF & 0x40) == 0);
                break;
            }
            case 195: {
                this.JP_CC(true);
                break;
            }
            case 196: {
                this.CALL_CC((this.regAF & 0x40) == 0);
                break;
            }
            case 197: {
                this.PUSH(this.regBC);
                break;
            }
            case 199: {
                this.RST(0);
                break;
            }
            case 200: {
                this.RET_CC((this.regAF & 0x40) != 0);
                break;
            }
            case 201: {
                this.RET();
                break;
            }
            case 202: {
                this.JP_CC((this.regAF & 0x40) != 0);
                break;
            }
            case 204: {
                this.CALL_CC((this.regAF & 0x40) != 0);
                break;
            }
            case 205: {
                this.CALL_CC(true);
                break;
            }
            case 207: {
                this.RST(8);
                break;
            }
            case 208: {
                this.RET_CC((this.regAF & 1) == 0);
                break;
            }
            case 209: {
                this.regDE = this.POP();
                break;
            }
            case 210: {
                this.JP_CC((this.regAF & 1) == 0);
                break;
            }
            case 211: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 212: {
                this.CALL_CC((this.regAF & 1) == 0);
                break;
            }
            case 213: {
                this.PUSH(this.regDE);
                break;
            }
            case 215: {
                this.RST(16);
                break;
            }
            case 216: {
                this.RET_CC((this.regAF & 1) != 0);
                break;
            }
            case 217: {
                this.RET();
                this.setInterruptsEnabled(true);
                break;
            }
            case 218: {
                this.JP_CC((this.regAF & 1) != 0);
                break;
            }
            case 219: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 220: {
                this.CALL_CC((this.regAF & 1) != 0);
                break;
            }
            case 221: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 223: {
                this.RST(24);
                break;
            }
            case 224: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.WRITE_BYTE(0xFF00 | this.READ_BYTE(), this.regAF >> 8);
                this.cycleCount -= 4;
                break;
            }
            case 225: {
                this.regHL = this.POP();
                break;
            }
            case 226: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.WRITE_BYTE(0xFF00 | this.regBC & 0xFF, this.regAF >> 8);
                this.cycleCount -= 4;
                break;
            }
            case 227: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 228: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 229: {
                this.PUSH(this.regHL);
                break;
            }
            case 231: {
                this.RST(32);
                break;
            }
            case 232: {
                this.regSP = this.ADD_TO_SP();
                this.cycleCount -= 4;
                break;
            }
            case 234: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                super.executeInstruction(50);
                this.cycleCount -= 4;
                break;
            }
            case 235: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 236: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 237: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 239: {
                this.RST(40);
                break;
            }
            case 240: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.regAF = this.READ_BYTE(0xFF00 | this.READ_BYTE()) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 241: {
                this.setRegAF(this.POP());
                break;
            }
            case 242: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.regAF = this.READ_BYTE(0xFF00 | this.regBC & 0xFF) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 244: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 245: {
                this.PUSH(this.getRegAF());
                break;
            }
            case 247: {
                this.RST(48);
                break;
            }
            case 248: {
                this.regHL = this.ADD_TO_SP();
                break;
            }
            case 250: {
                this.accurateTiming = true;
                int n2 = this.READ_BYTE();
                this.cycleCount -= 4;
                this.cycleCount -= 4;
                this.regAF = this.READ_BYTE(n2 |= this.READ_BYTE() << 8) << 8 | this.regAF & 0xFF;
                this.cycleCount -= 4;
                break;
            }
            case 252: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 253: {
                this.ILLEGAL_INSTRUCTION(n);
                break;
            }
            case 255: {
                this.RST(56);
                break;
            }
            default: {
                super.executeInstruction(n);
            }
        }
        if (n != 16) {
            this.prevPC = this.regPC;
        }
        this.accurateTiming = false;
    }

    private int getRegAF() {
        return this.regAF & 0xFF00 | (this.regAF & 0x50) << 1 | (this.regAF & 1) << 4 | (this.regAF & 2) << 5;
    }

    private void setRegAF(int n) {
        this.regAF = n & 0xFF00 | (n & 0xA0) >> 1 | (n & 0x10) >> 4 | (n & 0x40) >> 5;
    }

    @Override
    protected void executeInstructionCB(int n) {
        switch (n) {
            case 6: 
            case 14: 
            case 22: 
            case 30: 
            case 38: 
            case 46: 
            case 62: 
            case 134: 
            case 142: 
            case 150: 
            case 158: 
            case 166: 
            case 174: 
            case 182: 
            case 190: 
            case 198: 
            case 206: 
            case 214: 
            case 222: 
            case 230: 
            case 238: 
            case 246: 
            case 254: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.consumeCyclesBeforeWrite = true;
                super.executeInstructionCB(n);
                this.cycleCount -= 4;
                break;
            }
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 102: 
            case 110: 
            case 118: 
            case 126: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                super.executeInstructionCB(n);
                this.cycleCount -= 4;
                break;
            }
            case 48: {
                this.regBC = this.SWAP_HIBYTE(this.regBC);
                break;
            }
            case 49: {
                this.regBC = this.SWAP_LOBYTE(this.regBC);
                break;
            }
            case 50: {
                this.regDE = this.SWAP_HIBYTE(this.regDE);
                break;
            }
            case 51: {
                this.regDE = this.SWAP_LOBYTE(this.regDE);
                break;
            }
            case 52: {
                this.regHL = this.SWAP_HIBYTE(this.regHL);
                break;
            }
            case 53: {
                this.regHL = this.SWAP_LOBYTE(this.regHL);
                break;
            }
            case 54: {
                this.accurateTiming = true;
                this.cycleCount += 4;
                this.consumeCyclesBeforeWrite = true;
                this.WRITE_BYTE(this.regHL, this.SWAP_LOBYTE(this.READ_BYTE(this.regHL)));
                this.cycleCount -= 4;
                break;
            }
            case 55: {
                this.regAF = (this.regAF & 0xFF00) == 0 ? 64 : (this.regAF & 0xF00) << 4 | (this.regAF & 0xF000) >> 4;
                break;
            }
            default: {
                super.executeInstructionCB(n);
            }
        }
    }

    private final void ILLEGAL_INSTRUCTION(int n) {
        if (!this.lockedUp) {
            this.WRITE_PORT(477, n);
        }
        --this.regPC;
        this.memory[255] = 0;
        if (this.cycleCount > 0) {
            this.cycleCount = 0;
        }
        this.setInterruptsEnabled(false);
        this.lockedUp = true;
    }

    private final void PUSH(int n) {
        this.accurateTiming = true;
        this.cycleCount -= 4;
        this.handleOamBugInc(this.regSP);
        this.WRITE_BYTE(this.DEC_SP(), n >> 8);
        this.cycleCount -= 4;
        this.WRITE_BYTE(this.DEC_SP(), n & 0xFF);
        this.cycleCount -= 4;
    }

    private final int POP() {
        this.accurateTiming = true;
        this.handleOAMbugIncRead(this.regSP);
        int n = this.READ_BYTE(this.INC_SP());
        this.cycleCount -= 4;
        this.cycleCount -= 4;
        return n |= this.READ_BYTE(this.INC_SP()) << 8;
    }

    private final void CALL_CC(boolean bl) {
        this.accurateTiming = true;
        int n = this.READ_BYTE();
        this.cycleCount -= 4;
        n |= this.READ_BYTE() << 8;
        this.cycleCount -= 4;
        if (bl) {
            this.PUSH(this.regPC);
            this.regPC = n;
        }
    }

    private final void JP_CC(boolean bl) {
        this.accurateTiming = true;
        int n = this.READ_BYTE();
        this.cycleCount -= 4;
        n |= this.READ_BYTE() << 8;
        this.cycleCount -= 4;
        if (bl) {
            this.cycleCount -= 4;
            this.regPC = n;
        }
    }

    private final void RET() {
        this.accurateTiming = true;
        this.regPC = this.POP();
        this.cycleCount -= 4;
    }

    private final void RET_CC(boolean bl) {
        this.accurateTiming = true;
        this.cycleCount -= 4;
        if (bl) {
            this.regPC = this.POP();
            this.cycleCount -= 4;
        }
    }

    private final void RST(int n) {
        this.accurateTiming = true;
        this.PUSH(this.regPC);
        this.regPC = n;
    }

    private final void DAA() {
        int n = this.regAF >> 8;
        if ((this.regAF & 2) != 0) {
            if ((this.regAF & 0x10) != 0) {
                this.regAF = this.regAF - 1536 & 0xFFFF;
            }
            if ((this.regAF & 1) != 0) {
                this.regAF = this.regAF - 24576 & 0xFFFF | 1;
            }
        } else {
            if ((this.regAF & 0x10) != 0 || (n & 0xF) > 9) {
                this.regAF = this.regAF + 1536 & 0xFFFF;
            }
            if ((this.regAF & 1) != 0 || n > 153) {
                this.regAF = this.regAF + 24576 & 0xFFFF | 1;
            }
        }
        this.regAF = this.regAF & 0xFF03 | (this.regAF >> 8 == 0 ? 64 : 0);
    }

    private final int ADD_TO_SP() {
        this.accurateTiming = true;
        byte by = (byte)this.READ_BYTE();
        this.cycleCount -= 8;
        int n = this.regSP + by;
        this.regAF = this.regAF & 0xFF00 | (((this.regSP ^ by ^ n) & 0x100) != 0 ? 1 : 0) | (((this.regSP ^ by ^ n) & 0x10) != 0 ? 16 : 0);
        return n & 0xFFFF;
    }

    private final int SWAP_LOBYTE(int n) {
        if ((n & 0xFF) == 0) {
            this.regAF = this.regAF & 0xFF00 | 0x40;
            return n;
        }
        this.regAF &= 0xFF00;
        return n & 0xFF00 | (n & 0xF) << 4 | (n & 0xF0) >> 4;
    }

    private final int SWAP_HIBYTE(int n) {
        if ((n & 0xFF00) == 0) {
            this.regAF = this.regAF & 0xFF00 | 0x40;
            return n;
        }
        this.regAF &= 0xFF00;
        return (n & 0xF00) << 4 | (n & 0xF000) >> 4 | n & 0xFF;
    }

    @Override
    protected int incPC() {
        this.handleOAMbugIncRead(this.regPC);
        return super.incPC();
    }

    private void handleOamBugInc(int n) {
        if (this.oamBugHandler != null && n >= 65024 && n < 65280) {
            this.oamBugHandler.handleOamBugInc(this.cyclesToExecute - this.cycleCount);
        }
    }

    private void handleOAMbugIncRead(int n) {
        if (this.oamBugHandler != null && n >= 65024 && n < 65280) {
            this.oamBugHandler.handleOamBugIncRead(this.cyclesToExecute - this.cycleCount);
        }
    }

    public boolean isJustHalted() {
        return this.justHalted;
    }

    @Override
    public boolean isInterruptsEnabled() {
        return this.flagIME && !this.afterEI;
    }

    @Override
    public void setInterruptsEnabled(boolean bl) {
        if (this.flagIME) {
            this.afterEI = false;
        }
        this.flagIME = bl;
    }

    @Override
    public void setInterruptLine(int n, boolean bl) {
        this.memory[15] = this.memory[15] | (0xE0 | n & 0x1F);
    }

    @Override
    protected void handleInterrupts() {
        int n = this.memory[255] & this.memory[15] & 0x1F;
        if (n != 0) {
            if (this.halted) {
                this.halted = false;
                this.justHalted = false;
                ++this.regPC;
                boolean bl = this.cycleCount % 4 == 0;
                this.cyclesToExecute -= this.cycleCount;
                this.cycleCount = 0;
                if (!bl) {
                    this.cycleCount -= 4;
                } else if (this.cgb) {
                    this.cycleCount -= 4;
                }
                if (!this.cgb && (n & 7) == 4) {
                    this.cycleCount -= 4;
                }
                this.WRITE_PORT(374, 0);
            }
            if (this.isInterruptsEnabled()) {
                this.setInterruptsEnabled(false);
                this.accurateTiming = true;
                this.incPC();
                this.cycleCount -= 4;
                --this.regPC;
                this.cycleCount -= 4;
                this.handleOamBugInc(this.regPC);
                this.cycleCount -= 4;
                this.handleOamBugInc(this.regSP);
                this.WRITE_BYTE(this.DEC_SP(), this.regPC >> 8);
                n = this.memory[255] & this.READ_BYTE(65295) & 0x1F;
                this.cycleCount -= 4;
                this.WRITE_BYTE(this.DEC_SP(), this.regPC & 0xFF);
                this.cycleCount -= 4;
                this.regPC = 0;
                if ((n & 1) != 0) {
                    this.EXECUTE_INTERUPT(1);
                } else if ((n & 2) != 0) {
                    this.EXECUTE_INTERUPT(2);
                } else if ((n & 4) != 0) {
                    this.EXECUTE_INTERUPT(4);
                } else if ((n & 8) != 0) {
                    this.EXECUTE_INTERUPT(8);
                } else if ((n & 0x10) != 0) {
                    this.EXECUTE_INTERUPT(16);
                }
                this.accurateTiming = false;
                this.prevPC = this.regPC;
            }
        }
    }

    private final void EXECUTE_INTERUPT(int n) {
        this.memory[15] = this.memory[15] ^ n;
        switch (n) {
            case 1: {
                this.regPC = 64;
                break;
            }
            case 2: {
                this.regPC = 72;
                break;
            }
            case 4: {
                this.regPC = 80;
                break;
            }
            case 8: {
                this.regPC = 88;
                break;
            }
            case 16: {
                this.regPC = 96;
            }
        }
    }

    public State getLR35902State() {
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int getRegAF() {
                return LR35902.this.regAF;
            }

            @Override
            public int getRegBC() {
                return LR35902.this.regBC;
            }

            @Override
            public int getRegDE() {
                return LR35902.this.regDE;
            }

            @Override
            public int getRegHL() {
                return LR35902.this.regHL;
            }

            @Override
            public int getRegPC() {
                return LR35902.this.regPC;
            }

            @Override
            public int getRegSP() {
                return LR35902.this.regSP;
            }

            @Override
            public boolean isAfterEI() {
                return LR35902.this.afterEI;
            }

            @Override
            public boolean isFlagIME() {
                return LR35902.this.flagIME;
            }

            @Override
            public boolean isSkip() {
                return LR35902.this.skip;
            }

            @Override
            public int getCycleCount() {
                return LR35902.this.cycleCount;
            }

            @Override
            public boolean isHalted() {
                return LR35902.this.halted;
            }

            @Override
            public boolean isJustHalted() {
                return LR35902.this.justHalted;
            }

            @Override
            public boolean isLockedUp() {
                return LR35902.this.lockedUp;
            }
        };
    }

    public void setLR35902State(State state) {
        this.regAF = state.getRegAF();
        this.regBC = state.getRegBC();
        this.regDE = state.getRegDE();
        this.regHL = state.getRegHL();
        this.regPC = state.getRegPC();
        this.regSP = state.getRegSP();
        this.prevPC = this.regPC;
        this.prevSP = this.regSP;
        this.afterEI = state.isAfterEI();
        this.flagIME = state.isFlagIME();
        this.skip = state.isSkip();
        this.cycleCount = state.getCycleCount();
        this.halted = state.isHalted();
        this.justHalted = state.isJustHalted();
        this.lockedUp = state.isLockedUp();
    }

    public static interface OamBugHandler {
        public void handleOamBugInc(int var1);

        public void handleOamBugIncRead(int var1);
    }

    public static interface State {
        public void setState(State var1) throws UnmodifiableClassException;

        public State clone();

        public int getRegAF();

        public int getRegBC();

        public int getRegDE();

        public int getRegHL();

        public int getRegPC();

        public int getRegSP();

        public boolean isAfterEI();

        public boolean isFlagIME();

        public boolean isSkip();

        public int getCycleCount();

        public boolean isHalted();

        public boolean isJustHalted();

        public boolean isLockedUp();
    }

    private static class StateClone
    implements State {
        private int regAF;
        private int regBC;
        private int regDE;
        private int regHL;
        private int regPC;
        private int regSP;
        private boolean afterEI;
        private boolean flagIME;
        private boolean skip;
        private int cycleCount;
        private boolean halted;
        private boolean justHalted;
        private boolean lockedUp;

        public StateClone(State state) {
            this.setState(state);
        }

        @Override
        public void setState(State state) {
            this.regAF = state.getRegAF();
            this.regBC = state.getRegBC();
            this.regDE = state.getRegDE();
            this.regHL = state.getRegHL();
            this.regPC = state.getRegPC();
            this.regSP = state.getRegSP();
            this.afterEI = state.isAfterEI();
            this.flagIME = state.isFlagIME();
            this.skip = state.isSkip();
            this.cycleCount = state.getCycleCount();
            this.halted = state.isHalted();
            this.justHalted = state.isJustHalted();
            this.lockedUp = state.isLockedUp();
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int getRegAF() {
            return this.regAF;
        }

        @Override
        public int getRegBC() {
            return this.regBC;
        }

        @Override
        public int getRegDE() {
            return this.regDE;
        }

        @Override
        public int getRegHL() {
            return this.regHL;
        }

        @Override
        public int getRegPC() {
            return this.regPC;
        }

        @Override
        public int getRegSP() {
            return this.regSP;
        }

        @Override
        public boolean isAfterEI() {
            return this.afterEI;
        }

        @Override
        public boolean isFlagIME() {
            return this.flagIME;
        }

        @Override
        public boolean isSkip() {
            return this.skip;
        }

        @Override
        public int getCycleCount() {
            return this.cycleCount;
        }

        @Override
        public boolean isHalted() {
            return this.halted;
        }

        @Override
        public boolean isJustHalted() {
            return this.justHalted;
        }

        @Override
        public boolean isLockedUp() {
            return this.lockedUp;
        }
    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

