/*
 * Decompiled with CFR 0.152.
 */
package components.cpu;

import components.cpu.MemoryMap;
import components.cpu.PortMap;

public abstract class CPU {
    private final int[] CYCLES;
    protected int regPC;
    protected int regSP;
    protected int cyclesToExecute;
    protected int cycleCount;
    private MemoryMap memoryMap;
    private final PortMap portMap;

    public CPU(MemoryMap memoryMap, PortMap portMap, int[] nArray) {
        this.memoryMap = memoryMap;
        this.portMap = portMap;
        this.CYCLES = nArray;
    }

    public void setMemoryMap(MemoryMap memoryMap) {
        this.memoryMap = memoryMap;
    }

    protected final int READ_BYTE() {
        return this.READ_BYTE(this.incPC());
    }

    protected final int READ_BYTE(int n) {
        return this.memoryMap.readByte(n, this.cyclesToExecute - this.cycleCount);
    }

    protected final int READ_WORD() {
        return this.READ_BYTE() | this.READ_BYTE() << 8;
    }

    protected final int READ_WORD(int n) {
        return this.READ_BYTE(n) | this.READ_BYTE(n + 1) << 8;
    }

    protected final void WRITE_WORD(int n, int n2) {
        this.WRITE_BYTE(n, n2 & 0xFF);
        this.WRITE_BYTE(n + 1, n2 >> 8);
    }

    protected final void WRITE_BYTE(int n, int n2) {
        this.memoryMap.writeByte(n, n2, this.cyclesToExecute - this.cycleCount);
    }

    protected final void WRITE_PORT(int n, int n2) {
        this.portMap.writePort(n, n2, this.cyclesToExecute - this.cycleCount);
    }

    protected final int READ_PORT(int n) {
        return this.portMap.readPort(n, this.cyclesToExecute - this.cycleCount);
    }

    public final int execute(int n) {
        this.cyclesToExecute = n;
        this.cycleCount = n;
        do {
            this.handleInterrupts();
            if (this.cycleCount < 0) continue;
            int n2 = this.READ_BYTE();
            this.cycleCount -= this.CYCLES[n2];
            this.executeInstruction(n2);
        } while (this.cycleCount > 0);
        return this.cyclesToExecute - this.cycleCount;
    }

    public abstract void reset();

    public abstract void setInterruptLine(int var1, boolean var2);

    protected abstract void executeInstruction(int var1);

    protected abstract void handleInterrupts();

    protected abstract int incPC();

    public abstract String[] getRegisterNames();

    public abstract int indexOfPC();

    public abstract int getRegisterValue(int var1);

    public abstract boolean isAdditionalRegister(int var1);

    public abstract String[] getFlagNames();

    public abstract boolean isFlagSet(int var1);

    public int getPC() {
        return this.regPC;
    }

    public int getSP() {
        return this.regSP;
    }
}

