/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Properties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JRadioButtonMenuItem;

public class RecentFilesList
implements Iterable<File> {
    private final LinkedList<File> files = new LinkedList();
    private final int size;
    private final String propertyName;
    private final MenuItemActions actions;

    public RecentFilesList(String string, int n, MenuItemActions menuItemActions) {
        if (string == null) {
            throw new IllegalArgumentException("propertyName must not be null.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("size must be greater than 0.");
        }
        if (menuItemActions == null) {
            throw new IllegalArgumentException("actions must not be null.");
        }
        this.propertyName = string;
        this.size = n;
        this.actions = menuItemActions;
    }

    public void add(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null.");
        }
        this.files.remove(file);
        this.files.addFirst(file);
        if (this.files.size() > this.size) {
            this.files.removeLast();
        }
    }

    public void load(Properties properties) {
        int n = 0;
        while (n < this.size) {
            if (properties.getProperty(String.valueOf(this.propertyName) + n) != null) {
                this.files.add(new File(properties.getProperty(String.valueOf(this.propertyName) + n)));
            }
            ++n;
        }
    }

    public void save(Properties properties) {
        int n = 0;
        for (File file : this.files) {
            properties.setProperty(String.valueOf(this.propertyName) + n++, file.getAbsolutePath());
        }
    }

    public List<JRadioButtonMenuItem> generateMenuItems() {
        final MenuItemActions menuItemActions = this.actions;
        LinkedList<JRadioButtonMenuItem> linkedList = new LinkedList<JRadioButtonMenuItem>();
        for (final File file : this.files) {
            if (!file.exists()) continue;
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(file.getName(), menuItemActions.isSelected(file));
            jRadioButtonMenuItem.setToolTipText(file.getAbsolutePath());
            linkedList.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    menuItemActions.actionPerformed(file);
                }
            });
        }
        return linkedList;
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Override
    public Iterator<File> iterator() {
        return this.files.iterator();
    }

    public static interface MenuItemActions {
        public boolean isSelected(File var1);

        public void actionPerformed(File var1);
    }
}

