/*
 * Decompiled with CFR 0.152.
 */
package assembler.parsers;

import assembler.parsers.ParseException;
import assembler.parsers.tokens.ConstantToken;
import assembler.parsers.tokens.IndirectConstantToken;
import assembler.parsers.tokens.IndirectRegisterPair;
import assembler.parsers.tokens.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Z80Parser {
    protected final Pattern opCodePattern;
    protected final Pattern registerPattern;
    protected final Pattern registerPairPattern;
    protected final Pattern conditionPattern;

    public Z80Parser() {
        this(Z80Parser.enumToRegEx(OpCode.values()), Z80Parser.enumToRegEx(Register.values()), Z80Parser.enumToRegEx(RegisterPair.values()), Z80Parser.enumToRegEx(Condition.values()));
    }

    protected static String enumToRegEx(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(Pattern.quote(object.toString()));
            ++n2;
        }
        return stringBuilder.toString();
    }

    protected Z80Parser(String string, String string2, String string3, String string4) {
        this.opCodePattern = Pattern.compile("^(" + string + ")\\b", 2);
        this.registerPattern = Pattern.compile("^(" + string2 + ")\\b", 2);
        this.registerPairPattern = Pattern.compile("^(" + string3 + ")\\b", 2);
        this.conditionPattern = Pattern.compile("^(" + string4 + ")\\b", 2);
    }

    protected Token parseOpCode(String string) {
        Matcher matcher = this.opCodePattern.matcher(string);
        if (matcher.find()) {
            return OpCode.valueOf(matcher.group().toUpperCase());
        }
        return null;
    }

    protected Token parseRegister(String string) {
        Matcher matcher = this.registerPattern.matcher(string);
        if (matcher.find()) {
            return Register.valueOf(matcher.group().toUpperCase());
        }
        return null;
    }

    protected Token parseRegisterPair(String string) {
        Matcher matcher = this.registerPairPattern.matcher(string);
        if (matcher.find()) {
            RegisterPair registerPair = RegisterPair.valueOf(matcher.group().toUpperCase());
            if (registerPair == RegisterPair.AF && string.length() >= 3 && string.charAt(2) == '\'') {
                return RegisterPair.AFprime;
            }
            return registerPair;
        }
        return null;
    }

    protected Token parseCondition(String string) {
        Matcher matcher = this.conditionPattern.matcher(string);
        if (matcher.find()) {
            return Condition.valueOf(matcher.group().toUpperCase());
        }
        return null;
    }

    private static Token orToken(Token token, Token token2) {
        return token != null ? token : token2;
    }

    private Token parseRegisterOrRegisterPair(String string) {
        Token token = this.parseRegister(string);
        if (token != null) {
            return token;
        }
        return this.parseRegisterPair(string);
    }

    protected Token parseRegisterOrConstant(String string) {
        Token token = this.parseRegister(string);
        if (token != null) {
            return token;
        }
        return new ConstantToken(string);
    }

    private Token parseRegisterOrRegisterPairOrConstant(String string) {
        Token token = this.parseRegister(string);
        if (token != null) {
            return token;
        }
        Token token2 = this.parseRegisterPair(string);
        if (token2 != null) {
            return token2;
        }
        return new ConstantToken(string);
    }

    private static Token parseIndirectConstant(String string) throws ParseException {
        if (string.isEmpty() || string.charAt(0) != '(') {
            return null;
        }
        int n = Z80Parser.indexOfMatchingClosingParenthesis(string);
        if (n < 0) {
            throw new ParseException("Closing parenthesis is missing: " + string);
        }
        return new IndirectConstantToken(string.substring(1, n));
    }

    protected static String consumeToken(Token token, List<Token> list, String string) {
        if (list != null) {
            list.add(token);
        }
        int n = token.toString().length();
        int n2 = string.length();
        while (n < n2 && string.charAt(n) <= ' ') {
            ++n;
        }
        return string.substring(n);
    }

    protected static String consumeOpeningParenthesis(String string) {
        if (string.isEmpty() || string.charAt(0) != '(') {
            return string;
        }
        int n = 1;
        int n2 = string.length();
        while (n < n2 && string.charAt(n) <= ' ') {
            ++n;
        }
        return string.substring(n);
    }

    /*
     * Unable to fully structure code
     */
    protected static String parseComma(String var0) throws ParseException {
        var1_1 = var0.length();
        var2_2 = 0;
        while (var2_2 < var1_1 && var0.charAt(var2_2) <= ' ') {
            ++var2_2;
        }
        if (!var0.isEmpty() && var0.charAt(var2_2++) == ',') ** GOTO lbl9
        throw new ParseException("Comma is missing: " + var0);
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl9:
            // 2 sources

            ** while (var2_2 < var1_1 && var0.charAt((int)var2_2) <= ' ')
        }
lbl10:
        // 1 sources

        return var0.substring(var2_2);
    }

    public Token[] parse(String string) throws ParseException {
        Token token;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        int n = string.indexOf(59);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((token = this.parseOpCode(string = string.trim())) == null) {
            throw new ParseException("Illegal opcode encountered: " + string);
        }
        string = Z80Parser.consumeToken(token, arrayList, string);
        return this.parse(token, string, arrayList);
    }

    protected Token[] parse(Token token, String string, List<Token> list) throws ParseException {
        OpCode opCode = (OpCode)token;
        switch (opCode) {
            case ADC: 
            case ADD: 
            case SBC: 
            case SUB: {
                Token token2;
                if (opCode == OpCode.SUB && string.indexOf(44) < 0) {
                    token2 = Register.A;
                } else {
                    token2 = this.parseRegisterOrRegisterPair(string);
                    if (token2 != Register.A && token2 != RegisterPair.HL && token2 != RegisterPair.IX && token2 != RegisterPair.IY) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = Z80Parser.parseComma(Z80Parser.consumeToken(token2, opCode != OpCode.SUB ? list : null, string));
                }
                if (token2 == Register.A) {
                    if (string.isEmpty()) {
                        throw new ParseException("Operand is missing: " + string);
                    }
                    if (string.charAt(0) == '(') {
                        string = this.parseIndirectHLorIndexWithDisplacementOrConstant(string, list);
                        break;
                    }
                    Token token3 = this.parseRegisterOrConstant(string);
                    if (token3 == null || token3 == Register.I || token3 == Register.R) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = Z80Parser.consumeToken(token3, list, string);
                    break;
                }
                Token token4 = this.parseRegisterPair(string);
                if (token4 == null || token2 != RegisterPair.HL && token2 != RegisterPair.IX && token2 != RegisterPair.IY || token4 == RegisterPair.AF || token4 == RegisterPair.AFprime) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                string = Z80Parser.consumeToken(token4, list, string);
                break;
            }
            case AND: 
            case CP: 
            case OR: 
            case XOR: {
                Token token5;
                if (string.isEmpty()) {
                    throw new ParseException("Operand is missing: " + string);
                }
                if (string.indexOf(44) >= 0) {
                    token5 = this.parseRegister(string);
                    if (token5 != Register.A) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    int n = string.length();
                    int n2 = token5.toString().length();
                    while (n2 < n && string.charAt(n2) <= ' ') {
                        ++n2;
                    }
                    string = string.substring(n2);
                    string = Z80Parser.parseComma(string);
                }
                if (string.charAt(0) == '(') {
                    string = this.parseIndirectHLorIndexWithDisplacementOrConstant(string, list);
                    break;
                }
                token5 = this.parseRegisterOrConstant(string);
                if (token5 == null || token5 == Register.I || token5 == Register.R) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                string = Z80Parser.consumeToken(token5, list, string);
                break;
            }
            case CALL: {
                Token token6 = this.parseCondition(string);
                if (token6 != null) {
                    string = Z80Parser.consumeToken(token6, list, string);
                    string = Z80Parser.parseComma(string);
                }
                string = Z80Parser.consumeToken(new ConstantToken(string), list, string);
                break;
            }
            case DJNZ: {
                string = Z80Parser.consumeToken(new ConstantToken(string), list, string);
                break;
            }
            case EX: {
                Object object;
                Object object2;
                if (string.isEmpty()) {
                    throw new ParseException("Operand is missing.");
                }
                if (string.charAt(0) == '(') {
                    object2 = Z80Parser.consumeOpeningParenthesis(string);
                    Token token7 = this.parseRegisterPair((String)object2);
                    if (token7 != RegisterPair.SP) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = Z80Parser.consumeToken(token7, list, (String)object2).substring(1);
                    object = token7;
                } else {
                    object2 = this.parseRegisterPair(string);
                    if (object2 != RegisterPair.AF && object2 != RegisterPair.DE) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = Z80Parser.consumeToken((Token)object2, list, string);
                    object = object2;
                }
                string = Z80Parser.parseComma(string);
                object2 = this.parseRegisterPair(string);
                if (object2 == null || (object != RegisterPair.AF || object2 != RegisterPair.AFprime) && (object != RegisterPair.DE || object2 != RegisterPair.HL) && (object != RegisterPair.SP || object2 != RegisterPair.HL && object2 != RegisterPair.IX && object2 != RegisterPair.IY)) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                string = Z80Parser.consumeToken((Token)object2, list, string);
                break;
            }
            case IM: {
                if (string.isEmpty()) {
                    throw new ParseException("Operand is missing: " + string);
                }
                if ("012".indexOf(string.charAt(0)) < 0) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                string = Z80Parser.consumeToken(new ConstantToken(Character.toString(string.charAt(0))), list, string);
                break;
            }
            case IN: {
                Token token8;
                int n;
                boolean bl;
                if (string.charAt(0) == '(') {
                    String string2 = Z80Parser.consumeOpeningParenthesis(string);
                    Token token9 = this.parseRegister(string2);
                    if (token9 != Register.C) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = Z80Parser.consumeToken(token9, list, string2).substring(1);
                    break;
                }
                Token token10 = this.parseRegister(string);
                if (token10 != Register.A && token10 != Register.B && token10 != Register.C && token10 != Register.D && token10 != Register.E && token10 != Register.H && token10 != Register.L) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                boolean bl2 = bl = (string = Z80Parser.parseComma(Z80Parser.consumeToken(token10, list, string))).charAt(0) == '(';
                if (bl) {
                    n = (string = Z80Parser.consumeOpeningParenthesis(string)).lastIndexOf(41);
                    if (n < 0) {
                        throw new ParseException("Closing parenthesis is missing: " + string);
                    }
                } else {
                    n = string.length();
                }
                if ((token8 = this.parseRegister(string)) != null) {
                    string = Z80Parser.consumeToken(token8, list, string).substring(1);
                    break;
                }
                if (token10 != Register.A) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                string = Z80Parser.consumeToken(new IndirectConstantToken(string.substring(0, n)), list, string).substring(bl ? 1 : 0);
                break;
            }
            case DEC: 
            case INC: {
                if (string.isEmpty()) {
                    throw new ParseException("Operand is missing.");
                }
                if (string.charAt(0) == '(') {
                    string = this.parseIndirectHLorIndexWithDisplacement(string, list);
                    break;
                }
                Token token11 = this.parseRegisterOrRegisterPair(string);
                if (token11 == null || token11 == Register.I || token11 == Register.R || token11 == RegisterPair.AFprime) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                string = Z80Parser.consumeToken(token11, list, string);
                break;
            }
            case JP: {
                Token token12 = this.parseCondition(string);
                if (token12 != null) {
                    string = Z80Parser.consumeToken(token12, list, string);
                    string = Z80Parser.parseComma(string);
                }
                if (string.isEmpty()) {
                    throw new ParseException("Operand is missing.");
                }
                if (string.charAt(0) == '(') {
                    String string3 = Z80Parser.consumeOpeningParenthesis(string);
                    Token token13 = this.parseRegisterPair(string3);
                    if (token13 != RegisterPair.HL && token13 != RegisterPair.IX && token13 != RegisterPair.IY) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = Z80Parser.consumeToken(token13, list, string3).substring(1);
                    break;
                }
                Token token14 = this.parseRegisterPair(string);
                if (token14 == RegisterPair.HL || token14 == RegisterPair.IX || token14 == RegisterPair.IY) {
                    string = Z80Parser.consumeToken(token14, list, string);
                    break;
                }
                string = Z80Parser.consumeToken(new ConstantToken(string), list, string);
                break;
            }
            case JR: {
                Token token15 = this.parseCondition(string);
                if (token15 != null) {
                    if (token15 != Condition.C && token15 != Condition.NC && token15 != Condition.Z && token15 != Condition.NZ) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = Z80Parser.consumeToken(token15, list, string);
                    string = Z80Parser.parseComma(string);
                }
                string = Z80Parser.consumeToken(new ConstantToken(string), list, string);
                break;
            }
            case LD: {
                Object object;
                Object object3;
                if (string.isEmpty()) {
                    throw new ParseException("Operand is missing.");
                }
                if (string.charAt(0) == '(') {
                    object3 = Z80Parser.consumeOpeningParenthesis(string);
                    Token token16 = this.parseRegisterPair((String)object3);
                    if (token16 == null) {
                        object = Z80Parser.parseIndirectConstant(string);
                        string = Z80Parser.consumeToken((Token)object, list, (String)object3).substring(1);
                    } else {
                        if (token16 == RegisterPair.AF || token16 == RegisterPair.AFprime || token16 == RegisterPair.SP) {
                            throw new ParseException("Illegal token encountered: " + string);
                        }
                        if (token16 == RegisterPair.IX || token16 == RegisterPair.IY) {
                            string = Z80Parser.consumeToken(new IndirectRegisterPair(token16), list, (String)object3);
                            string = Z80Parser.parseDisplacement(string, list);
                        } else {
                            string = Z80Parser.consumeToken(new IndirectRegisterPair(token16), list, (String)object3).substring(1);
                        }
                        object = token16;
                    }
                } else {
                    object3 = this.parseRegisterOrRegisterPair(string);
                    if (object3 == null || object3 == RegisterPair.AFprime || object3 == RegisterPair.AF) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = Z80Parser.consumeToken((Token)object3, list, string);
                    object = object3;
                }
                string = Z80Parser.parseComma(string);
                if (string.isEmpty()) {
                    throw new ParseException("Second operand is missing.");
                }
                if (object instanceof ConstantToken) {
                    object3 = this.parseRegisterOrRegisterPair(string);
                    if (object3 == null || object3 instanceof Register && object3 != Register.A || object3 == RegisterPair.AF || object3 == RegisterPair.AFprime) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = Z80Parser.consumeToken((Token)object3, list, string);
                    break;
                }
                if (string.charAt(0) == '(' && Z80Parser.indexOfMatchingClosingParenthesis(string) == string.length() - 1) {
                    object3 = this.parseRegisterPair(string = Z80Parser.consumeOpeningParenthesis(string));
                    if (object3 == null) {
                        int n = string.lastIndexOf(41);
                        if (n < 0) {
                            throw new ParseException("Closing parenthesis is missing: " + string);
                        }
                        if ((object == Register.A || object instanceof RegisterPair && object != RegisterPair.AF && object != RegisterPair.AFprime) && n == string.length() - 1) {
                            string = Z80Parser.consumeToken(new IndirectConstantToken(string.substring(0, n)), list, string).substring(1);
                            break;
                        }
                        string = Z80Parser.consumeToken(new ConstantToken(String.valueOf('(') + string), list, String.valueOf('(') + string);
                        break;
                    }
                    if (object3 == RegisterPair.AF || object3 == RegisterPair.AFprime || object3 == RegisterPair.SP) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    int n = string.lastIndexOf(41);
                    if (n < 0) {
                        throw new ParseException("Closing parenthesis is missing: " + string);
                    }
                    if (object3 == RegisterPair.IX || object3 == RegisterPair.IY) {
                        string = Z80Parser.consumeToken(new IndirectRegisterPair((Token)object3), list, string);
                        string = Z80Parser.parseDisplacement(string, list);
                        break;
                    }
                    string = Z80Parser.consumeToken(new IndirectRegisterPair((Token)object3), list, string).substring(1);
                    break;
                }
                object3 = this.parseRegisterOrRegisterPairOrConstant(string);
                if (object3 == null || object3 instanceof RegisterPair && object3 != RegisterPair.HL && object3 != RegisterPair.IX && object3 != RegisterPair.IY) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                string = Z80Parser.consumeToken((Token)object3, list, string);
                break;
            }
            case OUT: {
                if (string.charAt(0) != '(') {
                    throw new ParseException("Missing parenthesis: " + string);
                }
                int n = (string = Z80Parser.consumeOpeningParenthesis(string)).lastIndexOf(41);
                if (n < 0) {
                    throw new ParseException("Closing parenthesis is missing: " + string);
                }
                Token token17 = Z80Parser.orToken(this.parseRegister(string), new IndirectConstantToken(string.substring(0, n)));
                string = Z80Parser.consumeToken(token17, list, string).substring(1);
                if ((string = Z80Parser.parseComma(string)).isEmpty()) {
                    throw new ParseException("Operand is missing.");
                }
                Token token18 = this.parseRegister(string);
                if (token18 != Register.A && token18 != Register.B && token18 != Register.C && token18 != Register.D && token18 != Register.E && token18 != Register.H && token18 != Register.L && string.charAt(0) != '0') {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                if (token18 != null) {
                    string = Z80Parser.consumeToken(token18, list, string);
                    break;
                }
                string = Z80Parser.consumeToken(new ConstantToken(Character.toString(string.charAt(0))), list, string);
                break;
            }
            case POP: 
            case PUSH: {
                if (string.isEmpty()) {
                    throw new ParseException("Operand is missing.");
                }
                Token token19 = this.parseRegisterPair(string);
                if (token19 != RegisterPair.AF && token19 != RegisterPair.BC && token19 != RegisterPair.DE && token19 != RegisterPair.HL && token19 != RegisterPair.IX && token19 != RegisterPair.IY) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                string = Z80Parser.consumeToken(token19, list, string);
                break;
            }
            case RET: {
                Token token20 = this.parseCondition(string);
                if (token20 == null) break;
                string = Z80Parser.consumeToken(token20, list, string);
                break;
            }
            case RST: {
                string = Z80Parser.consumeToken(new ConstantToken(string), list, string);
                break;
            }
            case BIT: 
            case RES: 
            case SET: {
                int n = string.indexOf(44);
                if (n < 0) {
                    throw new ParseException("Comma is missing: " + string);
                }
                string = Z80Parser.consumeToken(new ConstantToken(string.substring(0, n)), list, string);
                string = Z80Parser.parseComma(string);
            }
            case RLC: 
            case RL: 
            case RRC: 
            case RR: 
            case SLA: 
            case SLL: 
            case SRA: 
            case SRL: {
                if (string.isEmpty()) {
                    throw new ParseException("Operand is missing.");
                }
                if (string.charAt(0) == '(') {
                    string = this.parseIndirectHLorIndexWithDisplacement(string, list);
                    if (opCode == OpCode.BIT || string.indexOf(44) < 0) break;
                    Token token21 = this.parseRegister(string = Z80Parser.parseComma(string));
                    if (token21 == null) {
                        throw new ParseException("Operand is missing.");
                    }
                    string = Z80Parser.consumeToken(token21, list, string);
                    break;
                }
                Token token22 = this.parseRegister(string);
                if (token22 != Register.A && token22 != Register.B && token22 != Register.C && token22 != Register.D && token22 != Register.E && token22 != Register.H && token22 != Register.L) {
                    throw new ParseException("Illegal token encountered: " + string);
                }
                string = Z80Parser.consumeToken(token22, list, string);
            }
        }
        if (!string.isEmpty() && !string.trim().isEmpty()) {
            throw new ParseException("Line didn't get consumed completely: " + string);
        }
        return list.toArray(new Token[list.size()]);
    }

    private String parseIndirectHLorIndexWithDisplacement(String string, List<Token> list) throws ParseException {
        String string2 = Z80Parser.consumeOpeningParenthesis(string);
        Token token = this.parseRegisterPair(string2);
        if (token != RegisterPair.HL && token != RegisterPair.IX && token != RegisterPair.IY) {
            throw new ParseException("Illegal token encountered: " + string);
        }
        if (token != RegisterPair.HL) {
            string = Z80Parser.consumeToken(new IndirectRegisterPair(token), list, string2);
            string = Z80Parser.parseDisplacement(string, list);
        } else {
            string = Z80Parser.consumeToken(new IndirectRegisterPair(token), list, string2).substring(1);
        }
        return string;
    }

    private String parseIndirectHLorIndexWithDisplacementOrConstant(String string, List<Token> list) throws ParseException {
        String string2 = Z80Parser.consumeOpeningParenthesis(string);
        Token token = this.parseRegisterPair(string2);
        if (token != RegisterPair.HL && token != RegisterPair.IX && token != RegisterPair.IY) {
            string = Z80Parser.consumeToken(new ConstantToken(string), list, string);
        } else if (token != RegisterPair.HL) {
            string = Z80Parser.consumeToken(new IndirectRegisterPair(token), list, string2);
            string = Z80Parser.parseDisplacement(string, list);
        } else {
            string = Z80Parser.consumeToken(new IndirectRegisterPair(token), list, string2).substring(1);
        }
        return string;
    }

    private static int indexOfMatchingClosingParenthesis(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '(') {
                ++n2;
            } else if (c == ')' && --n2 <= 0) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static String parseDisplacement(String string, List<Token> list) throws ParseException {
        if (string.isEmpty()) {
            throw new ParseException("Displacement is missing.");
        }
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        } else if (string.charAt(0) != '-') {
            throw new ParseException("Illegal character encountered: " + string);
        }
        return Z80Parser.consumeToken(new ConstantToken(string.substring(0, Z80Parser.indexOfMatchingClosingParenthesis(string))), list, string).substring(1);
    }

    public static enum Condition implements Token
    {
        C,
        M,
        NC,
        NZ,
        PE,
        PO,
        P,
        Z;

    }

    public static enum OpCode implements Token
    {
        ADC,
        ADD,
        AND,
        BIT,
        CALL,
        CCF,
        CPDR,
        CPD,
        CPIR,
        CPI,
        CPL,
        CP,
        DAA,
        DEC,
        DI,
        DJNZ,
        EI,
        EXX,
        EX,
        HALT,
        IM,
        INC,
        INDR,
        IND,
        INIR,
        INI,
        IN,
        JP,
        JR,
        LDDR,
        LDD,
        LDIR,
        LDI,
        LD,
        NEG,
        NOP,
        OR,
        OTDR,
        OTIR,
        OUTI,
        OUTD,
        OUT,
        POP,
        PUSH,
        RES,
        RETI,
        RETN,
        RET,
        RLA,
        RLCA,
        RLC,
        RLD,
        RL,
        RRA,
        RRCA,
        RRC,
        RRD,
        RR,
        RST,
        SBC,
        SCF,
        SET,
        SLA,
        SLL,
        SRA,
        SRL,
        SUB,
        XOR;

    }

    public static enum Register implements Token
    {
        A,
        B,
        C,
        D,
        E,
        H,
        IXH,
        IXL,
        IYH,
        IYL,
        I,
        L,
        R;

    }

    public static enum RegisterPair implements Token
    {
        AFprime{

            public String toString() {
                return "AF'";
            }
        }
        ,
        AF,
        BC,
        DE,
        HL,
        IX,
        IY,
        SP;

    }
}

