/*
 * Decompiled with CFR 0.152.
 */
package assembler.parsers;

import assembler.parsers.ParseException;
import assembler.parsers.Z80Parser;
import assembler.parsers.tokens.ConstantToken;
import assembler.parsers.tokens.IndirectConstantToken;
import assembler.parsers.tokens.IndirectRegisterPair;
import assembler.parsers.tokens.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class LR35902Parser
extends Z80Parser {
    public LR35902Parser() {
        super(LR35902Parser.enumToRegEx(OpCode.values()), LR35902Parser.enumToRegEx(LR35902Register.values()), LR35902Parser.enumToRegEx(LR35902RegisterPair.values()), LR35902Parser.enumToRegEx(LR35902Condition.values()));
    }

    @Override
    protected Token parseOpCode(String string) {
        Matcher matcher = this.opCodePattern.matcher(string);
        if (matcher.find()) {
            return OpCode.valueOf(matcher.group().toUpperCase()).toZ80();
        }
        return null;
    }

    @Override
    protected Token parseRegister(String string) {
        Matcher matcher = this.registerPattern.matcher(string);
        if (matcher.find()) {
            return Z80Parser.Register.valueOf(matcher.group().toUpperCase());
        }
        return null;
    }

    @Override
    protected Token parseRegisterPair(String string) {
        Matcher matcher = this.registerPairPattern.matcher(string);
        if (matcher.find()) {
            LR35902RegisterPair lR35902RegisterPair = LR35902RegisterPair.valueOf(matcher.group().toUpperCase());
            if (lR35902RegisterPair == LR35902RegisterPair.HL && string.length() >= 3) {
                if (string.charAt(2) == '+') {
                    return LR35902RegisterPair.HLI;
                }
                if (string.charAt(2) == '-') {
                    return LR35902RegisterPair.HLD;
                }
            }
            return lR35902RegisterPair.toZ80();
        }
        return null;
    }

    @Override
    protected Token parseCondition(String string) {
        Matcher matcher = this.conditionPattern.matcher(string);
        if (matcher.find()) {
            return Z80Parser.Condition.valueOf(matcher.group().toUpperCase());
        }
        return null;
    }

    private static Token parseFF00plusC(Token token) {
        if (!(token instanceof ConstantToken)) {
            return token;
        }
        String string = ((ConstantToken)token).getConstant();
        int n = string.length();
        int n2 = string.indexOf(43);
        if (n2 >= 0) {
            char c;
            int n3 = n2 + 1;
            while (n3 < n && string.charAt(n3) <= ' ') {
                ++n3;
            }
            if (n3 < n && ((c = string.charAt(n3++)) == 'c' || c == 'C')) {
                while (n3 < n && string.charAt(n3) <= ' ') {
                    ++n3;
                }
                if (n3 == n) {
                    n3 = 0;
                    while (n3 < n2 && string.charAt(n3) <= ' ') {
                        ++n3;
                    }
                    if (n3 < n2 && string.charAt(n3++) == '$') {
                        int n4 = n3;
                        while (n3 < n2 && string.charAt(n3) > ' ') {
                            ++n3;
                        }
                        try {
                            if (Integer.parseInt(string.substring(n4, n3), 16) == 65280) {
                                return Z80Parser.Register.C;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
        } else {
            char c;
            int n5 = 0;
            while (n5 < n && string.charAt(n5) <= ' ') {
                ++n5;
            }
            if (n5 < n && ((c = string.charAt(n5++)) == 'c' || c == 'C')) {
                while (n5 < n && string.charAt(n5) <= ' ') {
                    ++n5;
                }
                if (n5 == n) {
                    return Z80Parser.Register.C;
                }
            }
        }
        return token;
    }

    @Override
    protected Token[] parse(Token token, String string, List<Token> list) throws ParseException {
        if (token instanceof OpCode) {
            OpCode opCode = (OpCode)token;
            switch (opCode) {
                case RETI: 
                case STOP: {
                    break;
                }
                case LDD: 
                case LDI: {
                    Token token2;
                    Token token3;
                    if (string.isEmpty()) {
                        throw new ParseException("Operand is missing.");
                    }
                    if (string.charAt(0) == '(') {
                        token3 = this.parseRegisterPair(string = string.substring(1).trim());
                        if (token3 != Z80Parser.RegisterPair.HL) {
                            throw new ParseException("Illegal token encountered: " + string);
                        }
                        string = LR35902Parser.consumeToken(token3, list, string).substring(1);
                        token2 = token3;
                    } else {
                        token3 = this.parseRegister(string);
                        if (token3 != Z80Parser.Register.A) {
                            throw new ParseException("Illegal token encountered: " + string);
                        }
                        string = LR35902Parser.consumeToken(token3, list, string);
                        token2 = token3;
                    }
                    string = LR35902Parser.parseComma(string);
                    if (string.isEmpty()) {
                        throw new ParseException("Second operand is missing.");
                    }
                    if (token2 == Z80Parser.Register.A) {
                        if (string.charAt(0) != '(') {
                            throw new ParseException("(hl) expected: " + string);
                        }
                        token3 = this.parseRegisterPair(string = string.substring(1).trim());
                        if (token3 != Z80Parser.RegisterPair.HL) {
                            throw new ParseException("Illegal token encountered: " + string);
                        }
                        string = LR35902Parser.consumeToken(token3, list, string).substring(1);
                        break;
                    }
                    token3 = this.parseRegister(string);
                    if (token3 != Z80Parser.Register.A) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = LR35902Parser.consumeToken(token3, list, string);
                    break;
                }
                case LDH: {
                    Token token4;
                    Token token5;
                    if (string.isEmpty()) {
                        throw new ParseException("Operand is missing.");
                    }
                    int n = string.indexOf(44);
                    if (n < 0) {
                        throw new ParseException("Comma is missing: " + string);
                    }
                    if (string.charAt(0) == '(') {
                        token5 = this.parseRegisterOrConstant((string = string.substring(1).trim()).substring(0, string.lastIndexOf(41)));
                        if (token5 instanceof Z80Parser.Register && token5 != Z80Parser.Register.C) {
                            throw new ParseException("Illegal token encountered: " + string);
                        }
                        string = LR35902Parser.consumeToken(token5, list, string).substring(1);
                        list.set(list.size() - 1, LR35902Parser.parseFF00plusC(list.get(list.size() - 1)));
                        token4 = token5;
                    } else {
                        token5 = this.parseRegister(string);
                        if (token5 != Z80Parser.Register.A) {
                            throw new ParseException("Illegal token encountered: " + string);
                        }
                        string = LR35902Parser.consumeToken(token5, list, string);
                        token4 = token5;
                    }
                    string = LR35902Parser.parseComma(string);
                    if (token4 == Z80Parser.Register.A) {
                        if (string.charAt(0) != '(') {
                            throw new ParseException("( expected: " + string);
                        }
                        token5 = this.parseRegisterOrConstant((string = string.substring(1).trim()).substring(0, string.lastIndexOf(41)));
                        if (token5 instanceof Z80Parser.Register && token5 != Z80Parser.Register.C) {
                            throw new ParseException("Illegal token encountered: " + string);
                        }
                        string = LR35902Parser.consumeToken(token5, list, string).substring(1);
                        list.set(list.size() - 1, LR35902Parser.parseFF00plusC(list.get(list.size() - 1)));
                        break;
                    }
                    token5 = this.parseRegister(string);
                    if (token5 != Z80Parser.Register.A) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = LR35902Parser.consumeToken(token5, list, string);
                    break;
                }
                case SWAP: {
                    if (string.isEmpty()) {
                        throw new ParseException("Operand is missing.");
                    }
                    if (string.charAt(0) == '(') {
                        Token token6 = this.parseRegisterPair(string = string.substring(1).trim());
                        if (token6 != Z80Parser.RegisterPair.HL) {
                            throw new ParseException("Illegal token encountered: " + string);
                        }
                        string = LR35902Parser.consumeToken(new IndirectRegisterPair(token6), list, string).substring(1);
                        break;
                    }
                    Token token7 = this.parseRegister(string);
                    if (token7 == null) {
                        throw new ParseException("Illegal token encountered: " + string);
                    }
                    string = LR35902Parser.consumeToken(token7, list, string);
                    break;
                }
                default: {
                    throw new ParseException("Unhandled opcode: " + opCode + " " + string);
                }
            }
            if (!string.isEmpty() && !string.trim().isEmpty()) {
                throw new ParseException("Line didn't get consumed completely: " + string);
            }
            return list.toArray(new Token[list.size()]);
        }
        if (token == Z80Parser.OpCode.ADD && this.parseRegisterPair(string) == Z80Parser.RegisterPair.SP) {
            string = LR35902Parser.parseComma(LR35902Parser.consumeToken(Z80Parser.RegisterPair.SP, list, string));
            if (!(string = LR35902Parser.consumeToken(new ConstantToken(string), list, string)).isEmpty() && !string.trim().isEmpty()) {
                throw new ParseException("Line didn't get consumed completely: " + string);
            }
            return list.toArray(new Token[list.size()]);
        }
        if (token == Z80Parser.OpCode.LD) {
            Token token8 = this.parseRegisterPair(string);
            if (token8 != null) {
                Token token9;
                string = LR35902Parser.parseComma(LR35902Parser.consumeToken(token8, list, string));
                if (token8 == Z80Parser.RegisterPair.HL) {
                    Token token10 = this.parseRegisterPair(string);
                    if (token10 == Z80Parser.RegisterPair.SP) {
                        if ((string = LR35902Parser.consumeToken(token10, list, string)).charAt(0) == '+') {
                            string = string.substring(1).trim();
                        } else if (string.charAt(0) != '-') {
                            throw new ParseException("Illegal character encountered: " + string);
                        }
                        list.add(new ConstantToken(string));
                        return list.toArray(new Token[list.size()]);
                    }
                } else if (token8 == Z80Parser.RegisterPair.SP && (token9 = this.parseRegisterPair(string)) == Z80Parser.RegisterPair.HL) {
                    string = LR35902Parser.consumeToken(token9, list, string);
                    return list.toArray(new Token[list.size()]);
                }
                string = LR35902Parser.consumeToken(new ConstantToken(string), list, string);
                return list.toArray(new Token[list.size()]);
            }
            Token[] tokenArray = super.parse(token, string, new ArrayList<Token>(list));
            IndirectConstantToken indirectConstantToken = (IndirectConstantToken)(tokenArray.length != 3 ? null : (tokenArray[1] instanceof IndirectConstantToken ? tokenArray[1] : (tokenArray[2] instanceof IndirectConstantToken ? tokenArray[2] : null)));
            if (indirectConstantToken != null) {
                if (tokenArray[1] instanceof IndirectConstantToken) {
                    tokenArray[1] = LR35902Parser.parseFF00plusC(tokenArray[1]);
                    if (tokenArray[1] == Z80Parser.Register.C) {
                        tokenArray[0] = OpCode.LDH;
                        return tokenArray;
                    }
                } else {
                    tokenArray[2] = LR35902Parser.parseFF00plusC(tokenArray[2]);
                    if (tokenArray[2] == Z80Parser.Register.C) {
                        tokenArray[0] = OpCode.LDH;
                        return tokenArray;
                    }
                }
            }
        } else if (token == Z80Parser.OpCode.JP && string.length() == 2 && this.parseRegisterPair(string) == Z80Parser.RegisterPair.HL) {
            list.add(Z80Parser.RegisterPair.HL);
            return list.toArray(new Token[list.size()]);
        }
        if ((token == Z80Parser.OpCode.ADD || token == Z80Parser.OpCode.ADC || token == Z80Parser.OpCode.SBC) && this.parseRegisterPair(string) == null) {
            return super.parse(Z80Parser.OpCode.SUB, string, list);
        }
        return super.parse(token, string, list);
    }

    public static enum LR35902Condition implements Token
    {
        C,
        NC,
        NZ,
        Z;

    }

    public static enum LR35902Register implements Token
    {
        A,
        B,
        C,
        D,
        E,
        H,
        L;

    }

    public static enum LR35902RegisterPair implements Token
    {
        AF,
        BC,
        DE,
        HLI,
        HLD,
        HL,
        SP;


        public Token toZ80() {
            try {
                if (this != HLI && this != HLD) {
                    return Z80Parser.RegisterPair.valueOf(this.toString());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return this;
        }
    }

    public static enum OpCode implements Token
    {
        ADC,
        ADD,
        AND,
        BIT,
        CALL,
        CCF,
        CPL,
        CP,
        DAA,
        DEC,
        DI,
        EI,
        HALT,
        INC,
        JP,
        JR,
        LDD,
        LDI,
        LDH,
        LD,
        NOP,
        OR,
        POP,
        PUSH,
        RES,
        RETI,
        RET,
        RLA,
        RLCA,
        RLC,
        RL,
        RRA,
        RRCA,
        RRC,
        RR,
        RST,
        SBC,
        SCF,
        SET,
        SLA,
        SRA,
        SRL,
        STOP,
        SUB,
        SWAP,
        XOR;


        public Token toZ80() {
            if (this != LDI && this != LDD && this != LDH && this != RETI && this != STOP && this != SWAP) {
                return Z80Parser.OpCode.valueOf(this.toString());
            }
            return this;
        }
    }
}

