/*
 * Decompiled with CFR 0.152.
 */
package assembler;

import assembler.Z80Instruction;
import assembler.parsers.ExpressionEvaluator;
import assembler.parsers.ParseException;
import assembler.parsers.Z80Parser;
import assembler.parsers.tokens.ConstantToken;
import assembler.parsers.tokens.IndirectConstantToken;
import assembler.parsers.tokens.IndirectRegisterPair;
import assembler.parsers.tokens.Token;

public class Z80Assembler {
    private final Z80Parser parser;
    private final ExpressionEvaluator expressionEvaluator;

    protected Z80Assembler(Z80Parser z80Parser, ExpressionEvaluator expressionEvaluator) {
        this.parser = z80Parser;
        this.expressionEvaluator = expressionEvaluator;
    }

    public Z80Assembler(ExpressionEvaluator expressionEvaluator) {
        this(new Z80Parser(), expressionEvaluator);
    }

    public Z80Instruction assemble(String string) throws ParseException {
        return this.assemble(this.parser.parse(string));
    }

    protected Z80Instruction assemble(Token[] tokenArray) {
        switch ((Z80Parser.OpCode)tokenArray[0]) {
            case ADC: {
                if (tokenArray[1] instanceof Z80Parser.RegisterPair) {
                    return this.createInstruction(0x40 | Z80Assembler.registerPairIndex(tokenArray[2]) << 4 | 0xA, 237);
                }
                if (tokenArray[2] instanceof ConstantToken) {
                    return this.createInstruction(206, 0, 256, this.evaluate((ConstantToken)tokenArray[2]), 1);
                }
                return this.createInstruction(0x88 | Z80Assembler.registerIndex(tokenArray[2]), Z80Assembler.registerPrefix(tokenArray[2]), tokenArray.length > 3 ? this.evaluate((ConstantToken)tokenArray[3]) : 256);
            }
            case ADD: {
                if (tokenArray[1] instanceof Z80Parser.RegisterPair) {
                    return this.createInstruction(Z80Assembler.registerPairIndex(tokenArray[2]) << 4 | 9, Z80Assembler.registerPairPrefix(tokenArray[1]));
                }
                if (tokenArray[2] instanceof ConstantToken) {
                    return this.createInstruction(198, 0, 256, this.evaluate((ConstantToken)tokenArray[2]), 1);
                }
                return this.createInstruction(0x80 | Z80Assembler.registerIndex(tokenArray[2]), Z80Assembler.registerPrefix(tokenArray[2]), tokenArray.length > 3 ? this.evaluate((ConstantToken)tokenArray[3]) : 256);
            }
            case AND: {
                if (tokenArray[1] instanceof ConstantToken) {
                    return this.createInstruction(230, 0, 256, this.evaluate((ConstantToken)tokenArray[1]), 1);
                }
                return this.createInstruction(0xA0 | Z80Assembler.registerIndex(tokenArray[1]), Z80Assembler.registerPrefix(tokenArray[1]), tokenArray.length > 2 ? this.evaluate((ConstantToken)tokenArray[2]) : 256);
            }
            case BIT: {
                if (tokenArray[2] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[2]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(0xCB46 | this.evaluateBitNumber(tokenArray[1]) << 3, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[2]), this.evaluate((ConstantToken)tokenArray[3]));
                }
                return this.createInstruction(0x40 | this.evaluateBitNumber(tokenArray[1]) << 3 | Z80Assembler.registerIndex(tokenArray[2]), 203);
            }
            case CALL: {
                if (tokenArray[1] instanceof Z80Parser.Condition) {
                    return this.createInstruction(0xC4 | Z80Assembler.conditionIndex((Z80Parser.Condition)tokenArray[1]) << 3, 0, 0, this.evaluate((ConstantToken)tokenArray[2]), 2);
                }
                return this.createInstruction(205, 0, 0, this.evaluate((ConstantToken)tokenArray[1]), 2);
            }
            case CCF: {
                return this.createInstruction(63);
            }
            case CP: {
                if (tokenArray[1] instanceof ConstantToken) {
                    return this.createInstruction(254, 0, 256, this.evaluate((ConstantToken)tokenArray[1]), 1);
                }
                return this.createInstruction(0xB8 | Z80Assembler.registerIndex(tokenArray[1]), Z80Assembler.registerPrefix(tokenArray[1]), tokenArray.length > 2 ? this.evaluate((ConstantToken)tokenArray[2]) : 256);
            }
            case CPD: {
                return this.createInstruction(169, 237);
            }
            case CPDR: {
                return this.createInstruction(185, 237);
            }
            case CPI: {
                return this.createInstruction(161, 237);
            }
            case CPIR: {
                return this.createInstruction(177, 237);
            }
            case CPL: {
                return this.createInstruction(47);
            }
            case DAA: {
                return this.createInstruction(39);
            }
            case DEC: {
                if (tokenArray[1] instanceof IndirectRegisterPair) {
                    return this.createInstruction(53, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), tokenArray.length > 2 ? this.evaluate((ConstantToken)tokenArray[2]) : 0);
                }
                if (tokenArray[1] instanceof Z80Parser.RegisterPair) {
                    return this.createInstruction(Z80Assembler.registerPairIndex(tokenArray[1]) << 4 | 0xB, Z80Assembler.registerPairPrefix(tokenArray[1]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) << 3 | 5, Z80Assembler.registerPrefix(tokenArray[1]));
            }
            case DI: {
                return this.createInstruction(243);
            }
            case DJNZ: {
                return this.createInstruction(16, 0, 0, this.evaluate((ConstantToken)tokenArray[1]), 1);
            }
            case EI: {
                return this.createInstruction(251);
            }
            case EX: {
                if (tokenArray[1] == Z80Parser.RegisterPair.AF) {
                    return this.createInstruction(8);
                }
                if (tokenArray[1] == Z80Parser.RegisterPair.DE) {
                    return this.createInstruction(235);
                }
                return this.createInstruction(227, Z80Assembler.registerPairPrefix(tokenArray[2]));
            }
            case EXX: {
                return this.createInstruction(217);
            }
            case HALT: {
                return this.createInstruction(118);
            }
            case IM: {
                int n = ((ConstantToken)tokenArray[1]).getConstant().charAt(0) - 48;
                return this.createInstruction(n == 0 ? 70 : 0x56 | n - 1 << 3, 237);
            }
            case IN: {
                if (tokenArray.length < 3) {
                    return this.createInstruction(112, 237);
                }
                if (tokenArray[2] instanceof IndirectConstantToken) {
                    return this.createInstruction(219, 0, 0, this.evaluate((IndirectConstantToken)tokenArray[2]), 1);
                }
                return this.createInstruction(0x40 | Z80Assembler.registerIndex(tokenArray[1]) << 3, 237);
            }
            case INC: {
                if (tokenArray[1] instanceof IndirectRegisterPair) {
                    return this.createInstruction(52, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), tokenArray.length > 2 ? this.evaluate((ConstantToken)tokenArray[2]) : 0);
                }
                if (tokenArray[1] instanceof Z80Parser.RegisterPair) {
                    return this.createInstruction(Z80Assembler.registerPairIndex(tokenArray[1]) << 4 | 3, Z80Assembler.registerPairPrefix(tokenArray[1]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) << 3 | 4, Z80Assembler.registerPrefix(tokenArray[1]));
            }
            case IND: {
                return this.createInstruction(170, 237);
            }
            case INDR: {
                return this.createInstruction(186, 237);
            }
            case INI: {
                return this.createInstruction(162, 237);
            }
            case INIR: {
                return this.createInstruction(178, 237);
            }
            case JP: {
                if (tokenArray[1] instanceof Z80Parser.Condition) {
                    return this.createInstruction(0xC2 | Z80Assembler.conditionIndex((Z80Parser.Condition)tokenArray[1]) << 3, 0, 0, this.evaluate((ConstantToken)tokenArray[2]), 2);
                }
                if (tokenArray[1] instanceof Z80Parser.RegisterPair) {
                    return this.createInstruction(233, Z80Assembler.registerPairPrefix(tokenArray[1]));
                }
                return this.createInstruction(195, 0, 0, this.evaluate((ConstantToken)tokenArray[1]), 2);
            }
            case JR: {
                if (tokenArray[1] instanceof Z80Parser.Condition) {
                    return this.createInstruction(Z80Assembler.conditionIndex((Z80Parser.Condition)tokenArray[1]) << 3 | 0x20, 0, 0, this.evaluate((ConstantToken)tokenArray[2]), 1);
                }
                return this.createInstruction(24, 0, 0, this.evaluate((ConstantToken)tokenArray[1]), 1);
            }
            case LD: {
                if (tokenArray[1] == Z80Parser.Register.I) {
                    return this.createInstruction(71, 237);
                }
                if (tokenArray[1] == Z80Parser.Register.R) {
                    return this.createInstruction(79, 237);
                }
                if (tokenArray[2] == Z80Parser.Register.I) {
                    return this.createInstruction(87, 237);
                }
                if (tokenArray[2] == Z80Parser.Register.R) {
                    return this.createInstruction(95, 237);
                }
                if (tokenArray[1] == Z80Parser.RegisterPair.SP && tokenArray[2] instanceof Z80Parser.RegisterPair) {
                    return this.createInstruction(249, Z80Assembler.registerPairPrefix(tokenArray[2]));
                }
                if (tokenArray[2] instanceof IndirectConstantToken) {
                    if (tokenArray[1] == Z80Parser.Register.A) {
                        return this.createInstruction(58, 0, 256, this.evaluate((IndirectConstantToken)tokenArray[2]), 2);
                    }
                    if (tokenArray[1] == Z80Parser.RegisterPair.HL || tokenArray[1] == Z80Parser.RegisterPair.IX || tokenArray[1] == Z80Parser.RegisterPair.IY) {
                        return this.createInstruction(42, Z80Assembler.registerPairPrefix(tokenArray[1]), 256, this.evaluate((IndirectConstantToken)tokenArray[2]), 2);
                    }
                    return this.createInstruction(0x4B | Z80Assembler.registerPairIndex(tokenArray[1]) << 4, 237, 256, this.evaluate((IndirectConstantToken)tokenArray[2]), 2);
                }
                if (tokenArray[1] instanceof IndirectRegisterPair) {
                    Token token = ((IndirectRegisterPair)tokenArray[1]).getRegisterPair();
                    if (tokenArray[tokenArray.length - 1] instanceof ConstantToken) {
                        return this.createInstruction(54, Z80Assembler.registerPairPrefix(token), this.evaluate((ConstantToken)tokenArray[2]), this.evaluate((ConstantToken)tokenArray[tokenArray.length - 1]), 1);
                    }
                    if (token == Z80Parser.RegisterPair.HL || token == Z80Parser.RegisterPair.IX || token == Z80Parser.RegisterPair.IY) {
                        return this.createInstruction(0x70 | Z80Assembler.registerIndex(tokenArray[tokenArray.length - 1]), Z80Assembler.registerPairPrefix(token), tokenArray[2] instanceof ConstantToken ? this.evaluate((ConstantToken)tokenArray[2]) : 0);
                    }
                    return this.createInstruction(Z80Assembler.registerPairIndex(token) << 4 | 2);
                }
                if (tokenArray[1] instanceof Z80Parser.RegisterPair) {
                    return this.createInstruction(Z80Assembler.registerPairIndex(tokenArray[1]) << 4 | 1, Z80Assembler.registerPairPrefix(tokenArray[1]), 256, this.evaluate((ConstantToken)tokenArray[2]), 2);
                }
                if (tokenArray[1] instanceof IndirectConstantToken) {
                    if (tokenArray[2] == Z80Parser.Register.A) {
                        return this.createInstruction(50, 0, 256, this.evaluate((IndirectConstantToken)tokenArray[1]), 2);
                    }
                    if (tokenArray[2] == Z80Parser.RegisterPair.HL || tokenArray[2] == Z80Parser.RegisterPair.IX || tokenArray[2] == Z80Parser.RegisterPair.IY) {
                        return this.createInstruction(34, Z80Assembler.registerPairPrefix(tokenArray[2]), 256, this.evaluate((IndirectConstantToken)tokenArray[1]), 2);
                    }
                    return this.createInstruction(0x43 | Z80Assembler.registerPairIndex(tokenArray[2]) << 4, 237, 256, this.evaluate((IndirectConstantToken)tokenArray[1]), 2);
                }
                if (tokenArray[2] instanceof IndirectRegisterPair) {
                    Token token = ((IndirectRegisterPair)tokenArray[2]).getRegisterPair();
                    if (token == Z80Parser.RegisterPair.HL) {
                        return this.createInstruction(0x40 | Z80Assembler.registerIndex(tokenArray[1]) << 3 | 6, Z80Assembler.registerPrefix(tokenArray[1]));
                    }
                    if (token == Z80Parser.RegisterPair.IX || token == Z80Parser.RegisterPair.IY) {
                        return this.createInstruction(0x40 | Z80Assembler.registerIndex(tokenArray[1]) << 3 | 6, Z80Assembler.registerPairPrefix(token), this.evaluate((ConstantToken)tokenArray[3]));
                    }
                    return this.createInstruction(Z80Assembler.registerPairIndex(token) << 4 | 0xA);
                }
                if (tokenArray[2] instanceof Z80Parser.Register) {
                    return this.createInstruction(0x40 | Z80Assembler.registerIndex(tokenArray[1]) << 3 | Z80Assembler.registerIndex(tokenArray[2]), Z80Assembler.registerPrefix(tokenArray[1]) | Z80Assembler.registerPrefix(tokenArray[2]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) << 3 | 6, Z80Assembler.registerPrefix(tokenArray[1]), 256, this.evaluate((ConstantToken)tokenArray[2]), 1);
            }
            case LDD: {
                return this.createInstruction(168, 237);
            }
            case LDDR: {
                return this.createInstruction(184, 237);
            }
            case LDI: {
                return this.createInstruction(160, 237);
            }
            case LDIR: {
                return this.createInstruction(176, 237);
            }
            case NEG: {
                return this.createInstruction(68, 237);
            }
            case NOP: {
                return this.createInstruction(0);
            }
            case OR: {
                if (tokenArray[1] instanceof ConstantToken) {
                    return this.createInstruction(246, 0, 256, this.evaluate((ConstantToken)tokenArray[1]), 1);
                }
                return this.createInstruction(0xB0 | Z80Assembler.registerIndex(tokenArray[1]), Z80Assembler.registerPrefix(tokenArray[1]), tokenArray.length > 2 ? this.evaluate((ConstantToken)tokenArray[2]) : 256);
            }
            case OTDR: {
                return this.createInstruction(187, 237);
            }
            case OTIR: {
                return this.createInstruction(179, 237);
            }
            case OUT: {
                if (tokenArray[1] instanceof IndirectConstantToken) {
                    return this.createInstruction(211, 0, 0, this.evaluate((IndirectConstantToken)tokenArray[1]), 1);
                }
                if (tokenArray[2] instanceof ConstantToken) {
                    return this.createInstruction(113, 237);
                }
                return this.createInstruction(0x40 | Z80Assembler.registerIndex(tokenArray[2]) << 3 | 1, 237);
            }
            case OUTD: {
                return this.createInstruction(171, 237);
            }
            case OUTI: {
                return this.createInstruction(163, 237);
            }
            case POP: {
                return this.createInstruction(0xC1 | Z80Assembler.registerPairIndex(tokenArray[1]) << 4, Z80Assembler.registerPairPrefix(tokenArray[1]));
            }
            case PUSH: {
                return this.createInstruction(0xC5 | Z80Assembler.registerPairIndex(tokenArray[1]) << 4, Z80Assembler.registerPairPrefix(tokenArray[1]));
            }
            case RES: {
                if (tokenArray[2] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[2]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(0xCB80 | this.evaluateBitNumber(tokenArray[1]) << 3 | (tokenArray.length > 4 ? Z80Assembler.registerIndex(tokenArray[4]) : 6), Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[2]), this.evaluate((ConstantToken)tokenArray[3]));
                }
                return this.createInstruction(0x80 | this.evaluateBitNumber(tokenArray[1]) << 3 | Z80Assembler.registerIndex(tokenArray[2]), 203);
            }
            case RET: {
                if (tokenArray.length > 1) {
                    return this.createInstruction(0xC0 | Z80Assembler.conditionIndex((Z80Parser.Condition)tokenArray[1]) << 3);
                }
                return this.createInstruction(201);
            }
            case RETI: {
                return this.createInstruction(77, 237);
            }
            case RETN: {
                return this.createInstruction(69, 237);
            }
            case RL: {
                if (tokenArray[1] == Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(22, 203);
                }
                if (tokenArray[1] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[1]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(tokenArray.length > 3 ? 0xCB10 | Z80Assembler.registerIndex(tokenArray[3]) : 51990, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), this.evaluate((ConstantToken)tokenArray[2]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) | 0x10, 203);
            }
            case RLA: {
                return this.createInstruction(23);
            }
            case RLC: {
                if (tokenArray[1] == Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(6, 203);
                }
                if (tokenArray[1] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[1]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(tokenArray.length > 3 ? 0xCB00 | Z80Assembler.registerIndex(tokenArray[3]) : 51974, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), this.evaluate((ConstantToken)tokenArray[2]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]), 203);
            }
            case RLCA: {
                return this.createInstruction(7);
            }
            case RLD: {
                return this.createInstruction(111, 237);
            }
            case RR: {
                if (tokenArray[1] == Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(30, 203);
                }
                if (tokenArray[1] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[1]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(tokenArray.length > 3 ? 0xCB18 | Z80Assembler.registerIndex(tokenArray[3]) : 51998, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), this.evaluate((ConstantToken)tokenArray[2]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) | 0x18, 203);
            }
            case RRA: {
                return this.createInstruction(31);
            }
            case RRC: {
                if (tokenArray[1] == Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(14, 203);
                }
                if (tokenArray[1] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[1]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(tokenArray.length > 3 ? 0xCB08 | Z80Assembler.registerIndex(tokenArray[3]) : 51982, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), this.evaluate((ConstantToken)tokenArray[2]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) | 8, 203);
            }
            case RRCA: {
                return this.createInstruction(15);
            }
            case RRD: {
                return this.createInstruction(103, 237);
            }
            case RST: {
                return this.createRSTInstruction(tokenArray);
            }
            case SBC: {
                if (tokenArray[1] instanceof Z80Parser.RegisterPair) {
                    return this.createInstruction(0x40 | Z80Assembler.registerPairIndex(tokenArray[2]) << 4 | 2, 237);
                }
                if (tokenArray[2] instanceof ConstantToken) {
                    return this.createInstruction(222, 0, 256, this.evaluate((ConstantToken)tokenArray[2]), 1);
                }
                return this.createInstruction(0x98 | Z80Assembler.registerIndex(tokenArray[2]), Z80Assembler.registerPrefix(tokenArray[2]), tokenArray.length > 3 ? this.evaluate((ConstantToken)tokenArray[3]) : 256);
            }
            case SCF: {
                return this.createInstruction(55);
            }
            case SET: {
                if (tokenArray[2] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[2]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(0xCBC0 | this.evaluateBitNumber(tokenArray[1]) << 3 | (tokenArray.length > 4 ? Z80Assembler.registerIndex(tokenArray[4]) : 6), Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[2]), this.evaluate((ConstantToken)tokenArray[3]));
                }
                return this.createInstruction(0xC0 | this.evaluateBitNumber(tokenArray[1]) << 3 | Z80Assembler.registerIndex(tokenArray[2]), 203);
            }
            case SLA: {
                if (tokenArray[1] == Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(38, 203);
                }
                if (tokenArray[1] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[1]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(tokenArray.length > 3 ? 0xCB20 | Z80Assembler.registerIndex(tokenArray[3]) : 52006, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), this.evaluate((ConstantToken)tokenArray[2]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) | 0x20, 203);
            }
            case SLL: {
                if (tokenArray[1] == Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(54, 203);
                }
                if (tokenArray[1] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[1]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(tokenArray.length > 3 ? 0xCB30 | Z80Assembler.registerIndex(tokenArray[3]) : 52022, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), this.evaluate((ConstantToken)tokenArray[2]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) | 0x30, 203);
            }
            case SRA: {
                if (tokenArray[1] == Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(46, 203);
                }
                if (tokenArray[1] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[1]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(tokenArray.length > 3 ? 0xCB28 | Z80Assembler.registerIndex(tokenArray[3]) : 52014, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), this.evaluate((ConstantToken)tokenArray[2]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) | 0x28, 203);
            }
            case SRL: {
                if (tokenArray[1] == Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(62, 203);
                }
                if (tokenArray[1] instanceof IndirectRegisterPair && ((IndirectRegisterPair)tokenArray[1]).getRegisterPair() != Z80Parser.RegisterPair.HL) {
                    return this.createInstruction(tokenArray.length > 3 ? 0xCB38 | Z80Assembler.registerIndex(tokenArray[3]) : 52030, Z80Assembler.registerPairPrefix((IndirectRegisterPair)tokenArray[1]), this.evaluate((ConstantToken)tokenArray[2]));
                }
                return this.createInstruction(Z80Assembler.registerIndex(tokenArray[1]) | 0x38, 203);
            }
            case SUB: {
                if (tokenArray[1] instanceof ConstantToken) {
                    return this.createInstruction(214, 0, 256, this.evaluate((ConstantToken)tokenArray[1]), 1);
                }
                return this.createInstruction(0x90 | Z80Assembler.registerIndex(tokenArray[1]), Z80Assembler.registerPrefix(tokenArray[1]), tokenArray.length > 2 ? this.evaluate((ConstantToken)tokenArray[2]) : 256);
            }
            case XOR: {
                if (tokenArray[1] instanceof ConstantToken) {
                    return this.createInstruction(238, 0, 256, this.evaluate((ConstantToken)tokenArray[1]), 1);
                }
                return this.createInstruction(0xA8 | Z80Assembler.registerIndex(tokenArray[1]), Z80Assembler.registerPrefix(tokenArray[1]), tokenArray.length > 2 ? this.evaluate((ConstantToken)tokenArray[2]) : 256);
            }
        }
        return this.createInstruction(0);
    }

    private int evaluateBitNumber(Token token) {
        int n = this.evaluate((ConstantToken)token);
        if (n < 0 || n > 7) {
            throw new IndexOutOfBoundsException("Bit number " + n + " is out of range: " + token);
        }
        return n;
    }

    private Z80Instruction createRSTInstruction(Token[] tokenArray) {
        int n = this.evaluate((ConstantToken)tokenArray[1]);
        if (n < 0 || n > 56 || (n & 7) != 0) {
            n = 0;
        }
        return this.createInstruction(0xC7 | n);
    }

    protected Z80Instruction createInstruction(int n, int n2, int n3, int n4, int n5) {
        return Z80Instruction.getInstance(n, n2, n3, n4, n5);
    }

    protected Z80Instruction createInstruction(int n, int n2, int n3) {
        return Z80Instruction.getInstance(n, n2, n3);
    }

    protected Z80Instruction createInstruction(int n, int n2) {
        return Z80Instruction.getInstance(n, n2);
    }

    protected Z80Instruction createInstruction(int n) {
        return Z80Instruction.getInstance(n);
    }

    protected int evaluate(ConstantToken constantToken) {
        try {
            return this.expressionEvaluator.evaluate(constantToken.getConstant());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected static int registerIndex(Token token) {
        if (token instanceof IndirectRegisterPair) {
            return 6;
        }
        return Z80Assembler.registerIndex((Z80Parser.Register)token);
    }

    private static int registerIndex(Z80Parser.Register register) {
        switch (register) {
            case A: {
                return 7;
            }
            case B: {
                return 0;
            }
            case C: {
                return 1;
            }
            case D: {
                return 2;
            }
            case E: {
                return 3;
            }
            case H: 
            case IXH: 
            case IYH: {
                return 4;
            }
            case IXL: 
            case IYL: 
            case L: {
                return 5;
            }
        }
        throw new IllegalArgumentException(register + " doesn't have an index");
    }

    private static int registerPairIndex(Token token) {
        switch ((Z80Parser.RegisterPair)token) {
            case BC: {
                return 0;
            }
            case DE: {
                return 1;
            }
            case HL: 
            case IX: 
            case IY: {
                return 2;
            }
            case AF: 
            case SP: {
                return 3;
            }
        }
        throw new IllegalArgumentException(token + " doesn't have an index");
    }

    private static int conditionIndex(Z80Parser.Condition condition) {
        switch (condition) {
            case C: {
                return 3;
            }
            case M: {
                return 7;
            }
            case NC: {
                return 2;
            }
            case NZ: {
                return 0;
            }
            case P: {
                return 6;
            }
            case PE: {
                return 5;
            }
            case PO: {
                return 4;
            }
            case Z: {
                return 1;
            }
        }
        throw new IllegalArgumentException(condition + " doesn't have an index");
    }

    private static int registerPairPrefix(IndirectRegisterPair indirectRegisterPair) {
        return Z80Assembler.registerPairPrefix(indirectRegisterPair.getRegisterPair());
    }

    private static int registerPairPrefix(Token token) {
        return token == Z80Parser.RegisterPair.IX ? 221 : (token == Z80Parser.RegisterPair.IY ? 253 : 0);
    }

    private static int registerPrefix(Token token) {
        if (token instanceof Z80Parser.RegisterPair) {
            return Z80Assembler.registerPrefix((Z80Parser.RegisterPair)token);
        }
        if (token instanceof IndirectRegisterPair) {
            return Z80Assembler.registerPrefix(((IndirectRegisterPair)token).getRegisterPair());
        }
        return Z80Assembler.registerPrefix((Z80Parser.Register)token);
    }

    private static int registerPrefix(Z80Parser.RegisterPair registerPair) {
        if (registerPair == Z80Parser.RegisterPair.IX) {
            return 221;
        }
        if (registerPair == Z80Parser.RegisterPair.IY) {
            return 253;
        }
        return 0;
    }

    private static int registerPrefix(Z80Parser.Register register) {
        return register == Z80Parser.Register.IXH || register == Z80Parser.Register.IXL ? 221 : (register == Z80Parser.Register.IYH || register == Z80Parser.Register.IYL ? 253 : 0);
    }
}

