/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.NestedPolicy;
import com.sun.xml.internal.ws.policy.PolicyIntersector;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.sourcemodel.ModelNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class PolicyAssertion {
    private final AssertionData data;
    private AssertionSet parameters;
    private NestedPolicy nestedPolicy;

    protected PolicyAssertion() {
        this.data = AssertionData.createAssertionData(null);
        this.parameters = AssertionSet.createAssertionSet(null);
    }

    @Deprecated
    protected PolicyAssertion(AssertionData assertionData, Collection<? extends PolicyAssertion> collection, AssertionSet assertionSet) {
        this.data = assertionData;
        if (assertionSet != null) {
            this.nestedPolicy = NestedPolicy.createNestedPolicy(assertionSet);
        }
        this.parameters = AssertionSet.createAssertionSet(collection);
    }

    protected PolicyAssertion(AssertionData assertionData, Collection<? extends PolicyAssertion> collection) {
        this.data = assertionData == null ? AssertionData.createAssertionData(null) : assertionData;
        this.parameters = AssertionSet.createAssertionSet(collection);
    }

    public final QName getName() {
        return this.data.getName();
    }

    public final String getValue() {
        return this.data.getValue();
    }

    public boolean isOptional() {
        return this.data.isOptionalAttributeSet();
    }

    public boolean isIgnorable() {
        return this.data.isIgnorableAttributeSet();
    }

    public final boolean isPrivate() {
        return this.data.isPrivateAttributeSet();
    }

    public final Set<Map.Entry<QName, String>> getAttributesSet() {
        return this.data.getAttributesSet();
    }

    public final Map<QName, String> getAttributes() {
        return this.data.getAttributes();
    }

    public final String getAttributeValue(QName qName) {
        return this.data.getAttributeValue(qName);
    }

    @Deprecated
    public final boolean hasNestedAssertions() {
        return !this.parameters.isEmpty();
    }

    public final boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    @Deprecated
    public final Iterator<PolicyAssertion> getNestedAssertionsIterator() {
        return this.parameters.iterator();
    }

    public final Iterator<PolicyAssertion> getParametersIterator() {
        return this.parameters.iterator();
    }

    boolean isParameter() {
        return this.data.getNodeType() == ModelNode.Type.ASSERTION_PARAMETER_NODE;
    }

    public boolean hasNestedPolicy() {
        return this.getNestedPolicy() != null;
    }

    public NestedPolicy getNestedPolicy() {
        return this.nestedPolicy;
    }

    public <T extends PolicyAssertion> T getImplementation(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)((PolicyAssertion)clazz.cast(this));
        }
        return null;
    }

    public String toString() {
        return this.toString(0, new StringBuffer()).toString();
    }

    protected StringBuffer toString(int n, StringBuffer stringBuffer) {
        String string = PolicyUtils.Text.createIndent(n);
        String string2 = PolicyUtils.Text.createIndent(n + 1);
        stringBuffer.append(string).append("Assertion[").append(this.getClass().getName()).append("] {").append(PolicyUtils.Text.NEW_LINE);
        this.data.toString(n + 1, stringBuffer);
        stringBuffer.append(PolicyUtils.Text.NEW_LINE);
        if (this.hasParameters()) {
            stringBuffer.append(string2).append("parameters {").append(PolicyUtils.Text.NEW_LINE);
            for (PolicyAssertion policyAssertion : this.parameters) {
                policyAssertion.toString(n + 2, stringBuffer).append(PolicyUtils.Text.NEW_LINE);
            }
            stringBuffer.append(string2).append('}').append(PolicyUtils.Text.NEW_LINE);
        } else {
            stringBuffer.append(string2).append("no parameters").append(PolicyUtils.Text.NEW_LINE);
        }
        if (this.hasNestedPolicy()) {
            this.getNestedPolicy().toString(n + 1, stringBuffer).append(PolicyUtils.Text.NEW_LINE);
        } else {
            stringBuffer.append(string2).append("no nested policy").append(PolicyUtils.Text.NEW_LINE);
        }
        stringBuffer.append(string).append('}');
        return stringBuffer;
    }

    boolean isCompatibleWith(PolicyAssertion policyAssertion, PolicyIntersector.CompatibilityMode compatibilityMode) {
        boolean bl;
        boolean bl2 = bl = this.data.getName().equals(policyAssertion.data.getName()) && this.hasNestedPolicy() == policyAssertion.hasNestedPolicy();
        if (bl && this.hasNestedPolicy()) {
            bl = this.getNestedPolicy().getAssertionSet().isCompatibleWith(policyAssertion.getNestedPolicy().getAssertionSet(), compatibilityMode);
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PolicyAssertion)) {
            return false;
        }
        PolicyAssertion policyAssertion = (PolicyAssertion)object;
        boolean bl = true;
        bl = bl && this.data.equals(policyAssertion.data);
        boolean bl2 = bl = bl && this.parameters.equals(policyAssertion.parameters);
        bl = bl && (this.getNestedPolicy() == null ? policyAssertion.getNestedPolicy() == null : this.getNestedPolicy().equals(policyAssertion.getNestedPolicy()));
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.data.hashCode();
        n = 37 * n + (this.hasParameters() ? 17 : 0);
        n = 37 * n + (this.hasNestedPolicy() ? 17 : 0);
        return n;
    }
}

