/*
 * Decompiled with CFR 0.152.
 */
package testing;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import testing.TestCaseExecutor;
import testing.TestCaseRunner;

public class MultiTestCaseRunner
implements TestCaseRunner {
    private final TestCaseExecutor executor;
    private final File[] files;
    private final String[] names;
    private final int[] results;
    private final String[] failedAssertions;
    private final Exception[] exceptions;
    private final int[] frames;
    private int testCase;
    private TestCaseRunner testCaseRunner;

    public MultiTestCaseRunner(File file, TestCaseExecutor testCaseExecutor) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("A MultiTestCaseRunner must be provided with a directory.");
        }
        this.executor = testCaseExecutor;
        this.files = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".zip");
            }
        });
        this.names = new String[this.files.length];
        this.results = new int[this.files.length];
        this.failedAssertions = new String[this.files.length];
        this.exceptions = new Exception[this.files.length];
        this.frames = new int[this.files.length];
    }

    @Override
    public void frameStarted() {
        if (!this.isRunning()) {
            return;
        }
        if (this.testCaseRunner == null || !this.testCaseRunner.isRunning()) {
            if (this.testCaseRunner != null) {
                this.results[this.testCase] = this.testCaseRunner.getResult();
                this.exceptions[this.testCase] = this.testCaseRunner.getException();
                this.failedAssertions[this.testCase] = this.testCaseRunner.getFailedAssertion();
                this.frames[this.testCase] = this.testCaseRunner.getFrame();
                if (++this.testCase >= this.files.length) {
                    return;
                }
            }
            try {
                this.testCaseRunner = this.executor.executeTestCase(this.files[this.testCase]);
                this.names[this.testCase] = this.testCaseRunner.getTestCaseName();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.testCaseRunner.frameStarted();
    }

    @Override
    public boolean isRunning() {
        return this.testCase < this.files.length;
    }

    @Override
    public String getTestCaseName() {
        return null;
    }

    @Override
    public int getResult() {
        return 0;
    }

    @Override
    public String getFailedAssertion() {
        return null;
    }

    @Override
    public Exception getException() {
        return null;
    }

    @Override
    public int getFrame() {
        return 0;
    }

    public int getNumberOfTestCases() {
        return this.files.length;
    }

    public String getTestCaseName(int n) {
        return this.names[n];
    }

    public int getResult(int n) {
        return this.results[n];
    }

    public String getFailedAssertion(int n) {
        return this.failedAssertions[n];
    }

    public Exception getException(int n) {
        return this.exceptions[n];
    }

    public int getFrame(int n) {
        return this.frames[n];
    }
}

