/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import common.ScreenUtilities;
import java.awt.Component;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import platform.Emulicious;

public class ExpressionsHelpDialog {
    private static ExpressionsHelpDialog expressionsHelpDialog;
    final Window window;

    public ExpressionsHelpDialog(Window window, boolean bl) {
        Object object;
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Expressions Help");
        this.window.setIconImages(window.getIconImages());
        File file = new File(Emulicious.getHomeDirectory(), "Expressions.txt");
        StringBuilder stringBuilder = new StringBuilder((int)file.length());
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            object = bufferedReader.readLine();
            while (object != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append((String)object);
                object = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            stringBuilder.append(iOException);
        }
        object = new JTextArea(stringBuilder.toString());
        ((JTextComponent)object).setEditable(false);
        this.window.add((Component)new JScrollPane((Component)object), "Center");
        if (expressionsHelpDialog == null || !expressionsHelpDialog.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setSize(800, 600);
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    public static void open(Window window, boolean bl) {
        if (expressionsHelpDialog == null) {
            expressionsHelpDialog = new ExpressionsHelpDialog(window, Emulicious.isUseFrames());
            expressionsHelpDialog.setVisible(true);
        } else if (!bl) {
            expressionsHelpDialog.setVisible(true);
        }
    }

    public static void close() {
        if (expressionsHelpDialog != null) {
            Emulicious.getProperties().setProperty("Window" + expressionsHelpDialog.getClass().getSimpleName() + "Open", "" + expressionsHelpDialog.isVisible());
            Emulicious.getProperties().setProperty("Window" + expressionsHelpDialog.getClass().getSimpleName() + "X", "" + expressionsHelpDialog.getX());
            Emulicious.getProperties().setProperty("Window" + expressionsHelpDialog.getClass().getSimpleName() + "Y", "" + expressionsHelpDialog.getY());
            Emulicious.getProperties().setProperty("Window" + expressionsHelpDialog.getClass().getSimpleName() + "Width", "" + expressionsHelpDialog.getWidth());
            Emulicious.getProperties().setProperty("Window" + expressionsHelpDialog.getClass().getSimpleName() + "Height", "" + expressionsHelpDialog.getHeight());
            expressionsHelpDialog.dispose();
            expressionsHelpDialog = null;
        }
    }
}

