/*
 * Decompiled with CFR 0.152.
 */
package system;

import components.cartridge.SMSCartridge;
import components.communication.GearToGear;
import components.video.GGVDP;
import components.video.SMS2VDP;
import output.SMSDisplayWindow;
import output.SMSSoundOutput;
import system.MasterSystem;

public class GameGear
extends MasterSystem {
    private final int[] regs;
    private final int region;
    private static final int[] ERROR_CODES;
    private static SMSCartridge emuliciousBIOSgg;
    private GearToGear gearToGear;

    static {
        int[] nArray = new int[3];
        nArray[0] = 3;
        nArray[2] = 1;
        ERROR_CODES = nArray;
    }

    public GameGear(SMSDisplayWindow sMSDisplayWindow, SMSSoundOutput sMSSoundOutput, int n) {
        super(sMSDisplayWindow, sMSSoundOutput);
        int[] nArray = new int[7];
        nArray[0] = 192;
        nArray[1] = 127;
        nArray[2] = 255;
        nArray[4] = 255;
        nArray[6] = 255;
        this.regs = nArray;
        this.region = n;
    }

    public boolean isSmsMode() {
        return this.cartridge.isSmsMode();
    }

    public static SMSCartridge createEmuliciousBIOS() {
        if (emuliciousBIOSgg != null) {
            return emuliciousBIOSgg;
        }
        int[] nArray = new int[1024];
        nArray[0] = 243;
        nArray[13] = 33;
        nArray[14] = 0;
        nArray[15] = 192;
        nArray[16] = 17;
        nArray[17] = 1;
        nArray[18] = 192;
        nArray[19] = 1;
        nArray[20] = 239;
        nArray[21] = 31;
        nArray[22] = 117;
        nArray[23] = 237;
        nArray[24] = 176;
        nArray[25] = 49;
        nArray[26] = 240;
        nArray[27] = 223;
        nArray[72] = 33;
        nArray[73] = 233;
        nArray[74] = 3;
        nArray[75] = 1;
        nArray[76] = 191;
        nArray[77] = 22;
        nArray[78] = 237;
        nArray[79] = 179;
        nArray[228] = 33;
        nArray[229] = 242;
        nArray[230] = 0;
        nArray[231] = 17;
        nArray[232] = 0;
        nArray[233] = 200;
        nArray[234] = 1;
        nArray[235] = 8;
        nArray[236] = 0;
        nArray[237] = 237;
        nArray[238] = 176;
        nArray[239] = 195;
        nArray[240] = 0;
        nArray[241] = 200;
        nArray[242] = 62;
        nArray[243] = 168;
        nArray[244] = 50;
        nArray[245] = 0;
        nArray[246] = 192;
        nArray[247] = 211;
        nArray[248] = 62;
        nArray[249] = 199;
        nArray[1001] = 22;
        nArray[1002] = 128;
        nArray[1003] = 160;
        nArray[1004] = 129;
        nArray[1005] = 255;
        nArray[1006] = 130;
        nArray[1007] = 255;
        nArray[1008] = 131;
        nArray[1009] = 255;
        nArray[1010] = 132;
        nArray[1011] = 255;
        nArray[1012] = 133;
        nArray[1013] = 255;
        nArray[1014] = 134;
        nArray[1015] = 0;
        nArray[1016] = 135;
        nArray[1017] = 0;
        nArray[1018] = 136;
        nArray[1019] = 0;
        nArray[1020] = 137;
        nArray[1021] = 255;
        nArray[1022] = 138;
        emuliciousBIOSgg = new SMSCartridge(nArray){

            @Override
            public int readByte(int n, int n2) {
                if (n < this.getRom().length) {
                    return super.readByte(n, n2);
                }
                return 255;
            }

            @Override
            public void processWrite(int n, int n2, int n3) {
            }
        };
        return emuliciousBIOSgg;
    }

    public boolean assertNmi() {
        if (this.cpu.getState().isNmiPending()) {
            return false;
        }
        this.cpu.setInterruptLine(2, false);
        this.cpu.setInterruptLine(2, true);
        return true;
    }

    public void setGearToGear(GearToGear gearToGear) {
        this.gearToGear = gearToGear;
    }

    @Override
    protected boolean isEmuliciousBIOS() {
        return this.bios == emuliciousBIOSgg;
    }

    @Override
    protected SMS2VDP createVDP() {
        return new GGVDP(){

            @Override
            public boolean isSmsMode() {
                return GameGear.this.isSmsMode();
            }
        };
    }

    @Override
    protected boolean isPauseButtonPressed() {
        return this.isSmsMode() && this.buttons.isStartButtonPressed();
    }

    @Override
    public boolean isCartridgeEnabled() {
        return !this.isBiosEnabled();
    }

    @Override
    public void reset() {
        super.reset();
        this.cartridgeEnabled = true;
    }

    @Override
    public boolean isROMaddress(int n) {
        if (this.isBiosEnabled()) {
            return n >= 1024 && super.isROMaddress(n);
        }
        return super.isROMaddress(n);
    }

    @Override
    public int readByte(int n, int n2) {
        if (this.isBiosEnabled()) {
            this.biosEnabled = n < 1024;
            this.cartridgeEnabled = n >= 1024;
            int n3 = super.readByte(n, n2);
            this.cartridgeEnabled = true;
            this.biosEnabled = true;
            return n3;
        }
        return super.readByte(n, n2);
    }

    @Override
    public int readPort(int n, int n2) {
        if (!this.isSmsMode()) {
            if (n > 0 && n < 64 && this.gearToGear == null) {
                System.out.println("Read from port " + Integer.toHexString(n));
            }
            if (n == 6) {
                this.firePortRead(n, this.regs[n], n2);
            }
            switch (n) {
                case 0: {
                    this.handleInputChanges();
                    this.firePortRead(n, (this.buttons.isStartButtonPressed() ? 0 : 128) | this.region, n2);
                    return (this.buttons.isStartButtonPressed() ? 0 : 128) | this.region;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return this.readGearToGear(n, n2);
                }
                case 6: {
                    return this.regs[6];
                }
            }
        }
        return super.readPort(n, n2);
    }

    private int readGearToGear(int n, int n2) {
        int n3 = this.gearToGear != null ? this.gearToGear.readPort(n, n2) : this.regs[n];
        this.firePortRead(n, n3, n2);
        return n3;
    }

    @Override
    public void writePort(int n, int n2, int n3) {
        if (this.isSmsMode() && n != 2) {
            super.writePort(n, n2, n3);
        } else {
            if (n <= 6) {
                this.firePortWritten(n, n2, n3);
            }
            switch (n) {
                case 0: {
                    this.regs[n] = n2;
                    System.out.println(String.valueOf(Integer.toHexString(n2)) + "\t-->\t" + Integer.toHexString(n));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (this.gearToGear != null) {
                        this.gearToGear.writePort(n, n2, n3);
                        break;
                    }
                    this.regs[n] = n2;
                    System.out.println(String.valueOf(Integer.toHexString(n2)) + "\t-->\t" + Integer.toHexString(n));
                    break;
                }
                case 6: {
                    this.regs[n] = n2;
                    this.psg.processInput(n, n2, n3);
                    break;
                }
                default: {
                    super.writePort(n, n2, n3);
                }
            }
        }
        this.cartridgeEnabled = true;
    }

    @Override
    public int execute(int n) {
        int n2 = super.execute(n);
        if (this.gearToGear != null) {
            this.gearToGear.update(n - n2);
        }
        return n2;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.gearToGear != null) {
            this.gearToGear.shutdown();
        }
    }

    @Override
    public String palAddressToString(int n) {
        return String.format("PAL%X:%02X", n / 32, n & 0x1F);
    }

    @Override
    public int[] getErrorCodes() {
        return ERROR_CODES;
    }
}

