/*
 * Decompiled with CFR 0.152.
 */
package system;

import components.OutputListener;
import components.cartridge.Cartridge;
import components.cartridge.CartridgeEventListener;
import components.cartridge.GBCartridge;
import components.cpu.LR35902;
import components.cpu.PortMap;
import components.input.ButtonInputProvider;
import components.input.FrameInputDevice;
import components.input.GBJoypad;
import components.input.InputDevice;
import components.sound.GBSoundController;
import components.video.GBCLCDController;
import components.video.GBLCDController;
import events.AbstractArrayListEventModel;
import events.Event;
import events.EventModel;
import events.EventType;
import events.systems.GameBoyEventTypes;
import java.io.File;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import messages.Z80MessageParser;
import network.Network;
import network.SerialTransferListener;
import output.GBDisplayWindow;
import output.GBSoundOutput;
import system.DebuggableSystem;
import system.EmulatableSystem;
import system.GameBoyColor;
import system.IntBiMapBasedRamRomMap;
import system.RamRomMap;
import system.SystemEventListener;
import util.list.AbstractIntList;
import util.list.IntList;
import util.map.HashIntBiMap;
import util.map.IntBiMap;

public class GameBoy
implements DebuggableSystem {
    public static final int CYCLES_PER_SECOND = 0x400000;
    private static final int CYCLES_PER_FRAME = 70224;
    private static final int[] TIMA_BITS = new int[]{512, 8, 32, 128};
    private static final int SERIAL_BIT = 1024;
    private static final int SOUND_BIT = 4096;
    public static final int ERROR_ILLEGAL_INSTRUCTION = 221;
    public static final int ERROR_BREAKPOINT = 0;
    public static final int ERROR_EXECUTE_VRAM = 1;
    public static final int ERROR_EXECUTE_OAM = 2;
    public static final int ERROR_EXECUTE_PORT = 3;
    public static final int ERROR_ACCESS_UNUSABLE = 4;
    public static final int ERROR_ACCESS_MIRROR = 5;
    public static final int ERROR_INACCESSIBLE_SRAM = 6;
    public static final int ERROR_HALT_BUG = 7;
    public static final int ERROR_CPU_OAM_BUS_CONFLICT = 8;
    public static final int ERROR_NON_STANDARD_MBC_ADDRESS_WRITE = 9;
    public static final int ERROR_INCORRECT_HEADER = 10;
    public static final int ERROR_LCD = 16;
    public static final int ERROR_INACCESSIBLE_VRAM = 16;
    public static final int ERROR_INACCESSIBLE_PALETTE = 17;
    public static final int ERROR_INACCESSIBLE_OAM = 18;
    public static final int ERROR_TURN_OFF_LCD_OUTSIDE_VBLANK = 19;
    public static final int ERROR_OAM_BUG = 20;
    public static final int ERROR_SERIAL_TRANSFER = 32;
    public static final int ERROR_APU = 48;
    public static final int ERROR_WAVE_RAM_CORRUPTION = 48;
    private static final int[] ERROR_CODES;
    private static final String[] ADDITIONAL_MEMORY_LOCATION_NAMES;
    private static final int[] ADDITIONAL_MEMORY_LOCATION_LENGTHS;
    private static final String[] PPU_REGISTER_NAMES;
    private static final String[] APU_REGISTER_NAMES;
    private static final String[] SYSTEM_VARIABLE_NAMES;
    private static final String[] ADDITIONAL_VARIABLE_NAMES;
    private static final GBCartridge NULL_CARTRIDGE;
    private static GBCartridge emuliciousBootROM;
    protected final int[] wram;
    protected final int[] memory = new int[256];
    protected final LR35902 cpu;
    protected GBCartridge cartridge = NULL_CARTRIDGE;
    protected GBCartridge bootROM;
    protected GBLCDController lcd;
    protected GBSoundController sound = new GBSoundController();
    protected GBJoypad joypad;
    protected int latchedP1;
    protected int latchedP1counter;
    private int prevKeyStates;
    protected int prevSTAT;
    protected boolean prevSTATline;
    private boolean bootROMenabled;
    protected int counter;
    protected int counterAdjustment;
    protected TIMAState timaState;
    protected int dmaCounter;
    protected int dmaSource;
    protected int timerDMA;
    protected boolean dmaJustStarted;
    protected boolean dmaStillRunning;
    private boolean stopped;
    protected volatile int serialCounter;
    protected volatile int serialData;
    protected volatile boolean serialTransferStarted = false;
    protected volatile boolean serialTransferFinished = false;
    protected int memoryBusCartridge;
    protected int memoryBusVRAM;
    private boolean logSerialTransfer;
    private boolean allowPressingOppositeDirections;
    protected final boolean[] wramInitialized;
    private final boolean[] hramInitialized = new boolean[127];
    private final IntBiMap ramSources = new HashIntBiMap();
    private final RamRomMap ramRomMap = new IntBiMapBasedRamRomMap(this.ramSources);
    private final boolean analoguePocket;
    protected AbstractArrayListEventModel eventModel;
    private IntList allRAMaddresses;
    private final LinkedList<SystemEventListener> systemEventListenerList = new LinkedList();
    private SystemEventListener[] systemEventListeners = new SystemEventListener[0];
    private final LinkedList<OutputListener> portListenerList = new LinkedList();
    private OutputListener[] portListeners = new OutputListener[0];
    private final ButtonInputProvider.ButtonListener buttonListener = new ButtonInputProvider.ButtonListener(){

        @Override
        public void buttonPressed() {
            if ((GameBoy.this.joypad.getKeyStates(GameBoy.this.memory[0], GameBoy.this.latchedP1) & 0xF) != 15) {
                GameBoy.this.requestInterrupt(16);
            }
        }
    };

    static {
        int[] nArray = new int[18];
        nArray[0] = 221;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 9;
        nArray[6] = 10;
        nArray[7] = 4;
        nArray[8] = 5;
        nArray[9] = 6;
        nArray[10] = 16;
        nArray[11] = 17;
        nArray[12] = 18;
        nArray[13] = 19;
        nArray[14] = 8;
        nArray[15] = 20;
        nArray[16] = 7;
        nArray[17] = 48;
        ERROR_CODES = nArray;
        ADDITIONAL_MEMORY_LOCATION_NAMES = new String[]{"HRAM", "OAM", "I/O"};
        ADDITIONAL_MEMORY_LOCATION_LENGTHS = new int[]{128, 160, 128};
        String[] stringArray = new String[12];
        stringArray[0] = "LCDC";
        stringArray[1] = "STAT";
        stringArray[2] = "SCY";
        stringArray[3] = "SCX";
        stringArray[4] = "LY";
        stringArray[5] = "LYC";
        stringArray[7] = "BGP";
        stringArray[8] = "OBP0";
        stringArray[9] = "OBP1";
        stringArray[10] = "WY";
        stringArray[11] = "WX";
        PPU_REGISTER_NAMES = stringArray;
        String[] stringArray2 = new String[23];
        stringArray2[0] = "NR10";
        stringArray2[1] = "NR11";
        stringArray2[2] = "NR12";
        stringArray2[3] = "NR13";
        stringArray2[4] = "NR14";
        stringArray2[6] = "NR21";
        stringArray2[7] = "NR22";
        stringArray2[8] = "NR23";
        stringArray2[9] = "NR24";
        stringArray2[10] = "NR30";
        stringArray2[11] = "NR31";
        stringArray2[12] = "NR32";
        stringArray2[13] = "NR33";
        stringArray2[14] = "NR34";
        stringArray2[16] = "NR41";
        stringArray2[17] = "NR42";
        stringArray2[18] = "NR43";
        stringArray2[19] = "NR44";
        stringArray2[20] = "NR50";
        stringArray2[21] = "NR51";
        stringArray2[22] = "NR52";
        APU_REGISTER_NAMES = stringArray2;
        SYSTEM_VARIABLE_NAMES = new String[]{"IE", "IF", "SVBK", "DIV", "TIMA", "TMA", "TAC", "JOYP", "SB", "SC", "VBK"};
        ADDITIONAL_VARIABLE_NAMES = new String[]{"ROMB0", "ROMB1", "RAMG"};
        NULL_CARTRIDGE = new GBCartridge(new int[0]);
    }

    public GameBoy(GBDisplayWindow gBDisplayWindow, ButtonInputProvider buttonInputProvider, GBSoundOutput gBSoundOutput, Network network) {
        this(gBDisplayWindow, buttonInputProvider, gBSoundOutput, network, false);
    }

    public GameBoy(GBDisplayWindow gBDisplayWindow, ButtonInputProvider buttonInputProvider, GBSoundOutput gBSoundOutput, Network network, boolean bl) {
        this(gBDisplayWindow, buttonInputProvider, gBSoundOutput, network, new int[8192], bl);
    }

    protected GameBoy(final GBDisplayWindow gBDisplayWindow, ButtonInputProvider buttonInputProvider, GBSoundOutput gBSoundOutput, final Network network, int[] nArray, boolean bl) {
        this.init(gBDisplayWindow, buttonInputProvider, gBSoundOutput, network);
        this.analoguePocket = bl;
        this.cpu = new LR35902(this instanceof GameBoyColor, this.lcd.createOamBugHandler(), this, new PortMap(){

            @Override
            public void writePort(int n, int n2, int n3) {
                int n4;
                int n5 = n4 = n < GameBoy.this.memory.length ? GameBoy.this.memory[n] : 0;
                if (n < GameBoy.this.memory.length) {
                    GameBoy.this.handlePortEvent(n, n4, n2, n3);
                }
                GameBoy.this.writePort(n, n2, n3, gBDisplayWindow, network);
            }

            @Override
            public int readPort(int n, int n2) {
                GameBoy.this.onReadPort(n, n2);
                if (n < GameBoy.this.memory.length) {
                    GameBoy.this.handlePortEvent(n, GameBoy.this.memory[n], -1, n2);
                }
                return 0;
            }
        }, this.memory);
        this.wram = nArray;
        this.wramInitialized = new boolean[nArray.length];
    }

    protected void init(final GBDisplayWindow gBDisplayWindow, ButtonInputProvider buttonInputProvider, final GBSoundOutput gBSoundOutput, Network network) {
        if (this.lcd == null) {
            this.lcd = new GBLCDController();
        }
        this.setInputProvider(buttonInputProvider);
        gBDisplayWindow.setLCD(this.lcd);
        gBSoundOutput.setController(this.sound);
        this.lcd.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                switch (n) {
                    case 64: {
                        if (!((n2 & 0x180) != 256 || GameBoy.this.lcd instanceof GBCLCDController && GameBoy.this.lcd.getCyclesSinceLastFrame() <= 1668)) {
                            gBDisplayWindow.renderBlankScreen();
                        }
                        n2 &= 0xFF;
                        GameBoy.this.cpu.sync();
                        break;
                    }
                    case 65: {
                        boolean bl;
                        boolean bl2 = (n2 & 0x400) != 0;
                        boolean bl3 = (n2 & 0x200) != 0;
                        boolean bl4 = (n2 & 0x100) != 0 && GameBoy.this.lcd.isLCDDisplayEnabled();
                        int n4 = GameBoy.this.prevSTAT;
                        int n5 = n2 &= 0xFF;
                        if (bl3) {
                            n2 = n4;
                        }
                        if (!GameBoy.this.lcd.isLCDDisplayEnabled()) break;
                        GameBoy.this.prevSTAT = n5;
                        if (bl2) break;
                        int n6 = n5 & 3;
                        int n7 = bl4 && n6 == 2 || GameBoy.this.lcd.isOddMode0() ? 3 : n6;
                        boolean bl5 = bl = n7 < 3 && (n5 >> n7 & 8) != 0 || (n5 & 0x44) == 68;
                        if (!GameBoy.this.prevSTATline && bl) {
                            GameBoy.this.requestInterrupt(2, n6 == 1 ? -GameBoy.this.lcd.calcCurrentDot() : GameBoy.this.lcd.getTimer());
                        }
                        GameBoy.this.prevSTATline = bl;
                        if (GameBoy.this.lcd.isOddMode0()) {
                            n2 &= 0xFFFFFFFC;
                        }
                        if ((n4 & 3) == 3 && n6 == 0) {
                            gBDisplayWindow.drawCurrentLine();
                        }
                        if ((n4 & 3) == 1 && n6 == 2) {
                            GameBoy.this.frameFinished();
                        }
                        if ((n4 & 3) == 1 || n6 != 1) break;
                        GameBoy.this.requestInterrupt(1, -GameBoy.this.lcd.calcCurrentDot());
                        break;
                    }
                    case 70: {
                        GameBoy.this.dmaSource = n2 << 8;
                        GameBoy.this.dmaJustStarted = true;
                        GameBoy.this.dmaStillRunning = GameBoy.this.dmaCounter > 0;
                        GameBoy.this.dmaCounter = 160;
                        GameBoy.this.timerDMA = GameBoy.this.dmaCounter * 4 + 4;
                        GameBoy.this.cpu.sync();
                        break;
                    }
                    case 71: 
                    case 72: 
                    case 73: {
                        GameBoy.this.firePalettesWrite(n - 71, n2, n2);
                        break;
                    }
                    case 0x110000: {
                        if ((n2 & 0x4000) != 0 && (n2 & 0x1FFF) < 6144) {
                            gBDisplayWindow.makeTileDirty((n2 & 0x3FFF) >> 1);
                        }
                        GameBoy.this.fireVRAMwrite(n2 & 0x3FFF, GameBoy.this.lcd.getVRAM()[n2 & 0x3FFF], (n2 & 0xFF0000) >> 16);
                        if (GameBoy.this.eventModel != null) {
                            GameBoy.this.addEvent(GameBoyEventTypes.VRAM, (n2 & 0xFF0000) >> 16, GameBoy.this.lcd.getVRAM()[n2 & 0x3FFF], n3, 0x4000 | n2);
                        }
                        return;
                    }
                    case 0x110001: {
                        GameBoy.this.fireVRAMread(n2 & 0x3FFF, GameBoy.this.lcd.getVRAM()[n2 & 0x3FFF]);
                        if (GameBoy.this.eventModel != null) {
                            GameBoy.this.addEvent(GameBoyEventTypes.VRAM, GameBoy.this.lcd.getVRAM()[n2 & 0x3FFF], -1, n3, n2);
                        }
                        return;
                    }
                    case 0x110002: {
                        GameBoy.this.fireOamWrite(n2 & 0x3FFF, GameBoy.this.lcd.getOAM()[n2 & 0x3FFF], (n2 & 0xFF0000) >> 16);
                        if (GameBoy.this.eventModel != null) {
                            GameBoy.this.addEvent(GameBoyEventTypes.OAM, (n2 & 0xFF0000) >> 16, GameBoy.this.lcd.getOAM()[n2 & 0x3FFF], n3, 0x4000 | n2);
                        }
                        return;
                    }
                    case 0x110003: {
                        GameBoy.this.fireOamRead(n2 & 0x3FFF, GameBoy.this.lcd.getOAM()[n2 & 0x3FFF]);
                        if (GameBoy.this.eventModel != null) {
                            GameBoy.this.addEvent(GameBoyEventTypes.OAM, GameBoy.this.lcd.getOAM()[n2 & 0x3FFF], -1, n3, n2);
                        }
                        return;
                    }
                    case 0x110100: 
                    case 0x110101: 
                    case 0x110102: 
                    case 0x110103: 
                    case 0x110104: {
                        GameBoy.this.fireErrorOccurred(16 + (n & 0xF), n2);
                        return;
                    }
                    case 0x110010: {
                        gBDisplayWindow.renderFrame();
                        return;
                    }
                }
                if (GameBoy.this.isAnaloguePocket() && (n == 64 || n == 65)) {
                    n2 = n2 & 0xFFFFFF00 | GameBoy.this.reverseBits(n2);
                    if (n == 64) {
                        n = 78;
                    }
                }
                if (n < GameBoy.this.memory.length) {
                    GameBoy.this.memory[n] = n2;
                }
            }
        });
        this.sound.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 40) {
                    GameBoy.this.fireErrorOccurred(48, n2);
                } else if (n == 39) {
                    if (n2 < 0) {
                        gBSoundOutput.finishFrame();
                    } else {
                        gBSoundOutput.updateBuffer(n2);
                    }
                } else {
                    if (n == 38) {
                        int n4 = GameBoy.this.memory[n] ^ n2;
                        if ((n4 & 0x80) != 0 && (n2 & 0x80) != 0) {
                            if ((GameBoy.this.counter & GameBoy.this.getSoundBit()) != 0) {
                                GameBoy.this.sound.delayEnable();
                            }
                            GameBoy.this.cpu.sync();
                        }
                        if ((n4 & 0xF) != 0) {
                            int n5 = 0;
                            while (n5 < 4) {
                                if ((GameBoy.this.memory[n] & 1 << n5) != 0 && (n2 & 1 << n5) == 0) {
                                    gBSoundOutput.channelDisabled(n5);
                                }
                                ++n5;
                            }
                        }
                    }
                    GameBoy.this.memory[n] = n2;
                }
            }
        });
        network.setSerialTransferListener(new SerialTransferListener(){

            @Override
            public void transferStarted() {
                GameBoy.this.cpu.sync();
                GameBoy.this.serialTransferFinished = false;
                GameBoy.this.serialCounter = 12;
                GameBoy.this.serialTransferStarted = true;
                if (GameBoy.this.logSerialTransfer) {
                    GameBoy.this.fireMessageSent(String.valueOf(System.currentTimeMillis()) + " Sending serial data:  $" + String.format("%02X", GameBoy.this.memory[1]) + (GameBoy.this.memory[1] == 10 ? " '\\n'" : (GameBoy.this.memory[1] < 128 ? " '" + (char)GameBoy.this.memory[1] + "'" : "")) + "\n");
                }
            }

            @Override
            public void transferFinished(int n) {
                GameBoy.this.serialData = n;
                GameBoy.this.serialTransferFinished = true;
                if (GameBoy.this.logSerialTransfer) {
                    GameBoy.this.fireMessageSent(String.valueOf(System.currentTimeMillis()) + " Received serial data: $" + String.format("%02X", n) + "\n");
                }
            }
        });
    }

    protected void writePort(int n, int n2, int n3, GBDisplayWindow gBDisplayWindow, Network network) {
        int n4 = n < this.memory.length ? this.memory[n] : 0;
        switch (n) {
            case 0: {
                int n5 = this.joypad.getKeyStates(n2, this.latchedP1);
                int n6 = (n5 ^ this.memory[n]) & 0xF;
                if ((n6 & n5) < n6) {
                    this.requestInterrupt(16);
                }
                if ((n2 & 0x30) == 48) {
                    this.memory[n] = n2;
                }
                this.latchedP1 = n2;
                this.updateTimers(n3);
                this.counterAdjustment = n3;
                this.latchedP1counter = this.counter;
                break;
            }
            case 1: {
                this.updateTimers(n3);
                if (this.serialTransferStarted) {
                    this.fireErrorOccurred(32, n2);
                }
                this.memory[n] = n2;
                this.counterAdjustment = n3;
                break;
            }
            case 2: {
                this.updateTimers(n3);
                if (this.serialTransferStarted) {
                    this.fireErrorOccurred(32, n2);
                }
                this.memory[n] = (this instanceof GameBoyColor && !((GameBoyColor)this).dmgMode ? 124 : 126) | n2;
                if ((n2 & 0x80) != 0) {
                    network.startSerialTransfer(this.memory[1], this.memory[2]);
                }
                this.counterAdjustment = n3;
                break;
            }
            case 4: {
                this.updateTimers(n3);
                this.clearCounter();
                this.counterAdjustment = n3;
                break;
            }
            case 5: {
                this.updateTimers(n3);
                if (this.timaState != TIMAState.RELOADED) {
                    this.memory[n] = n2;
                }
                this.timaState = TIMAState.REGULAR;
                if ((this.memory[7] & 4) != 0) {
                    this.cpu.sync();
                }
                this.counterAdjustment = n3;
                break;
            }
            case 6: {
                this.updateTimers(n3);
                this.memory[n] = n2;
                if (this.timaState == TIMAState.RELOADED) {
                    this.memory[5] = n2;
                    this.timaState = TIMAState.REGULAR;
                }
                this.counterAdjustment = n3;
                break;
            }
            case 7: {
                this.updateTimers(n3);
                this.setTAC(n2);
                if ((this.memory[7] & 4) != 0) {
                    this.cpu.sync();
                }
                this.counterAdjustment = n3;
                break;
            }
            case 15: {
                this.lcd.processInput(n, n2, n3);
                this.updateTimers(n3);
                this.memory[n] = 0xE0 | n2;
                this.counterAdjustment = n3;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                this.updateTimers(n3);
                this.counterAdjustment = n3;
                this.sound.processInput(n, n2, this.calcNextSoundClock());
                break;
            }
            case 78: {
                if (!this.isAnaloguePocket()) break;
                this.memory[n] = n2;
                this.lcd.processInput(64, this.reverseBits(n2), n3);
                break;
            }
            case 64: {
                if (this.isAnaloguePocket()) {
                    this.memory[n] = 255;
                    break;
                }
            }
            case 65: {
                if (this.isAnaloguePocket()) {
                    this.memory[n] = n2;
                    this.lcd.processInput(n, this.reverseBits(n2), n3);
                    break;
                }
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                this.memory[n] = n2;
                this.lcd.processInput(n, n2, n3);
                break;
            }
            case 80: {
                if ((this.memory[n] & 1) == 0 && (n2 & 1) != 0) {
                    this.disableBootROM();
                }
                this.memory[n] = 255;
                break;
            }
            case 256: {
                this.fireErrorOccurred(0, 0);
                break;
            }
            case 338: {
                this.handleMessage();
                break;
            }
            case 374: {
                this.addHaltEvent(n2, n3);
                break;
            }
            case 376: {
                this.updateTimers(n3);
                this.handleStop();
                this.counterAdjustment = n3 - 4;
                if (!this.stopped) break;
                gBDisplayWindow.avoidFrameSkip();
                if (this instanceof GameBoyColor && (this.lcd.getRegSTAT() & 3) == 3) {
                    gBDisplayWindow.renderFrame();
                    break;
                }
                gBDisplayWindow.renderStopScreen();
                break;
            }
            case 630: {
                this.fireErrorOccurred(7, n2);
                break;
            }
            case 477: {
                this.fireErrorOccurred(221, n2);
                break;
            }
            case 255: {
                this.memory[n] = n2;
                break;
            }
            default: {
                if (n <= 75 || n >= 128 || this instanceof GameBoyColor) break;
                this.memory[n] = 255;
            }
        }
        if (n < this.memory.length) {
            this.firePortWritten(n, n2, n3);
            this.fireIOwrite(n, n4, n2);
        }
    }

    protected void onReadPort(int n, int n2) {
        switch (n) {
            case 0: {
                this.updateTimers(n2);
                this.counterAdjustment = n2;
                this.memory[n] = this.joypad.getKeyStates(this.memory[n], this.latchedP1, this.counter - this.latchedP1counter & 0x3FFFF);
                int n3 = this.joypad.getState();
                if (n3 == this.prevKeyStates) break;
                this.fireInputStateChanged(n3);
                this.prevKeyStates = n3;
                break;
            }
            case 1: {
                break;
            }
            case 38: {
                this.sound.readPort(n, this.calcNextSoundClock());
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                this.memory[n] = this.sound.readPort(n, this.calcNextSoundClock());
                break;
            }
            case 15: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                this.lcd.readPort(n, n2);
            }
        }
        this.firePortRead(n, this.memory[n], n2);
        this.fireIOread(n, this.memory[n]);
    }

    protected int reverseBits(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 8) {
            n2 = n2 << 1 | n & 1;
            n >>= 1;
            ++n3;
        }
        return n2;
    }

    public boolean isAnaloguePocket() {
        return this.analoguePocket && this.isCartridgeEnabled();
    }

    protected boolean isBootROMenabled() {
        return this.bootROMenabled;
    }

    protected void disableBootROM() {
        this.bootROMenabled = false;
        if (this.isEmuliciousBootROM()) {
            this.memory[38] = this.memory[38] | 1;
        }
        if (this.isAnaloguePocket()) {
            this.memory[78] = this.reverseBits(this.memory[64]);
            this.memory[64] = 255;
            this.memory[65] = this.reverseBits(this.memory[65]);
        }
    }

    protected boolean isCartridgeHeaderValid() {
        return this.cartridge == null || this.cartridge.isHeaderChecksumValid() && this.cartridge.isHeaderLogoValid(this.isAnaloguePocket());
    }

    public int getBGandWindowDataAddress() {
        return this.lcd.getBGandWindowDataAddress();
    }

    public int getBGTileMapDisplayAddress() {
        return this.lcd.getBGTileMapDisplayAddress();
    }

    public int getWindowTileMapDisplayAddress() {
        return this.lcd.getWindowTileMapDisplayAddress();
    }

    private void handleMessage() {
        this.fireMessageSent(Z80MessageParser.parseMessage(this));
    }

    protected void handleStop() {
        this.enterStopMode();
    }

    protected void enterStopMode() {
        this.stopped = true;
        this.cpu.sync();
    }

    protected void leaveStopMode() {
        this.cpu.reduceCycleCount(4);
        this.lcd.update(46092);
        this.counter = 0;
        this.stopped = false;
    }

    protected boolean isStopped() {
        if (this.stopped) {
            int n = this.joypad.getKeyStates(this.memory[0], this.latchedP1);
            if ((n & 0xF) < (this.memory[0] & 0xF)) {
                this.leaveStopMode();
            }
            this.memory[0] = n;
        }
        return this.stopped;
    }

    @Override
    public int getMemoryLength() {
        return 65536;
    }

    @Override
    public int readByte(int n, int n2) {
        if (n2 <= 0 || !this.cpu.isAccurateTiming()) {
            return this.doReadByte(n, n2);
        }
        this.updateDMA(n2);
        this.timerDMA += n2;
        this.updateTimers(n2);
        this.counterAdjustment = n2;
        return this.doReadByte(n, n2);
    }

    protected int doReadByte(int n, int n2) {
        return this.doReadByte(n, n2, false);
    }

    private int doReadByte(int n, int n2, boolean bl) {
        switch (n >> 13) {
            case 0: {
                if (this.bootROMenabled && this.isBootromAddress(n)) {
                    this.memoryBusCartridge = this.bootROM.readByte(n, n2);
                    return this.memoryBusCartridge;
                }
            }
            case 1: {
                if (!bl && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) {
                    if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                        this.fireErrorOccurred(8, n);
                        return this.memoryBusCartridge;
                    }
                    if (this.dmaSource < 32768 || this.dmaSource >= 40960 && (!(this instanceof GameBoyColor) || this.dmaSource < 49152)) {
                        this.fireErrorOccurred(8, n);
                        return this.memoryBusCartridge;
                    }
                }
                this.memoryBusCartridge = this.cartridge.readByte(n, n2);
                return this.memoryBusCartridge;
            }
            case 2: 
            case 3: {
                if (!bl && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) {
                    if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                        this.fireErrorOccurred(8, n);
                        return this.memoryBusCartridge;
                    }
                    if (this.dmaSource < 32768 || this.dmaSource >= 40960 && (!(this instanceof GameBoyColor) || this.dmaSource < 49152)) {
                        this.fireErrorOccurred(8, n);
                        return this.memoryBusCartridge;
                    }
                }
                this.memoryBusCartridge = this.cartridge.readByte(n, n2);
                return this.memoryBusCartridge;
            }
            case 4: {
                if (!bl && this.dmaSource >= 32768 && this.dmaSource < 40960 && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) {
                    this.fireErrorOccurred(8, n);
                    return this.memoryBusVRAM;
                }
                if (n == this.cpu.getPC()) {
                    this.fireErrorOccurred(1, n);
                }
                this.memoryBusVRAM = this.lcd.readByte(n, n2);
                return this.memoryBusVRAM;
            }
            case 5: {
                int n3;
                if (!bl && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) {
                    if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                        this.fireErrorOccurred(8, n);
                        return this.memoryBusCartridge;
                    }
                    if (this.dmaSource < 32768 || this.dmaSource >= 40960) {
                        this.fireErrorOccurred(8, n);
                        return this.memoryBusCartridge;
                    }
                }
                if ((n3 = this.cartridge.readByte(n, n2)) < 0) {
                    this.fireErrorOccurred(6, n);
                    return this.memoryBusCartridge;
                }
                this.addEvent(GameBoyEventTypes.SRAM, n3, -1, n2, n & 0x1FFF);
                this.memoryBusCartridge = n3;
                return this.memoryBusCartridge;
            }
            case 6: {
                if (!bl && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) {
                    if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                        this.fireErrorOccurred(8, n);
                        return this.memoryBusCartridge;
                    }
                    if (this.dmaSource < 32768 && !(this instanceof GameBoyColor) || this.dmaSource >= 40960) {
                        this.fireErrorOccurred(8, n);
                        return this.memoryBusCartridge;
                    }
                }
                this.memoryBusCartridge = this.readWRAM(n, n2);
                return this.memoryBusCartridge;
            }
            case 7: {
                if (n < 65024) {
                    this.fireErrorOccurred(5, n);
                    if (!bl && !(this instanceof GameBoyColor) && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) {
                        if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                            this.fireErrorOccurred(8, n);
                            return this.memoryBusCartridge;
                        }
                        if (this.dmaSource < 32768 || this.dmaSource >= 40960) {
                            this.fireErrorOccurred(8, n);
                            return this.memoryBusCartridge;
                        }
                    }
                    this.memoryBusCartridge = this.readWRAM(n, n2);
                    return this.memoryBusCartridge;
                }
                if (bl) {
                    return this.doReadByte(0xC000 | n & 0x1FFF, 0, true);
                }
                if (n < 65184) {
                    if (n == this.cpu.getPC()) {
                        this.fireErrorOccurred(2, n);
                    }
                    if (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning) {
                        return 255;
                    }
                    return this.lcd.readByte(n, n2);
                }
                if (n >= 65280) break;
                this.fireErrorOccurred(4, n);
                return this.lcd.readByte(n, n2);
            }
        }
        if (n < 65408) {
            if (n == this.cpu.getPC()) {
                this.fireErrorOccurred(3, n);
            }
            this.memoryBusCartridge = this.cpu.readByte(n);
            return this.memoryBusCartridge;
        }
        if (n < 65535) {
            if (!this.hramInitialized[n - 65408]) {
                this.fireErrorOccurred(-1, n);
            }
            int n4 = this.cpu.readByte(n);
            this.fireHramRead(n - 65408, n4);
            this.addEvent(GameBoyEventTypes.HRAM, n4, -1, n2, n - 65408);
            this.memoryBusCartridge = 255;
            return n4;
        }
        return this.cpu.readByte(n);
    }

    protected int readWRAM(int n, int n2) {
        if (!this.wramInitialized[n & 0x1FFF]) {
            this.fireErrorOccurred(-1, n);
        }
        this.addEvent(GameBoyEventTypes.WRAM, this.wram[n & 0x1FFF], -1, n2, n & 0x1FFF);
        return this.doReadWRAM(n);
    }

    protected int doReadWRAM(int n) {
        return this.wram[n & 0x1FFF];
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        if (this.cpu.isAccurateTiming()) {
            this.updateDMA(n3);
            this.timerDMA += n3;
            this.updateTimers(n3);
            this.counterAdjustment = n3;
        }
        this.doWriteByte(n, n2, n3);
    }

    protected void doWriteByte(int n, int n2, int n3) {
        switch (n >> 13) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.cartridge.processWrite(n, n2, n3);
                break;
            }
            case 4: {
                this.lcd.processWrite(n, n2, n3, false);
                break;
            }
            case 5: {
                if (!(this instanceof GameBoyColor) && (this.dmaSource < 32768 || this.dmaSource >= 40960 && this.dmaSource < 57344) && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) break;
                this.addEvent(GameBoyEventTypes.SRAM, this.cartridge.readByte(n, 0), n2, n3, n & 0x1FFF);
                this.cartridge.processWrite(n, n2, n3);
                break;
            }
            case 6: {
                if (!(this instanceof GameBoyColor) && (this.dmaSource < 32768 || this.dmaSource >= 40960 && this.dmaSource < 57344) && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) break;
                this.writeWRAM(n, n2, n3);
                break;
            }
            case 7: {
                if (n < 65024) {
                    this.fireErrorOccurred(5, n);
                    if (!(this instanceof GameBoyColor) && (this.dmaSource < 32768 || this.dmaSource >= 40960 && this.dmaSource < 57344) && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) break;
                    this.writeWRAM(n, n2, n3);
                    break;
                }
                if (n < 65184) {
                    if (this.dmaStillRunning || this.dmaCounter > 0 && this.timerDMA / 4 <= 160) break;
                    this.lcd.processWrite(n, n2, n3, false);
                    break;
                }
                if (n < 65280) {
                    this.fireErrorOccurred(4, n);
                    this.lcd.processWrite(n, n2, n3, false);
                    break;
                }
            }
            default: {
                if (n >= 65408 && n < 65535) {
                    this.addEvent(GameBoyEventTypes.HRAM, this.memory[n - 65280], n2, n3, n - 65408);
                    this.writeHRAM(n, n2);
                }
                this.cpu.writeByte(n, n2);
            }
        }
    }

    protected void writeWRAM(int n, int n2, int n3) {
        this.updateWRAMsource(n &= 0x1FFF);
        if (!this.isBootROMenabled()) {
            this.wramInitialized[n] = true;
        }
        this.addEvent(GameBoyEventTypes.WRAM, this.wram[n], n2, n3, n);
        this.wram[n] = n2;
    }

    protected void updateWRAMsource(int n) {
        int n2;
        int n3 = this.peekByte(this.cpu.getPrevPC());
        int n4 = -1;
        if ((n3 & 0xCF) == 2) {
            int n5 = this.peekByte(this.cpu.getPrevPC() - 1);
            if ((n5 & 0xCF) == 3) {
                n4 = n5 >> 4;
                n5 = this.peekByte(this.cpu.getPrevPC() - 2);
            }
            if ((n5 & 0xCF) == 10) {
                switch (n5 >> 4) {
                    case 0: {
                        n2 = n4 == 0 ? this.cpu.getRegisterValue(0) - 1 & 0xFFFF : this.cpu.getRegisterValue(0);
                        break;
                    }
                    case 1: {
                        n2 = n4 == 1 ? this.cpu.getRegisterValue(1) - 1 & 0xFFFF : this.cpu.getRegisterValue(1);
                        break;
                    }
                    case 2: {
                        n2 = this.cpu.getRegisterValue(2) - 1 & 0xFFFF;
                        break;
                    }
                    default: {
                        n2 = this.cpu.getRegisterValue(2) + 1 & 0xFFFF;
                        break;
                    }
                }
            } else {
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        if (n2 >= 0 && this.isROMaddress(n2)) {
            this.ramSources.put(n, this.mapAddress(n2));
        } else {
            this.ramSources.remove(n);
        }
    }

    private void writeHRAM(int n, int n2) {
        int n3;
        this.fireHramWrite(n - 65408, this.memory[n - 65280], n2);
        int n4 = this.peekByte(this.cpu.getPrevPC());
        int n5 = -1;
        if ((n4 & 0xCF) == 2 || n4 == 226) {
            int n6 = this.peekByte(this.cpu.getPrevPC() - 1);
            if ((n6 & 0xCF) == 3) {
                n5 = n6 >> 4;
                n6 = this.peekByte(this.cpu.getPrevPC() - 2);
            }
            if ((n6 & 0xCF) == 10) {
                switch (n6 >> 4) {
                    case 0: {
                        n3 = n5 == 0 ? this.cpu.getRegisterValue(0) - 1 & 0xFFFF : this.cpu.getRegisterValue(0);
                        break;
                    }
                    case 1: {
                        n3 = n5 == 1 ? this.cpu.getRegisterValue(1) - 1 & 0xFFFF : this.cpu.getRegisterValue(1);
                        break;
                    }
                    case 2: {
                        n3 = this.cpu.getRegisterValue(2) - 1 & 0xFFFF;
                        break;
                    }
                    default: {
                        n3 = this.cpu.getRegisterValue(2) + 1 & 0xFFFF;
                        break;
                    }
                }
            } else {
                n3 = -1;
            }
        } else {
            n3 = -1;
        }
        if (n3 >= 0 && this.isROMaddress(n3)) {
            this.ramSources.put(n, this.mapAddress(n3));
        } else {
            this.ramSources.remove(n);
        }
        if (!this.isBootROMenabled()) {
            this.hramInitialized[n - 65408] = true;
        }
    }

    public void setInputProvider(ButtonInputProvider buttonInputProvider) {
        if (this.joypad != null) {
            this.joypad.getInputProvider().removeButtonListener(this.buttonListener);
        }
        this.joypad = new GBJoypad(buttonInputProvider, this instanceof GameBoyColor ? 0 : 16, this.allowPressingOppositeDirections);
        this.joypad.getInputProvider().addButtonListener(this.buttonListener);
    }

    public void setLogSerialTransfer(boolean bl) {
        this.logSerialTransfer = bl;
    }

    public void setAllowPressingOppositeDirections(boolean bl) {
        this.allowPressingOppositeDirections = bl;
    }

    @Override
    public void insertCartridge(Cartridge cartridge) {
        this.cartridge = (GBCartridge)cartridge;
        cartridge.addCartridgeEventListener(new CartridgeEventListener(){

            @Override
            public void nonStandardAddressWrite(int n) {
                GameBoy.this.fireErrorOccurred(9, n);
            }
        });
        if (cartridge instanceof GBSoundController.VinProvider) {
            this.sound.setVinProvider((GBSoundController.VinProvider)((Object)cartridge));
        }
        this.reset();
    }

    @Override
    public void ejectCartridge() {
        this.cartridge.eject();
        this.cartridge = NULL_CARTRIDGE;
    }

    @Override
    public void shutdown() {
        this.ejectCartridge();
        this.bootROM = null;
        this.joypad.getInputProvider().removeButtonListener(this.buttonListener);
    }

    protected boolean isEmuliciousBootROM() {
        return this.bootROM == emuliciousBootROM;
    }

    public static GBCartridge createEmuliciousBootROM() {
        if (emuliciousBootROM != null) {
            return emuliciousBootROM;
        }
        int[] nArray = new int[256];
        nArray[0] = 49;
        nArray[1] = 254;
        nArray[2] = 255;
        nArray[12] = 33;
        nArray[13] = 38;
        nArray[14] = 255;
        nArray[15] = 14;
        nArray[16] = 17;
        nArray[17] = 62;
        nArray[18] = 128;
        nArray[19] = 50;
        nArray[20] = 226;
        nArray[21] = 12;
        nArray[22] = 62;
        nArray[23] = 243;
        nArray[24] = 226;
        nArray[25] = 50;
        nArray[26] = 62;
        nArray[27] = 119;
        nArray[28] = 119;
        nArray[33] = 17;
        nArray[34] = 4;
        nArray[35] = 1;
        nArray[36] = 33;
        nArray[37] = 16;
        nArray[38] = 128;
        nArray[39] = 26;
        nArray[40] = 205;
        nArray[41] = 149;
        nArray[42] = 0;
        nArray[43] = 205;
        nArray[44] = 150;
        nArray[45] = 0;
        nArray[46] = 19;
        nArray[47] = 123;
        nArray[48] = 254;
        nArray[49] = 52;
        nArray[50] = 32;
        nArray[51] = 243;
        nArray[52] = 17;
        nArray[53] = 216;
        nArray[54] = 0;
        nArray[55] = 6;
        nArray[56] = 8;
        nArray[57] = 26;
        nArray[58] = 19;
        nArray[59] = 34;
        nArray[60] = 35;
        nArray[61] = 5;
        nArray[62] = 32;
        nArray[63] = 249;
        nArray[64] = 62;
        nArray[65] = 25;
        nArray[66] = 234;
        nArray[67] = 16;
        nArray[68] = 153;
        nArray[69] = 33;
        nArray[70] = 47;
        nArray[71] = 153;
        nArray[72] = 14;
        nArray[73] = 12;
        nArray[74] = 61;
        nArray[75] = 40;
        nArray[76] = 8;
        nArray[77] = 50;
        nArray[78] = 13;
        nArray[79] = 32;
        nArray[80] = 249;
        nArray[81] = 46;
        nArray[82] = 15;
        nArray[83] = 24;
        nArray[84] = 243;
        nArray[91] = 62;
        nArray[92] = 145;
        nArray[93] = 224;
        nArray[94] = 64;
        nArray[95] = 195;
        nArray[96] = 224;
        nArray[97] = 0;
        nArray[124] = 14;
        nArray[125] = 19;
        nArray[126] = 30;
        nArray[127] = 193;
        nArray[128] = 123;
        nArray[129] = 226;
        nArray[130] = 12;
        nArray[131] = 62;
        nArray[132] = 7;
        nArray[133] = 226;
        nArray[149] = 79;
        nArray[150] = 6;
        nArray[151] = 4;
        nArray[152] = 197;
        nArray[153] = 203;
        nArray[154] = 17;
        nArray[155] = 23;
        nArray[156] = 193;
        nArray[157] = 203;
        nArray[158] = 17;
        nArray[159] = 23;
        nArray[160] = 5;
        nArray[161] = 32;
        nArray[162] = 245;
        nArray[163] = 34;
        nArray[164] = 35;
        nArray[165] = 34;
        nArray[166] = 35;
        nArray[167] = 201;
        nArray[216] = 60;
        nArray[217] = 66;
        nArray[218] = 185;
        nArray[219] = 165;
        nArray[220] = 185;
        nArray[221] = 165;
        nArray[222] = 66;
        nArray[223] = 60;
        nArray[241] = 14;
        nArray[242] = 19;
        nArray[243] = 30;
        nArray[244] = 216;
        nArray[245] = 33;
        nArray[246] = 77;
        nArray[247] = 1;
        nArray[248] = 62;
        nArray[249] = 255;
        nArray[250] = 198;
        nArray[251] = 1;
        nArray[252] = 62;
        nArray[253] = 1;
        nArray[254] = 224;
        nArray[255] = 80;
        emuliciousBootROM = new GBCartridge(nArray);
        return emuliciousBootROM;
    }

    public void setBootROM(GBCartridge gBCartridge) {
        this.bootROM = gBCartridge;
        if (this.analoguePocket) {
            int[] nArray = gBCartridge.getRom();
            int[] nArray2 = new int[48];
            nArray2[0] = 1;
            nArray2[1] = 16;
            nArray2[2] = 206;
            nArray2[3] = 239;
            nArray2[6] = 68;
            nArray2[7] = 170;
            nArray2[9] = 116;
            nArray2[11] = 24;
            nArray2[12] = 17;
            nArray2[13] = 149;
            nArray2[15] = 52;
            nArray2[17] = 26;
            nArray2[19] = 213;
            nArray2[21] = 34;
            nArray2[23] = 105;
            nArray2[24] = 111;
            nArray2[25] = 246;
            nArray2[26] = 247;
            nArray2[27] = 115;
            nArray2[28] = 9;
            nArray2[29] = 144;
            nArray2[30] = 225;
            nArray2[31] = 16;
            nArray2[32] = 68;
            nArray2[33] = 64;
            nArray2[34] = 154;
            nArray2[35] = 144;
            nArray2[36] = 213;
            nArray2[37] = 208;
            nArray2[38] = 68;
            nArray2[39] = 48;
            nArray2[40] = 169;
            nArray2[41] = 33;
            nArray2[42] = 93;
            nArray2[43] = 72;
            nArray2[44] = 34;
            nArray2[45] = 224;
            nArray2[46] = 248;
            nArray2[47] = 96;
            int[] nArray3 = nArray2;
            int n = 0;
            while (n + 3 < nArray.length) {
                if (nArray[n] == 206 && nArray[n + 1] == 237 && nArray[n + 2] == 102 && nArray[n + 3] == 102) {
                    System.arraycopy(nArray3, 0, nArray, n, nArray3.length);
                    break;
                }
                ++n;
            }
        }
    }

    public void setButtonDownOverride(int n, boolean bl) {
        this.joypad.setButtonDownOverride(n, bl);
        if (bl) {
            this.buttonListener.buttonPressed();
        }
    }

    public boolean isButtonDown(int n) {
        return this.joypad.isButtonDown(n);
    }

    @Override
    public void reset() {
        this.bootROMenabled = this.bootROM != null;
        this.prevKeyStates = 0;
        this.cpu.reset();
        Arrays.fill(this.memory, 76, 127, 255);
        this.memory[80] = 254;
        this.lcd.reset();
        this.sound.reset();
        this.cartridge.reset();
        System.arraycopy(this.sound.getState().getWavePatternRAM(), 0, this.memory, 48, this.sound.getState().getWavePatternRAM().length);
        this.memory[0] = 207;
        this.memory[1] = 0;
        this.memory[2] = 126;
        this.memory[5] = 0;
        this.memory[6] = 0;
        this.memory[7] = 248;
        this.memory[15] = 225;
        this.memory[65] = 132;
        this.memory[70] = 255;
        this.memory[255] = 0;
        this.latchedP1 = this.memory[0];
        this.counter = this.isEmuliciousBootROM() ? 6724 : 8;
        this.counterAdjustment = 0;
        this.stopped = false;
        this.dmaCounter = 0;
        this.ramSources.clear();
        Arrays.fill(this.wramInitialized, false);
        Arrays.fill(this.hramInitialized, false);
    }

    @Override
    public int execute(int n) {
        while ((n = this.executeOnce(n)) > 0 && !this.isStopped()) {
        }
        return n;
    }

    @Override
    public int executeOnce(int n) {
        if (this.isStopped()) {
            return Math.min(0, n - 4);
        }
        int n2 = this.cpu.execute(Math.min(Math.max(4, n), this.calcNextTimeout(this.lcd.getTimer())));
        n -= n2;
        this.updateTimers(n2);
        this.updateDMA(n2);
        this.lcd.update(n2);
        this.cartridge.update(n2);
        if (!this.lcd.isLCDDisplayEnabled() && this.lcd.getCyclesSinceLastFrame() >= this.getCyclesPerFrame()) {
            this.frameFinished();
        }
        return n;
    }

    protected int calcNextTimeout(int n) {
        int n2;
        if (this.serialTransferStarted || this.dmaCounter > 0) {
            return 4;
        }
        int n3 = n;
        if ((this.memory[7] & 4) != 0 && (n2 = this.calcNextTIMAinterrupt()) < n3) {
            n3 = n2;
        }
        return n3;
    }

    protected void updateDMA(int n) {
        if (this.dmaJustStarted) {
            this.dmaJustStarted = false;
            return;
        }
        if (this.dmaCounter <= 0 || this.cpu.isHalted()) {
            return;
        }
        this.dmaStillRunning = false;
        this.timerDMA -= n;
        int n2 = Math.max(0, this.timerDMA / 4);
        int n3 = this.dmaCounter;
        int n4 = n - (n3 - n2) * 4;
        while (n3 > n2) {
            this.doDmaWrite(65184 - n3--, n4);
            n4 += 4;
        }
        if (n3 > 0) {
            this.doReadByte(this.dmaSource, n4, true);
        }
        this.dmaCounter = n3;
    }

    protected void doDmaWrite(int n, int n2) {
        this.lcd.processWrite(n, this.doReadByte(this.dmaSource++, n2, true), n2, true);
    }

    /*
     * Unable to fully structure code
     */
    private void serialTransferBit() {
        block1: {
            if (this.serialCounter <= 0) ** GOTO lbl5
            --this.serialCounter;
            break block1;
lbl-1000:
            // 1 sources

            {
                Thread.yield();
lbl5:
                // 2 sources

                ** while (!this.serialTransferFinished)
            }
lbl6:
            // 1 sources

            this.memory[1] = this.serialData;
            this.memory[2] = this.memory[2] & 127;
            this.requestInterrupt(8);
            this.serialTransferStarted = false;
        }
    }

    protected void updateTimers(int n) {
        this.addToCounter(n);
    }

    private void addToCounter(int n) {
        int n2;
        int n3;
        int n4 = n - this.counterAdjustment;
        this.counterAdjustment = 0;
        if (n4 <= 0) {
            return;
        }
        int n5 = this.counter + n4;
        int n6 = this.getTIMAbit();
        int n7 = this.getSoundBit();
        int n8 = this.getSerialBit();
        int n9 = this.counter;
        while (n5 - n9 >= 4) {
            n3 = n9;
            n9 += 4;
            if (this.timaState == TIMAState.OVERFLOWED) {
                this.memory[5] = this.memory[6];
                this.requestInterrupt(4, n5 - this.counter);
                this.timaState = n5 - n9 < 4 ? TIMAState.RELOADED : TIMAState.REGULAR;
            } else {
                this.timaState = TIMAState.REGULAR;
            }
            if (n6 == 0) break;
            if ((n9 & n6) >= (n3 & n6)) continue;
            this.incTIMA();
        }
        if (this.serialTransferStarted && (n5 & n8) < (this.counter & n8)) {
            this.serialTransferBit();
        }
        if ((n2 = n5 & n7) != (n3 = this.counter & n7)) {
            if (n2 < n3) {
                this.sound.clock(false);
            } else {
                this.sound.risingClock();
            }
        }
        this.memory[4] = n5 >> 8 & 0xFF;
        this.counter = n5 & 0x3FFFF;
    }

    protected void requestInterrupt(int n) {
        this.requestInterrupt(n, 0);
    }

    protected void requestInterrupt(int n, int n2) {
        GameBoyEventTypes gameBoyEventTypes;
        this.cpu.setInterruptLine(n, true);
        switch (n) {
            case 1: {
                gameBoyEventTypes = GameBoyEventTypes.VBLANK_IRQ;
                break;
            }
            case 2: {
                gameBoyEventTypes = GameBoyEventTypes.STAT_IRQ;
                break;
            }
            case 4: {
                gameBoyEventTypes = GameBoyEventTypes.TIMER_IRQ;
                break;
            }
            case 8: {
                gameBoyEventTypes = GameBoyEventTypes.SERIAL_IRQ;
                break;
            }
            case 16: {
                gameBoyEventTypes = GameBoyEventTypes.JOYPAD_IRQ;
                break;
            }
            default: {
                gameBoyEventTypes = null;
            }
        }
        if (gameBoyEventTypes != null) {
            this.addEvent(gameBoyEventTypes, -1, -1, n2);
        }
    }

    private void clearCounter() {
        int n = this.getTIMAbit();
        int n2 = this.getSoundBit();
        int n3 = this.counter;
        this.sound.resync(this.calcNextSoundClock());
        this.counter = 0;
        if ((this.counter & n) < (n3 & n)) {
            this.incTIMA();
        }
        if (this.serialTransferStarted && (this.counter & 0x400) < (n3 & 0x400)) {
            this.serialTransferBit();
        }
        if ((this.counter & n2) < (n3 & n2)) {
            this.sound.clock(true);
        }
        this.memory[4] = this.counter >> 8 & 0xFF;
    }

    protected int getSerialBit() {
        return 1024;
    }

    protected int getSoundBit() {
        return 4096;
    }

    public int calcNextSoundClock() {
        int n = this.getSoundBit();
        int n2 = n << 1;
        return n2 - (this.counter & n2 - 1);
    }

    protected void setTAC(int n) {
        int n2 = this.getTIMAbit();
        this.memory[7] = 0xF8 | n & 7;
        int n3 = this.getTIMAbit();
        if ((this.counter & n2) != 0 && (this.counter & n3) == 0) {
            this.incTIMA();
        }
    }

    private void incTIMA() {
        this.memory[5] = this.memory[5] + 1;
        if (this.memory[5] >= 256) {
            this.memory[5] = 0;
            this.timaState = TIMAState.OVERFLOWED;
            this.cpu.sync();
        }
    }

    private int calcNextTIMAinterrupt() {
        if (this.timaState == TIMAState.OVERFLOWED) {
            return 4;
        }
        int n = this.getTIMAbit() << 1;
        return n * (256 - this.memory[5]) - this.counter % n;
    }

    private int getTIMAbit() {
        int n = this.memory[7];
        return -((n & 4) >> 2) & TIMA_BITS[n & 3];
    }

    public int calcDotsUntilVBlank() {
        return this.lcd.calcDotsUntilVBlank();
    }

    @Override
    public void plugInInputDevice(int n, InputDevice inputDevice) {
        if (!(inputDevice instanceof GBJoypad)) {
            throw new IllegalArgumentException(inputDevice + " is not compatible with " + this.getClass().getSimpleName());
        }
        this.joypad = (GBJoypad)((Object)inputDevice);
    }

    @Override
    public void uninitializeMemory(int n) {
        int[] nArray = this.lcd.getVRAM();
        int[] nArray2 = this.lcd.getOAM();
        if (n < 0 || n >= 256) {
            Random random = new Random();
            int n2 = 0;
            while (n2 < this.memory.length) {
                this.memory[n2] = random.nextInt(256);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.wram.length) {
                this.wram[n2] = random.nextInt(256);
                ++n2;
            }
            n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = random.nextInt(256);
                ++n2;
            }
            n2 = 0;
            while (n2 < nArray2.length) {
                nArray2[n2] = random.nextInt(256);
                ++n2;
            }
        } else {
            Arrays.fill(this.memory, n);
            Arrays.fill(this.wram, n);
            Arrays.fill(nArray, n);
            Arrays.fill(nArray2, n);
        }
    }

    @Override
    public int[] getRAM() {
        return this.wram;
    }

    @Override
    public int[] getSRAM() {
        return this.cartridge.getSRAM();
    }

    @Override
    public int getCyclesPerSecond() {
        return 0x400000;
    }

    @Override
    public int getCyclesPerFrame() {
        return 70224;
    }

    @Override
    public int[] getVRAM() {
        return this.lcd.getVRAM();
    }

    public int[] getOAM() {
        return this.lcd.getOAM();
    }

    public int[] getMemory() {
        return this.memory;
    }

    @Override
    public int getNumberOfPaletteBytes() {
        return 3;
    }

    @Override
    public int getNumberOfPaletteEntries() {
        return 12;
    }

    @Override
    public int getPaletteByte(int n) {
        return (int)(n > 0 ? this.lcd.getOBP(n - 1) : (long)this.lcd.getRegBGP());
    }

    @Override
    public void setPaletteByte(int n, int n2) {
        if (n > 0) {
            this.lcd.setOBP(n - 1, n2);
        } else {
            this.lcd.setBGP(0, n2);
        }
    }

    @Override
    public String getPaletteName(int n) {
        return n > 0 ? "OBP" + (n - 1) : "BGP";
    }

    @Override
    public String[] getFlagNames() {
        return this.cpu.getFlagNames();
    }

    @Override
    public String[] getRegisterNames() {
        return this.cpu.getRegisterNames();
    }

    @Override
    public int indexOfPC() {
        return this.cpu.indexOfPC();
    }

    @Override
    public int getRegisterValue(int n) {
        return this.cpu.getRegisterValue(n);
    }

    @Override
    public int getVRAMaddress() {
        return -1;
    }

    @Override
    public boolean isAdditionalRegister(int n) {
        return this.cpu.isAdditionalRegister(n);
    }

    @Override
    public String getAdditionalRegisterName(int n) {
        if (n < PPU_REGISTER_NAMES.length) {
            return PPU_REGISTER_NAMES[n] != null ? PPU_REGISTER_NAMES[n] : "";
        }
        n -= PPU_REGISTER_NAMES.length;
        if (n-- == 0) {
            return "RDiM";
        }
        if (n < SYSTEM_VARIABLE_NAMES.length) {
            return SYSTEM_VARIABLE_NAMES[n];
        }
        if ((n -= SYSTEM_VARIABLE_NAMES.length) < APU_REGISTER_NAMES.length) {
            return APU_REGISTER_NAMES[n] != null ? APU_REGISTER_NAMES[n] : "";
        }
        if ((n -= APU_REGISTER_NAMES.length) < ADDITIONAL_VARIABLE_NAMES.length) {
            return ADDITIONAL_VARIABLE_NAMES[n];
        }
        return null;
    }

    @Override
    public int getAdditionalRegisterValue(int n) {
        if (n < PPU_REGISTER_NAMES.length) {
            return PPU_REGISTER_NAMES[n] != null ? this.memory[64 + n] : -1;
        }
        n -= PPU_REGISTER_NAMES.length;
        if (n-- == 0) {
            return this.calcDotsInModeLeft();
        }
        if (n < SYSTEM_VARIABLE_NAMES.length) {
            int[] nArray = new int[11];
            nArray[0] = 255;
            nArray[1] = 15;
            nArray[2] = 112;
            nArray[3] = 4;
            nArray[4] = 5;
            nArray[5] = 6;
            nArray[6] = 7;
            nArray[8] = 1;
            nArray[9] = 2;
            nArray[10] = 79;
            int[] nArray2 = nArray;
            return n < nArray2.length ? this.memory[nArray2[n]] : -1;
        }
        if ((n -= SYSTEM_VARIABLE_NAMES.length) < APU_REGISTER_NAMES.length) {
            return APU_REGISTER_NAMES[n] != null ? this.memory[16 + n] : -1;
        }
        if ((n -= APU_REGISTER_NAMES.length) < ADDITIONAL_VARIABLE_NAMES.length) {
            switch (n) {
                case 0: {
                    return this.cartridge.getBank0();
                }
                case 1: {
                    return this.cartridge.getBank1();
                }
                case 2: {
                    return this.cartridge.getSRAMbank();
                }
            }
            return -1;
        }
        return -1;
    }

    @Override
    public int getAdditionalRegisterSize(int n) {
        if (n == PPU_REGISTER_NAMES.length) {
            return 0;
        }
        String string = this.getAdditionalRegisterName(n);
        return string != null && !string.isEmpty() ? 1 : -1;
    }

    public int calcDotsInModeLeft() {
        return this.lcd.calcDotsInModeLeft();
    }

    @Override
    public boolean hasSRAM() {
        return this.cartridge.hasSRAM();
    }

    public boolean hasRTC() {
        return this.cartridge.hasTimer();
    }

    public boolean isBootromAddress(int n) {
        return n < 256;
    }

    @Override
    public boolean isROMaddress(int n) {
        return this.isROMaddress(n, false);
    }

    @Override
    public boolean isROMaddress(int n, boolean bl) {
        return (this.isCartridgeEnabled() || bl) && n < 32768;
    }

    @Override
    public boolean isRAMaddress(int n) {
        return this.isWRAMaddress(n) || GameBoy.isHRAMaddress(n);
    }

    @Override
    public boolean isRAMaddress(int n, boolean bl) {
        return this.isRAMaddress(n);
    }

    public boolean isWRAMaddress(int n) {
        return n >= 49152 && n < 65024;
    }

    @Override
    public boolean isSRAMaddress(int n) {
        return this.cartridge.isSRAMaddress(n);
    }

    @Override
    public boolean isVRAMaddress(int n) {
        return n >= 32768 && n < 40960;
    }

    public static boolean isOAMaddress(int n) {
        return n >= 65024 && n < 65184;
    }

    public static boolean isHRAMaddress(int n) {
        return n >= 65408 && n < 65535;
    }

    public static boolean isIOaddress(int n) {
        return n == 65535 || n >= 65280 && n < 65408;
    }

    @Override
    public int mapAddress(int n) {
        if (GameBoy.isHRAMaddress(n)) {
            return n & 0x7F;
        }
        if (this.isWRAMaddress(n)) {
            return n & 0x1FFF;
        }
        if (this.isVRAMaddress(n)) {
            return n & this.getVRAM().length - 1;
        }
        if (GameBoy.isOAMaddress(n) || GameBoy.isIOaddress(n)) {
            return n & 0xFF;
        }
        return this.cartridge.mapAddress(n);
    }

    @Override
    public int mapAddress(int n, int n2) {
        if (GameBoy.isHRAMaddress(n)) {
            return n & 0x7F;
        }
        if (this.isWRAMaddress(n)) {
            return n & 0x1FFF;
        }
        if (this.isVRAMaddress(n)) {
            return n & this.getVRAM().length - 1;
        }
        if (GameBoy.isOAMaddress(n) || GameBoy.isIOaddress(n)) {
            return n & 0xFF;
        }
        return this.cartridge.mapAddress(n, n2);
    }

    @Override
    public int mapAddress(int n, int n2, boolean bl) {
        return this.mapAddress(n, n2);
    }

    @Override
    public int mapVirtualAddress(int n) {
        return this.mapAddress(n & 0xFFFF, n >> 16);
    }

    protected void fireMessageSent(String string) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n = this.systemEventListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemEventListener systemEventListener = systemEventListenerArray[n2];
            systemEventListener.messageSent(string);
            ++n2;
        }
    }

    protected void fireInputStateChanged(int n) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n2 = this.systemEventListeners.length;
        int n3 = 0;
        while (n3 < n2) {
            SystemEventListener systemEventListener = systemEventListenerArray[n3];
            systemEventListener.inputStateChanged(n);
            ++n3;
        }
    }

    protected void fireErrorOccurred(int n, int n2) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n3 = this.systemEventListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemEventListener systemEventListener = systemEventListenerArray[n4];
            systemEventListener.errorOccurred(n, n2);
            ++n4;
        }
    }

    protected void fireVRAMread(int n, int n2) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n3 = this.systemEventListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemEventListener systemEventListener = systemEventListenerArray[n4];
            systemEventListener.vramRead(n, n2);
            ++n4;
        }
    }

    protected void fireVRAMwrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.vramWrite(n, n2, n3);
            ++n5;
        }
    }

    protected void fireOamRead(int n, int n2) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n3 = this.systemEventListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemEventListener systemEventListener = systemEventListenerArray[n4];
            systemEventListener.memoryLocationRead("oam", n, n2);
            ++n4;
        }
    }

    protected void fireOamWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("oam", n, n2, n3);
            ++n5;
        }
    }

    protected void fireHramRead(int n, int n2) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n3 = this.systemEventListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemEventListener systemEventListener = systemEventListenerArray[n4];
            systemEventListener.memoryLocationRead("hram", n, n2);
            ++n4;
        }
    }

    protected void fireHramWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("hram", n, n2, n3);
            ++n5;
        }
    }

    protected void fireIOread(int n, int n2) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n3 = this.systemEventListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemEventListener systemEventListener = systemEventListenerArray[n4];
            systemEventListener.memoryLocationRead("i/o", n, n2);
            ++n4;
        }
    }

    protected void fireIOwrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("i/o", n, n2, n3);
            ++n5;
        }
    }

    protected void firePalettesWrite(int n, int n2, int n3) {
        SystemEventListener[] systemEventListenerArray = this.systemEventListeners;
        int n4 = this.systemEventListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            SystemEventListener systemEventListener = systemEventListenerArray[n5];
            systemEventListener.memoryLocationWrite("palettes", n, n2, n3);
            ++n5;
        }
    }

    @Override
    public void addSystemEventListener(SystemEventListener systemEventListener) {
        if (!this.systemEventListenerList.contains(systemEventListener)) {
            this.systemEventListenerList.addFirst(systemEventListener);
            this.systemEventListeners = this.systemEventListenerList.toArray(new SystemEventListener[this.systemEventListenerList.size()]);
            if (!this.isCartridgeHeaderValid()) {
                this.fireErrorOccurred(10, 0);
            }
        }
    }

    @Override
    public void removeSystemEventListener(SystemEventListener systemEventListener) {
        if (this.systemEventListenerList.remove(systemEventListener)) {
            this.systemEventListeners = this.systemEventListenerList.toArray(new SystemEventListener[this.systemEventListenerList.size()]);
        }
    }

    @Override
    public void setAddress(int n, int n2) {
        if (n2 == 1) {
            this.cartridge.setBank1(n / 16384);
            this.setRegValue(7, 0x4000 | n & 0x3FFF);
        } else {
            this.setRegValue(7, n);
        }
    }

    @Override
    public int getPrevPC() {
        return this.cpu.getPrevPC();
    }

    @Override
    public int getPC() {
        if (this.stopped) {
            return this.cpu.getPC() - 2;
        }
        return this.cpu.getPC();
    }

    @Override
    public int getSP() {
        return this.cpu.getSP();
    }

    @Override
    public int getStackPointer() {
        int n = this.getSP();
        if (!this.isROMaddress(n - 1) || this.isROMaddress(this.cpu.getPrevSP() - 1)) {
            return n;
        }
        return this.cpu.getPrevSP();
    }

    @Override
    public int getVirtualAddress() {
        return this.toVirtualAddress(this.getPC());
    }

    @Override
    public int toVirtualAddress(int n) {
        switch (n >> 14) {
            case 0: {
                return this.getBank0() << 16 | n;
            }
            case 1: {
                return this.getBank1() << 16 | n;
            }
        }
        return n;
    }

    @Override
    public int getROMsize() {
        return this.cartridge.getRom().length;
    }

    @Override
    public int getByte(int n) {
        return this.getByte(n & 0xFFFF, n >> 16);
    }

    @Override
    public int getByte(int n, int n2) {
        if (n2 < 0) {
            n2 = this.getBank(n);
        }
        if (this.isROMaddress(n, true)) {
            return this.cartridge.getRom()[this.mapAddress(n, n2)];
        }
        if (GameBoy.isHRAMaddress(n)) {
            return this.memory[n - 65280];
        }
        if (this.isWRAMaddress(n)) {
            return this.wram[this.mapAddress(n, n2)];
        }
        if (this.isVRAMaddress(n)) {
            return this.lcd.getVRAM()[this.mapAddress(n, n2)];
        }
        if (GameBoy.isOAMaddress(n)) {
            return this.lcd.getOAM()[this.mapAddress(n, n2)];
        }
        if (this.isSRAMaddress(n)) {
            return this.cartridge.getSRAM()[this.mapAddress(n, n2)];
        }
        if (this.cartridge.isTimerAddress(n)) {
            return this.cartridge.getTimerByte(n, n2);
        }
        if (n == 65280) {
            return this.joypad.getKeyStates(this.memory[0], this.latchedP1);
        }
        if (n >= 65328 && n < 65344) {
            return this.sound.getState().getWavePatternRAM()[n & 0xF];
        }
        return this.memory[n & 0xFF];
    }

    @Override
    public int peekByte(int n) {
        switch (n >> 13) {
            case 0: {
                if (this.bootROMenabled && this.isBootromAddress(n)) {
                    return this.bootROM.readByte(n, 0);
                }
            }
            case 1: {
                if (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning) {
                    if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                        return this.memoryBusCartridge;
                    }
                    if (this.dmaSource < 32768 || this.dmaSource >= 40960 && (!(this instanceof GameBoyColor) || this.dmaSource < 49152)) {
                        return this.memoryBusCartridge;
                    }
                }
                return this.cartridge.readByte(n, 0);
            }
            case 2: 
            case 3: {
                if (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning) {
                    if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                        return this.memoryBusCartridge;
                    }
                    if (this.dmaSource < 32768 || this.dmaSource >= 40960 && (!(this instanceof GameBoyColor) || this.dmaSource < 49152)) {
                        return this.memoryBusCartridge;
                    }
                }
                return this.cartridge.readByte(n, 0);
            }
            case 4: {
                if (this.dmaSource >= 32768 && this.dmaSource < 40960 && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) {
                    return this.memoryBusVRAM;
                }
                return this.lcd.peekByte(n);
            }
            case 5: {
                int n2;
                if (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning) {
                    if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                        return this.memoryBusCartridge;
                    }
                    if (this.dmaSource < 32768 || this.dmaSource >= 40960) {
                        return this.memoryBusCartridge;
                    }
                }
                if ((n2 = this.cartridge.readByte(n, 0)) < 0) {
                    return this.memoryBusCartridge;
                }
                return n2;
            }
            case 6: {
                if (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning) {
                    if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                        return this.memoryBusCartridge;
                    }
                    if (this.dmaSource < 32768 && !(this instanceof GameBoyColor) || this.dmaSource >= 40960) {
                        return this.memoryBusCartridge;
                    }
                }
                return this.doReadWRAM(n);
            }
            case 7: {
                if (n < 65024) {
                    if (!(this instanceof GameBoyColor) && (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning)) {
                        if (this.dmaSource >= 57344 && this.dmaSource < 65024) {
                            return this.memoryBusCartridge;
                        }
                        if (this.dmaSource < 32768 || this.dmaSource >= 40960) {
                            return this.memoryBusCartridge;
                        }
                    }
                    return this.doReadWRAM(n);
                }
                if (n < 65184) {
                    if (this.dmaCounter > 0 && this.timerDMA / 4 <= 160 || this.dmaStillRunning) {
                        return 255;
                    }
                    return this.lcd.peekByte(n);
                }
                if (n >= 65280) break;
                return this.lcd.peekByte(n);
            }
        }
        if (n == 65280) {
            return this.joypad.getKeyStates(this.memory[0], this.latchedP1);
        }
        if (n >= 65328 && n < 65344) {
            return this.sound.readWavePattern(n);
        }
        return this.memory[n & 0xFF];
    }

    @Override
    public void syncLazyState() {
        this.updateApu();
    }

    public String getCartridgeTitle() {
        return this.cartridge.getTitle();
    }

    public String getCartridgeType() {
        return this.cartridge != NULL_CARTRIDGE ? this.cartridge.getTypeString() : "None";
    }

    private void updateApu() {
        this.sound.update(this.calcNextSoundClock());
    }

    @Override
    public void pokeByte(int n, int n2) {
        if (this.isROMaddress(n) || this.isSRAMaddress(n) || this.cartridge.isTimerAddress(n)) {
            this.cartridge.processWrite(n, n2, 0);
        } else if (GameBoy.isHRAMaddress(n)) {
            this.memory[n - 65280] = n2;
            this.hramInitialized[n - 65408] = true;
        } else if (this.isWRAMaddress(n)) {
            int n3 = this.mapAddress(n);
            this.wram[n3] = n2;
            this.wramInitialized[n3] = true;
        } else if (this.isVRAMaddress(n) || GameBoy.isOAMaddress(n)) {
            this.lcd.pokeByte(n, n2);
        } else if (n >= 65280) {
            if ((n &= 0xFF) >= 64 && n <= 79) {
                this.memory[n] = n2;
                if (this.isAnaloguePocket()) {
                    if (n == 64) {
                        return;
                    }
                    if (n == 65 || n == 78) {
                        n2 = this.reverseBits(n2);
                    }
                    if (n == 78) {
                        n = 64;
                    }
                }
                this.lcd.processInput(n, n2, 0);
            } else if (n >= 16 && n <= 38) {
                this.sound.processInput(n, n2, -1);
            } else if (n >= 48 && n < 64) {
                this.sound.getState().getWavePatternRAM()[n & 0xF] = n2;
                this.memory[n] = n2;
            } else {
                this.memory[n] = n2;
            }
        }
    }

    @Override
    public void setByte(int n, int n2, int n3) {
        if (this.isROMaddress(n, true)) {
            this.cartridge.getRom()[this.mapAddress((int)n, (int)n2)] = n3;
        } else if (GameBoy.isHRAMaddress(n)) {
            this.pokeByte(n, n3);
        } else if (this.isWRAMaddress(n)) {
            int n4 = this.mapAddress(n, n2);
            this.wram[n4] = n3;
            this.wramInitialized[n4] = true;
        } else if (this.isVRAMaddress(n)) {
            this.lcd.getVRAM()[this.mapAddress((int)n, (int)n2)] = n3;
        } else if (GameBoy.isOAMaddress(n)) {
            this.lcd.getOAM()[this.mapAddress((int)n, (int)n2)] = n3;
        } else if (this.isSRAMaddress(n)) {
            this.cartridge.getSRAM()[this.mapAddress((int)n, (int)n2)] = n3;
        } else if (this.cartridge.isTimerAddress(n)) {
            this.cartridge.setTimerByte(n, n2, n3);
        } else if (n >= 65280) {
            this.pokeByte(n, n3);
        }
    }

    @Override
    public String getMemoryName(int n) {
        if (n == 65535) {
            return String.valueOf(SYSTEM_VARIABLE_NAMES[0]) + this.interruptBitsToString(0);
        }
        if (n == 65328) {
            return "Wave Pattern RAM";
        }
        if (n >= 65280 && n < 65408) {
            switch (n) {
                case 65295: {
                    return String.valueOf(SYSTEM_VARIABLE_NAMES[1]) + this.interruptBitsToString(1);
                }
                case 65392: {
                    return SYSTEM_VARIABLE_NAMES[2];
                }
                case 65284: {
                    return SYSTEM_VARIABLE_NAMES[3];
                }
                case 65285: {
                    return SYSTEM_VARIABLE_NAMES[4];
                }
                case 65286: {
                    return SYSTEM_VARIABLE_NAMES[5];
                }
                case 65287: {
                    return SYSTEM_VARIABLE_NAMES[6];
                }
                case 65280: {
                    return SYSTEM_VARIABLE_NAMES[7];
                }
                case 65281: {
                    return SYSTEM_VARIABLE_NAMES[8];
                }
                case 65282: {
                    return SYSTEM_VARIABLE_NAMES[9];
                }
                case 65359: {
                    return SYSTEM_VARIABLE_NAMES[10];
                }
            }
            if (n >= 65296 && n <= 65318) {
                return APU_REGISTER_NAMES[n - 65296];
            }
            if (n >= 65344 && n <= 65355) {
                return PPU_REGISTER_NAMES[n - 65344] != null ? String.valueOf(PPU_REGISTER_NAMES[n - 65344]) + this.ppuBitsToString(n - 65344) : null;
            }
        }
        if ((n & 0xF) == 0) {
            switch (n >> 13) {
                case 0: 
                case 1: {
                    return "ROM Slot 0";
                }
                case 2: 
                case 3: {
                    return "ROM Slot 1";
                }
                case 4: {
                    return "VRAM";
                }
                case 5: {
                    return "SRAM";
                }
                case 6: {
                    return "WRAM";
                }
                case 7: {
                    if (n < 65024) {
                        return "WRAM";
                    }
                    if (n >= 65184) break;
                    return "OAM";
                }
            }
            if (n < 65280) {
                return "Unusable";
            }
            if (n < 65408) {
                return null;
            }
            return "HRAM";
        }
        return null;
    }

    private String ppuBitsToString(int n) {
        String[][] stringArrayArray = new String[2][];
        stringArrayArray[0] = new String[]{"BG/Window Display/Priority", "OBJ (Sprite) Display Enable", "OBJ (Sprite) Size", "BG Tile Map Display Select", "BG & Window Tile Data Select", "Window Display Enable", "Window Tile Map Display Select", "LCD Display Enable"};
        String[] stringArray = new String[7];
        stringArray[1] = "Mode Flag";
        stringArray[2] = "Coincidence Flag";
        stringArray[3] = "Mode 0 H-Blank Interrupt";
        stringArray[4] = "Mode 1 V-Blank Interrupt";
        stringArray[5] = "Mode 2 OAM Interrupt";
        stringArray[6] = "LYC=LY Coincidence Interrupt";
        stringArrayArray[1] = stringArray;
        String[][] stringArrayArray2 = stringArrayArray;
        String[][] stringArrayArray3 = new String[][]{{"Off", "On"}, {"Off", "On"}, {"8x8", "8x16"}, {"9800-9BFF", "9C00-9FFF"}, {"8800-97FF", "8000-8FFF"}, {"Off", "On"}, {"9800-9BFF", "9C00-9FFF"}, {"Off", "On"}};
        String[] stringArray2 = new String[]{"H-Blank", "V-Blank", "OAM", "Render"};
        if (n < stringArrayArray2.length) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = n == 0 ? 0 : 1;
            int n3 = stringArrayArray2[n].length - 1;
            while (n3 >= n2) {
                int n4 = this.peekByte(0xFF40 | n) >> n3 & 1;
                stringBuilder.append('\n');
                if (n == 1) {
                    if (n3 == 1) {
                        stringBuilder.append("1-0 ").append('(').append(this.peekByte(0xFF40 | n) & 3).append(')').append(" - ");
                    } else {
                        stringBuilder.append(n3).append("    ").append('(').append(n4).append(')').append(" - ");
                    }
                } else {
                    stringBuilder.append(n3).append(' ').append('(').append(n4).append(')').append(" - ");
                }
                stringBuilder.append(stringArrayArray2[n][n3]);
                if (n == 0) {
                    stringBuilder.append(" (" + stringArrayArray3[n3][n4] + ")");
                } else if (n3 > 2) {
                    stringBuilder.append(" (").append(GameBoy.toEnabledString(n4 != 0)).append(')');
                } else if (n3 == 2) {
                    stringBuilder.append(" (").append(n4 != 0 ? "LYC=LY" : "LYC<>LY").append(')');
                } else {
                    int n5 = this.peekByte(0xFF40 | n) & 3;
                    stringBuilder.append(" (").append(stringArray2[n5]).append(')');
                }
                --n3;
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private static String toEnabledString(boolean bl) {
        return bl ? "Enabled" : "Disabled";
    }

    private String interruptBitsToString(int n) {
        String[] stringArray = new String[]{"V-Blank Interrupt", "LCD STAT Interrupt", "Timer Interrupt", "Serial Interrupt", "Joypad Interrupt"};
        String string = n == 0 ? " (Enabled)" : " (Requested)";
        int n2 = n == 0 ? 65535 : 65295;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = this.peekByte(n2) >> n3 & 1;
            stringBuilder.append('\n');
            stringBuilder.append(n3).append(' ').append('(').append(n4).append(')').append(" - ");
            stringBuilder.append(stringArray[n3]);
            if (n4 != 0) {
                stringBuilder.append(string);
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    @Override
    public void setMemoryAt(int n, int[] nArray) {
        System.arraycopy(nArray, 0, this.wram, n & this.wram.length - 1, Math.min(this.wram.length - (n & this.wram.length - 1), nArray.length));
    }

    @Override
    public void setRegValue(int n, int n2) {
        this.cpu.setRegValue(n, n2);
    }

    @Override
    public void setAdditionalRegValue(int n, int n2) {
        n2 &= 0xFF;
        if (n < PPU_REGISTER_NAMES.length) {
            if (PPU_REGISTER_NAMES[n] != null) {
                this.memory[64 + n] = n2;
                if (this.isAnaloguePocket() && n <= 1) {
                    n2 = this.reverseBits(n2);
                }
                this.lcd.processInput(64 + n, n2, 0);
            }
        } else {
            n -= PPU_REGISTER_NAMES.length;
            if (n-- == 0) {
                return;
            }
            if (n < SYSTEM_VARIABLE_NAMES.length) {
                int[] nArray = new int[11];
                nArray[0] = 255;
                nArray[1] = 15;
                nArray[2] = 112;
                nArray[3] = 4;
                nArray[4] = 5;
                nArray[5] = 6;
                nArray[6] = 7;
                nArray[8] = 1;
                nArray[9] = 2;
                nArray[10] = 79;
                int[] nArray2 = nArray;
                if (n < nArray2.length) {
                    this.memory[nArray2[n]] = n2;
                }
            } else if ((n -= SYSTEM_VARIABLE_NAMES.length) < APU_REGISTER_NAMES.length) {
                if (APU_REGISTER_NAMES[n] != null) {
                    this.pokeByte(65296 + n, n2);
                }
            } else if ((n -= APU_REGISTER_NAMES.length) < ADDITIONAL_VARIABLE_NAMES.length) {
                switch (n) {
                    case 0: {
                        this.cartridge.setBank0(n2);
                        break;
                    }
                    case 1: {
                        this.cartridge.setBank1(n2);
                        break;
                    }
                    case 2: {
                        this.cartridge.setSRAMbank(n2);
                    }
                }
            }
        }
    }

    @Override
    public String getAdditionalRegisterDescription(int n) {
        if (n < PPU_REGISTER_NAMES.length) {
            if (PPU_REGISTER_NAMES[n] != null && n <= 1) {
                return this.getMemoryName(65344 + n);
            }
        } else {
            n -= PPU_REGISTER_NAMES.length;
            if (n-- == 0) {
                return "Remaining dots in current mode";
            }
            if (n < SYSTEM_VARIABLE_NAMES.length) {
                int[] nArray = new int[11];
                nArray[0] = 255;
                nArray[1] = 15;
                nArray[2] = 112;
                nArray[3] = 4;
                nArray[4] = 5;
                nArray[5] = 6;
                nArray[6] = 7;
                nArray[8] = 1;
                nArray[9] = 2;
                nArray[10] = 79;
                int[] nArray2 = nArray;
                if (n < nArray2.length && n <= 1) {
                    return this.getMemoryName(0xFF00 | nArray2[n]);
                }
            } else if ((n -= SYSTEM_VARIABLE_NAMES.length) >= APU_REGISTER_NAMES.length) {
                n -= APU_REGISTER_NAMES.length;
                int cfr_ignored_0 = ADDITIONAL_VARIABLE_NAMES.length;
            }
        }
        return null;
    }

    @Override
    public boolean isFlagSet(int n) {
        return this.cpu.isFlagSet(n);
    }

    @Override
    public void setFlagSet(int n, boolean bl) {
        int n2 = this.cpu.getRegisterValue(3);
        n2 = !bl ? (n2 &= ~(1 << n)) : (n2 |= 1 << (n += 4));
        this.setRegValue(3, n2);
    }

    @Override
    public int getNumberOfPorts() {
        return 128;
    }

    @Override
    public int getPortExtension() {
        return 65280;
    }

    @Override
    public int getRAMlength() {
        return this.wram.length;
    }

    @Override
    public IntList getAllRAMaddresses() {
        int n;
        final int n2 = this.getRAMlength();
        int n3 = n = this.hasSRAM() ? n2 + 127 + this.getSRAM().length : n2 + 127;
        if (this.allRAMaddresses == null || this.allRAMaddresses.size() != n) {
            this.allRAMaddresses = new AbstractIntList(){

                @Override
                public int get(int n3) {
                    if (n3 < n2) {
                        if (n3 < 4096) {
                            return 49152 + n3;
                        }
                        return n3 / 4096 << 16 | 0xD000 | n3 & 0xFFF;
                    }
                    if (65408 + (n3 -= n2) < 65535) {
                        return 65408 + n3;
                    }
                    return (n3 -= 127) / 8192 << 16 | 0xA000 | n3 & 0x1FFF;
                }

                @Override
                public int size() {
                    return n;
                }
            };
        }
        return this.allRAMaddresses;
    }

    @Override
    public int getStackStart() {
        int n = this.getStackPointer() - 1 & 0xFFFF;
        if (n >= 65280) {
            return 65280;
        }
        return 49152;
    }

    @Override
    public int getStackLength() {
        int n = this.getStackPointer() - 1 & 0xFFFF;
        if (n >= 65280) {
            return 256;
        }
        return 8192;
    }

    @Override
    public int getRAMvalue(int n) {
        if (n >= 65280) {
            return this.memory[n & 0xFF];
        }
        return this.wram[n & 0x1FFF];
    }

    @Override
    public int getBank0() {
        return this.cartridge.getBank0();
    }

    @Override
    public int getBank1() {
        return this.cartridge.getBank1();
    }

    @Override
    public int getBank2() {
        return this.cartridge.getBank2();
    }

    @Override
    public int getBank3() {
        return this.cartridge.getBank3();
    }

    @Override
    public int getBank(int n) {
        if (this.isROMaddress(n &= 0xFFFF) || this.isSRAMaddress(n) || this.cartridge.isTimerAddress(n)) {
            return this.cartridge.getBank(n);
        }
        return 0;
    }

    @Override
    public void setBank(int n, int n2) {
        if (this.isROMaddress(n &= 0xFFFF) || this.isSRAMaddress(n) || this.cartridge.isTimerAddress(n)) {
            this.cartridge.setBank(n, n2);
        }
    }

    @Override
    public int getRomBankSize() {
        return this.cartridge.getBankSize();
    }

    @Override
    public boolean isSRAMenabled() {
        return this.cartridge.isSRAMenabled();
    }

    @Override
    public void setSRAMenabled(boolean bl) {
        this.cartridge.setSRAMenabled(bl);
    }

    @Override
    public int getSRAMbank() {
        return this.cartridge.getSRAMbank();
    }

    @Override
    public int getScanline() {
        return this.lcd.getRegLY();
    }

    @Override
    public boolean isHalted() {
        return this.cpu.isHalted() || this.cpu.isJustHalted() || this.stopped;
    }

    @Override
    public boolean isVBlank() {
        return (this.lcd.getRegSTAT() & 3) == 1;
    }

    @Override
    public boolean isInterruptsEnabled() {
        return this.cpu.isInterruptsEnabled();
    }

    @Override
    public void setInterruptsEnabled(boolean bl) {
        this.cpu.setInterruptsEnabled(bl);
    }

    @Override
    public boolean isInterruptAddress(int n) {
        return n == 64 || n == 72 || n == 80 || n == 88 || n == 96;
    }

    @Override
    public boolean isConditionMet(int n) {
        int n2 = this.cpu.getRegisterValue(3);
        switch (n) {
            case 0: {
                return (n2 & 0x80) == 0;
            }
            case 1: {
                return (n2 & 0x80) != 0;
            }
            case 2: {
                return (n2 & 0x10) == 0;
            }
            case 3: {
                return (n2 & 0x10) != 0;
            }
        }
        return false;
    }

    @Override
    public boolean canStepOver() {
        int n = this.peekByte(this.getPC());
        return n != 24 && n != 195 && n != 201 && n != 233;
    }

    @Override
    public boolean isCartridgeEnabled() {
        return !this.bootROMenabled;
    }

    @Override
    public boolean isBiosEnabled() {
        return this.bootROMenabled;
    }

    @Override
    public RamRomMap getRamRomMap() {
        return this.ramRomMap;
    }

    @Override
    public int[] getErrorCodes() {
        return ERROR_CODES;
    }

    @Override
    public int getNumberOfAdditionalMemoryLocations() {
        return ADDITIONAL_MEMORY_LOCATION_NAMES.length;
    }

    @Override
    public String getAdditionalMemoryLocationName(int n) {
        return ADDITIONAL_MEMORY_LOCATION_NAMES[n];
    }

    @Override
    public int getAdditionalMemoryLocationLength(int n) {
        return ADDITIONAL_MEMORY_LOCATION_LENGTHS[n];
    }

    @Override
    public String getAdditionalMemoryLocationAt(int n) {
        if (GameBoy.isHRAMaddress(n)) {
            return ADDITIONAL_MEMORY_LOCATION_NAMES[0];
        }
        if (GameBoy.isOAMaddress(n)) {
            return ADDITIONAL_MEMORY_LOCATION_NAMES[1];
        }
        if (GameBoy.isIOaddress(n)) {
            return ADDITIONAL_MEMORY_LOCATION_NAMES[2];
        }
        return null;
    }

    @Override
    public boolean isAdditionalMemoryLocationMemoryMapped(String string) {
        return ADDITIONAL_MEMORY_LOCATION_NAMES[0].equalsIgnoreCase(string);
    }

    @Override
    public String cpuAddressToString(int n) {
        switch (n >> 14) {
            case 0: {
                if (this.bootROMenabled && this.isBootromAddress(n)) {
                    return String.format(" BOOT:%04X", n);
                }
                return String.format("ROM%02X:%04X", this.getBank0(), n);
            }
            case 1: {
                return String.format("ROM%02X:%04X", this.getBank1(), n);
            }
            case 2: {
                return n < 40960 ? String.format(" VRAM:%04X", n) : String.format("SRAM%X:%04X", this.getSRAMbank(), n);
            }
            case 3: {
                if (n < 57344) {
                    return String.format(" WRAM:%04X", n);
                }
                if (n < 65024) {
                    return String.format(" ECHO:%04X", n);
                }
                if (n < 65184) {
                    return String.format("  OAM:%04X", n);
                }
                if (n < 65280) {
                    return String.format("  ---:%04X", n);
                }
                if (n < 65408) {
                    return String.format("  I/O:%04X", n);
                }
                if (n < 65535) {
                    return String.format(" HRAM:%04X", n);
                }
                return String.format("IE:%04X", n);
            }
        }
        return null;
    }

    @Override
    public String virtualAddressToString(int n) {
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        switch (n3 >> 14) {
            case 0: 
            case 1: {
                return String.format("ROM%02X:%04X", n2, n3);
            }
            case 2: {
                return n3 < 40960 ? String.format(" VRAM:%04X", n3) : String.format("SRAM%X:%04X", this.getSRAMbank(), n3);
            }
            case 3: {
                if (n3 < 57344) {
                    return String.format(" WRAM:%04X", n3);
                }
                if (n3 < 65024) {
                    return String.format(" ECHO:%04X", n3);
                }
                if (n3 < 65184) {
                    return String.format("  OAM:%04X", n3);
                }
                if (n3 < 65280) {
                    return String.format("  ---:%04X", n3);
                }
                if (n3 < 65408) {
                    return String.format("  I/O:%04X", n3);
                }
                if (n3 < 65535) {
                    return String.format(" HRAM:%04X", n3);
                }
                return String.format("IE:%04X", n3);
            }
        }
        return null;
    }

    @Override
    public String romAddressToString(int n) {
        if (n < 16384) {
            return String.format("00:%04X", n);
        }
        return String.format("%02X:%04X", n / 16384, 0x4000 | n & 0x3FFF);
    }

    @Override
    public String ramAddressToString(int n) {
        return String.format("%04X", 0xC000 | n);
    }

    @Override
    public String vramAddressToString(int n) {
        return String.format("%04X", 0x8000 | n);
    }

    @Override
    public String sramAddressToString(int n) {
        if (this.getSRAM().length <= 8192) {
            return String.format("%04X", 0xA000 | n);
        }
        return String.format("%X:%04X", n / 8192, 0xA000 | n & 0x1FFF);
    }

    @Override
    public String palAddressToString(int n) {
        return n == 0 ? "BGP" : "OBP" + (n - 1);
    }

    @Override
    public boolean isRamInitialized(int n) {
        return this.wramInitialized[n];
    }

    public boolean isHramInitialized(int n) {
        return this.hramInitialized[n];
    }

    @Override
    public boolean isVramInitialized(int n) {
        return true;
    }

    @Override
    public boolean isSramInitialized(int n) {
        return true;
    }

    @Override
    public boolean isCpuMemoryInitialized(int n) {
        if (GameBoy.isHRAMaddress(n)) {
            return this.isHramInitialized(this.mapAddress(n));
        }
        if (this.isWRAMaddress(n)) {
            return this.isRamInitialized(this.mapAddress(n));
        }
        if (this.isVRAMaddress(n)) {
            return this.isVramInitialized(this.mapAddress(n));
        }
        if (this.isSRAMaddress(n)) {
            return this.isSramInitialized(this.mapAddress(n));
        }
        return true;
    }

    @Override
    public boolean isPaletteInitialized(int n) {
        return true;
    }

    @Override
    public EventModel createEventModel() {
        if (this.eventModel == null) {
            this.eventModel = this.createGameBoyEventModel();
        }
        return this.eventModel;
    }

    protected GameBoyEventModel createGameBoyEventModel() {
        return new GameBoyEventModel();
    }

    protected void handlePortEvent(int n, int n2, int n3, int n4) {
        if (this.eventModel != null) {
            GameBoyEventTypes gameBoyEventTypes;
            switch (n) {
                case 16: {
                    this.addEvent(GameBoyEventTypes.CHANNEL1, this.sound.getState().getRegNR10(), n3, n4, n - 16);
                    return;
                }
                case 17: {
                    this.addEvent(GameBoyEventTypes.CHANNEL1, this.sound.getState().getRegNR11(), n3, n4, n - 16);
                    return;
                }
                case 18: {
                    this.addEvent(GameBoyEventTypes.CHANNEL1, this.sound.getState().getRegNR12(), n3, n4, n - 16);
                    return;
                }
                case 19: {
                    this.addEvent(GameBoyEventTypes.CHANNEL1, this.sound.getState().getRegNR13(), n3, n4, n - 16);
                    return;
                }
                case 20: {
                    this.addEvent(GameBoyEventTypes.CHANNEL1, this.sound.getState().getRegNR14(), n3, n4, n - 16);
                    return;
                }
                case 22: {
                    this.addEvent(GameBoyEventTypes.CHANNEL2, this.sound.getState().getRegNR21(), n3, n4, n - 22);
                    return;
                }
                case 23: {
                    this.addEvent(GameBoyEventTypes.CHANNEL2, this.sound.getState().getRegNR22(), n3, n4, n - 22);
                    return;
                }
                case 24: {
                    this.addEvent(GameBoyEventTypes.CHANNEL2, this.sound.getState().getRegNR23(), n3, n4, n - 22);
                    return;
                }
                case 25: {
                    this.addEvent(GameBoyEventTypes.CHANNEL2, this.sound.getState().getRegNR24(), n3, n4, n - 22);
                    return;
                }
                case 26: {
                    this.addEvent(GameBoyEventTypes.CHANNEL3, this.sound.getState().getRegNR30(), n3, n4, n - 26);
                    return;
                }
                case 27: {
                    this.addEvent(GameBoyEventTypes.CHANNEL3, this.sound.getState().getRegNR31(), n3, n4, n - 26);
                    return;
                }
                case 28: {
                    this.addEvent(GameBoyEventTypes.CHANNEL3, this.sound.getState().getRegNR32(), n3, n4, n - 26);
                    return;
                }
                case 29: {
                    this.addEvent(GameBoyEventTypes.CHANNEL3, this.sound.getState().getRegNR33(), n3, n4, n - 26);
                    return;
                }
                case 30: {
                    this.addEvent(GameBoyEventTypes.CHANNEL3, this.sound.getState().getRegNR34(), n3, n4, n - 26);
                    return;
                }
                case 32: {
                    this.addEvent(GameBoyEventTypes.CHANNEL4, this.sound.getState().getRegNR41(), n3, n4, n - 32);
                    return;
                }
                case 33: {
                    this.addEvent(GameBoyEventTypes.CHANNEL4, this.sound.getState().getRegNR42(), n3, n4, n - 32);
                    return;
                }
                case 34: {
                    this.addEvent(GameBoyEventTypes.CHANNEL4, this.sound.getState().getRegNR43(), n3, n4, n - 32);
                    return;
                }
                case 35: {
                    this.addEvent(GameBoyEventTypes.CHANNEL4, this.sound.getState().getRegNR44(), n3, n4, n - 32);
                    return;
                }
                case 36: {
                    this.addEvent(GameBoyEventTypes.APU_CONTROL, this.sound.getState().getRegNR50(), n3, n4, n - 36);
                    return;
                }
                case 37: {
                    this.addEvent(GameBoyEventTypes.APU_CONTROL, this.sound.getState().getRegNR51(), n3, n4, n - 36);
                    return;
                }
                case 38: {
                    this.addEvent(GameBoyEventTypes.APU_CONTROL, this.sound.getState().getRegNR52(), n3, n4, n - 36);
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: {
                    gameBoyEventTypes = GameBoyEventTypes.WAVE;
                    break;
                }
                case 64: {
                    gameBoyEventTypes = GameBoyEventTypes.LCDC;
                    break;
                }
                case 65: {
                    gameBoyEventTypes = GameBoyEventTypes.STAT;
                    break;
                }
                case 66: {
                    gameBoyEventTypes = GameBoyEventTypes.SCY;
                    break;
                }
                case 67: {
                    gameBoyEventTypes = GameBoyEventTypes.SCX;
                    break;
                }
                case 68: {
                    gameBoyEventTypes = GameBoyEventTypes.LY;
                    break;
                }
                case 69: {
                    gameBoyEventTypes = GameBoyEventTypes.LYC;
                    break;
                }
                case 70: {
                    this.addEvent(GameBoyEventTypes.DMA, n2, n3, n4, this.toVirtualAddress(n3 << 8));
                    gameBoyEventTypes = null;
                    break;
                }
                case 71: {
                    gameBoyEventTypes = GameBoyEventTypes.BGP;
                    break;
                }
                case 72: {
                    gameBoyEventTypes = GameBoyEventTypes.OBP0;
                    break;
                }
                case 73: {
                    gameBoyEventTypes = GameBoyEventTypes.OBP1;
                    break;
                }
                case 74: {
                    gameBoyEventTypes = GameBoyEventTypes.WY;
                    break;
                }
                case 75: {
                    gameBoyEventTypes = GameBoyEventTypes.WX;
                    break;
                }
                default: {
                    gameBoyEventTypes = null;
                }
            }
            if (gameBoyEventTypes != null) {
                this.addEvent(gameBoyEventTypes, n2, n3, n4);
            }
        }
    }

    protected void addHaltEvent(int n, int n2) {
        this.addEvent(GameBoyEventTypes.HALT, n ^ 1, n, n2);
    }

    protected void addEvent(EventType eventType, int n, int n2, int n3) {
        this.addEvent(eventType, n, n2, n3, -1);
    }

    protected void addEvent(EventType eventType, int n, int n2, int n3, int n4) {
        this.addEvent(eventType, n, n2, n3, n4, null);
    }

    protected void addEvent(EventType eventType, int n, int n2, int n3, int n4, String string) {
        if (this.eventModel != null) {
            this.eventModel.addEvent(eventType, this.getScanline(), this.lcd.calcCurrentDot() + (this.lcd.isLCDDisplayEnabled() ? n3 : 0), n, n2, this.getVirtualAddress(), n4, string);
        }
    }

    @Override
    public void addDebugEvent(DebuggableSystem.DebugEvent debugEvent, String string) {
        switch (debugEvent) {
            case BREAKPOINT: {
                this.addEvent(GameBoyEventTypes.BREAKPOINT, -1, -1, 0, -1, string);
                break;
            }
            case EXCEPTION: {
                this.addEvent(GameBoyEventTypes.EXCEPTION, -1, -1, 0, -1, string);
            }
        }
    }

    protected void frameFinished() {
        if (this.eventModel != null) {
            this.eventModel.finishFrame();
        }
        if (this.joypad instanceof FrameInputDevice) {
            ((FrameInputDevice)((Object)this.joypad)).frameFinished();
        }
        this.lcd.resetCyclesSinceLastFrame();
    }

    @Override
    public void setInputState(long l) {
        this.joypad.setState(l);
    }

    @Override
    public void setDebugger(DebuggableSystem debuggableSystem) {
        if (debuggableSystem == null) {
            debuggableSystem = this;
        }
        this.cpu.setMemoryMap(debuggableSystem);
    }

    protected void firePortWritten(int n, int n2, int n3) {
        OutputListener[] outputListenerArray = this.portListeners;
        int n4 = this.portListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            OutputListener outputListener = outputListenerArray[n5];
            outputListener.outputAvailable(n, n2, n3);
            ++n5;
        }
    }

    protected void firePortRead(int n, int n2, int n3) {
        OutputListener[] outputListenerArray = this.portListeners;
        int n4 = this.portListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            OutputListener outputListener = outputListenerArray[n5];
            outputListener.outputAvailable(n, Integer.MIN_VALUE | n2, n3);
            ++n5;
        }
    }

    @Override
    public void addPortListener(OutputListener outputListener) {
        if (!this.portListenerList.contains(outputListener)) {
            this.portListenerList.addFirst(outputListener);
            this.portListeners = this.portListenerList.toArray(new OutputListener[this.portListenerList.size()]);
        }
    }

    @Override
    public void removePortListener(OutputListener outputListener) {
        if (this.portListenerList.remove(outputListener)) {
            this.portListeners = this.portListenerList.toArray(new OutputListener[this.portListenerList.size()]);
        }
    }

    public void addOutputListener(OutputListener outputListener) {
        this.lcd.addOutputListener(outputListener);
        this.sound.addOutputListener(outputListener);
    }

    public void removeOutputListener(OutputListener outputListener) {
        this.lcd.removeOutputListener(outputListener);
        this.sound.removeOutputListener(outputListener);
    }

    @Override
    public EmulatableSystem.State createMutableState() {
        return this.getState().clone();
    }

    @Override
    public State getState() {
        final GBCartridge.State state = this.cartridge.getState();
        final LR35902.State state2 = this.cpu.getLR35902State();
        final GBLCDController.State state3 = this.lcd.getState();
        final GBSoundController.State state4 = this.sound.getState();
        return new UnmodifiableState(){

            @Override
            public State clone() {
                return new StateClone(this);
            }

            @Override
            public int[] getWRam() {
                return GameBoy.this.wram;
            }

            @Override
            public int[] getHRam() {
                return GameBoy.this.memory;
            }

            @Override
            public GBCartridge.State getCartridgeState() {
                return state;
            }

            @Override
            public LR35902.State getCPUstate() {
                return state2;
            }

            @Override
            public GBLCDController.State getLCDstate() {
                return state3;
            }

            @Override
            public GBSoundController.State getSoundState() {
                return state4;
            }

            @Override
            public boolean isPrevSTATline() {
                return GameBoy.this.prevSTATline;
            }

            @Override
            public boolean isBootROMenabled() {
                return GameBoy.this.isBootROMenabled();
            }

            @Override
            public int getCounter() {
                return GameBoy.this.counter;
            }

            @Override
            public TIMAState getTimaState() {
                return GameBoy.this.timaState;
            }

            @Override
            public int getSerialCounter() {
                return GameBoy.this.serialCounter;
            }

            @Override
            public boolean isStopped() {
                return GameBoy.this.stopped;
            }

            @Override
            public int getDmaCounter() {
                return GameBoy.this.dmaCounter;
            }

            @Override
            public int getDmaSource() {
                return GameBoy.this.dmaSource;
            }

            @Override
            public int getTimerDMA() {
                return GameBoy.this.timerDMA;
            }

            @Override
            public boolean isDmaJustStarted() {
                return GameBoy.this.dmaJustStarted;
            }

            @Override
            public boolean isDmaStillRunning() {
                return GameBoy.this.dmaStillRunning;
            }

            @Override
            public boolean[] getWRamInitialized() {
                return GameBoy.this.wramInitialized;
            }

            @Override
            public boolean[] getHRamInitialized() {
                return GameBoy.this.hramInitialized;
            }

            @Override
            public int getRegSVBK() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isDoubleSpeed() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isDmgMode() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void setState(EmulatableSystem.State state, boolean bl, boolean bl2) {
        if (state instanceof State) {
            State state2 = (State)state;
            System.arraycopy(state2.getWRam(), 0, this.wram, 0, Math.min(this.wram.length, state2.getWRam().length));
            System.arraycopy(state2.getWRamInitialized(), 0, this.wramInitialized, 0, Math.min(this.wramInitialized.length, state2.getWRamInitialized().length));
            System.arraycopy(state2.getHRam(), 0, this.memory, 0, this.memory.length);
            System.arraycopy(state2.getHRamInitialized(), 0, this.hramInitialized, 0, this.hramInitialized.length);
            if (this.analoguePocket && this.memory[64] != 255) {
                this.memory[78] = this.reverseBits(this.memory[64]);
                this.memory[64] = 255;
                this.memory[65] = this.reverseBits(this.memory[65]);
            }
            this.cartridge.setState(state2.getCartridgeState(), bl);
            this.cpu.setLR35902State(state2.getCPUstate());
            this.lcd.setState(state2.getLCDstate(), bl2);
            this.sound.setState(state2.getSoundState());
            this.prevSTATline = state2.isPrevSTATline();
            this.bootROMenabled = state2.isBootROMenabled();
            this.counter = state2.getCounter();
            this.timaState = state2.getTimaState();
            this.serialCounter = state2.getSerialCounter();
            this.stopped = state2.isStopped();
            this.dmaCounter = state2.getDmaCounter();
            this.dmaSource = state2.getDmaSource();
            this.timerDMA = state2.getTimerDMA();
            this.dmaJustStarted = state2.isDmaJustStarted();
            this.dmaStillRunning = state2.isDmaStillRunning();
        }
    }

    @Override
    public void loadSAV(File file) {
        this.cartridge.readRAMfromFile(file);
    }

    protected class GameBoyEventModel
    extends AbstractArrayListEventModel {
        private final GameBoyEventTypes[] eventTypes;
        private final String[] statInterruptNames;
        private final String[] lcdcBitLabels;
        private final String[][] lcdcBitValues;
        private final String[] channel1Labels;
        private final String[] channel2Labels;
        private final String[] channel3Labels;
        private final String[] channel4Labels;
        private final String[] apuControlLabels;

        public GameBoyEventModel() {
            this(GameBoyEventTypes.values());
        }

        public GameBoyEventModel(EventType[] eventTypeArray) {
            super(eventTypeArray);
            this.eventTypes = GameBoyEventTypes.values();
            this.statInterruptNames = new String[]{"LYC=LY", "Mode 2", "Mode 1", "Mode 0"};
            this.lcdcBitLabels = new String[]{"BG/Window Display/Priority", "OBJ (Sprite) Display Enable", "OBJ (Sprite) Size", "BG Tile Map Display Select", "BG & Window Tile Data Select", "Window Display Enable", "Window Tile Map Display Select", "LCD Display Enable"};
            this.lcdcBitValues = new String[][]{{"Off", "On"}, {"Off", "On"}, {"8x8", "8x16"}, {"9800-9BFF", "9C00-9FFF"}, {"8800-97FF", "8000-8FFF"}, {"Off", "On"}, {"9800-9BFF", "9C00-9FFF"}, {"Off", "On"}};
            this.channel1Labels = new String[]{"NR10 - Channel 1 Sweep register", "NR11 - Channel 1 Sound length/Wave pattern duty", "NR12 - Channel 1 Volume Envelope", "NR13 - Channel 1 Frequency lo", "FF14 - NR14 - Channel 1 Frequency hi"};
            this.channel2Labels = new String[]{"NR21 - Channel 2 Sound Length/Wave Pattern Duty", "NR22 - Channel 2 Volume Envelope", "NR23 - Channel 2 Frequency lo data", "FF19 - NR24 - Channel 2 Frequency hi data"};
            this.channel3Labels = new String[]{"NR30 - Channel 3 Sound on/off", "NR31 - Channel 3 Sound Length", "NR32 - Channel 3 Select output level", "NR33 - Channel 3 Frequency\u2019s lower data", "NR34 - Channel 3 Frequency\u2019s higher data"};
            this.channel4Labels = new String[]{"NR41 - Channel 4 Sound Length", "NR42 - Channel 4 Volume Envelope", "NR43 - Channel 4 Polynomial Counter", "NR44 - Channel 4 Counter/consecutive; Inital"};
            this.apuControlLabels = new String[]{"NR50 - Channel control / ON-OFF / Volume", "NR51 - Selection of Sound output terminal", "NR52 - Sound on/off"};
            int n = 0;
            while (n < this.statInterruptNames.length) {
                int n2 = n++;
                this.statInterruptNames[n2] = String.valueOf(this.statInterruptNames[n2]) + " STAT Interrupt ";
            }
        }

        @Override
        protected String pcToString(int n) {
            return GameBoy.this.virtualAddressToString(n).trim();
        }

        @Override
        protected String getDetails(Event event) {
            if (event.getType() >= this.eventTypes.length) {
                return null;
            }
            switch (this.eventTypes[event.getType()]) {
                case CHANNEL1: {
                    return this.channel1Labels[event.getDetailsData()];
                }
                case CHANNEL2: {
                    return this.channel2Labels[event.getDetailsData()];
                }
                case CHANNEL3: {
                    return this.channel3Labels[event.getDetailsData()];
                }
                case CHANNEL4: {
                    return this.channel4Labels[event.getDetailsData()];
                }
                case APU_CONTROL: {
                    return this.apuControlLabels[event.getDetailsData()];
                }
                case DMA: {
                    return "Requested OAM DMA Transfer from " + GameBoy.this.virtualAddressToString(event.getDetailsData()).trim() + " to OAM:FE00";
                }
                case LCDC: {
                    if (event.getNewValue() < 0) break;
                    int n = event.getNewValue() ^ event.getOldValue();
                    StringBuilder stringBuilder = new StringBuilder();
                    int n2 = 1;
                    int n3 = 0;
                    while (n3 < this.lcdcBitLabels.length) {
                        if ((n & n2) != 0) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append(this.lcdcBitLabels[n3]).append(": ").append((event.getNewValue() & n2) != 0 ? this.lcdcBitValues[n3][1] : this.lcdcBitValues[n3][0]);
                        }
                        n2 <<= 1;
                        ++n3;
                    }
                    return stringBuilder.toString();
                }
                case STAT: {
                    if (event.getNewValue() >= 0) {
                        int n = event.getNewValue() ^ event.getOldValue();
                        if ((n & 0x7F) == 0) break;
                        StringBuilder stringBuilder = new StringBuilder();
                        int n4 = 64;
                        int n5 = 0;
                        while (n5 < this.statInterruptNames.length) {
                            if ((n & n4) != 0) {
                                if (stringBuilder.length() > 0) {
                                    stringBuilder.append(", ");
                                }
                                stringBuilder.append(this.statInterruptNames[n5]).append((event.getNewValue() & n4) != 0 ? "Enabled" : "Disabled");
                            }
                            n4 >>= 1;
                            ++n5;
                        }
                        return stringBuilder.toString();
                    }
                    return "Mode " + (event.getOldValue() & 3) + ((event.getOldValue() & 4) != 0 ? ", LYC=LY" : "");
                }
                case WRAM: {
                    if (event.getNewValue() >= 0) {
                        return "Write to WRAM" + (GameBoy.this.getClass() == GameBoy.class ? ":" : "") + GameBoy.this.ramAddressToString(event.getDetailsData());
                    }
                    return "Read from WRAM" + (GameBoy.this.getClass() == GameBoy.class ? ":" : "") + GameBoy.this.ramAddressToString(event.getDetailsData());
                }
                case HRAM: {
                    if (event.getNewValue() >= 0) {
                        return "Write to HRAM:FF" + String.format("%02X", 128 + event.getDetailsData());
                    }
                    return "Read from HRAM:FF" + String.format("%02X", 128 + event.getDetailsData());
                }
                case SRAM: {
                    if (event.getNewValue() >= 0) {
                        return "Write to SRAM" + (GameBoy.this.getSRAM().length <= 8192 ? ":" : "") + GameBoy.this.sramAddressToString(event.getDetailsData());
                    }
                    return "Read from SRAM" + (GameBoy.this.getSRAM().length <= 8192 ? ":" : "") + GameBoy.this.sramAddressToString(event.getDetailsData());
                }
                case VRAM: {
                    if (event.getNewValue() >= 0) {
                        return String.valueOf((event.getDetailsData() & 0x8000) != 0 ? "DMA Write to VRAM" : "Write to VRAM") + (GameBoy.this.getClass() == GameBoy.class ? ":" : "") + GameBoy.this.vramAddressToString(event.getDetailsData() & 0x3FFF);
                    }
                    return "Read from VRAM" + (GameBoy.this.getClass() == GameBoy.class ? ":" : "") + GameBoy.this.vramAddressToString(event.getDetailsData() & 0x3FFF);
                }
                case OAM: {
                    if (event.getNewValue() >= 0) {
                        return String.valueOf((event.getDetailsData() & 0x8000) != 0 ? "DMA Write to OAM:FE" : "Write to OAM:FE") + String.format("%02X", event.getDetailsData() & 0x3FFF);
                    }
                    return "Read from OAM:FE" + String.format("%02X", event.getDetailsData() & 0x3FFF);
                }
                case HALT: {
                    return event.getNewValue() != 0 ? "Halted" : "Unhalted";
                }
            }
            return null;
        }

        @Override
        protected int getCurrentScanline() {
            return GameBoy.this.getScanline();
        }

        @Override
        protected int getCurrentDot() {
            return GameBoy.this.lcd.calcCurrentDot();
        }

        @Override
        protected int getCurrentPC() {
            return GameBoy.this.getVirtualAddress();
        }

        @Override
        public int getBreakpointEventId() {
            return GameBoyEventTypes.BREAKPOINT.ordinal();
        }

        @Override
        public int getExceptionEventId() {
            return GameBoyEventTypes.EXCEPTION.ordinal();
        }

        @Override
        protected boolean isRead(Event event) {
            return event.getOldValue() >= 0 && event.getNewValue() < 0;
        }
    }

    public static interface State
    extends EmulatableSystem.State {
        public int[] getWRam();

        public int[] getHRam();

        public GBCartridge.State getCartridgeState();

        public LR35902.State getCPUstate();

        public GBLCDController.State getLCDstate();

        public GBSoundController.State getSoundState();

        public boolean isPrevSTATline();

        public boolean isBootROMenabled();

        public int getCounter();

        public TIMAState getTimaState();

        public int getSerialCounter();

        public boolean isStopped();

        public int getDmaCounter();

        public int getDmaSource();

        public int getTimerDMA();

        public boolean isDmaJustStarted();

        public boolean isDmaStillRunning();

        public boolean[] getWRamInitialized();

        public boolean[] getHRamInitialized();

        public int getRegSVBK();

        public boolean isDoubleSpeed();

        public boolean isDmgMode();
    }

    protected static class StateClone
    implements State {
        private final int[] wram;
        private final int[] memory;
        private final GBCartridge.State cartridge;
        private final LR35902.State cpu;
        private final GBLCDController.State lcd;
        private final GBSoundController.State sound;
        private boolean prevSTATline;
        private boolean bootROMenabled;
        private int counter;
        private TIMAState timaState;
        private int serialCounter;
        private boolean stopped;
        private int dmaCounter;
        private int dmaSource;
        private int timerDMA;
        private boolean dmaJustStarted;
        private boolean dmaStillRunning;
        private final boolean[] wramInitialized;
        private final boolean[] hramInitialized;

        public StateClone(State state) {
            this.wram = new int[state.getWRam().length];
            System.arraycopy(state.getWRam(), 0, this.wram, 0, Math.min(this.wram.length, state.getWRam().length));
            this.memory = new int[state.getHRam().length];
            System.arraycopy(state.getHRam(), 0, this.memory, 0, this.memory.length);
            this.cartridge = state.getCartridgeState().clone();
            this.cpu = state.getCPUstate().clone();
            this.lcd = state.getLCDstate().clone();
            this.sound = state.getSoundState().clone();
            this.prevSTATline = state.isPrevSTATline();
            this.bootROMenabled = state.isBootROMenabled();
            this.counter = state.getCounter();
            this.timaState = state.getTimaState();
            this.serialCounter = state.getSerialCounter();
            this.stopped = state.isStopped();
            boolean[] blArray = state.getWRamInitialized();
            this.wramInitialized = new boolean[blArray.length];
            System.arraycopy(blArray, 0, this.wramInitialized, 0, blArray.length);
            boolean[] blArray2 = state.getHRamInitialized();
            this.hramInitialized = new boolean[blArray2.length];
            System.arraycopy(blArray2, 0, this.hramInitialized, 0, blArray2.length);
        }

        @Override
        public void setState(EmulatableSystem.State state) throws UnmodifiableClassException {
            State state2 = (State)state;
            System.arraycopy(state2.getWRam(), 0, this.wram, 0, Math.min(this.wram.length, state2.getWRam().length));
            System.arraycopy(state2.getHRam(), 0, this.memory, 0, this.memory.length);
            this.cartridge.setState(state2.getCartridgeState());
            this.cpu.setState(state2.getCPUstate());
            this.lcd.setState(state2.getLCDstate());
            this.sound.setState(state2.getSoundState());
            this.prevSTATline = state2.isPrevSTATline();
            this.bootROMenabled = state2.isBootROMenabled();
            this.counter = state2.getCounter();
            this.timaState = state2.getTimaState();
            this.serialCounter = state2.getSerialCounter();
            this.stopped = state2.isStopped();
            boolean[] blArray = state2.getWRamInitialized();
            System.arraycopy(blArray, 0, this.wramInitialized, 0, blArray.length);
            boolean[] blArray2 = state2.getHRamInitialized();
            System.arraycopy(blArray2, 0, this.hramInitialized, 0, blArray2.length);
        }

        @Override
        public State clone() {
            return new StateClone(this);
        }

        @Override
        public int[] getWRam() {
            return this.wram;
        }

        @Override
        public int[] getHRam() {
            return this.memory;
        }

        @Override
        public GBCartridge.State getCartridgeState() {
            return this.cartridge;
        }

        @Override
        public LR35902.State getCPUstate() {
            return this.cpu;
        }

        @Override
        public GBLCDController.State getLCDstate() {
            return this.lcd;
        }

        @Override
        public GBSoundController.State getSoundState() {
            return this.sound;
        }

        @Override
        public boolean isPrevSTATline() {
            return this.prevSTATline;
        }

        @Override
        public boolean isBootROMenabled() {
            return this.bootROMenabled;
        }

        @Override
        public int getCounter() {
            return this.counter;
        }

        @Override
        public TIMAState getTimaState() {
            return this.timaState;
        }

        @Override
        public int getSerialCounter() {
            return this.serialCounter;
        }

        @Override
        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public int getDmaCounter() {
            return this.dmaCounter;
        }

        @Override
        public int getDmaSource() {
            return this.dmaSource;
        }

        @Override
        public int getTimerDMA() {
            return this.timerDMA;
        }

        @Override
        public boolean isDmaJustStarted() {
            return this.dmaJustStarted;
        }

        @Override
        public boolean isDmaStillRunning() {
            return this.dmaStillRunning;
        }

        @Override
        public boolean[] getWRamInitialized() {
            return this.wramInitialized;
        }

        @Override
        public boolean[] getHRamInitialized() {
            return this.hramInitialized;
        }

        @Override
        public int getRegSVBK() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDoubleSpeed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDmgMode() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum TIMAState {
        REGULAR,
        OVERFLOWED,
        RELOADED;

    }

    public static abstract class UnmodifiableState
    implements State {
        @Override
        public abstract State clone();

        @Override
        public void setState(EmulatableSystem.State state) throws UnmodifiableClassException {
            throw new UnmodifiableClassException();
        }
    }
}

