/*
 * Decompiled with CFR 0.152.
 */
package sdcc.cdb;

import java.util.ArrayList;
import java.util.List;
import sdcc.CDBParser;
import sdcc.cdb.Record;
import sdcc.cdb.SymbolRecord;

public class TypeRecord
implements Record {
    private final String scope;
    private final String name;
    private final List<TypeMember> members;

    public TypeRecord(String string, String string2, List<TypeMember> list) {
        this.scope = string;
        this.name = string2;
        this.members = list;
    }

    public static TypeRecord from(String string) {
        String string2 = CDBParser.nextToken(string, '$');
        string = string.substring(string2.length() + 1);
        String string3 = CDBParser.nextToken(string, '[');
        string = string.substring(string3.length() + 1);
        ArrayList<TypeMember> arrayList = new ArrayList<TypeMember>();
        while (!string.isEmpty() && string.charAt(0) == '(') {
            int n = Math.min(string.indexOf(")]"), string.indexOf(")(") & 0xFFFF);
            String string4 = string.substring(string.indexOf(123) + 1, n);
            String string5 = CDBParser.nextToken(string4, '}');
            string4 = string4.substring(string5.length() + 1);
            SymbolRecord symbolRecord = SymbolRecord.from(string4);
            arrayList.add(new TypeMember(Integer.parseInt(string5), symbolRecord));
            string = string.substring(n + 1);
        }
        return new TypeRecord(string2, string3, arrayList);
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public List<TypeMember> getMembers() {
        return this.members;
    }

    public static class TypeMember {
        final int offset;
        final SymbolRecord record;

        public TypeMember(int n, SymbolRecord symbolRecord) {
            this.offset = n;
            this.record = symbolRecord;
        }

        public int getOffset() {
            return this.offset;
        }

        public SymbolRecord getRecord() {
            return this.record;
        }
    }
}

