/*
 * Decompiled with CFR 0.152.
 */
package sdcc.cdb;

import java.util.ArrayList;
import java.util.List;

public class TypeChainRecord {
    private final int size;
    private final List<DCLType> type;
    private final boolean signed;

    public TypeChainRecord(int n, List<DCLType> list, boolean bl) {
        this.size = n;
        this.type = list;
        this.signed = bl;
    }

    public static TypeChainRecord from(String string) {
        if (string.isEmpty() || string.charAt(0) != '{') {
            throw new IllegalArgumentException("Missing brace in " + string);
        }
        int n = string.indexOf(125);
        int n2 = Integer.parseInt(string.substring(1, n));
        string = string.substring(n + 1);
        ArrayList<DCLType> arrayList = new ArrayList<DCLType>();
        DCLType dCLType = DCLType.from(string);
        while (dCLType != null) {
            arrayList.add(dCLType);
            string = string.substring(Math.min(string.indexOf(58), (string.indexOf(44) & 0xFFFF) + 1));
            dCLType = DCLType.from(string);
        }
        return new TypeChainRecord(n2, arrayList, string.charAt(1) == 'S');
    }

    public int getSize() {
        return this.size;
    }

    public int[] getArrayDimensions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (DCLType object2 : this.getType()) {
            if (!(object2 instanceof DCLArrayType)) continue;
            DCLArrayType dCLArrayType = (DCLArrayType)object2;
            arrayList.add(dCLArrayType.getSize());
        }
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    public int getNumberOfElements() {
        DCLType dCLType;
        int n = 1;
        List<DCLType> list = this.getType();
        if (list.size() > 1 && (dCLType = list.get(0)) instanceof DCLArrayType) {
            DCLArrayType dCLArrayType = (DCLArrayType)dCLType;
            n *= dCLArrayType.getSize();
        }
        return n;
    }

    public int getElementSize() {
        DCLArrayType dCLArrayType;
        DCLType dCLType;
        int n = this.getSize();
        List<DCLType> list = this.getType();
        if (list.size() > 1 && (dCLType = list.get(0)) instanceof DCLArrayType && (dCLArrayType = (DCLArrayType)dCLType).getSize() != 0) {
            n /= dCLArrayType.getSize();
        }
        return n;
    }

    public TypeChainRecord getElementType() {
        List<DCLType> list = this.getType();
        if (list.size() > 1) {
            return new TypeChainRecord(this.getElementSize(), list.subList(1, list.size()), this.isSigned());
        }
        return this;
    }

    public List<DCLType> getType() {
        return this.type;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isArray() {
        int n;
        int n2 = n = this.isPointer() ? 1 : 0;
        return !this.getType().isEmpty() && this.getType().get(n).getType() == PrimitiveType.DA;
    }

    public boolean isStruct() {
        int n;
        int n2 = n = this.isPointer() ? 1 : 0;
        return !this.getType().isEmpty() && this.getType().get(n).getType() == PrimitiveType.ST;
    }

    public boolean isPointer() {
        return !this.getType().isEmpty() && this.getType().get(0).getType() == PrimitiveType.DG;
    }

    public boolean isCodePointer() {
        return !this.getType().isEmpty() && this.getType().get(0).getType() == PrimitiveType.DC;
    }

    public boolean isFunction() {
        return !this.getType().isEmpty() && this.getType().get(0).getType() == PrimitiveType.DF;
    }

    private static String primitiveTypeToString(PrimitiveType primitiveType, boolean bl) {
        String string = !bl ? "unsigned " : "";
        switch (primitiveType) {
            case SC: {
                return String.valueOf(string) + "char";
            }
            case SF: {
                return String.valueOf(string) + "float";
            }
            case SI: {
                return String.valueOf(string) + "int";
            }
            case SL: {
                return String.valueOf(string) + "long";
            }
            case SS: {
                return String.valueOf(string) + "short";
            }
            case SV: {
                return "void";
            }
            case SX: {
                return "sbit";
            }
            case SB: {
                return "bitfield";
            }
        }
        throw new IllegalArgumentException("Called with '" + (Object)((Object)primitiveType) + "' but this method only works for simple primitive types");
    }

    public String arrayDimensionsToString() {
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = this.getArrayDimensions();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 > 0) {
                stringBuilder.append('[').append(n3).append(']');
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static void appendTypeChain(List<DCLType> list, int n, StringBuilder stringBuilder, String string, boolean bl) {
        if (list.isEmpty()) {
            stringBuilder.append("Unknown type " + string);
            return;
        }
        DCLType dCLType = list.get(n);
        if (dCLType instanceof DCLArrayType) {
            TypeChainRecord.appendTypeChain(list, n + 1, stringBuilder, String.valueOf(string) + "[" + ((DCLArrayType)dCLType).getSize() + "]", bl);
        } else if (dCLType instanceof DCLStructType) {
            stringBuilder.append(String.valueOf(((DCLStructType)dCLType).getName()) + string);
        } else if (dCLType.getType() == PrimitiveType.DC) {
            TypeChainRecord.appendTypeChain(list, n + 1, stringBuilder.append("(*"), String.valueOf(string) + ")()", bl);
        } else if (dCLType.getType() == PrimitiveType.DF) {
            TypeChainRecord.appendTypeChain(list, n + 1, stringBuilder, string, bl);
        } else if (dCLType.getType() == PrimitiveType.DG) {
            TypeChainRecord.appendTypeChain(list, n + 1, stringBuilder, String.valueOf(string) + "*", bl);
        } else {
            stringBuilder.append(String.valueOf(TypeChainRecord.primitiveTypeToString(dCLType.getType(), bl)) + string);
        }
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        TypeChainRecord.appendTypeChain(this.type, 0, stringBuilder, "", this.isSigned());
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getName();
    }

    public static class DCLArrayType
    extends DCLType {
        private final int size;

        private DCLArrayType(PrimitiveType primitiveType, int n) {
            super(primitiveType);
            this.size = n;
        }

        public static DCLArrayType from(PrimitiveType primitiveType, String string) {
            int n = Math.min(string.indexOf(58), string.indexOf(44) & 0xFFFF);
            while (n - 1 > 0 && !Character.isDigit(string.charAt(n - 1))) {
                --n;
            }
            return new DCLArrayType(primitiveType, Integer.parseInt(string.substring(0, n)));
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public String toString() {
            return "DCLArrayType [size=" + this.size + "]";
        }
    }

    public static class DCLBitFieldType
    extends DCLType {
        private final int offset;
        private final int size;

        private DCLBitFieldType(PrimitiveType primitiveType, int n, int n2) {
            super(primitiveType);
            this.offset = n;
            this.size = n2;
        }

        public static DCLBitFieldType from(PrimitiveType primitiveType, String string) {
            int n = string.indexOf(36);
            int n2 = Integer.parseInt(string.substring(0, n));
            string = string.substring(n + 1);
            int n3 = Math.min(string.indexOf(58), string.indexOf(44) & 0xFFFF);
            while (n3 - 1 > 0 && !Character.isDigit(string.charAt(n3 - 1))) {
                --n3;
            }
            return new DCLBitFieldType(primitiveType, n2, Integer.parseInt(string.substring(0, n3)));
        }

        public int getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public String toString() {
            return "DCLBitFieldType [offset=" + this.offset + ", size=" + this.size + "]";
        }
    }

    public static class DCLStructType
    extends DCLType {
        private final String name;

        private DCLStructType(String string) {
            super(PrimitiveType.ST);
            this.name = string;
        }

        public static DCLStructType from(String string) {
            return new DCLStructType(string.substring(0, string.indexOf(58)));
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return "DCLStructType [name=" + this.name + "]";
        }

        public static /* bridge */ /* synthetic */ DCLType from(String string) {
            return DCLStructType.from(string);
        }
    }

    public static class DCLType {
        private final PrimitiveType type;

        DCLType(PrimitiveType primitiveType) {
            this.type = primitiveType;
        }

        public static DCLType from(String string) {
            if (string.length() < 2 || string.charAt(0) != 'D' && string.charAt(0) != 'S') {
                return null;
            }
            PrimitiveType primitiveType = PrimitiveType.valueOf(string.substring(0, 2));
            if (primitiveType == PrimitiveType.ST) {
                return DCLStructType.from(string.substring(2));
            }
            if (primitiveType == PrimitiveType.DA) {
                return DCLArrayType.from(primitiveType, string.substring(2));
            }
            if (primitiveType == PrimitiveType.SB) {
                return DCLBitFieldType.from(primitiveType, string.substring(2));
            }
            return new DCLType(primitiveType);
        }

        public PrimitiveType getType() {
            return this.type;
        }

        public String toString() {
            return "DCLType [type=" + (Object)((Object)this.type) + "]";
        }
    }

    private static enum PrimitiveType {
        DA,
        DF,
        DG,
        DC,
        DX,
        DD,
        DI,
        SL,
        SI,
        SC,
        SS,
        SV,
        SF,
        ST,
        SX,
        SB;

    }
}

