/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import highlighting.Highlighter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import treetable.AbstractTreeTableModel;
import treetable.TreeTable;
import variables.Variable;
import variables.Variables;

public class VariablesTree
extends TreeTable {
    private final DefaultCellEditor booleanEditor = new DefaultCellEditor(new JCheckBox(){

        @Override
        public void setBounds(Rectangle rectangle) {
            if (!VariablesTree.this.painting) {
                super.setBounds(rectangle);
            }
        }

        @Override
        public Color getBackground() {
            return VariablesTree.this.getSelectionBackground();
        }
    }){

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Variable variable = object instanceof Variable ? (Variable)object : null;
            Component component = super.getTableCellEditorComponent(jTable, variable != null ? variable.getValue() : object, bl, n, n2);
            return component;
        }
    };
    boolean painting;

    public VariablesTree(Variables variables) {
        super(new VariablesModel(variables));
        this.setShowGrid(false);
        this.setFillsViewportHeight(true);
        this.setTableHeader(null);
        this.setIntercellSpacing(new Dimension());
        this.setHideIcons(true);
        this.expandFirstLevel();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setAutoResizeMode(3);
        this.setDefaultEditor(Variable.class, new DefaultCellEditor(new JTextField(){

            @Override
            public void setBounds(Rectangle rectangle) {
                if (!VariablesTree.this.painting) {
                    super.setBounds(rectangle);
                }
            }
        }){
            {
                this.setClickCountToStart(1);
                VariablesTree.this.setSurrendersFocusOnKeystroke(true);
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                Variable variable = object instanceof Variable ? (Variable)object : null;
                Component component = super.getTableCellEditorComponent(jTable, variable != null ? variable.getValue() : object, bl, n, n2);
                component.setFont(VariablesTree.this.getFont());
                component.setForeground(VariablesTree.this.getSelectionForeground());
                component.setBackground(VariablesTree.this.getSelectionBackground());
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setCaretColor(component.getForeground());
                }
                return component;
            }
        });
        if (this.getDefaultRenderer(Boolean.class) instanceof JCheckBox) {
            ((JCheckBox)((Object)this.getDefaultRenderer(Boolean.class))).setHorizontalAlignment(2);
        }
        this.setDefaultRenderer(Variable.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText(null);
                    if (jComponent instanceof JLabel) {
                        JLabel jLabel = (JLabel)component;
                        jLabel.setIcon(null);
                        if (n2 == 1) {
                            Variable variable;
                            Variable variable2 = variable = object instanceof Variable ? (Variable)object : null;
                            if (variable != null) {
                                if ("Boolean".equals(variable.getType())) {
                                    return VariablesTree.this.getDefaultRenderer(Boolean.class).getTableCellRendererComponent(jTable, Boolean.parseBoolean(variable.getDisplayValue()), bl, bl2, n, n2);
                                }
                                Highlighter highlighter = VariablesTree.this.getHighlighter();
                                jLabel.setText(highlighter != null ? highlighter.highlight(variable.getDisplayValue()) : variable.getDisplayValue());
                                String string = variable.getType();
                                if (string != null && string.indexOf(10) >= 0) {
                                    jLabel.setToolTipText("<html>" + string.replace("\n", "<br />") + "</html>");
                                } else {
                                    jLabel.setToolTipText(string);
                                }
                                jLabel.setHorizontalTextPosition(2);
                                Icon icon = variable.getValueIcon(jLabel);
                                if (icon == null || highlighter == null || jTable.getColumnModel().getColumn(n2).getWidth() >= jLabel.getPreferredSize().width + icon.getIconWidth() / 2) {
                                    jLabel.setIcon(icon);
                                } else {
                                    jLabel.setText(highlighter.highlight(String.valueOf(variable.getDisplayValue()) + "..."));
                                }
                            }
                        }
                    }
                }
                return component;
            }
        });
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        Variable variable;
        if (n2 != 1) {
            return super.getCellEditor(n, n2);
        }
        Object object = this.getValueAt(n, n2);
        Variable variable2 = variable = object instanceof Variable ? (Variable)object : null;
        if (variable != null && "Boolean".equals(variable.getType())) {
            return this.booleanEditor;
        }
        return super.getCellEditor(n, n2);
    }

    @Override
    public void setUI(TableUI tableUI) {
        super.setUI(new BasicTableUI(){

            @Override
            public void installUI(JComponent jComponent) {
                super.installUI(jComponent);
                this.table.remove(this.rendererPane);
                this.rendererPane = new CellRendererPane(){

                    @Override
                    public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4, boolean bl) {
                        Point point = new Point(n, n2);
                        int n5 = VariablesTree.this.rowAtPoint(point);
                        int n6 = point.x < VariablesTree.this.getColumnModel().getColumn(0).getWidth() ? 0 : 1;
                        Rectangle rectangle = VariablesTree.this.getCellRect(n5, n6, false);
                        super.paintComponent(graphics, component, container, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
                    }
                };
                this.table.add(this.rendererPane);
            }
        });
    }

    @Override
    public Rectangle getCellRect(int n, int n2, boolean bl) {
        Rectangle rectangle = super.getCellRect(n, n2, bl);
        int n3 = this.getCellRenderer((int)n, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n, (int)0), (boolean)false, (boolean)false, (int)n, (int)0).getPreferredSize().width;
        if (n2 == 0) {
            rectangle.width = n3;
        } else {
            rectangle.width += rectangle.x - n3;
            rectangle.x = n3;
        }
        return rectangle;
    }

    @Override
    public int columnAtPoint(Point point) {
        if (this.painting) {
            return -1;
        }
        int n = this.rowAtPoint(point);
        int n2 = this.getCellRenderer((int)n, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n, (int)0), (boolean)false, (boolean)false, (int)n, (int)0).getPreferredSize().width;
        return point.x < n2 ? 0 : 1;
    }

    @Override
    public void paint(Graphics graphics) {
        this.painting = true;
        super.paint(graphics);
        this.painting = false;
    }

    @Override
    public void setRowHeight(int n) {
        if (this.getModel() != null) {
            int n2 = 0;
            while (n2 < this.getRowCount()) {
                n = Math.max(this.getCellRenderer((int)n2, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n2, (int)0), (boolean)false, (boolean)false, (int)n2, (int)0).getPreferredSize().height, n);
                n = Math.max(this.getCellRenderer((int)n2, (int)1).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n2, (int)1), (boolean)false, (boolean)false, (int)n2, (int)1).getPreferredSize().height, n);
                ++n2;
            }
        }
        super.setRowHeight(n);
    }

    public void setVariables(Variables variables) {
        AbstractTableModel abstractTableModel = (AbstractTableModel)this.getModel();
        this.setModel(new VariablesModel(variables));
        TableModelListener[] tableModelListenerArray = (TableModelListener[])abstractTableModel.getListeners(TableModelListener.class);
        int n = tableModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableModelListener tableModelListener = tableModelListenerArray[n2];
            this.getModel().addTableModelListener(tableModelListener);
            abstractTableModel.removeTableModelListener(tableModelListener);
            ++n2;
        }
        this.expandFirstLevel();
    }

    public Highlighter getHighlighter() {
        return null;
    }

    static class VariablesModel
    extends AbstractTreeTableModel {
        private final Variables variables;

        public VariablesModel(Object object) {
            super(object);
            this.variables = (Variables)object;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return Variable.class;
        }

        @Override
        public Object getValueAt(Object object, int n) {
            if (n == 0) {
                return object instanceof Variable && ((Variable)object).getValue() != null ? object + ": " : object;
            }
            if (object instanceof Variable) {
                return object;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return n == 1 && object instanceof Variable && ((Variable)object).isEditable();
        }

        @Override
        public void setValueAt(Object object, Object object2, int n) {
            if (n == 1 && object2 instanceof Variable) {
                ((Variable)object2).setValue(object.toString());
            }
        }

        @Override
        public Object getChild(Object object, int n) {
            Object object2;
            if (object instanceof Variables) {
                object2 = ((Variables)object).getScopes()[n];
            } else if (object instanceof String) {
                object2 = this.variables.getVariables(object.toString())[n];
            } else if (object instanceof Variable) {
                object2 = ((Variable)object).getVariables()[n];
            } else {
                throw new IllegalArgumentException("Illegal type");
            }
            if (object2 == null) {
                throw new NullPointerException();
            }
            return object2;
        }

        @Override
        public int getChildCount(Object object) {
            if (object instanceof Variables) {
                return ((Variables)object).getScopes().length;
            }
            if (object instanceof String) {
                return this.variables.getVariables(object.toString()).length;
            }
            if (object instanceof Variable) {
                return ((Variable)object).getVariables().length;
            }
            return 0;
        }
    }
}

