/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import javax.swing.table.DefaultTableModel;
import platform.Emulicious;
import platform.debugger.Debugger;
import system.DebuggableSystem;

public class RegisterTableModel
extends DefaultTableModel {
    private final DebuggableSystem system;
    private final String[] registerNames;
    private final int numberOfRegularRegisters;
    private final int[] registerIndices;

    public RegisterTableModel(DebuggableSystem debuggableSystem) {
        this.system = debuggableSystem;
        this.registerNames = debuggableSystem.getRegisterNames();
        int n = 0;
        int n2 = 0;
        while (n2 < this.registerNames.length) {
            if (!debuggableSystem.isAdditionalRegister(n2)) {
                ++n;
            }
            ++n2;
        }
        this.numberOfRegularRegisters = n;
        this.registerIndices = new int[this.numberOfRegularRegisters * 2];
        this.updateRegisterIndices();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.getRegisterIndex(n, n2);
        switch (n2) {
            case 0: 
            case 2: {
                int n4 = this.indexOfRegister(object.toString());
                if (n4 < 0) break;
                int n5 = n2 / 2 * this.getRowCount() + n;
                int n6 = 0;
                while (n6 < this.registerIndices.length) {
                    if (this.registerIndices[n6] == n4) {
                        this.registerIndices[n6] = this.registerIndices[n5];
                        break;
                    }
                    ++n6;
                }
                this.registerIndices[n5] = n4;
                this.updateRegistersProperty();
                this.updateRegisterIndices();
                break;
            }
            case 1: 
            case 3: {
                if (n3 < this.numberOfRegularRegisters) {
                    this.system.setRegValue(n3, Integer.parseInt(object.toString(), 16));
                    break;
                }
                this.system.setAdditionalRegValue(n3 - this.numberOfRegularRegisters, Integer.parseInt(object.toString(), 16));
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = this.getRegisterIndex(n, n2);
        switch (n2) {
            default: {
                if (n3 < this.numberOfRegularRegisters) {
                    return this.registerNames[n3];
                }
                return this.system.getAdditionalRegisterName(n3 - this.numberOfRegularRegisters);
            }
            case 1: 
            case 3: 
        }
        if (n3 < this.numberOfRegularRegisters) {
            return Debugger.getHexStringWord(this.system.getRegisterValue(n3) & 0xFFFF);
        }
        int n4 = this.system.getAdditionalRegisterSize(n3 -= this.numberOfRegularRegisters);
        if (n4 == 2) {
            return Debugger.getHexStringWord(this.system.getAdditionalRegisterValue(n3) & 0xFFFF);
        }
        if (n4 == 1) {
            return Debugger.getHexStringByte(this.system.getAdditionalRegisterValue(n3) & 0xFF);
        }
        if (n4 == 0) {
            return this.system.getAdditionalRegisterValue(n3);
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.numberOfRegularRegisters;
    }

    public int getRegisterIndex(int n, int n2) {
        return this.registerIndices[n2 / 2 * this.getRowCount() + n];
    }

    public int getNumberOfRegularRegisters() {
        return this.numberOfRegularRegisters;
    }

    private void updateRegistersProperty() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.registerIndices.length) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.getValueAt(n % this.getRowCount(), n / this.getRowCount() * 2));
            ++n;
        }
        Emulicious.getProperties().setProperty(Emulicious.getRegistersProperty(), stringBuilder.toString());
    }

    private int indexOfRegister(String string) {
        int n = 0;
        while (n < this.registerNames.length) {
            if (!this.system.isAdditionalRegister(n) && this.registerNames[n].equals(string)) {
                return n;
            }
            ++n;
        }
        n = 0;
        String string2 = this.system.getAdditionalRegisterName(0);
        while (string2 != null) {
            if (string2.equals(string)) {
                return this.numberOfRegularRegisters + n;
            }
            string2 = this.system.getAdditionalRegisterName(++n);
        }
        return -1;
    }

    private void updateRegisterIndices() {
        String string = Emulicious.getProperties().getProperty(Emulicious.getRegistersProperty());
        if (string != null) {
            String[] stringArray = string.split(",");
            int[] nArray = new int[stringArray.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.indexOfRegister(stringArray[n]);
                if (nArray[n] < 0) {
                    nArray[n] = n;
                }
                ++n;
            }
            n = 0;
            while (n < this.registerIndices.length) {
                this.registerIndices[n] = nArray[n];
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.registerIndices.length) {
                this.registerIndices[n] = n;
                ++n;
            }
        }
        this.fireTableDataChanged();
    }
}

