/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import cheats.Cheat;
import common.ComponentWrapper;
import common.FontUtilities;
import common.MenuItem;
import common.ScreenUtilities;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import platform.Emulicious;
import system.DebuggableSystem;
import util.list.IntList;

public class RAMSearchWindow {
    private static RAMSearchWindow ramSearchWindow;
    DebuggableSystem system;
    ArrayList<RAMSearchEntry> entries = new ArrayList();
    final Window window;
    JTable table;
    final DefaultTableModel tableModel;
    private final JLabel entriesLabel = new JLabel();
    private final JRadioButton[] compareTo = new JRadioButton[]{new JRadioButton("Old Value", true), new JRadioButton("Constant:"), new JRadioButton("Other RAM Value:"), new JRadioButton("Number of Changes:")};
    final JTextField[] compareToValues = new JTextField[this.compareTo.length];
    private final JToggleButton[] comparisonOperator = new JToggleButton[]{new JToggleButton(new EqualsIcon(true), true), new JToggleButton(new NotEqualsIcon(true)), new JToggleButton(new LessThanIcon(true)), new JToggleButton(new LessThanOrEqualsIcon(true)), new JToggleButton(new GreaterThanIcon(true)), new JToggleButton(new GreaterThanOrEqualsIcon(true))};
    private final JCheckBox autoSearch = new JCheckBox("Search automatically");
    private final JComboBox<Integer> size = new JComboBox<Integer>(new Integer[]{1, 2, 4});
    private final JComboBox<String> type = new JComboBox<String>(new String[]{"Unsigned", "Signed"});
    private final JCheckBox bigEndian = new JCheckBox("Big Endian");
    private final LinkedList<ArrayList<RAMSearchEntry>> undoStack = new LinkedList();
    private final LinkedList<ArrayList<RAMSearchEntry>> redoStack = new LinkedList();

    private RAMSearchWindow(Window window, DebuggableSystem debuggableSystem, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - RAM Search");
        this.window.setIconImages(window.getIconImages());
        this.system = debuggableSystem;
        this.clear();
        this.entriesLabel.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
        this.window.add((Component)this.entriesLabel, "North");
        this.tableModel = this.createTableModel();
        this.window.add((Component)this.createRAMSearchTable(this.tableModel), "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.window.add((Component)jPanel, "East");
        JPanel jPanel2 = new JPanel(new GridLayout(2, 3));
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add(new JLabel("Size"));
        jPanel2.add(new JLabel("Type"));
        jPanel2.add(new JLabel());
        jPanel2.add(this.size);
        jPanel2.add(this.type);
        jPanel2.add(this.bigEndian);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new GridLayout(this.compareTo.length, 2));
        jPanel3.add((Component)jPanel4, "North");
        jPanel4.setBorder(BorderFactory.createTitledBorder("Compare To/By"));
        ButtonGroup buttonGroup = new ButtonGroup();
        Object object = this.compareTo;
        int n = this.compareTo.length;
        final int n2 = 0;
        while (n2 < n) {
            JRadioButton jRadioButton = object[n2];
            buttonGroup.add(jRadioButton);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.compareTo.length) {
            jPanel4.add(this.compareTo[n3]);
            if (n3 == 0) {
                jPanel4.add(new JLabel());
            } else {
                this.compareToValues[n3] = new JTextField(8);
                jPanel4.add(this.compareToValues[n3]);
                this.compareToValues[n3].setEnabled(false);
            }
            n2 = n3;
            this.compareTo[n3].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        int n = 1;
                        while (n < RAMSearchWindow.this.compareToValues.length) {
                            RAMSearchWindow.this.compareToValues[n].setEnabled(n == n2);
                            ++n;
                        }
                    }
                }
            });
            ++n3;
        }
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel5, "South");
        JPanel jPanel6 = new JPanel(new GridLayout(this.compareTo.length, 2));
        jPanel5.add((Component)jPanel6, "North");
        jPanel6.setBorder(BorderFactory.createTitledBorder("Comparison Operator"));
        jPanel6.setLayout(new GridLayout(this.comparisonOperator.length / 2, 2));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Object object2 = this.comparisonOperator;
        int n4 = this.comparisonOperator.length;
        int n5 = 0;
        while (n5 < n4) {
            object = object2[n5];
            buttonGroup2.add((AbstractButton)object);
            jPanel6.add((Component)object);
            ++n5;
        }
        object = new JPanel(new GridLayout(2, 2));
        jPanel5.add((Component)object, "South");
        JButton jButton = new JButton("Reset");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMSearchWindow.this.pushToUndoStack();
                RAMSearchWindow.this.clear();
            }
        });
        ((Container)object).add(ComponentWrapper.wrapComponent(jButton));
        JButton jButton2 = new JButton("Clear Change Counts");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (RAMSearchEntry rAMSearchEntry : RAMSearchWindow.this.entries) {
                    rAMSearchEntry.resetChanges();
                }
                RAMSearchWindow.this.tableModel.fireTableDataChanged();
            }
        });
        ((Container)object).add(ComponentWrapper.wrapComponent(jButton2));
        object2 = new JButton("Search");
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMSearchWindow.this.search();
            }
        });
        ((Container)object).add(ComponentWrapper.wrapComponent((JComponent)object2));
        ((Container)object).add(ComponentWrapper.wrapComponent(this.autoSearch));
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        if (ramSearchWindow == null || !ramSearchWindow.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem("Undo", 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMSearchWindow.this.undo();
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem("Redo", 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMSearchWindow.this.redo();
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(RAMSearchWindow.this.canUndo());
                menuItem2.setEnabled(RAMSearchWindow.this.canRedo());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    void clear() {
        this.entries.clear();
        IntList intList = this.system.getAllRAMaddresses();
        int n = intList.size();
        int n2 = 0;
        while (n2 < n) {
            this.entries.add(new RAMSearchEntry(intList.get(n2), this.getValue(intList.get(n2))));
            ++n2;
        }
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
        this.updateEntriesLabel();
    }

    void updateEntriesLabel() {
        this.entriesLabel.setText(String.valueOf(this.entries.size()) + " addresses");
    }

    private DefaultTableModel createTableModel() {
        return new DefaultTableModel(new Object[]{"Address", "Value", "Old Value", "Changes"}, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                RAMSearchEntry rAMSearchEntry = RAMSearchWindow.this.entries.get(n);
                switch (n2) {
                    case 0: {
                        return rAMSearchEntry.getAddress();
                    }
                    case 1: {
                        return rAMSearchEntry.getValue();
                    }
                    case 2: {
                        return rAMSearchEntry.getOldValue();
                    }
                    case 3: {
                        return rAMSearchEntry.getChanges();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return n > 0 ? Long.class : Integer.class;
            }

            @Override
            public int getRowCount() {
                return RAMSearchWindow.this.entries.size();
            }
        };
    }

    private JScrollPane createRAMSearchTable(DefaultTableModel defaultTableModel) {
        JTable jTable;
        this.table = jTable = new JTable(defaultTableModel){

            @Override
            public void setFont(Font font) {
                super.setFont(FontUtilities.ensureMonospaceFont(font));
            }

            @Override
            public void updateUI() {
                int n;
                super.updateUI();
                TableColumn tableColumn = this.getColumnModel().getColumn(0);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.getTableHeader().getDefaultRenderer();
                }
                tableColumn = this.getColumnModel().getColumn(0);
                int n2 = n = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)0).getPreferredSize().width;
                int n3 = 0;
                while (n3 < this.getRowCount()) {
                    n = Math.max(n, this.getCellRenderer((int)n3, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n3, (int)0), (boolean)false, (boolean)false, (int)n3, (int)0).getPreferredSize().width) + this.getIntercellSpacing().width;
                    n3 += 4096;
                }
                n = (int)((float)n * 1.1f);
                tableColumn.setMaxWidth(Integer.MAX_VALUE);
                tableColumn.setMinWidth(n);
                tableColumn.setMaxWidth(n);
                tableColumn = this.getColumnModel().getColumn(1);
                n = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)1).getPreferredSize().width;
                if (n > n2) {
                    n2 = n;
                }
                tableColumn = this.getColumnModel().getColumn(2);
                n = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)2).getPreferredSize().width;
                if (n > n2) {
                    n2 = n;
                }
                tableColumn = this.getColumnModel().getColumn(3);
                n = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)3).getPreferredSize().width;
                if (n > n2) {
                    n2 = n;
                }
                n3 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)Integer.valueOf((int)Integer.MAX_VALUE), (boolean)false, (boolean)false, (int)0, (int)1).getPreferredSize().width;
                tableColumn = this.getColumnModel().getColumn(1);
                tableColumn.setMinWidth(n2 += this.getIntercellSpacing().width);
                tableColumn.setPreferredWidth(n3);
                tableColumn = this.getColumnModel().getColumn(2);
                tableColumn.setMinWidth(n2);
                tableColumn.setPreferredWidth(n3);
                tableColumn = this.getColumnModel().getColumn(3);
                tableColumn.setMinWidth(n2);
                tableColumn.setPreferredWidth(n3);
                this.setRowHeight(this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height);
            }
        };
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.isPopupTrigger()) {
                    int n2 = jTable.rowAtPoint(mouseEvent.getPoint());
                    if (!jTable.getSelectionModel().isSelectedIndex(n2)) {
                        jTable.getSelectionModel().setSelectionInterval(n2, n2);
                    }
                    RAMSearchWindow.this.showPopupMenu(jTable, mouseEvent.getPoint());
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0 && (n = jTable.getSelectedRow()) >= 0) {
                    RAMSearchWindow.this.openInMemoryEditor(RAMSearchWindow.this.entries.get(jTable.convertRowIndexToModel(n)));
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = jTable.rowAtPoint(mouseEvent.getPoint());
                    if (!jTable.getSelectionModel().isSelectedIndex(n)) {
                        jTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    RAMSearchWindow.this.showPopupMenu(jTable, mouseEvent.getPoint());
                }
            }
        });
        jTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        jTable.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "delete");
        jTable.getActionMap().put("delete", new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMSearchWindow.this.deleteSelectedRows();
            }
        });
        jTable.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (n2 == 0 && object instanceof Integer) {
                    object = RAMSearchWindow.this.system.virtualAddressToString((Integer)object).trim();
                }
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 0) {
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
                    int n3 = component.getPreferredSize().width + jTable.getIntercellSpacing().width;
                    if (tableColumn.getWidth() < n3) {
                        tableColumn.setMaxWidth(Integer.MAX_VALUE);
                        tableColumn.setMinWidth(n3);
                        tableColumn.setMaxWidth(n3 + 8);
                    }
                }
                return component;
            }
        });
        jTable.setAutoCreateRowSorter(true);
        jTable.setFillsViewportHeight(true);
        jTable.updateUI();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 8, 8, 8), BorderFactory.createBevelBorder(1)));
        return jScrollPane;
    }

    void deleteSelectedRows() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        this.pushToUndoStack();
        int[] nArray = this.table.getSelectedRows();
        this.entries.subList(nArray[0], nArray[nArray.length - 1] + 1).clear();
        this.tableModel.fireTableRowsDeleted(nArray[0], nArray[nArray.length - 1]);
        this.updateEntriesLabel();
    }

    void showPopupMenu(final JTable jTable, Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        MenuItem menuItem = new MenuItem("Select in Memory Editor");
        jPopupMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                if (n >= 0) {
                    RAMSearchWindow.this.openInMemoryEditor(RAMSearchWindow.this.entries.get(jTable.convertRowIndexToModel(n)));
                }
            }
        });
        menuItem.setFont(menuItem.getFont().deriveFont(1));
        MenuItem menuItem2 = new MenuItem(jTable.getActionMap().get("delete"));
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        jPopupMenu.add(menuItem2);
        MenuItem menuItem3 = new MenuItem("Add Cheat");
        jPopupMenu.add(menuItem3);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                if (n >= 0) {
                    RAMSearchEntry rAMSearchEntry = RAMSearchWindow.this.entries.get(jTable.convertRowIndexToModel(n));
                    final int n2 = rAMSearchEntry.getAddress() & 0xFFFF;
                    final int n3 = (int)rAMSearchEntry.getValue();
                    Emulicious.getCheatModel().addCheat(new Cheat(){

                        @Override
                        public boolean isBigEndian() {
                            return false;
                        }

                        @Override
                        public int getValue() {
                            return n3;
                        }

                        @Override
                        public int getSize() {
                            return 1;
                        }

                        @Override
                        public String getName() {
                            return "Unnamed";
                        }

                        @Override
                        public String getDomain() {
                            return "System Bus";
                        }

                        @Override
                        public String getDisplayType() {
                            return "h";
                        }

                        @Override
                        public int getCompare() {
                            return -1;
                        }

                        @Override
                        public Cheat.Comparator getComparator() {
                            return Cheat.Comparator.NONE;
                        }

                        @Override
                        public int getAddress() {
                            return n2;
                        }
                    });
                    Emulicious.openCheatsWindow();
                }
            }
        });
        jPopupMenu.show(jTable, point.x, point.y);
    }

    protected void openInMemoryEditor(RAMSearchEntry rAMSearchEntry) {
        String string = this.system.getAdditionalMemoryLocationAt(rAMSearchEntry.getAddress() & 0xFFFF);
        if (string != null) {
            Emulicious.openMemoryEditor(string, this.system.mapVirtualAddress(rAMSearchEntry.getAddress()));
        } else if (this.system.isSRAMaddress(rAMSearchEntry.getAddress() & 0xFFFF)) {
            Emulicious.openMemoryEditorSRAM(this.system.mapVirtualAddress(rAMSearchEntry.getAddress()));
        } else if (this.system.isRAMaddress(rAMSearchEntry.getAddress() & 0xFFFF)) {
            Emulicious.openMemoryEditorRAM(this.system.mapVirtualAddress(rAMSearchEntry.getAddress()));
        }
    }

    boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    synchronized void undo() {
        if (!this.canUndo()) {
            return;
        }
        this.redoStack.push(this.entries);
        this.entries = this.undoStack.pop();
        this.updateEntriesLabel();
        this.tableModel.fireTableDataChanged();
    }

    boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    synchronized void redo() {
        if (!this.canRedo()) {
            return;
        }
        this.undoStack.push(this.entries);
        this.entries = this.redoStack.pop();
        this.updateEntriesLabel();
        this.tableModel.fireTableDataChanged();
    }

    void pushToUndoStack() {
        this.redoStack.clear();
        this.undoStack.push(new ArrayList<RAMSearchEntry>(this.entries));
        if (this.undoStack.size() >= 20) {
            this.undoStack.removeLast();
        }
    }

    synchronized void search() {
        try {
            this.pushToUndoStack();
            Iterator<RAMSearchEntry> iterator = this.entries.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                RAMSearchEntry rAMSearchEntry = iterator.next();
                long l = this.getValue(rAMSearchEntry.getAddress());
                if (this.isConstraintSatisfied(rAMSearchEntry)) {
                    rAMSearchEntry.setOldValue(l);
                    continue;
                }
                iterator.remove();
                bl = true;
            }
            if (!bl) {
                this.undoStack.pop();
            }
            this.updateEntriesLabel();
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception exception) {}
    }

    long getValue(int n) {
        long l = this.getRAMvalue(n, (Integer)this.size.getSelectedItem(), this.bigEndian.isSelected());
        if (this.type.getSelectedIndex() > 0) {
            switch ((Integer)this.size.getSelectedItem()) {
                case 1: {
                    return (byte)l;
                }
                case 2: {
                    return (short)l;
                }
                case 4: {
                    return (int)l;
                }
            }
        }
        return l;
    }

    private long getRAMvalue(int n, int n2, boolean bl) {
        if (n2 <= 1) {
            return this.system.getByte(n);
        }
        if (bl) {
            if (n2 == 2) {
                return this.getRAMvalue(n, 1, bl) << 8 | this.getRAMvalue(n + 1, 1, bl);
            }
            return this.getRAMvalue(n, n2 - 2, bl) << 16 | this.getRAMvalue(n + 2, 2, bl);
        }
        if (n2 == 2) {
            return this.getRAMvalue(n + 1, 1, bl) << 8 | this.getRAMvalue(n, 1, bl);
        }
        return this.getRAMvalue(n + 2, n2 - 2, bl) << 16 | this.getRAMvalue(n, 2, bl);
    }

    private boolean isConstraintSatisfied(RAMSearchEntry rAMSearchEntry) {
        rAMSearchEntry.updateValue();
        long l = -1L;
        try {
            long l2;
            switch (this.getCompareTo()) {
                case 0: {
                    l2 = rAMSearchEntry.getValue();
                    l = rAMSearchEntry.getOldValue();
                    break;
                }
                case 1: {
                    l2 = rAMSearchEntry.getValue();
                    l = Integer.parseInt(this.compareToValues[1].getText(), 16);
                    break;
                }
                case 2: {
                    l2 = rAMSearchEntry.getValue();
                    l = this.getValue(Integer.parseInt(this.compareToValues[2].getText(), 16));
                    break;
                }
                case 3: {
                    l2 = rAMSearchEntry.getChanges();
                    l = Integer.parseInt(this.compareToValues[3].getText(), 16);
                    break;
                }
                default: {
                    l2 = rAMSearchEntry.getValue();
                }
            }
            switch (this.getComparisonOperator()) {
                case 0: {
                    return l2 == l;
                }
                case 1: {
                    return l2 != l;
                }
                case 2: {
                    return l2 < l;
                }
                case 3: {
                    return l2 <= l;
                }
                case 4: {
                    return l2 > l;
                }
                case 5: {
                    return l2 >= l;
                }
            }
        }
        catch (Exception exception) {}
        return true;
    }

    private int getCompareTo() {
        int n = 0;
        while (n < this.compareTo.length) {
            if (this.compareTo[n].isSelected()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getComparisonOperator() {
        int n = 0;
        while (n < this.comparisonOperator.length) {
            if (this.comparisonOperator[n].isSelected()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized void updateValues() {
        for (RAMSearchEntry rAMSearchEntry : this.entries) {
            rAMSearchEntry.updateValue();
        }
        this.table.repaint();
    }

    public static void update() {
        if (ramSearchWindow != null && ramSearchWindow.isVisible()) {
            if (RAMSearchWindow.ramSearchWindow.autoSearch.isSelected()) {
                ramSearchWindow.search();
            } else {
                ramSearchWindow.updateValues();
            }
        }
    }

    public static void open(Window window, DebuggableSystem debuggableSystem, boolean bl) {
        if (ramSearchWindow == null) {
            ramSearchWindow = new RAMSearchWindow(window, debuggableSystem, Emulicious.isUseFrames());
            ramSearchWindow.setVisible(true);
        } else if (!bl) {
            ramSearchWindow.setVisible(true);
        }
    }

    public static void updateModel(DebuggableSystem debuggableSystem) {
        if (ramSearchWindow != null) {
            RAMSearchWindow.ramSearchWindow.system = debuggableSystem;
            ramSearchWindow.clear();
        }
    }

    public static void close() {
        if (ramSearchWindow != null) {
            Emulicious.getProperties().setProperty("Window" + ramSearchWindow.getClass().getSimpleName() + "Open", "" + ramSearchWindow.isVisible());
            Emulicious.getProperties().setProperty("Window" + ramSearchWindow.getClass().getSimpleName() + "X", "" + ramSearchWindow.getX());
            Emulicious.getProperties().setProperty("Window" + ramSearchWindow.getClass().getSimpleName() + "Y", "" + ramSearchWindow.getY());
            Emulicious.getProperties().setProperty("Window" + ramSearchWindow.getClass().getSimpleName() + "Width", "" + ramSearchWindow.getWidth());
            Emulicious.getProperties().setProperty("Window" + ramSearchWindow.getClass().getSimpleName() + "Height", "" + ramSearchWindow.getHeight());
            ramSearchWindow.dispose();
            ramSearchWindow = null;
        }
    }

    public static final class EqualsIcon
    implements Icon {
        private boolean enabled;

        public EqualsIcon(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.enabled) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(Color.GRAY);
            }
            graphics.fillRect(n + 2, n2 + 4, 12, 3);
            graphics.fillRect(n + 2, n2 + 10, 12, 3);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static final class GreaterThanIcon
    implements Icon {
        private boolean enabled;

        public GreaterThanIcon(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.enabled) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(Color.GRAY);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawLine(n + 3, n2 + 4, n + 12, n2 + 8);
            graphics2D.drawLine(n + 3, n2 + 12, n + 12, n2 + 8);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static final class GreaterThanOrEqualsIcon
    implements Icon {
        private boolean enabled;

        public GreaterThanOrEqualsIcon(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.enabled) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(Color.GRAY);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawLine(n + 3, n2 + 3, n + 12, n2 + 6);
            graphics2D.drawLine(n + 3, n2 + 9, n + 12, n2 + 6);
            graphics2D.fillRect(n + 2, n2 + 12, 12, 3);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static final class LessThanIcon
    implements Icon {
        private boolean enabled;

        public LessThanIcon(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.enabled) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(Color.GRAY);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawLine(n + 3, n2 + 8, n + 12, n2 + 4);
            graphics2D.drawLine(n + 3, n2 + 8, n + 12, n2 + 12);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static final class LessThanOrEqualsIcon
    implements Icon {
        private boolean enabled;

        public LessThanOrEqualsIcon(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.enabled) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(Color.GRAY);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawLine(n + 3, n2 + 6, n + 12, n2 + 3);
            graphics2D.drawLine(n + 3, n2 + 6, n + 12, n2 + 9);
            graphics2D.fillRect(n + 2, n2 + 12, 12, 3);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static final class NotEqualsIcon
    implements Icon {
        private boolean enabled;

        public NotEqualsIcon(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.enabled) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(Color.GRAY);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.fillRect(n + 2, n2 + 4, 12, 3);
            graphics2D.fillRect(n + 2, n2 + 10, 12, 3);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawLine(n + 6, n2 + 2, n + 10, n2 + 14);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    private final class RAMSearchEntry {
        private final int address;
        private long value;
        private long oldValue;
        private long changes;

        public RAMSearchEntry(int n, long l) {
            this.address = n;
            this.value = l;
            this.oldValue = l;
        }

        public void setOldValue(long l) {
            this.oldValue = l;
        }

        public void updateValue() {
            long l = RAMSearchWindow.this.getValue(this.getAddress());
            if (l != this.value) {
                ++this.changes;
            }
            this.value = l;
        }

        public void resetChanges() {
            this.changes = 0L;
        }

        public int getAddress() {
            return this.address;
        }

        public long getValue() {
            return this.value;
        }

        public long getOldValue() {
            return this.oldValue;
        }

        public long getChanges() {
            return this.changes;
        }
    }
}

