/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import expressions.ParseException;
import expressions.UnknownVariableException;
import java.util.Map;
import platform.debugger.Breakpoint;
import platform.debugger.ExpressionEvaluator;

public class InvalidBreakpoint
extends Breakpoint {
    private final Map<String, String> attributes;
    private final Exception cause;

    protected InvalidBreakpoint(String string, String string2, boolean bl, boolean bl2, String string3, String string4, Map<String, String> map, Exception exception) throws ParseException, UnknownVariableException {
        super(string, string2, null, bl, bl2, string3, string4);
        if (map == null) {
            map = InvalidBreakpoint.parseAttributes(super.toString());
        }
        this.attributes = map;
        this.cause = exception;
    }

    protected static InvalidBreakpoint create(String string, String string2, boolean bl, boolean bl2, String string3, String string4, Map<String, String> map, Exception exception) {
        try {
            return new InvalidBreakpoint(string, string2, bl, bl2, string3, string4, map, exception);
        }
        catch (ParseException parseException) {
        }
        catch (UnknownVariableException unknownVariableException) {}
        throw new IllegalStateException("This cannot happen");
    }

    protected static InvalidBreakpoint create(String string, String string2, Exception exception) {
        try {
            return new InvalidBreakpoint(string, string2, true, true, null, null, null, exception);
        }
        catch (ParseException parseException) {
        }
        catch (UnknownVariableException unknownVariableException) {}
        throw new IllegalStateException("This cannot happen");
    }

    @Override
    public Breakpoint newInstance(String string, String string2, ExpressionEvaluator expressionEvaluator) {
        throw new IllegalStateException("Cannot create new instancef from InvalidBreakpoint");
    }

    public Exception getCause() {
        return this.cause;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public void setSuspend(boolean bl) {
    }

    @Override
    public void setCondition(String string) {
    }

    @Override
    public void setMessage(String string) {
    }

    public Breakpoint recreate(ExpressionEvaluator expressionEvaluator) {
        if (this.attributes == null) {
            return this;
        }
        Breakpoint breakpoint = InvalidBreakpoint.create(this.attributes, expressionEvaluator);
        if (breakpoint instanceof InvalidBreakpoint) {
            return this;
        }
        return breakpoint;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(String.valueOf(entry.getKey()) + "=" + InvalidBreakpoint.escape(entry.getValue()));
        }
        return stringBuilder.toString();
    }
}

