/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import expressions.Expression;
import expressions.ParseException;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import java.util.HashMap;
import java.util.Map;
import platform.debugger.ExpressionEvaluator;
import platform.debugger.InvalidBreakpoint;
import platform.debugger.Watchpoint;

class Breakpoint {
    private final int address;
    private final String addressString;
    private final int end;
    private final String endString;
    private final boolean virtualAddress;
    private boolean enabled;
    private boolean suspend;
    private String condition;
    private String message;

    protected Breakpoint(String string, int n, String string2, int n2, ExpressionEvaluator expressionEvaluator, boolean bl, boolean bl2, String string3, String string4) throws ParseException, UnknownVariableException {
        if (expressionEvaluator != null) {
            n = expressionEvaluator.evaluate(string);
            n2 = expressionEvaluator.evaluate(string2);
        }
        if (n < 0) {
            throw new IllegalArgumentException("An address must not be negative.");
        }
        if (Math.max(n, n2) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("End address must be less than 7FFFFFFF");
        }
        this.address = n & Integer.MAX_VALUE;
        this.addressString = string;
        this.virtualAddress = expressionEvaluator != null && string != null && (string.contains(":") || expressionEvaluator.hasVariables(string));
        this.end = Math.max(this.address, n2);
        this.endString = string2;
        this.enabled = bl;
        this.suspend = bl2;
        this.condition = string3;
        this.message = string4;
    }

    protected Breakpoint(String string, String string2, ExpressionEvaluator expressionEvaluator, boolean bl, boolean bl2, String string3, String string4) throws ParseException, UnknownVariableException {
        this(string, 0, string2, 0, expressionEvaluator, bl, bl2, string3, string4);
    }

    public Breakpoint(String string, String string2, ExpressionEvaluator expressionEvaluator) throws ParseException, UnknownVariableException {
        this(string, string2, expressionEvaluator, true, true, null, null);
    }

    public Breakpoint newInstance(String string, String string2, ExpressionEvaluator expressionEvaluator) {
        try {
            return new Breakpoint(string, string2, expressionEvaluator, this.isEnabled(), this.isSuspend(), this.getCondition(), this.getMessage());
        }
        catch (Exception exception) {
            return InvalidBreakpoint.create(string, string2, this.isEnabled(), this.isSuspend(), this.getCondition(), this.getMessage(), null, exception);
        }
    }

    public Breakpoint newInstance(int n, int n2) {
        try {
            return new Breakpoint(this.getAddressString(), n, this.getEndString(), n2, null, this.isEnabled(), this.isSuspend(), this.getCondition(), this.getMessage());
        }
        catch (Exception exception) {
            return InvalidBreakpoint.create(this.addressString, this.endString, this.isEnabled(), this.isSuspend(), this.getCondition(), this.getMessage(), null, exception);
        }
    }

    public Breakpoint moveBankToCondition(int n) {
        if (!this.isVirtualAddress()) {
            throw new IllegalStateException("Cannot determine bank if address is not virtual");
        }
        int n2 = this.getAddress() / n;
        Breakpoint breakpoint = this.getAddress() < n ? this : this.newInstance(this.getAddress() % n, this.getEnd() % n);
        String string = this.getCondition();
        int n3 = string.indexOf("&source");
        if (n3 >= 0) {
            int n4 = string.indexOf(61, n3);
            int n5 = n4 + 1;
            while (n5 < string.length() && string.charAt(n5) <= ' ') {
                ++n5;
            }
            int n6 = n5;
            while (n6 < string.length() && Character.isDigit(string.charAt(n6))) {
                ++n6;
            }
            try {
                int n7 = Integer.parseInt(string.substring(n5, n6));
                if (n2 != n7) {
                    breakpoint.setCondition(String.valueOf(string.substring(0, n5)) + n2 + string.substring(n6));
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else {
            breakpoint.setCondition(string.isEmpty() ? "&source = " + n2 : "(" + string + ") && &source = " + n2);
        }
        return breakpoint;
    }

    public int getAddress() {
        return this.address;
    }

    public String getAddressString() {
        return this.addressString;
    }

    public int getEnd() {
        return this.end;
    }

    public String getEndString() {
        return this.endString;
    }

    public boolean isVirtualAddress() {
        return this.virtualAddress;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    public void setSuspend(boolean bl) {
        this.suspend = bl;
    }

    public String getCondition() {
        if (this.condition == null) {
            return "";
        }
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public String getMessage() {
        if (this.message == null) {
            return "";
        }
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Action getAction() {
        return null;
    }

    public Expression getConditionExpression() {
        return null;
    }

    public boolean isConditionSigned() {
        return false;
    }

    public VariableProvider getVariables() {
        return null;
    }

    public static Breakpoint create(Map<String, String> map, ExpressionEvaluator expressionEvaluator) {
        String string = map.get("address");
        String string2 = map.get("end");
        try {
            if ("instruction".equals(map.get("type"))) {
                return new Breakpoint(string, string2, expressionEvaluator, Boolean.parseBoolean(map.get("enabled")), Boolean.parseBoolean(map.get("suspend")), map.get("condition"), map.get("message"));
            }
            if ("watchpoint".equals(map.get("type"))) {
                return new Watchpoint(string, string2, expressionEvaluator, Boolean.parseBoolean(map.get("enabled")), Boolean.parseBoolean(map.get("suspend")), Boolean.parseBoolean(map.get("read")), Boolean.parseBoolean(map.get("write")), map.get("condition"), map.get("message"));
            }
        }
        catch (Exception exception) {
            return InvalidBreakpoint.create(string, string2, Boolean.parseBoolean(map.get("enabled")), Boolean.parseBoolean(map.get("suspend")), map.get("condition"), map.get("message"), map, exception);
        }
        return null;
    }

    public static Map<String, String> parseAttributes(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length == 2) {
                hashMap.put(stringArray2[0], stringArray2[1].replace("%20", " ").replace("%3d", "="));
            }
            ++n2;
        }
        return hashMap;
    }

    protected static String escape(String string) {
        return string.replace(" ", "%20").replace("=", "%3d");
    }

    public String toString() {
        return String.format("type=instruction address=%s end=%s enabled=%b suspend=%b condition=%s message=%s", Breakpoint.escape(this.getAddressString()), Breakpoint.escape(this.getEndString()), this.isEnabled(), this.isSuspend(), Breakpoint.escape(this.getCondition()), Breakpoint.escape(this.getMessage()));
    }

    static interface Action {
        public void performAction();
    }
}

